/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import org.openjdk.asmtools.jasm.AnnotationData;
import org.openjdk.asmtools.jasm.Argument;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.TypeAnnotationTargetInfoData;
import org.openjdk.asmtools.jasm.TypeAnnotationTypePathData;
import org.openjdk.asmtools.jasm.TypeAnnotationTypes;

public class TypeAnnotationData
extends AnnotationData {
    protected TypeAnnotationTypes.ETargetType targetType;
    protected TypeAnnotationTargetInfoData targetInfo;
    protected TypeAnnotationTypePathData typePath = new TypeAnnotationTypePathData();

    public TypeAnnotationData(Argument typeCPX, boolean invisible) {
        super(typeCPX, invisible);
    }

    @Override
    public int getLength() {
        return super.getLength() + 1 + this.targetInfo.getLength() + this.typePath.getLength();
    }

    @Override
    public void write(CheckedDataOutputStream out) throws IOException {
        out.writeByte(this.targetType.value);
        this.targetInfo.write(out);
        this.typePath.write(out);
        super.write(out);
    }

    public void addTypePathEntry(TypeAnnotationTypes.TypePathEntry path) {
        this.typePath.addTypePathEntry(path);
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int tabLevel) {
        StringBuilder sb = new StringBuilder(this.tabString(tabLevel));
        sb.append(this.targetType.toString()).append(' ').append(this.targetInfo.toString(tabLevel)).append(this.typePath.toString(tabLevel));
        return sb.toString();
    }
}

