/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.openjdk.asmtools.jdis.AnnotationData;
import org.openjdk.asmtools.jdis.ClassData;
import org.openjdk.asmtools.jdis.TraceUtils;

public class ParameterAnnotationData {
    private boolean invisible = false;
    private static final String initialTab = "";
    private ArrayList<ArrayList<AnnotationData>> array = null;
    private ClassData cls;

    public ParameterAnnotationData(ClassData cls, boolean invisible) {
        this.cls = cls;
        this.invisible = invisible;
    }

    public int numParams() {
        if (this.array == null) {
            return 0;
        }
        return this.array.size();
    }

    public ArrayList<AnnotationData> get(int i) {
        return this.array.get(i);
    }

    public void read(DataInputStream in) throws IOException {
        int numParams = in.readByte();
        TraceUtils.traceln("             ParameterAnnotationData[" + numParams + "]");
        this.array = new ArrayList(numParams);
        for (int paramNum = 0; paramNum < numParams; ++paramNum) {
            int numAnnots = in.readShort();
            TraceUtils.traceln("             Param#[" + paramNum + "]: numAnnots=" + numAnnots);
            if (numAnnots > 0) {
                ArrayList<AnnotationData> p_annots = new ArrayList<AnnotationData>(numAnnots);
                for (int annotIndex = 0; annotIndex < numAnnots; ++annotIndex) {
                    AnnotationData annot = new AnnotationData(this.invisible, this.cls);
                    annot.read(in);
                    p_annots.add(annot);
                }
                this.array.add(paramNum, p_annots);
                continue;
            }
            this.array.add(paramNum, null);
        }
    }

    public void print(PrintWriter out, String tab) {
        if (this.array != null && this.array.size() > 0) {
            out.println();
            int paramNum = 0;
            for (ArrayList<AnnotationData> p_annot : this.array) {
                if (p_annot != null && p_annot.size() > 0) {
                    out.print("\t" + paramNum + ": ");
                    boolean firstTime = true;
                    for (AnnotationData annot : p_annot) {
                        if (!firstTime) {
                            out.print("\t   ");
                        }
                        annot.print(out, initialTab);
                        firstTime = false;
                    }
                }
                ++paramNum;
                out.println();
            }
        }
    }
}

