/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov;

import com.sun.tdk.jcov.Grabber;
import com.sun.tdk.jcov.Server;
import com.sun.tdk.jcov.instrument.DataRoot;
import com.sun.tdk.jcov.runtime.Collect;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.util.logging.Level;

class Client
extends Thread {
    private final Socket socket;
    private final Server server;
    private final int clientNumber;
    private boolean working = true;
    public static int unknownTestNumber = 0;
    private String testName;
    private String testerName;
    private String productName;
    private int slotNumber;
    private static final int MAX_SLOTS = 2000000;
    public static final String UNKNOWN = "<unknown>";

    public Client(Server server, Socket socket, int clientNumber) {
        this.setName("Client" + clientNumber + "Thread");
        this.setDaemon(false);
        this.socket = socket;
        this.server = server;
        this.clientNumber = clientNumber;
    }

    @Override
    public void run() {
        this.executeClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeClient() {
        block45: {
            DataInputStream IN = null;
            boolean legacy = false;
            boolean dynamic = false;
            long reserve = 0L;
            try {
                int i;
                IN = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
                byte[] buff = new byte[4];
                for (int i2 = 0; i2 < buff.length; ++i2) {
                    buff[i2] = IN.readByte();
                }
                if (!new String(buff, "UTF-8").equals("JCOV")) {
                    reserve = 10000000L;
                    legacy = true;
                } else {
                    int version = IN.read();
                    this.testerName = IN.readUTF();
                    this.testName = IN.readUTF();
                    this.productName = IN.readUTF();
                    if ("".equals(this.testName)) {
                        this.testName = this.testName + " " + this.testerName + " " + this.productName + "_test" + ++unknownTestNumber;
                    }
                    Grabber.logger.log(Level.FINE, "Got test data: name {0}, tester {1}, product {2}", new Object[]{this.testName, this.testerName, this.productName});
                    dynamic = IN.readBoolean();
                    reserve = dynamic ? 50000000L : (long)(Collect.SLOTS * 10);
                }
                if (legacy) {
                    int i3;
                    Grabber.logger.log(Level.FINE, "Header missmatch from client N{0}: '{1}'. Reading as legacy", new Object[]{this.clientNumber + "", new String(buff, "UTF-8")});
                    this.testerName = UNKNOWN;
                    this.testName = "test" + ++unknownTestNumber;
                    this.productName = UNKNOWN;
                    long[] ids = new long[1000000];
                    for (int j = 0; j < 4; ++j) {
                        ids[0] = ids[0] + (((long)buff[j] & 0xFFL) << 8 * j);
                    }
                    try {
                        for (i3 = 1; i3 < 1000000; ++i3) {
                            ids[i3] = IN.readLong();
                        }
                    }
                    catch (EOFException e) {
                        Grabber.logger.log(Level.SEVERE, "Got incorrect number of longs from legacy-format client N{0}: {1}, expected 1 000 000", new Object[]{this.clientNumber + "", i3});
                        this.server.decreaseReserved(reserve);
                        if (IN != null) {
                            try {
                                IN.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        if (!this.socket.isClosed()) {
                            try {
                                this.socket.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        --this.server.aliveClients;
                        this.working = false;
                        Grabber.logger.log(Level.FINE, "Client N{0} done", this.clientNumber + "");
                        return;
                    }
                    IN.close();
                    IN = null;
                    Grabber.logger.log(Level.FINER, "Got legacy-format static data from client N{0}", this.clientNumber + "");
                    this.saveResults(ids);
                    return;
                }
                if (dynamic) {
                    DataRoot root = new DataRoot(IN);
                    this.slotNumber = root.getCount();
                    IN.close();
                    IN = null;
                    this.saveResults(root);
                    break block45;
                }
                String templateHash = IN.readUTF();
                this.slotNumber = IN.readInt();
                int lastIndex = IN.readInt();
                long[] ids = new long[lastIndex + 1];
                try {
                    for (i = 0; i < this.slotNumber; ++i) {
                        int index = IN.readInt();
                        ids[index] = IN.readLong();
                    }
                }
                catch (EOFException e) {
                    Grabber.logger.log(Level.SEVERE, "Got incorrect number of longs from static client N{0}: found {1}, expected {2}", new Object[]{this.clientNumber + "", i, this.slotNumber});
                }
                catch (IOException ioe) {
                    Grabber.logger.log(Level.WARNING, "Got incorrect number of longs from static client N{0}: found {1}, expected {2}", new Object[]{this.clientNumber + "", i, this.slotNumber});
                }
                IN.close();
                IN = null;
                this.socket.close();
                Grabber.logger.log(Level.FINER, "Got new-format static data from client N{0}", this.clientNumber + "");
                this.saveResults(ids);
            }
            catch (Exception e) {
                Grabber.logger.log(Level.SEVERE, "e =" + e);
                Grabber.logger.log(Level.SEVERE, "Error while receiving data from client N" + this.clientNumber, e);
            }
            finally {
                this.server.decreaseReserved(reserve);
                if (IN != null) {
                    try {
                        IN.close();
                    }
                    catch (IOException iOException) {}
                }
                if (!this.socket.isClosed()) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException iOException) {}
                }
                --this.server.aliveClients;
                this.working = false;
                Grabber.logger.log(Level.FINE, "Client N{0} done", this.clientNumber + "");
            }
        }
    }

    private void saveResults(long[] ids) {
        this.server.handleData(ids, this);
    }

    private void saveResults(DataRoot root) {
        this.server.handleData(root, this);
    }

    public String getClientAddress() {
        return this.socket.getInetAddress().getHostName() + ":" + this.socket.getLocalPort();
    }

    public int getClientNumber() {
        return this.clientNumber;
    }

    public boolean isWorking() {
        return this.working;
    }

    public String getTestName() {
        return this.testName;
    }

    public String getTesterName() {
        return this.testerName;
    }

    public String getProductName() {
        return this.productName;
    }
}

