/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov;

import com.sun.tdk.jcov.Grabber;
import com.sun.tdk.jcov.Instr;
import com.sun.tdk.jcov.Merger;
import com.sun.tdk.jcov.ProductInstr;
import com.sun.tdk.jcov.RepGen;
import com.sun.tdk.jcov.data.FileFormatException;
import com.sun.tdk.jcov.data.Result;
import com.sun.tdk.jcov.instrument.InstrumentationOptions;
import com.sun.tdk.jcov.processing.ProcessingException;
import com.sun.tdk.jcov.tools.EnvHandler;
import com.sun.tdk.jcov.tools.JCovCMDTool;
import com.sun.tdk.jcov.tools.JCovTool;
import com.sun.tdk.jcov.tools.OptionDescr;
import com.sun.tdk.jcov.util.Utils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Exec
extends JCovCMDTool {
    static final Logger logger;
    private String[] command;
    private Grabber grabber;
    private String outLogFile;
    private String errLogFile;
    private String grabberLogFile;
    private String template = "template.xml";
    private String outTestList;
    private String outputFile = "result.xml";
    private File commandDir = null;
    private ProductInstr pInstr;
    private File reportDir;
    public static final OptionDescr DSC_TEST_COMMAND;
    public static final OptionDescr DSC_COMMAND_DIR;
    public static final OptionDescr DSC_TEST_COMMANDS;
    public static final OptionDescr DSC_REDIRECT_OUT;
    public static final OptionDescr DSC_REDIRECT_ERR;
    public static final OptionDescr DSC_GRABBER_REDIRECT;
    public static final OptionDescr DSC_REPORT;

    private void instrumentProduct() throws Exception {
        this.pInstr.instrumentProduct();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void runCommand() throws IOException, Exception {
        block26: {
            Process proc;
            OutputStream errStream;
            OutputStream outStream;
            block24: {
                int exitStatus;
                if (this.pInstr != null || this.reportDir != null) {
                    logger.log(Level.INFO, " - Starting command");
                }
                logger.log(Level.CONFIG, "Command to run: ''{0}''", Arrays.toString(this.command));
                outStream = null;
                errStream = null;
                proc = null;
                this.grabber.createServer();
                logger.log(Level.INFO, "Starting the Grabber");
                this.grabber.startServer();
                outStream = this.outLogFile != null ? new FileOutputStream(this.outLogFile) : System.out;
                errStream = this.errLogFile != null ? (this.errLogFile.equals(this.outLogFile) ? outStream : new FileOutputStream(this.errLogFile)) : (this.outLogFile != null ? outStream : System.err);
                ProcessBuilder pb = new ProcessBuilder(this.command).redirectErrorStream(errStream == outStream).directory(this.commandDir);
                pb.environment().put("JCOV_PORT", Integer.toString(this.grabber.getServerPort()));
                logger.log(Level.INFO, "Starting the command");
                proc = pb.start();
                InputStream inputStream = proc.getInputStream();
                new Thread(new Redirector(inputStream, outStream)).start();
                if (errStream != outStream) {
                    new Thread(new Redirector(proc.getErrorStream(), errStream)).start();
                }
                if ((exitStatus = proc.waitFor()) == 0) {
                    logger.log(Level.FINE, "Command finished with 0");
                } else {
                    logger.log(Level.WARNING, "Command finished with {0}", exitStatus);
                }
                proc = null;
                if (proc != null) {
                    logger.log(Level.INFO, "Destroying the process...");
                    proc.destroy();
                }
                if (this.outLogFile == null) break block24;
                outStream.close();
                if (outStream != errStream) {
                    errStream.close();
                }
            }
            try {
                logger.log(Level.INFO, "Stopping the grabber (not forcely)...");
                this.grabber.stopServer(false);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            if (!new File(this.outputFile).exists()) {
                throw new Exception("Output file " + this.outputFile + " was not created after grabber stop." + (this.reportDir != null ? " Can't write the report." : ""));
            }
            break block26;
            catch (Throwable e) {
                block25: {
                    try {
                        e.printStackTrace();
                        if (proc != null) {
                            logger.log(Level.INFO, "Destroying the process...");
                            proc.destroy();
                        }
                        if (this.outLogFile == null) break block25;
                    }
                    catch (Throwable throwable) {
                        if (proc != null) {
                            logger.log(Level.INFO, "Destroying the process...");
                            proc.destroy();
                        }
                        if (this.outLogFile != null) {
                            outStream.close();
                            if (outStream != errStream) {
                                errStream.close();
                            }
                        }
                        try {
                            logger.log(Level.INFO, "Stopping the grabber (not forcely)...");
                            this.grabber.stopServer(false);
                        }
                        catch (Throwable e2) {
                            e2.printStackTrace();
                        }
                        if (!new File(this.outputFile).exists()) {
                            throw new Exception("Output file " + this.outputFile + " was not created after grabber stop." + (this.reportDir != null ? " Can't write the report." : ""));
                        }
                        throw throwable;
                    }
                    outStream.close();
                    if (outStream != errStream) {
                        errStream.close();
                    }
                }
                try {
                    logger.log(Level.INFO, "Stopping the grabber (not forcely)...");
                    this.grabber.stopServer(false);
                }
                catch (Throwable e3) {
                    e3.printStackTrace();
                }
                if (!new File(this.outputFile).exists()) {
                    throw new Exception("Output file " + this.outputFile + " was not created after grabber stop." + (this.reportDir != null ? " Can't write the report." : ""));
                }
            }
        }
    }

    private void createReport() throws ProcessingException, FileFormatException, Exception {
        logger.log(Level.INFO, " - Generating report");
        logger.log(Level.CONFIG, "Output report directory: ''{0}''", this.reportDir.getPath());
        RepGen rg = new RepGen();
        rg.configure(null, null, null, null, false, false, false, false, false, false, false, false);
        Result res = this.outTestList == null ? new Result(this.outputFile) : new Result(this.outputFile, this.outTestList);
        rg.generateReport(this.reportDir.getAbsolutePath(), res);
    }

    @Override
    protected int run() throws Exception {
        if (this.pInstr != null) {
            this.instrumentProduct();
        }
        this.runCommand();
        if (this.reportDir != null) {
            this.createReport();
        }
        return 0;
    }

    @Override
    protected EnvHandler defineHandler() {
        return new EnvHandler(new OptionDescr[]{DSC_TEST_COMMAND, DSC_TEST_COMMANDS, DSC_COMMAND_DIR, Grabber.DSC_PORT, Grabber.DSC_OUTPUT, Merger.DSC_OUTPUT_TEST_LIST, DSC_REDIRECT_OUT, DSC_REDIRECT_ERR, DSC_GRABBER_REDIRECT, ProductInstr.DSC_INSTRUMENT, ProductInstr.DSC_INSTRUMENT_TO, ProductInstr.DSC_RT_TO, Instr.DSC_INCLUDE_RT, DSC_REPORT, InstrumentationOptions.DSC_TEMPLATE}, (JCovTool)this);
    }

    @Override
    protected int handleEnv(EnvHandler envHandler) throws JCovTool.EnvHandlingException {
        if (envHandler.isSet(DSC_TEST_COMMAND)) {
            this.command = Exec.splitNoQuotes(envHandler.getValue(DSC_TEST_COMMAND));
            if (envHandler.isSet(DSC_TEST_COMMANDS)) {
                logger.log(Level.CONFIG, "'-commands' option ignored as '-command' option specified");
            }
        } else if (envHandler.isSet(DSC_TEST_COMMANDS)) {
            this.command = envHandler.getValues(DSC_TEST_COMMANDS);
        } else {
            throw new JCovTool.EnvHandlingException("'-command' or '-commands' option needed");
        }
        if (envHandler.isSet(DSC_COMMAND_DIR)) {
            this.commandDir = Utils.checkFileNotNull(envHandler.getValue(DSC_COMMAND_DIR), "command dir", new Utils.CheckOptions[0]);
        }
        if (envHandler.isSet(ProductInstr.DSC_INSTRUMENT)) {
            this.pInstr = new ProductInstr();
            this.pInstr.handleEnv(envHandler);
        }
        this.reportDir = Utils.checkFileCanBeNull(envHandler.getValue(DSC_REPORT), "report directory", Utils.CheckOptions.FILE_NOTEXISTS, Utils.CheckOptions.FILE_CANWRITE);
        if (envHandler.isSet(DSC_GRABBER_REDIRECT)) {
            this.grabberLogFile = envHandler.getValue(DSC_GRABBER_REDIRECT);
            Logger grLogger = Logger.getLogger(Grabber.class.getName());
            grLogger.setUseParentHandlers(false);
            try {
                grLogger.addHandler(new FileHandler(this.grabberLogFile));
            }
            catch (Exception ex) {
                throw new JCovTool.EnvHandlingException("Error opening file for logging grabber: " + ex.getMessage(), ex);
            }
        }
        this.grabber = new Grabber();
        this.grabber.handleEnv(envHandler);
        if (envHandler.isSet(DSC_REDIRECT_ERR)) {
            this.errLogFile = envHandler.getValue(DSC_REDIRECT_ERR);
            Utils.checkFileNotNull(this.errLogFile, "error log file", Utils.CheckOptions.FILE_CANWRITE, Utils.CheckOptions.FILE_NOTISDIR);
        }
        if (envHandler.isSet(DSC_REDIRECT_OUT)) {
            this.outLogFile = envHandler.getValue(DSC_REDIRECT_OUT);
            Utils.checkFileNotNull(this.outLogFile, "output log file", Utils.CheckOptions.FILE_CANWRITE, Utils.CheckOptions.FILE_NOTISDIR);
        }
        if (envHandler.isSet(InstrumentationOptions.DSC_TEMPLATE)) {
            this.template = envHandler.getValue(InstrumentationOptions.DSC_TEMPLATE);
            Utils.checkFileNotNull(this.template, "template file", Utils.CheckOptions.FILE_CANREAD, Utils.CheckOptions.FILE_ISFILE, Utils.CheckOptions.FILE_EXISTS);
        }
        if (envHandler.isSet(Merger.DSC_OUTPUT_TEST_LIST)) {
            this.outTestList = envHandler.getValue(Merger.DSC_OUTPUT_TEST_LIST);
            Utils.checkFileNotNull(this.outTestList, "output testlist file", Utils.CheckOptions.FILE_CANWRITE, Utils.CheckOptions.FILE_NOTISDIR, Utils.CheckOptions.FILE_NOTEXISTS);
        }
        if (envHandler.isSet(Grabber.DSC_OUTPUT)) {
            this.outputFile = envHandler.getValue(Grabber.DSC_OUTPUT);
            Utils.checkFileNotNull(this.outputFile, "output file", Utils.CheckOptions.FILE_CANWRITE, Utils.CheckOptions.FILE_NOTISDIR);
        }
        return 0;
    }

    @Override
    protected String getDescr() {
        return "Executes a command collecting coverage data in a grabber";
    }

    @Override
    protected String usageString() {
        return "java -jar jcov.jar exec -command <command to run> [-option value]";
    }

    @Override
    protected String exampleString() {
        return "java -jar jcov.jar exec -command \"./runtests.sh -testoptions:\\\"-javaagent:jcov.jar=grabber=\\\"\"";
    }

    public static String[] splitNoQuotes(String str) {
        Character quote = null;
        LinkedList<String> r = new LinkedList<String>();
        StringBuilder sb = new StringBuilder();
        block4: for (int i = 0; i < str.length(); ++i) {
            char charAt = str.charAt(i);
            if (quote == null) {
                switch (charAt) {
                    case '\"': 
                    case '\'': {
                        quote = Character.valueOf(charAt);
                        break;
                    }
                    case '\t': 
                    case '\n': 
                    case '\u000b': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        if (sb.length() <= 0) continue block4;
                        r.add(sb.toString());
                        sb = new StringBuilder();
                        break;
                    }
                    default: {
                        sb.append(charAt);
                        break;
                    }
                }
                continue;
            }
            if (charAt == quote.charValue()) {
                quote = null;
                continue;
            }
            sb.append(charAt);
        }
        if (sb.length() > 0) {
            r.add(sb.toString());
        }
        return r.toArray(new String[r.size()]);
    }

    static {
        Utils.initLogger();
        logger = Logger.getLogger(Exec.class.getName());
        DSC_TEST_COMMAND = new OptionDescr("command", new String[]{"comm", "cmd"}, "Exec commands", 1, "Command running tests over instrumented classes or using JCov agent. Use quotes for arguments: -command \"./tests.sh -arg1 -arg2 arg3\"");
        DSC_COMMAND_DIR = new OptionDescr("command.dir", new String[]{"dir"}, "", 1, "Specify directory to run the command");
        DSC_TEST_COMMANDS = new OptionDescr("commands", new String[]{"comms", "cmds"}, "", 3, "Command running tests over instrumented classes or using JCov agent. Use quotes for arguments: -command \"./tests.sh -arg1 -arg2 arg3\"");
        DSC_REDIRECT_OUT = new OptionDescr("out.file", new String[]{"out", "log.command"}, "", 1, "Redirect command output to a file");
        DSC_REDIRECT_ERR = new OptionDescr("err.file", new String[]{"err"}, "", 1, "Redirect command error output to a file");
        DSC_GRABBER_REDIRECT = new OptionDescr("log.grabber", "", 1, "Redirect grabber output to a file");
        DSC_REPORT = new OptionDescr("report", "", 1, "");
    }

    public static class Redirector
    implements Runnable {
        private final OutputStream out;
        private final BufferedReader rin;
        private final BufferedWriter rout;

        public Redirector(InputStream in, OutputStream out) {
            this.rin = new BufferedReader(new InputStreamReader(in, Charset.defaultCharset()));
            this.out = out;
            this.rout = new BufferedWriter(new OutputStreamWriter(out, Charset.defaultCharset()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                String s;
                while ((s = this.rin.readLine()) != null) {
                    OutputStream outputStream = this.out;
                    synchronized (outputStream) {
                        this.rout.write(s);
                        this.rout.newLine();
                        this.rout.flush();
                    }
                }
                return;
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }
}

