/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.insert;

import com.sun.tdk.jcov.instrument.OverriddenClassWriter;
import com.sun.tdk.jcov.runtime.PropertyFinder;
import com.sun.tdk.jcov.util.Utils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public abstract class AbstractUniversalInstrumenter {
    private static final String ZIP_EXT = ".zip";
    private static final String JAR_EXT = ".jar";
    private static final String WAR_EXT = ".war";
    private static final String CLASS_EXT = ".class";
    private static final String[] CUST_CLASS_EXTS;
    private String INSTR_FILE_SUFF = "i";
    private int fileCount = 0;
    private int classCount = 0;
    private int iClassCount = 0;
    private static final Logger logger;
    protected byte[] classBuf = new byte[32768];
    protected boolean overwrite;
    protected boolean readOnly;

    public AbstractUniversalInstrumenter(boolean overwrite) {
        this(overwrite, false);
    }

    public AbstractUniversalInstrumenter(boolean overwrite, boolean readOnly) {
        this.overwrite = overwrite;
        this.readOnly = readOnly;
    }

    protected String makeInstrumentedFileName(String name) {
        int dotInd = name.lastIndexOf(46);
        if (dotInd <= 0) {
            logger.log(Level.SEVERE, "Invalid classfile name: ''{0}''", name);
        }
        return name.substring(0, dotInd) + "." + this.INSTR_FILE_SUFF + name.substring(dotInd + 1, name.length());
    }

    private void ensureClassBufLength(int length, boolean copy_old_buf) {
        if (this.classBuf.length >= length) {
            return;
        }
        byte[] tmp_buf = new byte[length + length / 2];
        if (copy_old_buf) {
            System.arraycopy(this.classBuf, 0, tmp_buf, 0, this.classBuf.length);
        }
        this.classBuf = tmp_buf;
    }

    protected boolean processClassFile(File f, File outFile) throws IOException {
        String fname = f.getPath();
        logger.log(Level.INFO, "Instrumenting classfile ''{0}''...", fname);
        boolean instredFine = true;
        int classLength = (int)f.length();
        if (f.getName().equals("module-info.class")) {
            return true;
        }
        this.ensureClassBufLength(classLength, false);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            logger.log(Level.SEVERE, "  File not found - skipped", e);
            return false;
        }
        try {
            fis.read(this.classBuf, 0, classLength);
            fis.close();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "  Error reading '" + fname + "' - skipped", e);
            return false;
        }
        byte[] outBuf = null;
        try {
            if (f.length() < 4L) {
                if (f.length() == 0L) {
                    logger.log(Level.SEVERE, "  Error reading data from ''{0}'': File is empty\n - skipped", fname);
                    instredFine = false;
                } else {
                    logger.log(Level.SEVERE, "  Error reading data from ''{0}'': File is too small ({1}) - skipped", new Object[]{fname, f.length()});
                    instredFine = false;
                }
            } else {
                outBuf = this.instrument(this.classBuf, classLength);
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "  Error reading data from '" + fname + "' - skipped", e);
            instredFine = false;
        }
        catch (NullPointerException e) {
            logger.log(Level.SEVERE, "  Error reading data from '" + fname + "' - skipped", e);
            instredFine = false;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "  Error instrumenting '" + fname + "' - skipped", e);
            instredFine = false;
        }
        if (outBuf == null) {
            instredFine = false;
            outBuf = this.classBuf;
        } else {
            classLength = outBuf.length;
        }
        if (!this.readOnly) {
            File parent;
            String parentName;
            if (outFile == null) {
                outFile = f;
                f.delete();
            }
            if ((parentName = outFile.getParent()) != null && !(parent = new File(parentName)).exists()) {
                parent.mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(outFile);
            fos.write(outBuf, 0, classLength);
            fos.close();
        }
        return instredFine;
    }

    protected void processClassDir(File dir, File outDir) throws IOException {
        Object[] entries = dir.list();
        Arrays.sort(entries);
        for (int i = 0; i < entries.length; ++i) {
            File f = new File(dir.getPath() + File.separator + (String)entries[i]);
            if (f.isDirectory()) {
                this.processClassDir(f, new File(outDir, (String)entries[i]));
                continue;
            }
            ++this.fileCount;
            if (!f.getPath().endsWith(CLASS_EXT)) continue;
            ++this.classCount;
            if (!this.processClassFile(f, new File(outDir, (String)entries[i]))) continue;
            ++this.iClassCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processArc(File arc, File outArc, String rtPath) {
        logger.log(Level.INFO, " - Instrumenting archive ''{0}''...", arc);
        String outFilename = outArc == null ? this.makeInstrumentedFileName(arc.getPath()) : outArc.getPath() + File.separator + arc.getName();
        logger.log(Level.CONFIG, "  Output archive ''{0}''", outFilename);
        if (rtPath != null) {
            logger.log(Level.CONFIG, "  RT to implant: ''{0}''", rtPath);
        }
        CRC32 crc32 = new CRC32();
        ZipInputStream in = null;
        try {
            in = new ZipInputStream(new BufferedInputStream(new FileInputStream(arc)));
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "  Error opening archive '" + arc.getPath() + "'", ex);
            return;
        }
        ZipOutputStream out = null;
        File outFile = new File(outFilename);
        if (!this.readOnly) {
            try {
                out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(outFile)));
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "  Error creating output archive '" + outFilename + "'", ex);
            }
        }
        while (true) {
            boolean isClass;
            ZipEntry e0 = null;
            try {
                e0 = in.getNextEntry();
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "  Error reading archive entry in '" + arc.getPath() + "'", ex);
            }
            if (e0 == null) break;
            String ename = e0.getName();
            boolean isDir = e0.isDirectory();
            if (!isDir) {
                ++this.fileCount;
            }
            int fileLength = (int)e0.getSize();
            try {
                int i;
                if (fileLength >= 0) {
                    this.ensureClassBufLength(fileLength, false);
                    i = 0;
                    while (i < fileLength) {
                        this.classBuf[i++] = (byte)in.read();
                    }
                    in.read(this.classBuf, 0, fileLength);
                } else {
                    int b;
                    i = 0;
                    while ((b = in.read()) >= 0) {
                        this.ensureClassBufLength(i + 1, true);
                        this.classBuf[i] = (byte)b;
                        ++i;
                    }
                    fileLength = i;
                }
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "  Error reading archive entry '" + ename + "' in '" + arc.getPath() + "' - skipped", ex);
            }
            byte[] res = null;
            boolean bl = isClass = ename.endsWith(CLASS_EXT) && !isDir;
            if (isClass) {
                ++this.classCount;
                logger.log(Level.INFO, "  Instrumenting ''{0}''...", ename);
                try {
                    res = this.instrument(this.classBuf, fileLength);
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, "    Error reading archive entry '" + ename + "' in '" + arc.getPath() + "' - skipped", ex);
                    res = null;
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, "    Error instrumenting archive entry '" + ename + "' in '" + arc.getPath() + "' - skipped", ex);
                    res = null;
                }
            } else {
                res = this.classBuf;
                logger.log(Level.INFO, "  Storing ''{0}''...", ename);
            }
            if (this.readOnly) continue;
            ZipEntry e1 = new ZipEntry(ename);
            e1.setSize(fileLength);
            e1.setMethod(e0.getMethod());
            e1.setExtra(e0.getExtra());
            e1.setComment(e0.getComment());
            long crc = e0.getCrc();
            if (crc >= 0L) {
                e1.setCrc(crc);
            }
            if (res != null && isClass) {
                if (res.length > 1) {
                    ++this.iClassCount;
                    if (e0.getCrc() != -1L) {
                        crc32.reset();
                        crc32.update(res);
                        e1.setCrc(crc32.getValue());
                    }
                    fileLength = res.length;
                    e1.setSize(fileLength);
                } else {
                    if (res.length == 1 && res[0] == 80) {
                        logger.log(Level.WARNING, "    skipped: first pass native preview");
                    }
                    if (res.length == 1 && res[0] == 70) {
                        logger.log(Level.WARNING, "    skipped: filtered out");
                    }
                    res = this.classBuf;
                }
            } else {
                res = this.classBuf;
                if (!isClass) {
                    logger.log(Level.FINE, "    ''{0}'' - not instrumented (not a class)", ename);
                }
            }
            try {
                out.putNextEntry(e1);
                out.write(res, 0, fileLength);
                out.closeEntry();
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Error adding archive entry '" + ename + "' to '" + outFilename + "' - skipped", ex);
            }
        }
        try {
            in.close();
        }
        catch (IOException e0) {
            // empty catch block
        }
        try {
            if (rtPath != null) {
                ZipEntry e0;
                logger.log(Level.INFO, "  Adding saver libray...");
                File rt = new File(rtPath);
                if (!rt.exists()) {
                    throw new IOException("Runtime file doesn't exist " + rt);
                }
                if (!rt.isFile() || !rt.getName().endsWith(JAR_EXT) && !rt.getName().endsWith(ZIP_EXT)) {
                    throw new IOException("Malformed runtime archive " + rt);
                }
                ZipInputStream rtIn = new ZipInputStream(new BufferedInputStream(new FileInputStream(rt)));
                while ((e0 = rtIn.getNextEntry()) != null) {
                    int fileLength;
                    block59: {
                        ZipEntry e1;
                        block58: {
                            int i;
                            String ename = e0.getName();
                            if (ename.startsWith("META-INF")) continue;
                            fileLength = (int)e0.getSize();
                            if (fileLength >= 0) {
                                this.ensureClassBufLength(fileLength, false);
                                i = 0;
                                while (i < fileLength) {
                                    this.classBuf[i++] = (byte)rtIn.read();
                                }
                                rtIn.read(this.classBuf, 0, fileLength);
                            } else {
                                int b;
                                i = 0;
                                while ((b = rtIn.read()) >= 0) {
                                    this.ensureClassBufLength(i + 1, true);
                                    this.classBuf[i] = (byte)b;
                                    ++i;
                                }
                                fileLength = i;
                            }
                            e1 = new ZipEntry(ename);
                            e1.setSize(fileLength);
                            e1.setMethod(e0.getMethod());
                            e1.setExtra(e0.getExtra());
                            e1.setComment(e0.getComment());
                            long crc = e0.getCrc();
                            if (crc >= 0L) {
                                e1.setCrc(crc);
                            }
                            ZipInputStream inJar = new ZipInputStream(new BufferedInputStream(new FileInputStream(arc)));
                            try {
                                ZipEntry checking;
                                do {
                                    if ((checking = inJar.getNextEntry()) != null) continue;
                                    break block58;
                                } while (!checking.getName().equals(e1.getName()));
                                if (checking.getSize() != e1.getSize()) {
                                    // empty if block
                                }
                                inJar.close();
                                continue;
                            }
                            catch (EOFException checking) {
                            }
                            finally {
                                inJar.close();
                                continue;
                            }
                        }
                        try {
                            out.putNextEntry(e1);
                        }
                        catch (ZipException e) {
                            if (e.getMessage().startsWith("duplicate entry")) break block59;
                            throw e;
                        }
                    }
                    out.write(this.classBuf, 0, fileLength);
                    out.closeEntry();
                }
                rtIn.close();
            }
            if (out != null) {
                out.finish();
                out.close();
            }
        }
        catch (Throwable ex) {
            logger.log(Level.SEVERE, "Error processing archive '" + arc.getPath() + "'", ex);
            outFile.delete();
            return;
        }
        if (!this.readOnly && outArc == null && this.overwrite) {
            if (!arc.delete()) {
                logger.log(Level.WARNING, " Can''t remove initial JAR file ''{0}''", arc.getAbsolutePath());
            }
            if (!outFile.renameTo(arc)) {
                logger.log(Level.WARNING, " Can''t rename result JAR file ''{0}' to ''{1}''. Please move manually", new Object[]{outFile.getAbsolutePath(), arc.getAbsolutePath()});
            }
        }
    }

    public void instrument(String arg) throws IOException {
        this.instrument(new File(arg), null, null, false);
    }

    public void instrument(File arg, File outDir) throws IOException {
        this.instrument(arg, outDir, null, false);
    }

    public void instrument(File arg, File outDir, String rtPath) throws IOException {
        this.instrument(arg, outDir, rtPath, false);
    }

    public void instrument(File instrumentingPath, File destinationPath, String rtPath, boolean recursive) throws IOException {
        this.instrument(instrumentingPath, destinationPath, rtPath, null, recursive);
    }

    public void instrument(File instrumentingPath, File destinationPath, String rtPath, ArrayList<String> rtClassDirTargets, boolean recursive) throws IOException {
        this.fileCount = 0;
        this.classCount = 0;
        this.iClassCount = 0;
        if (!instrumentingPath.exists()) {
            logger.log(Level.WARNING, "Path ''{0}'' doesn''t exist - skipped", instrumentingPath);
            return;
        }
        boolean isClassFile = false;
        if (instrumentingPath.isDirectory()) {
            if (destinationPath == null) {
                destinationPath = instrumentingPath;
            }
            if (recursive) {
                Utils.addToClasspath(instrumentingPath);
                logger.log(Level.FINE, "Scanning directory ''{0}''...", instrumentingPath);
                Object[] entries = instrumentingPath.listFiles();
                Arrays.sort(entries);
                for (int i = 0; i < entries.length; ++i) {
                    destinationPath.mkdir();
                    this.instrument((File)entries[i], new File(destinationPath, ((File)entries[i]).getName()), rtPath, rtClassDirTargets, recursive);
                }
            } else {
                logger.log(Level.INFO, "Instrumenting directory ''{0}''...", instrumentingPath);
                this.processClassDir(instrumentingPath, destinationPath);
                if (rtPath != null) {
                    if (destinationPath != null) {
                        this.unjarRT(rtPath, destinationPath);
                    } else {
                        this.unjarRT(rtPath, instrumentingPath);
                    }
                }
            }
        } else if (instrumentingPath.getName().endsWith(JAR_EXT) || instrumentingPath.getName().endsWith(ZIP_EXT) || instrumentingPath.getName().endsWith(WAR_EXT)) {
            if (rtClassDirTargets == null || rtClassDirTargets.contains(instrumentingPath.getPath())) {
                if (recursive) {
                    this.processArc(instrumentingPath, destinationPath.getParentFile(), rtPath);
                } else {
                    this.processArc(instrumentingPath, destinationPath, rtPath);
                }
            } else if (recursive) {
                this.processArc(instrumentingPath, destinationPath.getParentFile(), null);
            } else {
                this.processArc(instrumentingPath, destinationPath, null);
            }
        } else if (instrumentingPath.getName().equals("modules")) {
            this.instrumentModulesFile(instrumentingPath, destinationPath);
        } else if (this.isClassFile(instrumentingPath.getName())) {
            if (destinationPath == null) {
                destinationPath = instrumentingPath;
            }
            this.processClassFile(instrumentingPath, destinationPath);
            isClassFile = true;
        } else {
            if (destinationPath == null) {
                destinationPath = instrumentingPath;
            }
            Utils.copyFile(instrumentingPath, destinationPath);
            return;
        }
        if (!isClassFile) {
            logger.log(Level.INFO, "Summary for ''{0}'': files total={1}, classes total={2}, instrumented classes total={3}", new Object[]{instrumentingPath, this.fileCount, this.classCount, this.iClassCount});
        }
    }

    public void processClassFileInModules(Path file, File destinationPath) {
        String fname = file.toAbsolutePath().toString();
        try {
            String distinationStr = destinationPath.toString();
            this.classBuf = Files.readAllBytes(file);
            int classLength = this.classBuf.length;
            byte[] outBuf = null;
            try {
                if (!"module-info.class".equals(file.getFileName().toString())) {
                    outBuf = this.instrument(this.classBuf, classLength);
                }
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "  Error reading data from '" + fname + "' - skipped", e);
            }
            catch (NullPointerException e) {
                logger.log(Level.SEVERE, "  Error reading data from '" + fname + "' - skipped", e);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "  Error instrumenting '" + fname + "' - skipped", e);
            }
            if (outBuf != null) {
                File parent;
                classLength = outBuf.length;
                File outFile = new File(distinationStr + File.separator + fname);
                String parentName = outFile.getParent();
                if (parentName != null && !(parent = new File(parentName)).exists()) {
                    parent.mkdirs();
                }
                FileOutputStream fos = new FileOutputStream(outFile);
                fos.write(outBuf, 0, classLength);
                try {
                    fos.close();
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "  Error writing data to '" + outFile.getAbsolutePath() + "' - skipped", e);
                }
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "  Error processing classFile by Path '" + fname + "' - skipped", e);
        }
    }

    private void instrumentModulesFile(File modulePath, final File destinationPath) {
        try {
            Utils.addToClasspath(modulePath.getParentFile().getParentFile());
            FileSystem fs = FileSystems.getFileSystem(URI.create("jrt:/"));
            Path path = fs.getPath("/modules/", new String[0]);
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (!attrs.isDirectory() && AbstractUniversalInstrumenter.this.isClassFile(file.getFileName().toString())) {
                        OverriddenClassWriter.addClassInfo(Files.newInputStream(file, new OpenOption[0]));
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (!attrs.isDirectory() && AbstractUniversalInstrumenter.this.isClassFile(file.getFileName().toString())) {
                        AbstractUniversalInstrumenter.this.processClassFileInModules(file, destinationPath);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Modules instrumentaion failed", e);
        }
    }

    protected abstract byte[] instrument(byte[] var1, int var2) throws IOException;

    public abstract void finishWork();

    public void unjarRT(String rtJar, File output) throws IOException {
        ZipEntry e0;
        if (output == null) {
            throw new IllegalArgumentException("Output path (jar file or classfile directory) needed to copy runtime jar file to");
        }
        File rt = new File(rtJar);
        if (!rt.exists()) {
            throw new IOException("Runtime file doesn't exist " + rt);
        }
        if (!rt.isFile() || !rt.getName().endsWith(JAR_EXT) && !rt.getName().endsWith(ZIP_EXT)) {
            throw new IOException("Malformed runtime archive " + rt);
        }
        ZipInputStream in = new ZipInputStream(new BufferedInputStream(new FileInputStream(rt)));
        while ((e0 = in.getNextEntry()) != null) {
            File parent;
            int i;
            String ename = e0.getName();
            if (ename.startsWith("META-INF")) continue;
            int fileLength = (int)e0.getSize();
            if (fileLength >= 0) {
                this.ensureClassBufLength(fileLength, false);
                i = 0;
                while (i < fileLength) {
                    this.classBuf[i++] = (byte)in.read();
                }
                in.read(this.classBuf, 0, fileLength);
            } else {
                int b;
                i = 0;
                while ((b = in.read()) >= 0) {
                    this.ensureClassBufLength(i + 1, true);
                    this.classBuf[i] = (byte)b;
                    ++i;
                }
                fileLength = i;
            }
            File outFile = new File(output.getPath() + File.separator + e0.getName());
            if (e0.isDirectory() || outFile.exists()) continue;
            String parentName = outFile.getAbsoluteFile().getParent();
            if (parentName != null && !(parent = new File(parentName)).exists()) {
                parent.mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(outFile);
            fos.write(this.classBuf, 0, fileLength);
            fos.close();
        }
        in.close();
    }

    private boolean isClassFile(String fileName) {
        if (fileName.endsWith(CLASS_EXT)) {
            return true;
        }
        for (String s : CUST_CLASS_EXTS) {
            if (!fileName.endsWith(s)) continue;
            return true;
        }
        return false;
    }

    static {
        String t = PropertyFinder.findValue("clext", null);
        CUST_CLASS_EXTS = t == null ? new String[0] : t.split(":");
        Utils.initLogger();
        logger = Logger.getLogger(AbstractUniversalInstrumenter.class.getName());
    }
}

