/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.instrument;

import com.sun.tdk.jcov.data.Scale;
import com.sun.tdk.jcov.instrument.DataAnnotated;
import com.sun.tdk.jcov.instrument.DataBlock;
import com.sun.tdk.jcov.instrument.DataBlockTarget;
import com.sun.tdk.jcov.instrument.DataBranch;
import com.sun.tdk.jcov.instrument.DataClass;
import com.sun.tdk.jcov.instrument.MergeException;
import com.sun.tdk.jcov.instrument.XmlContext;
import com.sun.tdk.jcov.util.NaturalComparator;
import com.sun.tdk.jcov.util.Utils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class DataMethod
extends DataAnnotated
implements Comparable<DataMethod>,
Iterable<DataBlock> {
    protected final DataClass parent;
    protected final int access;
    protected final String name;
    protected final String vmSig;
    protected final String signature;
    protected final String[] exceptions;
    protected List<LineEntry> lineTable;
    private final boolean differentiateMethods;

    DataMethod(DataClass k, int access, String name, String desc, String signature, String[] exceptions, boolean differentiateMethods) {
        super(k.rootId);
        this.parent = k;
        this.access = access;
        this.name = name;
        this.vmSig = desc;
        this.signature = signature;
        this.exceptions = exceptions;
        this.differentiateMethods = differentiateMethods;
        k.addMethod(this);
    }

    protected DataMethod(DataMethod other) {
        super(other.rootId);
        this.parent = other.parent;
        this.access = other.access;
        this.name = other.name;
        this.vmSig = other.vmSig;
        this.signature = other.signature;
        this.exceptions = other.exceptions;
        this.differentiateMethods = other.differentiateMethods;
    }

    public String[] getExceptions() {
        return this.exceptions;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.parent.getFullname() + "." + this.name + this.vmSig;
    }

    public DataClass getParent() {
        return this.parent;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getVmSignature() {
        return this.vmSig;
    }

    public String getFormattedSignature() {
        return Utils.convertVMtoJLS(this.name, this.vmSig);
    }

    public int getAccess() {
        return this.access;
    }

    public String[] getAccessFlags() {
        return this.accessFlags(this.access);
    }

    @Deprecated
    public boolean isPublic() {
        return (this.access & 5) != 0;
    }

    public boolean isPublicAPI() {
        return (this.access & 5) != 0;
    }

    public boolean isAbstract() {
        return (this.access & 0x400) != 0;
    }

    public boolean hasPrivateModifier() {
        return (this.access & 2) != 0;
    }

    public boolean hasPublicModifier() {
        return (this.access & 1) != 0;
    }

    public boolean hasProtectedModifier() {
        return (this.access & 4) != 0;
    }

    public boolean hasAbstractModifier() {
        return (this.access & 0x400) != 0;
    }

    public boolean hasStaticModifier() {
        return (this.access & 8) != 0;
    }

    public boolean hasNativeModifier() {
        return (this.access & 0x100) != 0;
    }

    public boolean hasModifier(int modifierCode) {
        return (this.access & modifierCode) != 0;
    }

    public abstract boolean wasHit();

    public abstract long getCount();

    public abstract void setCount(long var1);

    public abstract Scale getScale();

    public abstract int getSlot();

    public abstract DataMethod clone(DataClass var1, int var2, String var3);

    public boolean equals(Object o) {
        if (!(o instanceof DataMethod)) {
            return false;
        }
        DataMethod meth = (DataMethod)o;
        return this.parent.equals(meth.parent) && this.name.equals(meth.name) && this.vmSig.equals(meth.vmSig);
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + (this.parent != null ? this.parent.hashCode() : 0);
        hash = 17 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 17 * hash + (this.vmSig != null ? this.vmSig.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return super.toString() + "-" + this.name;
    }

    public boolean hasCRT() {
        return false;
    }

    @Override
    public String kind() {
        if (this.differentiateMethods) {
            if (this.name.equals("<init>")) {
                return "cons";
            }
            if (this.name.equals("<clinit>")) {
                return "clinit";
            }
        }
        return "meth";
    }

    @Override
    void xmlGen(XmlContext ctx) {
        if (ctx.showAbstract || (this.access & 0x400) == 0) {
            super.xmlGen(ctx);
        }
    }

    @Override
    void xmlAttrs(XmlContext ctx) {
        ctx.attrNormalized("name", this.name);
        ctx.attr("vmsig", this.vmSig);
        this.xmlAccessFlags(ctx, this.access);
        ctx.attr("access", this.access);
        if (!this.differentiateMethods) {
            if (this.name.equals("<init>")) {
                ctx.attr("cons", true);
            } else if (this.name.equals("<clinit>")) {
                ctx.attr("clinit", true);
            }
        }
        if (this.signature != null) {
            ctx.attrNormalized("signature", this.signature);
        }
    }

    @Override
    void xmlBody(XmlContext ctx) {
        if (ctx.showLineTable && this.lineTable != null) {
            this.xmlLineTable(ctx);
        }
    }

    void xmlLineTable(XmlContext ctx) {
        ctx.indent();
        ctx.print("<lt>");
        for (LineEntry pair : this.lineTable) {
            ctx.print(pair.bci + "=" + pair.line + ";");
        }
        ctx.println("</lt>");
    }

    public void addLineEntry(int bci, int line) {
        if (this.lineTable == null) {
            this.lineTable = new ArrayList<LineEntry>();
        }
        this.lineTable.add(new LineEntry(bci, line));
    }

    public List<LineEntry> getLineTable() {
        return this.lineTable;
    }

    @Override
    public int compareTo(DataMethod method) {
        return NaturalComparator.INSTANCE.compare(this.name, method.getName());
    }

    public abstract void checkCompatibility(DataMethod var1, String var2) throws MergeException;

    public abstract void merge(DataMethod var1);

    @Override
    String[] accessFlags(int access) {
        String[] as = super.accessFlags(access);
        ArrayList<String> lst = new ArrayList<String>();
        for (String s : as) {
            if (s.equals("interface")) {
                lst.add("defender");
                continue;
            }
            if ("volatile".equals(s) || "transient".equals(s)) continue;
            lst.add(s);
        }
        return lst.toArray(new String[lst.size()]);
    }

    public abstract List<DataBlock> getBlocks();

    public abstract List<DataBranch> getBranches();

    public abstract List<DataBlockTarget> getBranchTargets();

    @Override
    void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        out.writeUTF(this.name);
        DataMethod.writeString(out, this.vmSig);
        DataMethod.writeString(out, this.signature);
        out.writeInt(this.access & Short.MAX_VALUE);
        out.writeBoolean(this.differentiateMethods);
        DataMethod.writeStrings(out, this.exceptions);
        if (this.lineTable != null) {
            out.writeShort(this.lineTable.size());
            for (LineEntry line : this.lineTable) {
                out.writeShort(line.bci);
                out.writeShort(line.line);
            }
        } else {
            out.writeShort(Short.MAX_VALUE);
        }
    }

    DataMethod(DataClass parent, DataInput in) throws IOException {
        super(parent.rootId, in);
        this.parent = parent;
        this.name = in.readUTF();
        this.vmSig = DataMethod.readString(in);
        this.signature = DataMethod.readString(in);
        this.access = in.readInt();
        this.differentiateMethods = in.readBoolean();
        this.exceptions = DataMethod.readStrings(in);
        int len = in.readShort();
        if (len != Short.MAX_VALUE) {
            this.lineTable = new ArrayList<LineEntry>(len);
            for (int i = 0; i < len; ++i) {
                short bci = in.readShort();
                short line = in.readShort();
                this.lineTable.add(new LineEntry(bci, line));
            }
        } else {
            this.lineTable = null;
        }
    }

    public static class LineEntry {
        public int bci;
        public int line;

        LineEntry(int bci, int line) {
            this.bci = bci;
            this.line = line;
        }
    }
}

