/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.instrument;

import com.sun.tdk.jcov.instrument.DataMethodEntryOnly;
import com.sun.tdk.jcov.instrument.InstrumentationParams;
import com.sun.tdk.jcov.instrument.Instrumenter;
import com.sun.tdk.jcov.util.Utils;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

class EntryCodeMethodAdapter
extends MethodVisitor {
    private final DataMethodEntryOnly method;
    boolean isLineNumberVisited = false;
    private final InstrumentationParams params;

    EntryCodeMethodAdapter(MethodVisitor mv, DataMethodEntryOnly method, InstrumentationParams params) {
        super(458752, mv);
        this.method = method;
        this.params = params;
    }

    @Override
    public void visitCode() {
        super.visitCode();
        int id = 0;
        int fullId = 0;
        if (this.params.isCallerFilterOn() && (this.params.isDynamicCollect() || Utils.isAdvanceStaticInstrAllowed(this.method.getParent().getFullname(), this.method.getName()))) {
            id = (this.method.getName() + this.method.getVmSignature()).hashCode();
            fullId = (this.method.getParent().getFullname() + this.method.getName() + this.method.getVmSignature()).hashCode();
        }
        if (this.params.isInnerInvacationsOff() && Utils.isAdvanceStaticInstrAllowed(this.method.getParent().getFullname(), this.method.getName())) {
            id = -1;
            fullId = -1;
            if (this.method.getName().equals("<clinit>")) {
                id = 1;
            }
        }
        Instrumenter.visitInstrumentation(this.mv, this.method.getId(), id, fullId, this.params.isDetectInternal());
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        super.visitMaxs(maxStack < 3 ? 3 : maxStack, maxLocals);
    }

    @Override
    public void visitLineNumber(int line, Label start) {
        if (!this.isLineNumberVisited) {
            this.method.addLineEntry(0, line);
            this.isLineNumberVisited = true;
        }
        super.visitLineNumber(line, start);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String anno, boolean b) {
        this.method.addAnnotation(anno);
        return super.visitAnnotation(anno, b);
    }
}

