/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.instrument;

import org.objectweb.asm.Attribute;
import org.objectweb.asm.ByteVector;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;

public class InstrumentedAttributeClassAdapter
extends ClassVisitor {
    private boolean isAlreadyInstrumented = false;

    public boolean isAlreadyInstrumented() {
        return this.isAlreadyInstrumented;
    }

    public InstrumentedAttributeClassAdapter(ClassVisitor cv) {
        super(458752, cv);
    }

    @Override
    public void visitAttribute(Attribute attr) {
        System.out.println(attr.type);
        if (attr.type.equals("Instrumented")) {
            System.out.println("class is already instrumented");
            this.isAlreadyInstrumented = true;
        }
        super.visitAttribute(attr);
    }

    @Override
    public void visitEnd() {
        if (!this.isAlreadyInstrumented) {
            super.visitAttribute(new AttributeInstrumented());
        }
        super.visitEnd();
    }

    private static class AttributeInstrumented
    extends Attribute {
        static final String INSTRUMENTED = "Instrumented";

        AttributeInstrumented() {
            super(INSTRUMENTED);
        }

        @Override
        protected Attribute read(ClassReader cr, int off, int len, char[] buf, int codeOff, Label[] labels) {
            return new AttributeInstrumented();
        }

        @Override
        protected ByteVector write(ClassWriter cw, byte[] code, int len, int maxStack, int maxLocals) {
            return new ByteVector().putShort(cw.newUTF8(INSTRUMENTED));
        }
    }
}

