/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.instrument;

import com.sun.tdk.jcov.instrument.InstrumentationParams;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;

public class InvokeMethodAdapter
extends MethodVisitor {
    static volatile int invokeCount = 0;
    private final String className;
    private final InstrumentationParams params;
    private static final Map<String, Integer> map = Collections.synchronizedMap(new HashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getInvokeID(String owner, String name, String descr) {
        String sig = owner + "." + name + descr;
        Map<String, Integer> map = InvokeMethodAdapter.map;
        synchronized (map) {
            Integer id = InvokeMethodAdapter.map.get(sig);
            if (id != null) {
                return id;
            }
            id = invokeCount++;
            InvokeMethodAdapter.map.put(sig, id);
            return id;
        }
    }

    public InvokeMethodAdapter(MethodVisitor mv, String className, InstrumentationParams params) {
        super(458752, mv);
        this.className = className;
        this.params = params;
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        if ((opcode == 180 || opcode == 178) && this.params.isInstrumentFields() && this.params.isIncluded(owner) && this.params.isCallerFilterAccept(this.className)) {
            InsnList il = new InsnList();
            il.add(new LdcInsnNode((Object)InvokeMethodAdapter.getInvokeID(owner, name, desc)));
            il.add(new MethodInsnNode(184, "com/sun/tdk/jcov/runtime/CollectDetect", "invokeHit", "(I)V"));
            il.accept(this);
        }
        super.visitFieldInsn(opcode, owner, name, desc);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (this.params.isCallerFilterOn() && this.params.isCallerFilterAccept(this.className)) {
            if (ReflPair.contains(owner, name)) {
                this.visitReflectionCI(ReflPair.valueOf(owner, name));
            } else {
                int id = (name + desc).hashCode();
                super.visitLdcInsn(id);
                super.visitMethodInsn(184, "com/sun/tdk/jcov/runtime/CollectDetect", "setExpected", "(I)V", false);
            }
        }
        if ((opcode == 182 || opcode == 185) && this.params.isInstrumentAbstract() && this.params.isIncluded(owner) && this.params.isCallerFilterAccept(this.className)) {
            super.visitLdcInsn(InvokeMethodAdapter.getInvokeID(owner, name, desc));
            super.visitMethodInsn(184, "com/sun/tdk/jcov/runtime/CollectDetect", "invokeHit", "(I)V", false);
        }
        super.visitMethodInsn(opcode, owner, name, desc, itf);
    }

    private void visitReflectionCI(ReflPair p) {
        if (p == null) {
            return;
        }
        switch (p) {
            case CLASS: {
                super.visitInsn(89);
                super.visitMethodInsn(184, "com/sun/tdk/jcov/instrument/InvokeMethodAdapter", "getMethodHash", "(Ljava/lang/Object;)I");
                super.visitMethodInsn(184, "com/sun/tdk/jcov/runtime/CollectDetect", "setExpectedFull", "(I)V");
                break;
            }
            case METHOD: {
                super.visitInsn(93);
                super.visitInsn(87);
                super.visitInsn(87);
                super.visitInsn(89);
                super.visitMethodInsn(184, "com/sun/tdk/jcov/instrument/InvokeMethodAdapter", "getMethodHash", "(Ljava/lang/Object;)I");
                super.visitMethodInsn(184, "com/sun/tdk/jcov/runtime/CollectDetect", "setExpectedFull", "(I)V");
                super.visitInsn(91);
                super.visitInsn(87);
                break;
            }
            case CONSTRUCTOR: {
                super.visitInsn(92);
                super.visitInsn(87);
                super.visitMethodInsn(184, "com/sun/tdk/jcov/instrument/InvokeMethodAdapter", "getMethodHash", "(Ljava/lang/Object;)I");
                super.visitMethodInsn(184, "com/sun/tdk/jcov/runtime/CollectDetect", "setExpectedFull", "(I)V");
                break;
            }
        }
    }

    public static int getMethodHash(Object obj) {
        String desc = "";
        if (obj instanceof Method) {
            Method m = (Method)obj;
            Class<?> c = m.getDeclaringClass();
            desc = c.getName().replace(".", "/");
            desc = desc + m.getName();
            Class<?>[] types = m.getParameterTypes();
            desc = desc + "(";
            for (Class<?> t : types) {
                desc = desc + InvokeMethodAdapter.vmType(t.getName());
            }
            desc = desc + ")";
            desc = desc + InvokeMethodAdapter.vmType(m.getReturnType().getName());
        } else if (obj instanceof Constructor) {
            Constructor c = (Constructor)obj;
            Class cl = c.getDeclaringClass();
            desc = cl.getName().replace(".", "/");
            desc = desc + "<init>";
            Class<?>[] types = c.getParameterTypes();
            desc = desc + "(";
            for (Class<?> t : types) {
                desc = desc + InvokeMethodAdapter.vmType(t.getName());
            }
            desc = desc + ")";
            desc = desc + "V";
        } else if (obj instanceof Class) {
            Class c = (Class)obj;
            desc = c.getName().replace(".", "/");
            desc = desc + "<init>()V";
        }
        return desc.hashCode();
    }

    private static String vmType(String type) {
        String res = "";
        if (type.equals("")) {
            return "V";
        }
        while (type.endsWith("[]")) {
            type = type.substring(0, type.length() - 2);
            res = res + "[";
        }
        while (type.startsWith("[")) {
            res = res + '[';
            type = type.substring(1);
        }
        if (type.equals("byte")) {
            res = res + "B";
        } else if (type.equals("char")) {
            res = res + "C";
        } else if (type.equals("double")) {
            res = res + "D";
        } else if (type.equals("float")) {
            res = res + "F";
        } else if (type.equals("int")) {
            res = res + "I";
        } else if (type.equals("long")) {
            res = res + "J";
        } else if (type.equals("short")) {
            res = res + "S";
        } else if (type.equals("boolean")) {
            res = res + "Z";
        } else if (type.equals("void")) {
            res = res + "V";
        } else {
            if (!(type = type.replace(".", "/")).startsWith("L")) {
                type = "L" + type;
            }
            res = res + type;
            if (!type.endsWith(";")) {
                res = res + ";";
            }
        }
        return res;
    }

    public static void addID(String className, String name, String descr, int id) {
        String sig = className + "." + name + descr;
        map.put(sig, id);
    }

    private static enum ReflPair {
        CLASS("java/lang/Class", "newInstance"),
        METHOD("java/lang/reflect/Method", "invoke"),
        CONSTRUCTOR("java/lang/reflect/Constructor", "newInstance");

        private String className;
        private String methName;

        private ReflPair(String className, String methName) {
            this.className = className;
            this.methName = methName;
        }

        private boolean isEqual(String clName, String mName) {
            return this.className.equals(clName) && this.methName.equals(mName);
        }

        public static boolean contains(String clName, String mName) {
            return ReflPair.valueOf(clName, mName) != null;
        }

        public static ReflPair valueOf(String clName, String mName) {
            for (ReflPair p : ReflPair.values()) {
                if (!p.isEqual(clName, mName)) continue;
                return p;
            }
            return null;
        }
    }
}

