/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.instrument.reader;

import com.sun.tdk.jcov.data.FileFormatException;
import com.sun.tdk.jcov.instrument.BasicBlock;
import com.sun.tdk.jcov.instrument.Constants;
import com.sun.tdk.jcov.instrument.DataAbstract;
import com.sun.tdk.jcov.instrument.DataBlockCatch;
import com.sun.tdk.jcov.instrument.DataBlockFallThrough;
import com.sun.tdk.jcov.instrument.DataBlockMethEnter;
import com.sun.tdk.jcov.instrument.DataBranchCond;
import com.sun.tdk.jcov.instrument.DataBranchGoto;
import com.sun.tdk.jcov.instrument.DataBranchSwitch;
import com.sun.tdk.jcov.instrument.DataExit;
import com.sun.tdk.jcov.instrument.DataExitSimple;
import com.sun.tdk.jcov.instrument.reader.Reader;
import com.sun.tdk.jcov.instrument.reader.ReaderFactory;
import com.sun.tdk.jcov.instrument.reader.ReaderFactoryStAX;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class BasicBlockStAX
implements Reader {
    private BasicBlock block;
    private XMLStreamReader parser;
    private ReaderFactory rf;

    @Override
    public void readData(Object dest) throws FileFormatException {
        this.block = (BasicBlock)dest;
        try {
            this.readData();
        }
        catch (XMLStreamException ex) {
            throw new FileFormatException(ex);
        }
    }

    void readData() throws XMLStreamException, FileFormatException {
        Reader r = this.rf.getSuperReaderFor(BasicBlock.class);
        r.readData(this.block);
        this.parser.nextTag();
        while (this.parser.getEventType() != 2 || this.parser.getLocalName() != "bl") {
            String elem = this.parser.getLocalName();
            if (this.isXMLDataExit(elem)) {
                this.block.setExit(this.instantiateExit());
            } else {
                if (elem == "methenter") {
                    DataBlockMethEnter enter = new DataBlockMethEnter(this.block.rootId(), 0, false, 0L);
                    enter.readDataFrom();
                    this.block.add(enter);
                } else if (elem == "fall") {
                    DataBlockFallThrough fall = new DataBlockFallThrough(this.block.rootId(), 0, false, 0L);
                    fall.readDataFrom();
                    this.block.add(fall);
                } else if (elem == "catch") {
                    DataBlockCatch ctch = new DataBlockCatch(this.block.rootId(), 0, false, 0L);
                    ctch.readDataFrom();
                    this.block.add(ctch);
                }
                this.parser.nextTag();
            }
            this.parser.nextTag();
        }
    }

    private boolean isXMLDataExit(String elem) {
        return elem == "exit" || elem == "switch" || elem == "goto" || elem == "br";
    }

    private DataExit instantiateExit() throws XMLStreamException, FileFormatException {
        DataAbstract dExit = null;
        String elem = this.parser.getLocalName();
        int start = Integer.parseInt(this.parser.getAttributeValue(null, "s"));
        int end = Integer.parseInt(this.parser.getAttributeValue(null, "e"));
        if (elem == "exit") {
            int opCode = Constants.getOpCode(this.parser.getAttributeValue(null, "opcode"));
            dExit = new DataExitSimple(this.block.rootId(), start, end, opCode);
            this.parser.nextTag();
            return dExit;
        }
        if (elem == "switch") {
            dExit = new DataBranchSwitch(this.block.rootId(), start, end);
        } else if (elem == "goto") {
            dExit = new DataBranchGoto(this.block.rootId(), start, end);
        } else if (elem == "br") {
            dExit = new DataBranchCond(this.block.rootId(), start, end);
        }
        dExit.readDataFrom();
        return dExit;
    }

    @Override
    public void setReaderFactory(ReaderFactory r) {
        this.rf = r;
        this.parser = ((ReaderFactoryStAX)r).parser;
    }
}

