/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.report;

import com.sun.tdk.jcov.data.Scale;
import com.sun.tdk.jcov.filter.MemberFilter;
import com.sun.tdk.jcov.instrument.DataClass;
import com.sun.tdk.jcov.instrument.DataField;
import com.sun.tdk.jcov.instrument.DataMethod;
import com.sun.tdk.jcov.report.AbstractCoverage;
import com.sun.tdk.jcov.report.AncFilter;
import com.sun.tdk.jcov.report.CoverageData;
import com.sun.tdk.jcov.report.DataType;
import com.sun.tdk.jcov.report.FieldCoverage;
import com.sun.tdk.jcov.report.LineCoverage;
import com.sun.tdk.jcov.report.MethodCoverage;
import com.sun.tdk.jcov.report.javap.JavapClass;
import com.sun.tdk.jcov.util.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ClassCoverage
extends AbstractCoverage {
    private String source;
    private boolean javapSource = false;
    private JavapClass javapClass;
    private List<MethodCoverage> methods = new ArrayList<MethodCoverage>();
    private List<FieldCoverage> fields = new ArrayList<FieldCoverage>();
    private LineCoverage lineCoverage = new LineCoverage();
    private DataType[] supportedColumns = new DataType[]{DataType.CLASS, DataType.METHOD, DataType.FIELD, DataType.BLOCK, DataType.BRANCH, DataType.LINE};
    private int access;
    private String fullname;
    private String name;
    private String packagename;
    private String modulename;
    private boolean isInAnc = false;
    protected String ancInfo;
    static final String pref = "<UNKNOWN_SOURCE/";
    static final String suff = ">";

    public ClassCoverage(DataClass clz, String[] srcRootPaths, MemberFilter filter) {
        this(clz, srcRootPaths, null, filter);
    }

    public ClassCoverage(DataClass clz, String[] srcRootPaths, List<JavapClass> javapClasses, MemberFilter filter) {
        this(clz, srcRootPaths, null, filter, null, false);
    }

    public ClassCoverage(DataClass clz, String[] srcRootPaths, List<JavapClass> javapClasses, MemberFilter filter, AncFilter[] ancFilters, boolean anonym) {
        this.access = clz.getAccess();
        this.fullname = clz.getFullname();
        this.name = clz.getName();
        this.packagename = clz.getPackageName();
        this.modulename = clz.getModuleName();
        if (ancFilters != null) {
            for (AncFilter ancFilter : ancFilters) {
                if (!ancFilter.accept(clz)) continue;
                this.isInAnc = true;
                this.setAncInfo(ancFilter.getAncReason());
                break;
            }
        }
        for (DataMethod method : clz.getMethods()) {
            if (filter != null && !filter.accept(clz, method)) continue;
            MethodCoverage methodCoverage = null;
            if (ancFilters != null) {
                for (AncFilter ancFilter : ancFilters) {
                    if (!this.isInAnc && !ancFilter.accept(clz, method)) continue;
                    methodCoverage = new MethodCoverage(method, ancFilters, ancFilter.getAncReason());
                    methodCoverage.setAncInfo(ancFilter.getAncReason());
                    break;
                }
            }
            if (methodCoverage == null) {
                methodCoverage = new MethodCoverage(method, ancFilters, null);
            }
            methodCoverage.setAnonymOn(anonym);
            if (method.getName() != null && method.getName().matches("\\$\\d.*")) {
                methodCoverage.setInAnonymClass(true);
            }
            if ((method.getAccess() & 0x1000) != 0 && method.getName().startsWith("lambda$")) {
                methodCoverage.setLambdaMethod(true);
            }
            this.methods.add(methodCoverage);
            this.lineCoverage.processLineCoverage(methodCoverage.getLineCoverage());
        }
        for (DataField field : clz.getFields()) {
            if (filter != null && !filter.accept(clz, field)) continue;
            FieldCoverage fieldCoverage = new FieldCoverage(field);
            this.fields.add(fieldCoverage);
        }
        if (javapClasses == null) {
            this.source = ClassCoverage.findBestSource(clz, srcRootPaths);
        } else {
            this.javapSource = true;
            for (JavapClass jpClass : javapClasses) {
                if (jpClass == null || jpClass.getClassName() == null || !jpClass.getClassName().equals(this.name)) continue;
                this.javapClass = jpClass;
                break;
            }
        }
        Collections.sort(this.methods);
        Collections.sort(this.fields);
    }

    public boolean isEmpty() {
        return this.methods.isEmpty() && this.fields.isEmpty();
    }

    public boolean isPublicAPI() {
        return (this.access & 5) != 0;
    }

    public boolean isPublic() {
        return (this.access & 1) != 0;
    }

    public boolean isPrivate() {
        return (this.access & 2) != 0;
    }

    public boolean isProtected() {
        return (this.access & 4) != 0;
    }

    public boolean isAbstract() {
        return (this.access & 0x400) != 0;
    }

    public boolean isFinal() {
        return (this.access & 0x10) != 0;
    }

    public int getAccess() {
        return this.access;
    }

    @Override
    public boolean isCoveredByTest(int test) {
        for (MethodCoverage method : this.methods) {
            Scale s = method.getScale();
            if (s == null || !s.isBitSet(test)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isCovered() {
        for (MethodCoverage method : this.methods) {
            if (method.count <= 0L) continue;
            return true;
        }
        return false;
    }

    public List<MethodCoverage> getMethods() {
        return this.methods;
    }

    public List<FieldCoverage> getFields() {
        return this.fields;
    }

    public String getPackageName() {
        return this.packagename;
    }

    public String getModuleName() {
        return this.modulename;
    }

    public String getFullClassName() {
        return this.fullname.replace('/', '.');
    }

    public String getFullClassNameFilename() {
        return this.fullname;
    }

    public String getSource() {
        return this.source;
    }

    public boolean isJavapSource() {
        return this.javapSource;
    }

    public JavapClass getJavapClass() {
        return this.javapClass;
    }

    @Override
    public DataType getDataType() {
        return DataType.CLASS;
    }

    @Override
    protected DataType[] getDataTypes() {
        return this.supportedColumns;
    }

    public boolean isLineCovered(int lineNum) {
        return this.lineCoverage.isLineCovered(lineNum);
    }

    public boolean isLineInAnc(int lineNum) {
        return this.lineCoverage.isLineAnc(lineNum);
    }

    public void setAncInfo(String ancInfo) {
        this.isInAnc = ancInfo != null && !ancInfo.isEmpty();
        this.ancInfo = ancInfo;
    }

    public String getAncInfo() {
        return this.ancInfo;
    }

    public boolean isCode(long lineNum) {
        return this.lineCoverage.isCode(lineNum);
    }

    @Override
    public CoverageData getData(DataType column, int testNumber) {
        switch (column) {
            case CLASS: {
                boolean allMethodsInANC = true;
                for (MethodCoverage method : this.methods) {
                    if (method.count > 0L && (testNumber < 0 || method.isCoveredByTest(testNumber))) {
                        if (this.isInAnc) {
                            return new CoverageData(1, 1, 1);
                        }
                        return new CoverageData(1, 0, 1);
                    }
                    if (method.count > 0L || method.isMethodInAnc()) continue;
                    allMethodsInANC = false;
                }
                if (this.isInAnc || allMethodsInANC && this.methods.size() > 0) {
                    return new CoverageData(0, 1, 1);
                }
                return new CoverageData(0, 0, 1);
            }
            case METHOD: 
            case BLOCK: 
            case BRANCH: {
                CoverageData covered = new CoverageData(0, 0, 0);
                for (MethodCoverage method : this.methods) {
                    if (testNumber < 0 || method.isCoveredByTest(testNumber)) {
                        covered.add(method.getData(column, testNumber));
                        continue;
                    }
                    CoverageData mcov = method.getData(column, testNumber);
                    covered.add(new CoverageData(0, mcov.getAnc(), mcov.getTotal()));
                }
                return covered;
            }
            case FIELD: {
                CoverageData covered = new CoverageData(0, 0, 0);
                for (FieldCoverage field : this.fields) {
                    covered.add(field.getData(column));
                }
                return covered;
            }
            case LINE: {
                return new CoverageData(this.lineCoverage.getCovered(), this.lineCoverage.getAnc(), this.lineCoverage.getTotal());
            }
        }
        return new CoverageData();
    }

    @Override
    public CoverageData getData(DataType column) {
        return this.getData(column, -1);
    }

    private static String findBestSource(DataClass clz, String[] source_paths) {
        int i;
        if (source_paths == null) {
            return clz.getSource();
        }
        char sep = File.separatorChar;
        String source_name = clz.getSource();
        boolean dummy = false;
        if (source_name == null) {
            String clzName = clz.getName();
            int indexOf = clzName.indexOf(36);
            clzName = indexOf > 0 ? clzName.substring(0, indexOf) : clzName + ".java";
            source_name = clzName;
            dummy = true;
        }
        if (source_name.startsWith(pref) && source_name.endsWith(suff)) {
            source_name = source_name.substring(0, source_name.length() - suff.length());
            source_name = source_name.substring(pref.length());
            dummy = true;
        }
        source_name = source_name.replace('/', sep);
        source_name = source_name.replace('\\', sep);
        source_name = Utils.basename(source_name);
        if (dummy && (i = source_name.indexOf("$")) > 0) {
            source_name = source_name.substring(0, i) + ".java";
        }
        String pckg = clz.getPackageName();
        source_name = pckg.replace('/', File.separatorChar) + sep + source_name;
        for (int i2 = 0; i2 < source_paths.length; ++i2) {
            File f = new File(source_paths[i2] + source_name);
            if (f.exists()) {
                return f.getAbsolutePath();
            }
            if (clz.getModuleName() == null) continue;
            if (source_paths[i2].contains("#module") && (f = new File(source_paths[i2].replaceAll("\\#module", clz.getModuleName()) + source_name)).exists()) {
                return f.getAbsolutePath();
            }
            f = new File(source_paths[i2].concat(clz.getModuleName()).concat(String.valueOf(sep)).concat(source_name));
            if (!f.exists()) continue;
            return f.getAbsolutePath();
        }
        return clz.getSource();
    }
}

