/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.report;

import com.sun.tdk.jcov.report.ClassCoverage;
import com.sun.tdk.jcov.report.Test;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SmartTestService
implements Iterable<Test> {
    private List<Test> allTests;

    public SmartTestService() {
        this.allTests = new ArrayList<Test>();
    }

    public SmartTestService(String[] tests) {
        this.allTests = new ArrayList<Test>(tests.length);
        for (String test : tests) {
            this.allTests.add(new SmartTest(test));
        }
    }

    public SmartTestService(BufferedReader reader) {
        try {
            this.allTests = new ArrayList<Test>();
            String name = null;
            while ((name = reader.readLine()) != null) {
                this.allTests.add(new SmartTest(name));
            }
        }
        catch (IOException ioe) {
            throw new Error(ioe);
        }
    }

    public List<Test> getHitTestByClasses(ClassCoverage clz) {
        ArrayList<Test> result = new ArrayList<Test>();
        if (this.allTests.isEmpty()) {
            result.addAll(this.allTests);
        } else {
            for (int i = 0; i < this.allTests.size(); ++i) {
                if (!clz.isCoveredByTest(i)) continue;
                result.add(this.allTests.get(i));
            }
        }
        return result;
    }

    public List<Test> getAllTests() {
        return this.allTests;
    }

    public int getTestCount() {
        return this.allTests.size();
    }

    @Override
    public Iterator<Test> iterator() {
        return this.allTests.iterator();
    }

    private static class SmartTest
    implements Test {
        private String name;
        private String testername;

        SmartTest(String name) {
            this.name = name;
        }

        SmartTest(String name, String testername) {
            this.name = name;
            this.testername = testername;
        }

        @Override
        public String getTestName() {
            return this.name;
        }

        @Override
        public String getTestOwner() {
            return this.testername;
        }
    }
}

