/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.report.html;

import com.sun.tdk.jcov.instrument.InstrumentationOptions;
import com.sun.tdk.jcov.report.AbstractCoverage;
import com.sun.tdk.jcov.report.ClassCoverage;
import com.sun.tdk.jcov.report.CoverageData;
import com.sun.tdk.jcov.report.DataType;
import com.sun.tdk.jcov.report.FieldCoverage;
import com.sun.tdk.jcov.report.ItemCoverage;
import com.sun.tdk.jcov.report.MemberCoverage;
import com.sun.tdk.jcov.report.MethodCoverage;
import com.sun.tdk.jcov.report.PackageCoverage;
import com.sun.tdk.jcov.report.ProductCoverage;
import com.sun.tdk.jcov.report.ReportGenerator;
import com.sun.tdk.jcov.report.SmartTestService;
import com.sun.tdk.jcov.report.SubpackageCoverage;
import com.sun.tdk.jcov.report.Test;
import com.sun.tdk.jcov.report.html.JavaToHtml;
import com.sun.tdk.jcov.report.html.resources.CopyResources;
import com.sun.tdk.jcov.report.javap.JavapClass;
import com.sun.tdk.jcov.report.javap.JavapCodeLine;
import com.sun.tdk.jcov.report.javap.JavapLine;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CoverageReport
implements ReportGenerator {
    private ProductCoverage coverage;
    private SmartTestService testService;
    private boolean isGenSrc4Zero = false;
    private boolean isGenHitTests = false;
    private boolean isAddTestsInfo = false;
    private boolean isMergeRepGenMode = false;
    private boolean isAnonymOn = false;
    private String title = "Coverage report";
    private String mainReportTitle;
    private String overviewListTitle;
    private String entitiesTitle;
    private String dir;
    private boolean showLines;
    private boolean showFields;
    private boolean showBranches;
    private boolean showBlocks;
    private boolean showMethods;
    private boolean showOverviewColorBars;
    private static final Logger logger = Logger.getLogger(CoverageReport.class.getName());
    private InstrumentationOptions.InstrumentationMode mode;
    private static final String REPORT_DATE;

    @Override
    public void init(String dir) throws IOException {
        this.dir = dir;
        File d = new File(dir);
        if (d.exists() && !d.isDirectory()) {
            throw new IOException("Not a directory: " + dir);
        }
        if (!d.exists() && !d.mkdirs()) {
            throw new IOException("Failed to create directory: " + dir);
        }
    }

    @Override
    public void generateReport(ProductCoverage coverage, ReportGenerator.Options options) throws IOException {
        this.coverage = coverage;
        if (options.getTestListService() != null) {
            this.setTestService(options.getTestListService());
            this.setGenHitTests(true);
            this.setAddTestsInfo(options.isWithTestsInfo());
            this.setMergeRepGenMode(options.isMergeRepGenMode());
        }
        this.setInstrMode(options.getInstrMode());
        this.isAnonymOn = options.isAnonymOn();
        this.mainReportTitle = options.getMainReportTitle() == null ? "Coverage report" : options.getMainReportTitle();
        this.overviewListTitle = options.getOverviewListTitle() == null ? "Coverage report" : options.getOverviewListTitle();
        this.entitiesTitle = options.getEntitiesTitle() == null ? "Coverage report" : options.getEntitiesTitle();
        this.setGenSrc4Zero(true);
        this.generate();
    }

    public void generate() throws IOException {
        File directory = new File(this.dir);
        directory.mkdirs();
        CopyResources.copy(directory);
        this.generateSourceFiles(directory);
        this.generateFrameset(directory);
        HashMap<String, ArrayList<ModuleCoverageData>> modules = this.getModulesCoverage();
        if (modules == null || modules.size() == 1 && "no_module".equals(modules.keySet().iterator().next())) {
            modules = null;
        }
        this.generateOverview(directory, modules);
        if (modules != null) {
            this.generateModulesList(directory, modules);
        }
        this.generatePackageList(directory, modules);
        this.generateClassList(directory);
    }

    private void generateModulesList(File directory, HashMap<String, ArrayList<ModuleCoverageData>> modules) throws IOException {
        List<PackageCoverage> list = this.coverage.getPackages();
        for (String moduleName : modules.keySet()) {
            HashMap<String, ArrayList<ModuleCoverageData>> module = new HashMap<String, ArrayList<ModuleCoverageData>>();
            module.put(moduleName, modules.get(moduleName));
            this.generateModuleOverview(directory, list, module);
        }
    }

    private HashMap<String, ArrayList<ModuleCoverageData>> getModulesCoverage() {
        HashMap<String, ArrayList<ModuleCoverageData>> modules = null;
        List<PackageCoverage> list = this.coverage.getPackages();
        if (list == null || list.size() == 0 || list.get(0) == null || list.get(0).getClasses() == null || list.get(0).getClasses().get(0).getModuleName() == null) {
            return modules;
        }
        modules = new HashMap<String, ArrayList<ModuleCoverageData>>();
        for (PackageCoverage pkg : list) {
            int test;
            String moduleName = pkg.getClasses().get(0).getModuleName();
            if (modules.get(moduleName) == null) {
                ArrayList<ModuleCoverageData> coverageDataList = new ArrayList<ModuleCoverageData>();
                if (this.testService != null && (this.isAddTestsInfo || this.isMergeRepGenMode)) {
                    for (test = 0; test < this.testService.getTestCount(); ++test) {
                        coverageDataList.add(new ModuleCoverageData(pkg, test));
                    }
                }
                coverageDataList.add(new ModuleCoverageData(pkg));
                modules.put(moduleName, coverageDataList);
                continue;
            }
            ArrayList<ModuleCoverageData> modulesCD = modules.get(moduleName);
            if (this.testService != null && (this.isAddTestsInfo || this.isMergeRepGenMode)) {
                for (test = 0; test < this.testService.getTestCount(); ++test) {
                    modulesCD.get(test).addPackage(pkg, test);
                }
            }
            modulesCD.get(modulesCD.size() - 1).addPackage(pkg);
        }
        return modules;
    }

    public void setVerbose(boolean verbose) {
        logger.setLevel(verbose ? Level.CONFIG : Level.WARNING);
    }

    public void setTestService(SmartTestService testService) {
        this.testService = testService;
    }

    public void setGenSrc4Zero(boolean isGenSrc4Zero) {
        this.isGenSrc4Zero = isGenSrc4Zero;
    }

    public void setGenHitTests(boolean isGenHitTests) {
        this.isGenHitTests = isGenHitTests;
    }

    public void setAddTestsInfo(boolean isWithTestsInfo) {
        this.isAddTestsInfo = isWithTestsInfo;
    }

    public void setMergeRepGenMode(boolean isMergeRepGenMode) {
        this.isMergeRepGenMode = isMergeRepGenMode;
    }

    public void setInstrMode(InstrumentationOptions.InstrumentationMode mode) {
        this.mode = mode;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    private void generateFrameset(File dir) throws IOException {
        File fsFile = new File(dir, "index.html");
        PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fsFile), Charset.defaultCharset())));
        pw.println("<!DOCTYPE html>");
        pw.println("<html>");
        pw.println("<head>");
        pw.println("<title>" + this.title + " </title>");
        pw.println("<link rel =\"stylesheet\" type=\"text/css\" href=\"style.css\" title=\"Style\">");
        this.generateScriptsHeader(pw);
        pw.println("</head>");
        String leftPaneStyle = "left20Container";
        String rightPaneStyle = "right80Container";
        if (this.showOverviewColorBars) {
            leftPaneStyle = "left30Container";
            rightPaneStyle = "right70Container";
        }
        pw.println("<body>");
        pw.println("<div class=\"container\">");
        pw.println("  <div class=\"" + leftPaneStyle + "\">");
        pw.println("    <div class=\"leftTop\">");
        pw.println("      <iframe seamless src=\"overview-frame.html\" name=\"packageListFrame\" title=\"All Packages\"></iframe>");
        pw.println("    </div>");
        pw.println("    <div class=\"leftBottom\">");
        pw.println("      <iframe src=\"allclasses-frame.html\" name=\"packageFrame\" title=\"All classes and interfaces (except non-static nested types)\"></iframe>");
        pw.println("    </div>");
        pw.println("  </div>");
        pw.println("  <div class=\"" + rightPaneStyle + "\">");
        pw.println("    <iframe src=\"overview-summary.html\" name=\"classFrame\" title=\"Package, class and interface descriptions\"></iframe>");
        pw.println("  </div>");
        pw.println("</div>");
        pw.println("</body>");
        pw.println("</html>");
        pw.close();
    }

    private void generatePackageList(File dir, HashMap<String, ArrayList<ModuleCoverageData>> modules) throws IOException {
        File fsFile = new File(dir, "overview-frame.html");
        logger.log(Level.INFO, "generatePackageList:{0}", fsFile.getAbsolutePath());
        PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fsFile), Charset.defaultCharset())));
        pw.println("<!DOCTYPE html>");
        pw.println("<html>");
        pw.println("<head>");
        pw.println("<title>coverage report</title>");
        pw.println("<link rel =\"stylesheet\" type=\"text/css\" href=\"style.css\" title=\"Style\">");
        pw.println("</head>");
        pw.println("<body>");
        pw.println("<span class=\"title\">" + this.overviewListTitle + "</span><br>");
        pw.println("<br>");
        pw.println("<table>");
        pw.println("<tr>");
        pw.println("<td nowrap=\"nowrap\">");
        pw.println("<a href=\"overview-summary.html\" target=\"classFrame\">Overview</a><br>");
        pw.println("<a href=\"allclasses-frame.html\" target=\"packageFrame\">All classes</a>");
        pw.println("</td>");
        pw.println("</tr>");
        pw.println("</table>");
        if (modules != null) {
            pw.println("<table>");
            pw.println("<tr>");
            pw.println("<td nowrap=\"nowrap\"><span class=\"title2\">All modules</span></td>");
            pw.println("</tr>");
            pw.println("<tr>");
            pw.println("<td nowrap=\"nowrap\">");
            ArrayList<String> modulesList = new ArrayList<String>(modules.keySet());
            Collections.sort(modulesList);
            for (String module : modulesList) {
                pw.println("<a href=\"" + module + "/module-summary.html\" target=\"classFrame\" onClick=\"parent.frames[1].location.href='allclasses-frame.html';\">" + module + "</a><br>");
            }
            pw.println("</tr>");
            pw.println("</table>");
        }
        pw.println("<table>");
        pw.println("<tr>");
        pw.println("<td nowrap=\"nowrap\"><span class=\"title2\">All packages</span></td>");
        pw.println("</tr>");
        pw.println("<tr>");
        pw.println("<td nowrap=\"nowrap\">");
        List<PackageCoverage> list = this.coverage.getPackages();
        for (PackageCoverage pkg : list) {
            String pkgPath = pkg.getName().replace('.', '/');
            String url = pkgPath + "/package-frame.html";
            logger.log(Level.FINE, "generatePackageList:url:{0}", url);
            String pkgCovData = "";
            if (this.showOverviewColorBars) {
                pkgCovData = this.generatePercentResult(pkg.getCoverageString(DataType.METHOD, this.coverage.isAncFiltersSet()), true);
            }
            pw.println("<a href=\"" + url + "\" target=\"packageFrame\" onClick=\"parent.frames[2].location.href='" + pkgPath + "/package-summary.html';\">" + pkgCovData + pkg.getName() + "</a><br>");
        }
        pw.println("</td>");
        pw.println("</tr>");
        pw.println("</table>");
        pw.println("</body>");
        pw.println("</html>");
        pw.close();
        for (PackageCoverage pkg : list) {
            this.generateClassList(dir, pkg);
            this.generateOverview(dir, pkg, null);
        }
    }

    private void generateClassList(File dir) throws IOException {
        this.generateClassList(dir, null);
    }

    private void generateClassList(File dir, PackageCoverage pkg) throws IOException {
        List<Object> classes;
        String filename;
        String rootRef;
        String urlDirectory = "";
        if (pkg == null) {
            rootRef = "";
            filename = "allclasses-frame.html";
            List<PackageCoverage> list = this.coverage.getPackages();
            classes = new ArrayList();
            for (PackageCoverage pcov : list) {
                classes.addAll(pcov.getClasses());
            }
            Collections.sort((List)classes);
        } else {
            rootRef = this.getRelativePath(pkg.getName());
            filename = pkg.getName().replace('.', '/') + "/package-frame.html";
            classes = pkg.getClasses();
            urlDirectory = ".";
        }
        logger.log(Level.INFO, "generateClassList:filename:{0}", filename);
        File fsFile = new File(dir, filename);
        if (!fsFile.getParentFile().exists()) {
            logger.log(Level.INFO, "mkdirs:{0}", fsFile.getParentFile());
            fsFile.getParentFile().mkdirs();
        }
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fsFile), Charset.defaultCharset()));
        pw.println("<!DOCTYPE html>");
        pw.println("<html>");
        pw.println("<head>");
        pw.println("<title>coverage report</title>");
        pw.println("<link rel =\"stylesheet\" type=\"text/css\" href=\"" + rootRef + "style.css\" title=\"Style\">");
        pw.println("</head>");
        pw.println("<body>");
        if (pkg != null) {
            pw.println("<p>");
            pw.println("<a href=\"package-summary.html\" target=\"classFrame\">" + pkg.getName() + "</a> <span class=\"text_italic\">&nbsp;" + pkg.getCoverageString(DataType.METHOD, this.coverage.isAncFiltersSet()) + "</span><br>");
            pw.println("</p>");
        }
        pw.println("<span class=\"title\">All classes</span>");
        pw.println("<table>");
        pw.println("<tr>");
        pw.println("<td nowrap=\"nowrap\">");
        int i = 0;
        for (ClassCoverage classCoverage : classes) {
            String prc;
            logger.log(Level.INFO, "{0} generateClassList:theClass:{1}", new Object[]{++i, classCoverage.getName()});
            String string = prc = this.showFields ? classCoverage.getData(DataType.METHOD).add(classCoverage.getData(DataType.FIELD)).toString() : classCoverage.getCoverageString(DataType.METHOD, this.coverage.isAncFiltersSet());
            if (pkg == null) {
                urlDirectory = classCoverage.getFullClassName().lastIndexOf(46) > 0 ? classCoverage.getFullClassName().substring(0, classCoverage.getFullClassName().lastIndexOf(46)).replace('.', '/') : ".";
            }
            String classCovBar = "";
            if (this.showOverviewColorBars) {
                classCovBar = this.generatePercentResult(classCoverage.getCoverageString(DataType.METHOD, this.coverage.isAncFiltersSet()), true);
            }
            String classFilename = classCoverage.getName() + ".html";
            pw.println("<a href=\"" + urlDirectory + "/" + classFilename + "\" target=\"classFrame\">" + classCovBar + classCoverage.getName() + "</a><span class=\"text_italic\">&nbsp;" + prc + "</span><br>");
        }
        pw.println("</td>");
        pw.println("</tr>");
        pw.println("</table>");
        pw.println("</body>");
        pw.println("</html>");
        pw.close();
    }

    private void generateOverview(File dir, HashMap<String, ArrayList<ModuleCoverageData>> modules) throws IOException {
        this.generateOverview(dir, null, modules);
    }

    /*
     * WARNING - void declaration
     */
    private void generateModuleOverview(File dir, List<PackageCoverage> allPkgList, HashMap<String, ArrayList<ModuleCoverageData>> module) throws IOException {
        String filename = "overview-summary.html";
        String rootRef = "../";
        String moduleName = module.keySet().iterator().next();
        if (moduleName != null) {
            filename = moduleName + "/module-summary.html";
            rootRef = "../";
        } else {
            rootRef = "";
        }
        File fsFile = new File(dir, filename);
        if (!fsFile.getParentFile().exists()) {
            logger.log(Level.INFO, "mkdirs:{0}", fsFile.getParentFile());
            fsFile.getParentFile().mkdirs();
        }
        PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fsFile), Charset.defaultCharset())));
        pw.println("<!DOCTYPE html>");
        pw.println("<html>");
        pw.println("<head>");
        pw.println("<title>coverage report</title>");
        pw.println("<link rel =\"stylesheet\" type=\"text/css\" href=\"" + rootRef + "style.css\" title=\"Style\">");
        pw.println("<script type=\"text/javascript\" src=\"" + rootRef + "sorttable.js\"></script>");
        pw.println("</head>");
        pw.println("<body>");
        pw.println("<p>");
        pw.println("<span class=\"title\"> <b>" + this.entitiesTitle + " </b> </span>");
        pw.println("</p>");
        if (module != null) {
            this.generateModulesInfo(pw, module, true);
        }
        pw.println("</table>");
        pw.println("<p>");
        ArrayList<PackageCoverage> modulesPkgList = new ArrayList<PackageCoverage>();
        for (PackageCoverage pc : allPkgList) {
            if (!pc.getClasses().get(0).getModuleName().equals(moduleName)) continue;
            modulesPkgList.add(pc);
        }
        ArrayList<PackageCoverage> pkgList = modulesPkgList;
        ArrayList<ClassCoverage> classes = new ArrayList<ClassCoverage>();
        for (PackageCoverage packageCoverage : pkgList) {
            classes.addAll(packageCoverage.getClasses());
        }
        SubpackageCoverage subCov = new SubpackageCoverage();
        pw.println("<span class=\"title2\">Packages</span><br>");
        pw.println("<table class=\"report\" cellpadding=\"0\" cellspacing=\"0\" id=\"subpackages\">");
        pw.println("<tr class=\"report\">");
        pw.println("<th class=\"report\">Name</th>");
        pw.println("<th class=\"report_number\">#classes</th>");
        pw.println("<th class=\"report\">%class</th>");
        this.printColumnHeaders(pw, "");
        pw.println("</tr>");
        for (PackageCoverage pkg : pkgList) {
            subCov.add(pkg);
            pw.println("<tr class=\"report\">");
            String subPkgDir = "../" + pkg.getName().replace('.', '/');
            pw.println("<td class=\"reportText\"><a href=\"" + subPkgDir + "/package-summary.html\">" + pkg.getName() + "</a></td>");
            pw.println("<td class=\"reportValue\">" + pkg.getData(DataType.CLASS).getTotal() + "</td>");
            pw.println("<td class=\"reportValue\">" + this.decorate(pkg.getCoverageString(DataType.CLASS, this.coverage.isAncFiltersSet())) + "</td>");
            this.printColumnCoverages(pw, pkg, true, "");
            pw.println("</tr>");
        }
        pw.println("</table>");
        pw.println("<p>");
        logger.log(Level.INFO, "generateOverview:classes.size:{0}", classes.size());
        if (classes.size() > 0) {
            pw.println("<span class=\"title2\">Classes</span><br>");
            pw.println("<table class=\"report\" cellpadding=\"0\" cellspacing=\"0\" id=\"classes\">");
            pw.println("<tr class=\"report\">");
            pw.println("<th class=\"report\">Name</th>");
            this.printColumnHeaders(pw, "");
            pw.println("</tr>");
            boolean bl = false;
            for (ClassCoverage cc : classes) {
                void var13_16;
                logger.log(Level.INFO, "{0} generateOverview():cl:{1}", new Object[]{(int)(++var13_16), cc.getName()});
                String classFilename = cc.getName();
                pw.println("<tr class=\"report\">");
                pw.println("<td class=\"reportText\"><a href=\"../" + cc.getPackageName().replace('.', '/') + "/" + classFilename + ".html\">" + classFilename + "</a></td>");
                this.printColumnCoverages(pw, cc, true, "");
                pw.println("</tr>");
            }
            pw.println("</table>");
        }
        pw.println(this.generateFooter());
        pw.println("</body>");
        pw.println("</html>");
        pw.close();
    }

    private void generateOverview(File dir, PackageCoverage thePackage, HashMap<String, ArrayList<ModuleCoverageData>> modules) throws IOException {
        String rootRef;
        String filename = "overview-summary.html";
        if (thePackage != null) {
            filename = thePackage.getName().replace('.', '/') + "/package-summary.html";
            rootRef = this.getRelativePath(thePackage.getName());
        } else {
            rootRef = "";
        }
        logger.log(Level.INFO, "generateOverview:filename:{0}", filename);
        File fsFile = new File(dir, filename);
        if (!fsFile.getParentFile().exists()) {
            logger.log(Level.INFO, "mkdirs:{0}", fsFile.getParentFile());
            fsFile.getParentFile().mkdirs();
        }
        PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fsFile), Charset.defaultCharset())));
        pw.println("<!DOCTYPE html>");
        pw.println("<html>");
        pw.println("<head>");
        pw.println("<title>coverage report</title>");
        pw.println("<link rel =\"stylesheet\" type=\"text/css\" href=\"" + rootRef + "style.css\" title=\"Style\">");
        pw.println("<script type=\"text/javascript\" src=\"" + rootRef + "sorttable.js\"></script>");
        pw.println("</head>");
        pw.println("<body>");
        String otitle = thePackage == null ? this.mainReportTitle : this.entitiesTitle;
        pw.println("<span class=\"title\">" + otitle + " </span>");
        pw.println("<br>");
        pw.println("<br>");
        pw.println("<table class=\"report\" cellpadding=\"0\" cellspacing=\"0\">");
        pw.println("<tr class=\"report\">");
        pw.println("<th class=\"report\">&nbsp;</th>");
        pw.println("<th class=\"report_number\">#classes</th>");
        this.printColumnHeaders(pw, "");
        pw.println("</tr>");
        pw.println("<tr class=\"report\">");
        if (thePackage != null) {
            pw.println("<td class=\"reportText\"> <b>" + thePackage.getName() + "</b></td>");
            pw.println("<td class=\"reportValue_number\">" + thePackage.getData(DataType.CLASS).getTotal() + "</td>");
            this.printColumnCoverages(pw, thePackage, false, "");
        } else {
            pw.println("<td class=\"reportText\"> <b>Overall statistics</b> </td>");
            pw.println("<td class=\"reportValue_number\">" + this.coverage.getData(DataType.CLASS).getTotal() + "</td>");
            this.printColumnCoverages(pw, this.coverage, false, "");
        }
        pw.println("</tr>");
        pw.println("</table>");
        pw.println("<p>");
        List<PackageCoverage> pkgList = null;
        SubpackageCoverage subCov = new SubpackageCoverage();
        if (thePackage != null) {
            pkgList = this.getSubPackages(thePackage);
            if (pkgList.size() > 0) {
                subCov.add(thePackage);
                pw.println("<span class=\"title2\">Subpackages</span><br>");
                pw.println("<table class=\"report\" cellpadding=\"0\" cellspacing=\"0\" id=\"subpackages\">");
                pw.println("<tr class=\"report\">");
                pw.println("<th class=\"report\">Name</th>");
                pw.println("<th class=\"report_number\">#classes</th>");
                pw.println("<th class=\"report\">%class</th>");
                this.printColumnHeaders(pw, "");
                pw.println("</tr>");
                for (PackageCoverage pkg : pkgList) {
                    subCov.add(pkg);
                    pw.println("<tr class=\"report\">");
                    String subPkgDir = pkg.getName().substring(thePackage.getName().length() + 1).replace('.', '/');
                    pw.println("<td class=\"reportText\"><a href=\"" + subPkgDir + "/package-summary.html\">" + pkg.getName() + "</a></td>");
                    pw.println("<td class=\"reportValue_number\">" + pkg.getData(DataType.CLASS).getTotal() + "</td>");
                    pw.println("<td class=\"reportValue\">" + this.decorate(pkg.getCoverageString(DataType.CLASS, this.coverage.isAncFiltersSet())) + "</td>");
                    this.printColumnCoverages(pw, pkg, true, "");
                    pw.println("</tr>");
                }
                pw.println("</table>");
                pw.println("<p>");
            }
            List<ClassCoverage> classes = thePackage.getClasses();
            logger.log(Level.INFO, "generateOverview:classes.size:{0}", classes.size());
            if (classes.size() > 0) {
                pw.println("<span class=\"title2\">Classes</span><br>");
                pw.println("<table class=\"report\" cellpadding=\"0\" cellspacing=\"0\" id=\"classes\">");
                pw.println("<tr class=\"report\">");
                pw.println("<th class=\"report\">Name</th>");
                this.printColumnHeaders(pw, "");
                pw.println("</tr>");
                int i = 0;
                for (ClassCoverage cc : classes) {
                    logger.log(Level.INFO, "{0} generateOverview():cl:{1}", new Object[]{++i, cc.getName()});
                    String classFilename = cc.getName();
                    pw.println("<tr class=\"report\">");
                    pw.println("<td class=\"reportText\"><a href=\"" + classFilename + ".html\">" + classFilename + "</a></td>");
                    this.printColumnCoverages(pw, cc, true, "");
                    pw.println("</tr>");
                }
                pw.println("</table>");
            }
        } else {
            pkgList = this.coverage.getPackages();
            if (pkgList.size() > 0) {
                if (modules != null) {
                    this.generateModulesInfo(pw, modules, false);
                }
                pw.println("<span class=\"title2\">Packages</span><br>");
                pw.println("<table class=\"report\" cellpadding=\"0\" cellspacing=\"0\" id=\"packages\">");
                pw.println("<tr class=\"report\">");
                pw.println("<th class=\"report\">Name</th>");
                pw.println("<th class=\"report_number\">#classes</th>");
                this.printColumnHeaders(pw, "");
                pw.println("</tr>");
                for (PackageCoverage pkg : pkgList) {
                    pw.println("<tr class=\"report\">");
                    pw.println("<td class=\"reportText\"><a href=\"" + pkg.getName().replace('.', '/') + "/package-summary.html\">" + pkg.getName() + "</a></td>");
                    pw.println("<td class=\"reportValue_number\">" + pkg.getData(DataType.CLASS).getTotal() + "</td>");
                    this.printColumnCoverages(pw, pkg, true, "");
                    pw.println("</tr>");
                }
                pw.println("</table>");
            }
        }
        if (thePackage != null && pkgList != null && pkgList.size() > 0) {
            pw.println("<p>");
            pw.println("<span class=\"title2\">Total (including subpackages)</span><br>");
            pw.println("<table class=\"report\" cellpadding=\"0\" cellspacing=\"0\" id=\"total_w_subpackages\">");
            pw.println("<tr class=\"report\">");
            pw.println("<th class=\"report\">-</th>");
            pw.println("<th class=\"report_number\">#classes</th>");
            this.printColumnHeaders(pw, "");
            pw.println("</tr>");
            pw.println("<tr class=\"report\">");
            pw.println("<td class=\"reportValue\"></td>");
            pw.println("<td class=\"reportValue_number\">" + subCov.getData(DataType.CLASS).getTotal() + "</td>");
            this.printColumnCoverages(pw, subCov, true, "");
            pw.println("</table>");
            pw.println("<br>");
        }
        pw.println(this.generateFooter());
        pw.println("</body>");
        pw.println("</html>");
        pw.close();
    }

    private void generateModulesInfo(PrintWriter pw, HashMap<String, ArrayList<ModuleCoverageData>> modules, boolean decorate) {
        if (modules.keySet().size() > 1) {
            pw.println("<span class=\"title2\">Modules</span><br>");
        } else {
            pw.println("<span class=\"title2\">Module</span><br>");
        }
        pw.println("<table class=\"report\" cellpadding=\"0\" cellspacing=\"0\" id=\"modules\">");
        pw.println("<tr class=\"report\">");
        pw.println("<th class=\"report\">Name</th>");
        pw.println("<th class=\"report_number\">#classes</th>");
        this.printColumnHeaders(pw, "");
        pw.println("</tr>");
        ArrayList<String> modulesList = new ArrayList<String>(modules.keySet());
        Collections.sort(modulesList);
        for (String module : modulesList) {
            pw.println("<tr class=\"report\">");
            if (!decorate) {
                pw.println("<td class=\"reportText\"><a href=\"" + module + "/module-summary.html\">" + module + "</a></td>");
            } else {
                pw.println("<td class=\"reportText\"> <b>" + module + " </b> </a></td>");
            }
            int moduleDataColumnsSize = modules.get(module).size();
            ModuleCoverageData totalModuleCD = modules.get(module).get(moduleDataColumnsSize - 1);
            pw.println("<td class=\"reportValue_number\">" + totalModuleCD.getData()[columns.classes.number].getTotal() + "</td>");
            for (int i = 1; i < totalModuleCD.getData().length; ++i) {
                if (!this.show(columns.valueOf(i))) continue;
                if (this.testService != null && (this.isAddTestsInfo || this.isMergeRepGenMode)) {
                    for (int test = 0; test < this.testService.getTestCount(); ++test) {
                        if (!this.show(columns.valueOf(i)) || i == columns.line.number) continue;
                        CoverageData cd = modules.get(module).get(test).getData()[i];
                        pw.println("<td class=\"reportValue\">" + this.decorate(cd.getFormattedCoverage(this.coverage.isAncFiltersSet())) + "</td>");
                    }
                }
                CoverageData cd = totalModuleCD.getData()[i];
                if (!decorate) {
                    pw.println("<td class=\"reportValue\">" + this.decorate(cd.getFormattedCoverage(this.coverage.isAncFiltersSet())) + "</td>");
                    continue;
                }
                pw.println("<td class=\"reportValue\">" + this.generatePercentResult(cd.getFormattedCoverage(this.coverage.isAncFiltersSet())) + "</td>");
            }
            pw.println("</tr>");
        }
        pw.println("</table>");
        pw.println("<p>");
    }

    boolean show(columns col) {
        switch (col) {
            case method: {
                return this.showMethods;
            }
            case field: {
                return this.showFields;
            }
            case block: {
                return this.showBlocks;
            }
            case branch: {
                return this.showBranches;
            }
            case line: {
                return this.showLines;
            }
        }
        return false;
    }

    String getColumnData(columns col, AbstractCoverage cc) {
        switch (col) {
            case method: {
                return cc.getCoverageString(DataType.METHOD, this.coverage.isAncFiltersSet());
            }
            case field: {
                return cc.getCoverageString(DataType.FIELD, this.coverage.isAncFiltersSet());
            }
            case block: {
                return cc.getCoverageString(DataType.BLOCK, this.coverage.isAncFiltersSet());
            }
            case branch: {
                return cc.getCoverageString(DataType.BRANCH, this.coverage.isAncFiltersSet());
            }
            case line: {
                return cc.getCoverageString(DataType.LINE, this.coverage.isAncFiltersSet());
            }
        }
        return "";
    }

    String getFormattedColumnData(columns col, AbstractCoverage cc, int testNumber) {
        switch (col) {
            case method: {
                return cc.getData(DataType.METHOD, testNumber).getFormattedCoverage(this.coverage.isAncFiltersSet());
            }
            case field: {
                return cc.getData(DataType.FIELD, testNumber).getFormattedCoverage(this.coverage.isAncFiltersSet());
            }
            case block: {
                return cc.getData(DataType.BLOCK, testNumber).getFormattedCoverage(this.coverage.isAncFiltersSet());
            }
            case branch: {
                return cc.getData(DataType.BRANCH, testNumber).getFormattedCoverage(this.coverage.isAncFiltersSet());
            }
            case line: {
                return "";
            }
        }
        return "";
    }

    void printColumnHeaders(PrintWriter pw, String pad) {
        for (columns col : columns.values()) {
            if (!this.show(col)) continue;
            if (col != columns.line && this.testService != null && (this.isAddTestsInfo || this.isMergeRepGenMode)) {
                int testNumber = 0;
                for (Test test : this.testService) {
                    pw.println("<th class=\"report\" title=\"" + test.getTestName() + "\">#" + ++testNumber + "</th>");
                }
            }
            pw.println(pad + "<th class=\"report\">%" + (Object)((Object)col) + "</th>");
        }
    }

    void printColumnCoverages(PrintWriter pw, AbstractCoverage cov, boolean decorate, String pad) {
        for (columns col : columns.values()) {
            if (!this.show(col)) continue;
            String testsData = "";
            if (this.testService != null && (this.isAddTestsInfo || this.isMergeRepGenMode)) {
                for (int test = 0; test < this.testService.getTestCount(); ++test) {
                    String columnData = this.getFormattedColumnData(col, cov, test);
                    if (this.mode != null && this.mode.equals((Object)InstrumentationOptions.InstrumentationMode.METHOD) && col != columns.method && !columnData.isEmpty()) {
                        columnData = "-";
                    }
                    if (columnData.isEmpty()) continue;
                    testsData = !columnData.trim().equals("-") ? testsData + "<td class=\"reportValue\">" + columnData + "</td>" : testsData + "<td class=\"reportValue\"><span style=\"text-align: center;\">" + columnData + "</span></td>";
                }
            }
            String data = this.getColumnData(col, cov);
            if (this.mode != null && this.mode.equals((Object)InstrumentationOptions.InstrumentationMode.METHOD) && col != columns.method) {
                data = "-";
            }
            String dataToShow = decorate ? this.decorate(data) : this.generatePercentResult(data);
            pw.println(pad + testsData + "<td class=\"reportValue\">" + dataToShow + "</td>");
        }
    }

    private List<PackageCoverage> getSubPackages(PackageCoverage thePackage) {
        ArrayList<PackageCoverage> list = new ArrayList<PackageCoverage>();
        String name = thePackage.getName();
        for (PackageCoverage pn : this.coverage) {
            String pname = pn.getName();
            int idx = pname.indexOf(name);
            if (idx == -1 || name.equals(pname) || !pname.replaceAll(name, "").startsWith(".")) continue;
            list.add(pn);
        }
        return list;
    }

    private void generateSourceFiles(File dir) throws IOException {
        logger.info("generating source files...");
        List<PackageCoverage> pkglist = this.coverage.getPackages();
        int i = 0;
        for (PackageCoverage pkgcov : pkglist) {
            logger.log(Level.FINE, "package:{0}", pkgcov.getName());
            List<ClassCoverage> clslist = pkgcov.getClasses();
            for (ClassCoverage clscov : clslist) {
                ++i;
                if (clscov == null) {
                    logger.log(Level.SEVERE, "{0}clscov is NULL!", i);
                    continue;
                }
                logger.log(Level.INFO, "{0} {1}", new Object[]{i, clscov.getName()});
                this.generateSourceFile(dir, clscov);
            }
        }
    }

    private void generateSourceFile(File directory, ClassCoverage theClass) throws IOException {
        String lineStr;
        boolean isGenerate;
        String srcOutputFilename = theClass.getFullClassName().replace('.', '/') + ".html";
        File srcOutputFile = new File(directory, srcOutputFilename);
        logger.log(Level.FINE, "srcOutputFile:{0}", srcOutputFile.getAbsolutePath());
        File dirOutputFile = srcOutputFile.getParentFile();
        if (dirOutputFile != null && !dirOutputFile.exists()) {
            logger.log(Level.INFO, "mkdirs:{0}", dirOutputFile);
            dirOutputFile.mkdirs();
        }
        PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(srcOutputFile), Charset.defaultCharset())));
        pw.println("<!DOCTYPE html>");
        pw.println("<html>");
        pw.println("<head>");
        pw.println("<title>tests coverage</title>");
        String rootRef = this.getRelativePath(theClass.getPackageName());
        pw.println("<link rel =\"stylesheet\" type=\"text/css\" href=\"" + rootRef + "style.css\" title=\"Style\">");
        pw.println("<script type=\"text/javascript\" src=\"" + rootRef + "sorttable.js\"></script>");
        this.generateScriptsHeader(pw);
        pw.println("</head>");
        pw.println("<body>");
        if (!theClass.getPackageName().isEmpty()) {
            this.generateNavHeader(pw, theClass.getName() + ".html", "" + theClass.getPackageName().replaceAll("[a-zA-Z0-9]+", "..") + "/index.html?" + srcOutputFilename);
        } else {
            this.generateNavHeader(pw, theClass.getName() + ".html", "" + theClass.getName() + "/../index.html?" + srcOutputFilename);
        }
        if (this.isGenHitTests) {
            pw.println("<p>");
            pw.println("<a href=\"#hittests\">Hit Tests</a>");
        }
        pw.println("<br>");
        pw.println(" <table cellspacing=\"0\" cellpadding=\"0\"class=\"report\">");
        pw.println(" <tr class=\"report\">");
        pw.println(" <th class=\"report\">&nbsp;</th>");
        this.printColumnHeaders(pw, " ");
        pw.println(" </tr>");
        pw.println(" <tr class=\"report\">");
        pw.println(" <td class=\"reportText\"><span class=\"text\"> <b>" + theClass.getFullClassName() + "</b></span></td>");
        this.printColumnCoverages(pw, theClass, false, " ");
        pw.println(" </tr>");
        pw.println(" </table>");
        pw.println(" <br>");
        String src = theClass.getSource();
        File srcfile = null;
        if (src == null || theClass.isJavapSource()) {
            isGenerate = false;
        } else {
            srcfile = new File(src);
            isGenerate = srcfile.exists();
        }
        int mcount = theClass.getData(DataType.METHOD).getCovered();
        if (mcount == 0 && !this.isGenSrc4Zero) {
            isGenerate = false;
        }
        HashMap<Integer, MemberCoverage> methodsForLine = new HashMap<Integer, MemberCoverage>();
        HashMap<Integer, List<ItemCoverage>> itemsForLine = new HashMap<Integer, List<ItemCoverage>>();
        List<MethodCoverage> methodList = theClass.getMethods();
        for (MethodCoverage methodCoverage : methodList) {
            methodsForLine.put(methodCoverage.getStartLine(), methodCoverage);
            for (ItemCoverage icov : methodCoverage.getItems()) {
                int srcLine = icov.getSourceLine();
                if (srcLine <= 0) continue;
                LinkedList<ItemCoverage> listIcov = (LinkedList<ItemCoverage>)itemsForLine.get(srcLine);
                if (listIcov == null) {
                    listIcov = new LinkedList<ItemCoverage>();
                    itemsForLine.put(srcLine, listIcov);
                }
                listIcov.add(icov);
            }
        }
        this.generateMemberTable(pw, theClass, "method", methodList, isGenerate, theClass.isJavapSource());
        List<FieldCoverage> fieldList = theClass.getFields();
        if (this.showFields) {
            for (FieldCoverage fcov : fieldList) {
                int startLine = fcov.getStartLine();
                methodsForLine.put(new Integer(startLine), fcov);
                logger.log(Level.FINE, "{0}-{1}", new Object[]{fcov.getName(), startLine});
            }
            this.generateMemberTable(pw, theClass, "field", fieldList, isGenerate, theClass.isJavapSource());
        }
        if (isGenerate) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(srcfile), Charset.defaultCharset()));
            int numLine = 1;
            pw.println(" <table cellspacing=\"0\" cellpadding=\"0\" class=\"src\">");
            while ((lineStr = bufferedReader.readLine()) != null) {
                this.generateSourceLine(pw, lineStr, numLine, theClass, methodsForLine, itemsForLine, null);
                ++numLine;
            }
            bufferedReader.close();
            pw.println(" </table>");
        }
        if (theClass.isJavapSource()) {
            pw.println(" <table cellspacing=\"0\" cellpadding=\"0\" class=\"src\">");
            JavapClass javapClass = theClass.getJavapClass();
            if (javapClass != null) {
                int numLine = 1;
                methodsForLine = new HashMap();
                for (MethodCoverage mcov : methodList) {
                    List<JavapLine> lines = javapClass.getMethod(mcov.getName() + mcov.getSignature());
                    if (lines == null) continue;
                    methodsForLine.put(lines.get(0).getLineNumber(), mcov);
                }
                for (JavapLine line : javapClass.getLines()) {
                    lineStr = line.getTextLine();
                    this.generateSourceLine(pw, lineStr, numLine, theClass, methodsForLine, itemsForLine, line);
                    ++numLine;
                }
            }
            pw.println(" </table>");
        }
        pw.println("<p>");
        if (this.isGenHitTests) {
            pw.println(this.generateHitTests(theClass));
        }
        pw.println(this.generateFooter());
        pw.println("</body>");
        pw.println("</html>");
        pw.close();
    }

    private void generateSourceLine(PrintWriter pw, String lineStr, int numLine, ClassCoverage theClass, HashMap<Integer, MemberCoverage> methodsForLine, HashMap<Integer, List<ItemCoverage>> itemsForLine, JavapLine javapLine) {
        block49: {
            block45: {
                String link;
                String ancInfo;
                String lineCov;
                block46: {
                    String nbHitsCov;
                    String shortInfo;
                    HashMap<DataType, Integer> total;
                    block48: {
                        List<ItemCoverage> items;
                        MemberCoverage mcov;
                        block47: {
                            boolean isGreen;
                            pw.println(" <tr>");
                            if (javapLine != null) break block45;
                            mcov = methodsForLine.get(numLine);
                            items = itemsForLine.get(numLine);
                            lineCov = null;
                            ancInfo = "";
                            if (!theClass.isCode(numLine)) {
                                lineCov = "numLine";
                            } else {
                                String unCover = theClass.isLineInAnc(numLine) ? "numLineAnc" : "numLineUnCover";
                                String string = lineCov = theClass.isLineCovered(numLine) ? "numLineCover" : unCover;
                                if (theClass.isLineInAnc(numLine) && !theClass.isLineCovered(numLine)) {
                                    if (theClass.getAncInfo() != null) {
                                        ancInfo = "title = \"" + theClass.getAncInfo() + "\" ";
                                    } else if (mcov instanceof MethodCoverage && ((MethodCoverage)mcov).getAncInfo() != null) {
                                        ancInfo = "title = \"" + ((MethodCoverage)mcov).getAncInfo() + "\" ";
                                    } else if (items == null) {
                                        List<ItemCoverage> upItems;
                                        int upLine = numLine;
                                        while ((upItems = itemsForLine.get(upLine)) == null) {
                                            --upLine;
                                        }
                                        for (ItemCoverage i : upItems) {
                                            if (!i.isInAnc()) continue;
                                            ancInfo = "title = \"" + i.getAncInfo() + "\" ";
                                            break;
                                        }
                                    }
                                }
                            }
                            link = "";
                            if (mcov != null) {
                                link = "<a name=\"src_" + numLine + "\"></a>";
                            }
                            if (items == null) break block46;
                            int allcovered = 0;
                            int allanc = 0;
                            HashMap<DataType, Integer> covered = new HashMap<DataType, Integer>();
                            total = new HashMap<DataType, Integer>();
                            for (DataType kind : ItemCoverage.getAllPossibleTypes()) {
                                covered.put(kind, 0);
                                total.put(kind, 0);
                            }
                            for (ItemCoverage icov : items) {
                                DataType kind = icov.getDataType();
                                total.put(kind, (Integer)total.get((Object)kind) + 1);
                                if (icov.getCount() != 0L) {
                                    covered.put(kind, (Integer)covered.get((Object)kind) + 1);
                                    ++allcovered;
                                }
                                if (!icov.isInAnc()) continue;
                                ++allanc;
                            }
                            shortInfo = "";
                            for (DataType kind : ItemCoverage.getAllPossibleTypes()) {
                                if ((Integer)total.get((Object)kind) == 0) continue;
                                shortInfo = shortInfo + kind.getTitle() + ":&nbsp;" + covered.get((Object)kind) + "/" + total.get((Object)kind) + "&nbsp;";
                            }
                            boolean bl = isGreen = items.size() == allcovered;
                            nbHitsCov = isGreen ? "nbHitsCovered" : (items.size() == allanc ? "nbHitsAnc" : "nbHitsUncovered");
                            ancInfo = "";
                            if (theClass.isLineCovered(numLine)) break block47;
                            if (items.size() != allanc) break block48;
                            lineCov = "numLineAnc";
                            ancInfo = theClass.getAncInfo() != null ? "title = \"" + theClass.getAncInfo() + "\" " : (mcov instanceof MethodCoverage && ((MethodCoverage)mcov).getAncInfo() != null ? "title = \"" + ((MethodCoverage)mcov).getAncInfo() + "\" " : "title = \"" + items.get(0).getAncInfo() + "\" ");
                            break block48;
                        }
                        ancInfo = "";
                        for (ItemCoverage i : items) {
                            if (i.isCovered()) continue;
                            if (theClass.getAncInfo() != null) {
                                ancInfo = "title = \"" + theClass.getAncInfo() + "\" ";
                                break;
                            }
                            if (mcov instanceof MethodCoverage && ((MethodCoverage)mcov).getAncInfo() != null) {
                                ancInfo = "title = \"" + ((MethodCoverage)mcov).getAncInfo() + "\" ";
                                break;
                            }
                            if (!i.isInAnc() || i.getAncInfo() == null) continue;
                            ancInfo = "title = \"" + i.getAncInfo() + "\" ";
                            break;
                        }
                    }
                    pw.println(" <td " + ancInfo + "class=\"" + lineCov + "\">&nbsp;" + numLine + link + "</td>");
                    if (this.isMergeRepGenMode) {
                        StringBuilder totalInfo = new StringBuilder();
                        if (total.get((Object)DataType.BLOCK) == null || (Integer)total.get((Object)DataType.BLOCK) == 0) {
                            totalInfo.append("-:");
                        } else {
                            totalInfo.append(total.get((Object)DataType.BLOCK)).append(":");
                        }
                        if (total.get((Object)DataType.BRANCH) == null || (Integer)total.get((Object)DataType.BRANCH) == 0) {
                            totalInfo.append("-");
                        } else {
                            totalInfo.append(total.get((Object)DataType.BRANCH));
                        }
                        pw.println(" <td class=\"nbHits\" title=\"#blocks:#branches\" >&nbsp;" + totalInfo + " </td>");
                    } else {
                        pw.println(" <td class=\"" + nbHitsCov + "\">&nbsp;" + shortInfo + "</td>");
                    }
                    if (this.testService != null && (this.isAddTestsInfo || this.isMergeRepGenMode)) {
                        int testNumber = 0;
                        for (Test test : this.testService) {
                            String testCovered = theClass.isLineInAnc(numLine) ? "numLineAnc" : "numLineUnCover";
                            int block = 0;
                            int branch = 0;
                            boolean blocks = false;
                            boolean branches = false;
                            for (ItemCoverage item : itemsForLine.get(numLine)) {
                                if (item.isInAnc()) {
                                    testCovered = "numLineAnc";
                                }
                                if (!blocks && item.isBlock()) {
                                    blocks = true;
                                }
                                if (!branches && !item.isBlock()) {
                                    branches = true;
                                }
                                if (!item.isCoveredByTest(testNumber)) continue;
                                testCovered = "numLineCover";
                                if (item.isBlock()) {
                                    ++block;
                                    continue;
                                }
                                ++branch;
                            }
                            ++testNumber;
                            StringBuilder testInfo = new StringBuilder();
                            if (!blocks) {
                                testInfo.append("-:");
                            } else {
                                testInfo.append(block).append(":");
                            }
                            if (!branches) {
                                testInfo.append("-");
                            } else {
                                testInfo.append(branch);
                            }
                            pw.println(" <td title=\"" + test.getTestName() + " (Block:Branch)\" class=\"" + testCovered + "\">&nbsp;" + testInfo + "</td>");
                        }
                    }
                    pw.println(" <td class=\"src\"><pre class=\"src\">&nbsp;" + JavaToHtml.syntaxHighlight(lineStr) + "</pre></td>");
                    break block49;
                }
                pw.println(" <td " + ancInfo + "class=\"" + lineCov + "\">&nbsp;" + numLine + link + "</td>");
                pw.println(" <td class=\"nbHits\">&nbsp;</td>");
                if (this.testService != null && (this.isAddTestsInfo || this.isMergeRepGenMode)) {
                    for (int k = 0; k < this.testService.getTestCount(); ++k) {
                        if (theClass.isCode(numLine)) {
                            String testCovered = theClass.isLineInAnc(numLine) ? "numLineAnc" : "numLineUnCover";
                            ancInfo = "";
                            if (theClass.isLineCovered(numLine)) {
                                for (int i = numLine; i >= 0; --i) {
                                    if (itemsForLine.get(i) == null) continue;
                                    for (ItemCoverage item : itemsForLine.get(i)) {
                                        if (item.isCoveredByTest(k)) {
                                            testCovered = "numLineCover";
                                            continue;
                                        }
                                        if (!item.isInAnc()) continue;
                                        testCovered = "numLineAnc";
                                        ancInfo = "title = \"" + item.getAncInfo() + "\" ";
                                    }
                                    break;
                                }
                            }
                            pw.println(" <td " + ancInfo + "class=\"" + testCovered + "\">&nbsp;</td>");
                            continue;
                        }
                        pw.println(" <td class=\"nbHits\">&nbsp;</td>");
                    }
                }
                pw.println(" <td class=\"src\"><pre class=\"src\">&nbsp;" + JavaToHtml.syntaxHighlight(lineStr) + "</pre></td>");
                break block49;
            }
            MemberCoverage mcov = methodsForLine.get(javapLine.getLineNumber() + 2);
            String link = "";
            if (mcov != null) {
                link = mcov.getName().equals("<clinit>") ? "<a name=\"src_" + mcov.getStartLine() + "cl\"></a>" : "<a name=\"src_" + mcov.getStartLine() + "\"></a>";
            }
            if (javapLine instanceof JavapCodeLine) {
                boolean isGreen = ((JavapCodeLine)javapLine).isVisited();
                String unCover = theClass.isLineInAnc(numLine) ? "nbHitsAnc" : "nbHitsUncovered";
                String nbHitsCov = isGreen ? "nbHitsCovered" : unCover;
                String htmlStr = javapLine.getTextLine().replaceAll("\\<", "&#60;").replaceAll("\\>", "&#62;").replaceAll("\\s++$", "");
                pw.println(" <td>" + numLine + link + "</td>");
                pw.println(" <td class=\"" + nbHitsCov + "\">&nbsp;   </td>");
                pw.println(" <td class=\"src\"><pre class=\"src\">&nbsp;" + htmlStr + "</pre></td>");
            } else {
                pw.println(" <td>" + numLine + link + "</td>");
                pw.println(" <td class=\"nbHits\">&nbsp;</td>");
                pw.println(" <td class=\"src\"><pre class=\"src\">&nbsp;" + JavaToHtml.syntaxHighlight(lineStr) + "</pre></td>");
            }
        }
        pw.println(" </tr>");
    }

    private void generateMemberTable(PrintWriter pw, ClassCoverage theClass, String fieldOrMethod, List<? extends MemberCoverage> list, boolean isGenerate, boolean javapReport) {
        pw.println(" <br>");
        pw.println(" <table cellspacing=\"0\" cellpadding=\"0\"class=\"report\" id=\"mcoverage\">");
        pw.println(" <tr class=\"report\">");
        pw.println(" <th class=\"report\">hit count</th>");
        if (this.testService != null && (this.isAddTestsInfo || this.isMergeRepGenMode)) {
            for (int i = 0; i < this.testService.getTestCount(); ++i) {
                pw.println(" <th class=\"report\"> #" + (i + 1) + "</th>");
            }
        }
        pw.println(" <th class=\"report\">" + fieldOrMethod + "  name</th>");
        pw.println(" <th class=\"report\">" + fieldOrMethod + " modifiers</th>");
        pw.println(" <th class=\"report\">" + fieldOrMethod + " signature</th>");
        pw.println(" </tr>");
        for (MemberCoverage memberCoverage : list) {
            if (!this.isAnonymOn && memberCoverage instanceof MethodCoverage && ((MethodCoverage)memberCoverage).isInAnonymClass() || memberCoverage instanceof MethodCoverage && ((MethodCoverage)memberCoverage).isLambdaMethod()) continue;
            pw.println(" <tr class=\"report\">");
            long c = memberCoverage.getHitCount();
            if (c > 0L) {
                pw.println(" <td class=\"reportValue_covered\"><span class=\"text\">" + c + "</span></td>");
            } else if (memberCoverage.getData(memberCoverage.getDataType()).getAnc() > 0) {
                String tooltip = "";
                if (memberCoverage instanceof MethodCoverage) {
                    String info = theClass.getAncInfo();
                    if (info == null) {
                        info = ((MethodCoverage)memberCoverage).getAncInfo() != null ? ((MethodCoverage)memberCoverage).getAncInfo() : ((MethodCoverage)memberCoverage).getItems().get(0).getAncInfo();
                    }
                    tooltip = "title=\"" + info + "\" ";
                }
                pw.println(" <td class=\"reportValue_anc\"" + tooltip + "><span class=\"text\">" + c + "</span></td>");
            } else {
                pw.println(" <td class=\"reportValue_uncovered\"><span class=\"text\">" + c + "</span></td>");
            }
            if (this.testService != null && (this.isAddTestsInfo || this.isMergeRepGenMode)) {
                for (int i = 0; i < this.testService.getTestCount(); ++i) {
                    if (memberCoverage.getCoveringTests().contains(i)) {
                        pw.println(" <td class=\"numLineCover\"><span style=\"text-align: center;\">+</span></td>");
                        continue;
                    }
                    if (memberCoverage.getData(memberCoverage.getDataType()).getAnc() > 0) {
                        String tooltip = "";
                        if (memberCoverage instanceof MethodCoverage) {
                            String info = theClass.getAncInfo();
                            if (info == null) {
                                info = ((MethodCoverage)memberCoverage).getAncInfo() != null ? ((MethodCoverage)memberCoverage).getAncInfo() : ((MethodCoverage)memberCoverage).getItems().get(0).getAncInfo();
                            }
                            tooltip = "title=\"" + info + "\" ";
                        }
                        pw.println(" <td class=\"numLineAnc\" " + tooltip + "><span style=\"text-align: center;\">-</span></td>");
                        continue;
                    }
                    pw.println(" <td class=\"numLineUnCover\"><span style=\"text-align: center;\">-</span></td>");
                }
            }
            String mname = memberCoverage.getName().replaceAll("<", "&lt;").replaceAll(">", "&gt;");
            if (isGenerate || javapReport) {
                if (javapReport && memberCoverage.getName().equals("<clinit>")) {
                    pw.println(" <td class=\"reportText\"><span class=\"text\"><a href=\"#src_" + memberCoverage.getStartLine() + "cl\">" + mname + "</a></span></td>");
                } else {
                    pw.println(" <td class=\"reportText\"><span class=\"text\"><a href=\"#src_" + memberCoverage.getStartLine() + "\">" + mname + "</a></span></td>");
                }
            } else {
                pw.println(" <td class=\"reportText\"><span class=\"text\">" + mname + "</span></td>");
            }
            String mmodifiers = memberCoverage.getModifiers();
            pw.println(" <td class=\"reportText\"><span class=\"text\">" + mmodifiers + "</span></td>");
            pw.println(" <td class=\"reportText\"><span class=\"text\">" + memberCoverage.getReadableSignature().replaceAll("<", "&lt;").replaceAll(">", "&gt;") + "</span></td>");
            pw.println(" </tr>");
        }
        pw.println(" </table>");
        pw.println(" <br>");
    }

    private static String constructShortDescr(List<ItemCoverage> items) {
        String str = "";
        return str;
    }

    private void generateScriptsHeader(PrintWriter pw) {
        pw.println("<script type=\"text/javascript\">");
        pw.println("  targetPage = \"\" + window.location.search;");
        pw.println("  if (targetPage != \"\" && targetPage != \"undefined\")");
        pw.println("    targetPage = targetPage.substring(1);");
        pw.println("  if (targetPage.indexOf(\":\") != -1 || (targetPage != \"\" && !validURL(targetPage)))");
        pw.println("    targetPage = \"undefined\";");
        pw.println("  function validURL(url) {");
        pw.println("    var pos = url.indexOf(\".html\");");
        pw.println("    if (pos == -1 || pos != url.length - 5)");
        pw.println("      return false;");
        pw.println("    var allowNumber = false;");
        pw.println("    var allowSep = false;");
        pw.println("    var seenDot = false;");
        pw.println("    for (var i = 0; i < url.length - 5; i++) {");
        pw.println("      var ch = url.charAt(i);");
        pw.println("      if ('a' <= ch && ch <= 'z' ||");
        pw.println("          'A' <= ch && ch <= 'Z' ||");
        pw.println("          ch == '$' ||");
        pw.println("          ch == '_') {");
        pw.println("            allowNumber = true;");
        pw.println("            allowSep = true;");
        pw.println("      } else if ('0' <= ch && ch <= '9' ||");
        pw.println("                 ch == '-') {");
        pw.println("                   if (!allowNumber)");
        pw.println("                     return false;");
        pw.println("      } else if (ch == '/' || ch == '.') {");
        pw.println("        if (!allowSep)");
        pw.println("          return false;");
        pw.println("        allowNumber = false;");
        pw.println("        allowSep = false;");
        pw.println("        if (ch == '.')");
        pw.println("          seenDot = true;");
        pw.println("        if (ch == '/' && seenDot)");
        pw.println("          return false;");
        pw.println("      } else {");
        pw.println("        return false;");
        pw.println("      }");
        pw.println("    }");
        pw.println("    return true;");
        pw.println("  }");
        pw.println("  function loadFrames() {");
        pw.println("    if (targetPage != \"\" && targetPage != \"undefined\")");
        pw.println("      top.classFrame.location = top.targetPage;");
        pw.println("  }");
        pw.println("</script>");
    }

    private void generateNavHeader(PrintWriter pw, String noframesPath, String index_classPath) {
        pw.println("<table>");
        pw.println("<tr>");
        pw.println("<td>");
        pw.println("<a href=\"" + index_classPath + "\" target=\"_top\">Frames</a>");
        pw.println("<a href=\"" + noframesPath + "\" target=\"_top\">No Frames</a>");
        pw.println("</td>");
        pw.println("</tr>");
        pw.println("</table>");
    }

    private String generateFooter() {
        StringBuilder sb = new StringBuilder();
        sb.append("<br>");
        sb.append("<table cellpadding=\"0\" cellspacing=\"0\" class=\"report\">");
        sb.append("  <tr class=\"report\">");
        sb.append("    <td class=\"reportText\"><span class=\"text\">");
        sb.append("    Report generated ").append(REPORT_DATE);
        sb.append("    </span></td>");
        sb.append("  </tr>");
        sb.append("</table>");
        return sb.toString();
    }

    private String generateHitTests(ClassCoverage n) {
        StringBuilder sb = new StringBuilder();
        if (n != null) {
            try {
                List<Object> hitlist;
                sb.append("<a name=\"hittests\"><span class=\"title\">Hit tests</span></a>");
                sb.append("<table cellpadding=\"0\" cellspacing=\"0\" class=\"report\">");
                sb.append(" <tr class=\"report\">");
                sb.append(" <th class=\"report\">#</th>");
                sb.append(" <th class=\"report\">Test name</th>");
                sb.append(" </tr>");
                List<Object> list = hitlist = this.testService != null ? this.testService.getHitTestByClasses(n) : new ArrayList();
                if (this.isAddTestsInfo || this.isMergeRepGenMode) {
                    hitlist = this.testService.getAllTests();
                }
                int i = 1;
                for (Test test : hitlist) {
                    String owner = test.getTestOwner();
                    String tname = test.getTestName();
                    sb.append(" <tr class=\"report\">");
                    sb.append(" <td class=\"reportValue\">").append(i++).append("</td>");
                    StringBuilder append = sb.append(" <td class=\"reportText\">").append(tname).append("</td>");
                    sb.append("  </tr>");
                }
                sb.append("</table>");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    private String generatePercentResult(String percentValue) {
        return this.generatePercentResult(percentValue, false);
    }

    private String generatePercentResult(String percentValue, boolean onlyColorBar) {
        String value = percentValue;
        String cov_total = "";
        double anc = 0.0;
        int idx = value.indexOf("%");
        if (idx != -1) {
            value = value.substring(0, idx);
            cov_total = percentValue.substring(idx + 1);
            String[] ancs = percentValue.split("/");
            if (ancs.length == 3) {
                try {
                    anc = Double.parseDouble(ancs[1]) / Double.parseDouble(ancs[2].substring(0, ancs[2].indexOf(")"))) * 100.0;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        double rest = 0.0;
        boolean badNumber = false;
        double dvalue = 0.0;
        try {
            dvalue = new Double(value.replace(',', '.'));
            rest = 100.0 - dvalue;
        }
        catch (NumberFormatException e) {
            badNumber = true;
        }
        StringBuilder sb = new StringBuilder();
        if (onlyColorBar) {
            sb.append("<table cellpadding=\"0\" cellspacing=\"0\">");
        } else {
            sb.append("<table cellpadding=\"0\" cellspacing=\"0\" style=\"margin: 0 auto;\">");
            sb.append("<tr>");
            sb.append("<td><span class=\"text\"><b>").append(value.trim()).append("</b>%").append(cov_total.trim()).append("</span></td>");
        }
        if (!badNumber) {
            if (onlyColorBar) {
                sb.append("<td>");
                sb.append("<table class=\"percentGraph\" cellpadding=\"0\" cellspacing=\"0\" style=\"padding-right: 5px\">");
            } else {
                sb.append("<tr>");
                sb.append("<td>");
                sb.append("<table class=\"percentGraph\" cellpadding=\"0\" cellspacing=\"0\">");
            }
            sb.append("<tr>");
            if (anc > 0.0) {
                sb.append("<td class=\"percentCovered\" width=\"").append((int)(dvalue - anc)).append("\"></td>");
                sb.append("<td class=\"percentAnc\" width=\"").append((int)anc).append("\"></td>");
                if (dvalue < 100.0) {
                    sb.append("<td class=\"percentUnCovered\" width=\"").append((int)rest).append("\"></td>");
                }
            } else {
                sb.append("<td class=\"percentCovered\" width=\"").append(value).append("\"></td>");
                sb.append("<td class=\"percentUnCovered\" width=\"").append((int)rest).append("\"></td>");
            }
            sb.append("</tr>");
            sb.append("</table>");
            sb.append("</td>");
        }
        if (!onlyColorBar) {
            sb.append("</tr>");
        }
        sb.append("</table>");
        return sb.toString();
    }

    private String getRelativePath(String path) {
        if (path != null && !path.equals("")) {
            return path.replace('.', '/').replaceAll("\\w+", "..") + "/";
        }
        return "";
    }

    private String decorate(String coverageString) {
        int idx = coverageString.indexOf("%");
        if (idx != -1) {
            StringBuilder sb = new StringBuilder();
            sb.append("<table class=\"report\">");
            sb.append("<tr>");
            sb.append("<td class=\"coverage_left\">");
            sb.append("<span class=\"text_bold\">");
            sb.append(coverageString.substring(0, idx + 1).trim());
            sb.append("</span>");
            sb.append("</td>");
            sb.append("<td class=\"coverage_right\"> ");
            sb.append("<span class=\"text\">");
            sb.append(coverageString.substring(idx + 1).trim());
            sb.append("</span>");
            sb.append("</td>");
            sb.append("</tr>");
            sb.append("</table>");
            return sb.toString();
        }
        return coverageString;
    }

    public void setShowMethods(boolean showMethods) {
        this.showMethods = showMethods;
    }

    public void setShowBlocks(boolean showBlocks) {
        this.showBlocks = showBlocks;
    }

    public void setShowBranches(boolean showBranches) {
        this.showBranches = showBranches;
    }

    public void setShowFields(boolean showFields) {
        this.showFields = showFields;
    }

    public void setShowLines(boolean showLines) {
        this.showLines = showLines;
    }

    public void setShowOverviewColorBars(boolean showOverviewColorBars) {
        this.showOverviewColorBars = showOverviewColorBars;
    }

    static {
        logger.setLevel(Level.WARNING);
        REPORT_DATE = System.getProperty("test.mode") == null ? DateFormat.getInstance().format(new Date()) : "date";
    }

    private class ModuleCoverageData {
        private CoverageData[] collectedData;

        public ModuleCoverageData() {
            this.collectedData = new CoverageData[6];
        }

        public ModuleCoverageData(PackageCoverage pkg) {
            this.collectedData = new CoverageData[]{pkg.getData(DataType.FIELD), pkg.getData(DataType.METHOD), pkg.getData(DataType.BLOCK), pkg.getData(DataType.BRANCH), pkg.getData(DataType.LINE), pkg.getData(DataType.CLASS)};
        }

        public ModuleCoverageData(PackageCoverage pkg, int testNumber) {
            this.collectedData = new CoverageData[]{pkg.getData(DataType.FIELD, testNumber), pkg.getData(DataType.METHOD, testNumber), pkg.getData(DataType.BLOCK, testNumber), pkg.getData(DataType.BRANCH, testNumber), pkg.getData(DataType.LINE, testNumber), pkg.getData(DataType.CLASS, testNumber)};
        }

        public void addPackage(PackageCoverage pkg, int testNumber) {
            this.collectedData[columns.field.number].add(pkg.getData(DataType.FIELD, testNumber));
            this.collectedData[columns.method.number].add(pkg.getData(DataType.METHOD, testNumber));
            this.collectedData[columns.block.number].add(pkg.getData(DataType.BLOCK, testNumber));
            this.collectedData[columns.branch.number].add(pkg.getData(DataType.BRANCH, testNumber));
            this.collectedData[columns.line.number].add(pkg.getData(DataType.LINE, testNumber));
            this.collectedData[columns.classes.number].add(pkg.getData(DataType.CLASS, testNumber));
        }

        public void addPackage(PackageCoverage pkg) {
            this.collectedData[columns.field.number].add(pkg.getData(DataType.FIELD));
            this.collectedData[columns.method.number].add(pkg.getData(DataType.METHOD));
            this.collectedData[columns.block.number].add(pkg.getData(DataType.BLOCK));
            this.collectedData[columns.branch.number].add(pkg.getData(DataType.BRANCH));
            this.collectedData[columns.line.number].add(pkg.getData(DataType.LINE));
            this.collectedData[columns.classes.number].add(pkg.getData(DataType.CLASS));
        }

        public CoverageData[] getData() {
            return this.collectedData;
        }
    }

    public static enum columns {
        method(1),
        field(0),
        block(2),
        branch(3),
        line(4),
        classes(5);

        private int number;
        private static Map<Integer, columns> map;

        public static columns valueOf(int number) {
            return map.get(number);
        }

        private columns(int number) {
            this.number = number;
        }

        static {
            map = new HashMap<Integer, columns>();
            for (columns column : columns.values()) {
                map.put(column.number, column);
            }
        }
    }
}

