/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.report.javap;

import com.sun.tdk.jcov.report.javap.JavapClassReader;
import com.sun.tdk.jcov.report.javap.JavapCodeLine;
import com.sun.tdk.jcov.report.javap.JavapLine;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavapClass {
    private String packageName;
    private String className;
    private ArrayList<JavapLine> lines = new ArrayList();
    private HashMap<String, ArrayList<Integer>> methods = new HashMap();

    public List<JavapLine> getMethod(String nameAndVMSig) {
        List numbers = this.methods.get(nameAndVMSig);
        if (numbers == null || numbers.isEmpty()) {
            return null;
        }
        return this.lines.subList((Integer)numbers.get(0), (Integer)numbers.get(numbers.size() - 1) + 1);
    }

    public String getClassName() {
        return this.className;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public List<JavapLine> getLines() {
        return this.lines;
    }

    void parseJavapFile(String filePath, String jarPath) {
        try {
            String textLine;
            BufferedReader inStream = null;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)out, Charset.defaultCharset()));
            JavapClassReader.read(filePath, jarPath, pw);
            inStream = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(out.toByteArray()), Charset.defaultCharset()));
            String lastMethodString = "";
            int lineNumber = 0;
            while ((textLine = inStream.readLine()) != null) {
                if (textLine.startsWith("Warning:")) continue;
                if (textLine.contains("class") && textLine.contains("{")) {
                    this.parseClassName(textLine);
                    this.parsePackageName(textLine);
                }
                if (textLine.contains("(") && (textLine.contains(");") || textLine.contains(") throws"))) {
                    lastMethodString = !textLine.contains("." + this.className + "(") ? this.parseMethodString(textLine) : this.parseClassString(textLine);
                    this.methods.put(lastMethodString, new ArrayList());
                } else if (textLine.trim().equals("static {};")) {
                    lastMethodString = this.parseStaticBlockString();
                    this.methods.put(lastMethodString, new ArrayList());
                }
                if (!(!textLine.contains(":") || textLine.contains("Code") || textLine.contains("case") || textLine.contains("default") || textLine.contains("Exception table"))) {
                    this.addCodeLine(lineNumber, textLine, lastMethodString);
                } else {
                    this.addLine(lineNumber, textLine);
                }
                ++lineNumber;
            }
            inStream.close();
        }
        catch (Exception e) {
            System.err.println("Error in parsing javap file:");
            e.printStackTrace();
        }
    }

    private void parseClassName(String textLine) {
        if (textLine.contains("implements")) {
            textLine = textLine.substring(0, textLine.indexOf("implements"));
        }
        if (textLine.contains("extends")) {
            textLine = textLine.substring(0, textLine.indexOf("extends"));
        }
        textLine = textLine + "{";
        this.className = JavapClass.substringBetween(textLine, "\\.", "\\ ", false);
        if (this.className != null && this.className.contains("<") && this.className.contains(">")) {
            this.className = this.className.substring(0, this.className.indexOf(60));
        }
        if (this.className.startsWith("class")) {
            this.className = this.className.substring(6, this.className.length());
        }
    }

    private void parsePackageName(String textLine) {
        if (textLine.contains("implements")) {
            textLine = textLine.substring(0, textLine.indexOf("implements"));
        }
        if (textLine.contains("extends")) {
            textLine = textLine.substring(0, textLine.indexOf("extends"));
        }
        textLine = textLine + "{";
        this.packageName = JavapClass.substringBetween(textLine, "\\ ", "\\.", false);
    }

    private String parseStaticBlockString() {
        String nameAndVMSig = "<clinit>()V";
        return nameAndVMSig;
    }

    private String parseClassString(String textLine) {
        textLine = JavapClass.removeGenericsInfo(textLine);
        String vmSig = JavapClass.encodeVmSignature(JavapClass.substringBetween(textLine, "\\(", "\\)", false), null);
        String nameAndVMSig = "<init>" + vmSig;
        return nameAndVMSig;
    }

    private String parseMethodString(String textLine) {
        textLine = JavapClass.removeGenericsInfo(textLine);
        String methodName = JavapClass.substringBetween(textLine, "\\ ", "\\(", true);
        String returnType = JavapClass.substringBetween(textLine, "\\ ", " " + methodName, true);
        String vmSig = JavapClass.encodeVmSignature(JavapClass.substringBetween(textLine, "\\(", "\\)", false), returnType);
        return methodName + vmSig;
    }

    private static String encodeVmType(String oneMethodParam) {
        String className;
        String s = className = oneMethodParam.replaceAll("[\\,\\[\\]]", "");
        if (className.lastIndexOf(".") > -1) {
            s = className.substring(className.lastIndexOf("."), className.length());
        }
        String dim = oneMethodParam.replaceAll("[^\\[\\]]", "");
        String newType = "";
        newType = "boolean".equals(s) || "Boolean".equals(s) ? "Z" : ("void".equals(s) || "Void".equals(s) ? "V" : ("int".equals(s) || "Integer".equals(s) ? "I" : ("long".equals(s) || "Long".equals(s) ? "J" : ("char".equals(s) || "Character".equals(s) ? "C" : ("byte".equals(s) || "Byte".equals(s) ? "B" : ("double".equals(s) || "Double".equals(s) ? "D" : ("short".equals(s) || "Short".equals(s) ? "S" : ("float".equals(s) || "Number".equals(s) ? "F" : "L"))))))));
        String prefix = "";
        for (int i = 0; i < dim.length() / 2; ++i) {
            prefix = prefix + "[";
        }
        if (className.lastIndexOf(".") > -1) {
            return prefix + newType + className.replaceAll("\\.", "/") + ";";
        }
        return prefix + newType;
    }

    private static String removeGenericsInfo(String textLine) {
        if (textLine != null) {
            textLine = textLine.replaceAll("<.*?>", "");
        }
        return textLine;
    }

    private static String encodeVmSignature(String params, String returnValue) {
        if (params == null && returnValue == null) {
            return "()V";
        }
        String vmSig = "";
        if (params != null) {
            if (params.contains(" ")) {
                for (String p : params.split(" ")) {
                    vmSig = vmSig + JavapClass.encodeVmType(p);
                }
            } else {
                vmSig = vmSig + JavapClass.encodeVmType(params);
            }
        }
        if (returnValue == null || returnValue.equals("void")) {
            return "(" + vmSig + ")V";
        }
        return "(" + vmSig + ")" + JavapClass.encodeVmType(returnValue);
    }

    private void addCodeLine(int lineNumber, String textLine, String methodNameAndVMsig) {
        JavapCodeLine codeLine = new JavapCodeLine();
        try {
            codeLine.setCodeNumber(Integer.parseInt(textLine.substring(0, textLine.indexOf(":")).trim()));
        }
        catch (NumberFormatException nfe) {
            System.err.println(nfe + " in code line: " + textLine);
        }
        codeLine.setLineNumber(lineNumber);
        codeLine.setTextLine(textLine);
        if (this.methods.get(methodNameAndVMsig) != null) {
            this.methods.get(methodNameAndVMsig).add(lineNumber);
        }
        this.lines.add(codeLine);
    }

    private void addLine(int lineNumber, String textLine) {
        JavapLine codeLine = new JavapLine();
        codeLine.setLineNumber(lineNumber);
        codeLine.setTextLine(textLine);
        this.lines.add(codeLine);
    }

    private static String substringBetween(String str, String open, String close, boolean firstValue) {
        Matcher m;
        String regexStringFirst;
        String regexStringLast = "([^" + open + "]+)(?=" + close + "[^" + close + "]*$)";
        String regexString = regexStringFirst = "([^" + open + "]+)(?=" + close + ")";
        if (!firstValue) {
            regexString = regexStringLast;
        }
        Pattern p = Pattern.compile(regexString);
        int i = (str = str.trim()).indexOf("//");
        if (i > -1) {
            str = str.substring(0, i);
        }
        if ((m = p.matcher(str)).find()) {
            return m.group(1).trim();
        }
        return null;
    }
}

