/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.report.text;

import com.sun.tdk.jcov.report.ClassCoverage;
import com.sun.tdk.jcov.report.DataType;
import com.sun.tdk.jcov.report.FieldCoverage;
import com.sun.tdk.jcov.report.MethodCoverage;
import com.sun.tdk.jcov.report.PackageCoverage;
import com.sun.tdk.jcov.report.ProductCoverage;
import com.sun.tdk.jcov.report.ReportGenerator;
import com.sun.tdk.jcov.tools.JcovStats;
import com.sun.tdk.jcov.util.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TextReportGenerator
implements ReportGenerator {
    public static final String sccsVersion = "%I% $LastChangedDate: 2013-10-14 18:13:10 +0400 (Mon, 14 Oct 2013) $";
    public static final String FMT_TEXT = "text";
    public static final String DEFAULT_REPORT_NAME = "report.txt";
    protected PrintWriter out;
    private static String[] spaces = new String[]{"", " ", "  ", "   ", "    ", "     ", "      "};
    private static String[] dashes = new String[]{"", " ", ". ", ".. ", "... ", ".... ", "..... "};
    private static final Logger logger;
    private boolean generateShortFormat;
    private boolean showMethods;
    private boolean showBlocks;
    private boolean showBranches;
    private boolean showLines;
    private boolean showFields;
    ReportGenerator.Options options;

    @Override
    public void init(String outputFile) throws IOException {
        this.out = (outputFile = TextReportGenerator.detectOutputTextFileName(outputFile)) == null ? new PrintWriter(new OutputStreamWriter((OutputStream)System.out, Charset.defaultCharset())) : new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), Charset.defaultCharset()));
    }

    @Override
    public void generateReport(ProductCoverage coverage, ReportGenerator.Options options) {
        this.options = options;
        this.out.println("Coverage Report: ");
        String sumFormat = "ALL: classes:%1$s;";
        String pkgFormat = "PKG%1s: %2s classes:%3$s;";
        String clsFormat = "CLS%1s: %2$s ";
        String mthFormat = "MTH%1s: %2$s hits: %3$s";
        String fldFormat = "FLD%1s: %2$s hits: %3$s";
        if (this.showMethods) {
            sumFormat = sumFormat + " methods:%2$s;";
            pkgFormat = pkgFormat + " methods:%4$s;";
            clsFormat = clsFormat + " methods:%3$s;";
        }
        if (this.showBlocks) {
            sumFormat = sumFormat + " blocks:%3$s;";
            pkgFormat = pkgFormat + " blocks:%5$s;";
            clsFormat = clsFormat + " blocks:%4$s;";
            mthFormat = mthFormat + " blocks:%4$s;";
        }
        if (this.showBranches) {
            sumFormat = sumFormat + " branches:%4$s;";
            pkgFormat = pkgFormat + " branches:%6$s;";
            clsFormat = clsFormat + " branches:%5$s;";
            mthFormat = mthFormat + " branches:%5$s;";
        }
        if (this.showLines) {
            sumFormat = sumFormat + " lines:%5$s;";
            pkgFormat = pkgFormat + " lines:%7$s;";
            clsFormat = clsFormat + " lines:%6$s;";
            mthFormat = mthFormat + " lines:%6$s;";
        }
        this.out.println(String.format(sumFormat, coverage.getCoverageString(DataType.CLASS, coverage.isAncFiltersSet()), coverage.getData(DataType.METHOD).add(coverage.getData(DataType.FIELD)).toString(), coverage.getCoverageString(DataType.BLOCK, coverage.isAncFiltersSet()), coverage.getCoverageString(DataType.BRANCH, coverage.isAncFiltersSet()), coverage.getCoverageString(DataType.LINE, coverage.isAncFiltersSet())));
        for (PackageCoverage pkgCov : coverage) {
            this.out.println(String.format(pkgFormat, pkgCov.isCovered() ? "+" : "-", pkgCov.getName(), pkgCov.getCoverageString(DataType.CLASS, coverage.isAncFiltersSet()), pkgCov.getData(DataType.METHOD).add(pkgCov.getData(DataType.FIELD)).toString(), pkgCov.getCoverageString(DataType.BLOCK, coverage.isAncFiltersSet()), pkgCov.getCoverageString(DataType.BRANCH, coverage.isAncFiltersSet()), pkgCov.getCoverageString(DataType.LINE, coverage.isAncFiltersSet())));
            for (ClassCoverage clsCov : pkgCov.getClasses()) {
                this.out.println(String.format(clsFormat, clsCov.isCovered() ? "+" : "-", clsCov.getName(), clsCov.getData(DataType.METHOD).add(clsCov.getData(DataType.FIELD)).toString(), clsCov.getCoverageString(DataType.BLOCK, coverage.isAncFiltersSet()), clsCov.getCoverageString(DataType.BRANCH, coverage.isAncFiltersSet()), clsCov.getCoverageString(DataType.LINE, coverage.isAncFiltersSet())));
                if (!this.generateShortFormat && this.showMethods) {
                    for (MethodCoverage mthCov : clsCov.getMethods()) {
                        this.out.println(String.format(mthFormat, mthCov.isCovered() ? "+" : "-", mthCov.getName() + mthCov.getSignature(), mthCov.getHitCount(), mthCov.getCoverageString(DataType.BLOCK, coverage.isAncFiltersSet()), mthCov.getCoverageString(DataType.BRANCH, coverage.isAncFiltersSet()), mthCov.getCoverageString(DataType.LINE, coverage.isAncFiltersSet())));
                    }
                }
                if (!this.generateShortFormat && this.showFields) {
                    for (FieldCoverage fldCov : clsCov.getFields()) {
                        this.out.println(String.format(fldFormat, fldCov.isCovered() ? "+" : "-", fldCov.getName(), fldCov.getHitCount()));
                    }
                }
                this.out.println();
            }
        }
        this.out.flush();
        this.out.close();
    }

    private static void printTrio(PrintWriter out, long num1, long num2, float prcnt, int align) {
        boolean use_dashes = false;
        if (align < 0) {
            align = -align;
            use_dashes = true;
        }
        String s1 = Long.toString(num1);
        String s2 = Long.toString(num2);
        String s3 = num1 == 0L ? "N/A" : ((double)prcnt < 0.01 ? "0.0" : Float.toString(prcnt * 100.0f));
        String[] fill = use_dashes ? dashes : spaces;
        out.print(fill[align - s1.length()]);
        out.print(s1 + " ");
        out.print(fill[align - s2.length()]);
        out.print(s2 + " ");
        if (num1 > 0L) {
            int dot_ind = s3.indexOf(46);
            out.print(fill[3 - dot_ind]);
            out.print(s3.substring(0, dot_ind + 2) + "% ");
        } else {
            out.print(fill[6 - s3.length()]);
            out.print(s3 + " ");
        }
    }

    public static void printStats(PrintWriter out, JcovStats stats) {
        TextReportGenerator.printStats(out, stats, false);
    }

    public static void printStats(PrintWriter out, JcovStats stats, boolean use_dashes) {
        int align = use_dashes ? -7 : 7;
        out.print(" ");
        TextReportGenerator.printTrio(out, stats.methods_tot, stats.methods_cov, stats.method_cvg, align);
        TextReportGenerator.printTrio(out, stats.blocks_tot, stats.blocks_cov, stats.block_cvg, align);
        TextReportGenerator.printTrio(out, stats.branches_tot, stats.branches_cov, stats.branch_cvg, align);
    }

    private void printModifiers(String[] modifiers) {
        if (modifiers == null || modifiers.length == 0) {
            return;
        }
        this.out.print("[");
        for (int i = 0; i < modifiers.length; ++i) {
            this.out.print(modifiers[i]);
            if (i >= modifiers.length - 1) continue;
            this.out.print(" ");
        }
        this.out.print("]");
    }

    private static String detectOutputTextFileName(String value) {
        if (value == null) {
            return null;
        }
        File f = new File(value);
        if (f.exists()) {
            if (f.isDirectory()) {
                return value + File.separator + DEFAULT_REPORT_NAME;
            }
            return value;
        }
        File dir = f;
        String result = value;
        if (value.endsWith(File.separator) || value.endsWith("/")) {
            result = dir.getPath() + File.separator + DEFAULT_REPORT_NAME;
        } else {
            dir = f.getParentFile();
        }
        if (dir != null) {
            dir.mkdirs();
        }
        return result;
    }

    public void setGenerateShortFormat(boolean generateShortFormat) {
        this.generateShortFormat = generateShortFormat;
    }

    public void setShowMethods(boolean showMethods) {
        this.showMethods = showMethods;
    }

    public void setShowBlocks(boolean showBlocks) {
        this.showBlocks = showBlocks;
    }

    public void setShowBranches(boolean showBranches) {
        this.showBranches = showBranches;
    }

    public void setShowFields(boolean showFields) {
        this.showFields = showFields;
    }

    public void setShowLines(boolean showLines) {
        this.showLines = showLines;
    }

    static {
        Utils.initLogger();
        logger = Logger.getLogger(TextReportGenerator.class.getName());
        logger.setLevel(Level.WARNING);
    }
}

