/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.tools;

import com.sun.tdk.jcov.runtime.PropertyFinder;
import com.sun.tdk.jcov.tools.EnvServiceProvider;
import com.sun.tdk.jcov.tools.JCovTool;
import com.sun.tdk.jcov.tools.OptionDescr;
import com.sun.tdk.jcov.tools.SPIDescr;
import com.sun.tdk.jcov.tools.ServiceProvider;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;

public class EnvHandler {
    public static final String sccsVersion = "1.6 01/17/03";
    public static final String OPTION_SPECIFIER = "-";
    public static final String OPT_VAL_DELIM = "=";
    public static final String PROP_FILE_SPECIFIER = "@";
    public static final String PROP_OPT_DELIM = ";";
    public static final String AGENT_OPT_DELIM = ",";
    private String[] tail;
    protected Map<String, List<String>> options = new HashMap<String, List<String>>();
    protected List<OptionDescr> validOptions;
    protected JCovTool tool;
    Properties CLProperties = new Properties();
    private List<SPIDescr> spiDescrs = new LinkedList<SPIDescr>();
    private Map<SPIDescr, ArrayList<ServiceProvider>> readProviders = new HashMap<SPIDescr, ArrayList<ServiceProvider>>();
    private ClassLoader classLoader = ClassLoader.getSystemClassLoader();
    private EnvServiceProvider extendingSPI;
    private PrintStream out = System.out;
    public static final OptionDescr HELP = new OptionDescr("help", new String[]{"h", "?"}, "Basic options", null);
    public static final OptionDescr HELP_VERBOSE = new OptionDescr("help-verbose", new String[]{"hv"}, null, null);
    public static final OptionDescr PROPERTYFILE = new OptionDescr("propfile", "", 1, (String)null, (String)null);
    public static final OptionDescr PRINT_ENV = new OptionDescr("print-env", new String[]{"env"}, (String)null, (String)null);
    public static final OptionDescr PLUGINDIR = new OptionDescr("plugindir", "", 1, "Directory to read plugins (SPIs)", "plugins");
    public static final OptionDescr LOGFILE = new OptionDescr("log.file", "", 1, "Set file for output logging");
    public static final OptionDescr LOGLEVEL = new OptionDescr("log.level", new String[]{"log"}, "", 1, "Set level of logging", "");
    static final List<OptionDescr> SHARED_OPTIONS = Arrays.asList(HELP, HELP_VERBOSE, PRINT_ENV, PROPERTYFILE, PLUGINDIR, LOGFILE, LOGLEVEL);

    public static boolean isOption(String s) {
        return s.startsWith(OPTION_SPECIFIER);
    }

    @Deprecated
    public EnvHandler() {
        this.validOptions = new LinkedList<OptionDescr>();
        for (OptionDescr d : SHARED_OPTIONS) {
            this.validOptions.add(d);
        }
    }

    public EnvHandler(OptionDescr[] valid_options, JCovTool tool) {
        this.validOptions = new LinkedList<OptionDescr>(Arrays.asList(valid_options));
        for (OptionDescr d : SHARED_OPTIONS) {
            this.validOptions.add(d);
        }
        this.tool = tool;
    }

    public EnvHandler(List<OptionDescr> validOptions, JCovTool tool) {
        this.validOptions = validOptions;
        for (OptionDescr d : SHARED_OPTIONS) {
            validOptions.add(d);
        }
        this.tool = tool;
    }

    private OptionDescr getOptionByName(String name) {
        for (int i = 0; i < this.validOptions.size(); ++i) {
            if (!this.validOptions.get(i).isName(name)) continue;
            return this.validOptions.get(i);
        }
        return null;
    }

    public SPIDescr getSPIDescrByName(String name) {
        for (SPIDescr spi : this.spiDescrs) {
            if (!spi.isName(name)) continue;
            return spi;
        }
        return null;
    }

    public SPIDescr getSPIByClass(Class<? extends ServiceProvider> spiClass) {
        for (SPIDescr spi : this.spiDescrs) {
            if (spiClass != spi.getSPIClass()) continue;
            return spi;
        }
        return null;
    }

    private void addSPI(SPIDescr spi, ServiceProvider customProviderInstance) {
        ArrayList<ServiceProvider> list;
        if (customProviderInstance instanceof EnvServiceProvider) {
            this.extendingSPI = (EnvServiceProvider)customProviderInstance;
            this.extendingSPI.extendEnvHandler(this);
            this.extendingSPI = null;
        }
        if ((list = this.readProviders.get(spi)) == null) {
            list = new ArrayList(1);
            list.add(customProviderInstance);
            this.readProviders.put(spi, list);
        } else {
            list.add(customProviderInstance);
        }
    }

    private ServiceProvider instantiateServiceProvider(SPIDescr spi, String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException, Exception {
        ServiceProvider alias = spi.getPreset(className);
        if (alias != null) {
            this.addSPI(spi, alias);
            return alias;
        }
        ServiceProvider customProviderInstance = (ServiceProvider)this.classLoader.loadClass(className).newInstance();
        this.addSPI(spi, customProviderInstance);
        return customProviderInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseCLIArgs(String[] options_array) throws CLParsingException {
        ArrayList<String> opts = new ArrayList<String>(Arrays.asList(options_array));
        LinkedList<String> tailList = new LinkedList<String>();
        this.CLProperties = new Properties();
        this.processSPIs(opts);
        CLParsingException toThrow = null;
        try {
            ListIterator<String> it = opts.listIterator();
            while (it.hasNext()) {
                String prop;
                String opt = it.next();
                if (!EnvHandler.isOption(opt) || !PROPERTYFILE.isName(opt = opt.substring(1))) continue;
                if (!it.hasNext() && toThrow == null) {
                    toThrow = new CLParsingException("Option '" + opt + "' is invalid: value expected.");
                }
                if ("".equals(prop = it.next())) break;
                PropertyFinder.setPropertiesFile(prop);
                break;
            }
            it = opts.listIterator();
            while (it.hasNext()) {
                String option = it.next();
                if (option.startsWith(PROP_FILE_SPECIFIER)) {
                    String filename = option.substring(1);
                    this.CLProperties = PropertyFinder.readProperties(filename, this.CLProperties);
                    continue;
                }
                if (!EnvHandler.isOption(option)) {
                    tailList.add(option);
                    continue;
                }
                OptionDescr optDescr = this.getOptionByName(option = option.substring(1));
                if (optDescr == null) {
                    if (toThrow != null) continue;
                    toThrow = new CLParsingException("Option '" + option + "' is invalid.");
                    continue;
                }
                if (!optDescr.isMultiple && this.options.containsKey(optDescr.name) && toThrow == null) {
                    toThrow = new CLParsingException("Option is specified twice : " + option);
                }
                if (optDescr.hasValue) {
                    try {
                        this.processOption(it, optDescr, option);
                    }
                    catch (NoSuchElementException e) {
                        if (toThrow != null) continue;
                        toThrow = new CLParsingException("Option '" + option + "' is invalid: value expected.");
                    }
                    continue;
                }
                this.setOption(optDescr);
            }
        }
        finally {
            if (toThrow != null) {
                throw toThrow;
            }
        }
        this.tail = !tailList.isEmpty() ? tailList.toArray(new String[tailList.size()]) : null;
    }

    private void processOption(ListIterator<String> it, OptionDescr optDescr, String option) throws CLParsingException {
        if (optDescr.val_kind == 3) {
            if (!it.hasNext()) {
                throw new NoSuchElementException();
            }
            while (it.hasNext()) {
                String value = it.next();
                this.addValuedOption(value, option, optDescr);
            }
        } else {
            String value = it.next();
            if (value.startsWith(PROP_FILE_SPECIFIER)) {
                value = PropertyFinder.readPropFrom(value.substring(1), option);
            }
            this.addValuedOption(value, option, optDescr);
        }
    }

    private void processSPIs(ArrayList<String> opts) throws CLParsingException {
        if (!this.spiDescrs.isEmpty()) {
            String className;
            ListIterator<String> it = opts.listIterator();
            while (it.hasNext()) {
                SPIDescr descr;
                String opt = it.next();
                if (!EnvHandler.isOption(opt) || (descr = this.getSPIDescrByName(opt = opt.substring(1))) == null) continue;
                if (!it.hasNext()) {
                    throw new CLParsingException("Service provider '" + opt + "' is invalid: value expected");
                }
                it.remove();
                className = it.next();
                it.remove();
                try {
                    this.instantiateServiceProvider(descr, className);
                }
                catch (ClassNotFoundException e) {
                    throw new CLParsingException("Service Provider class '" + className + "' not found");
                }
                catch (ClassCastException e) {
                    throw new CLParsingException("Invalid class for Service Provider '" + opt + "': '" + className + "' - not a Service provider");
                }
                catch (InstantiationException e) {
                    throw new CLParsingException("Can't instantiate Service Provider class '" + className + "'");
                }
                catch (Exception e) {
                    throw new CLParsingException("Error loading Service Provider '" + className + "': exception " + e.getClass() + " occured '" + e.getMessage() + "'", e);
                }
            }
            for (SPIDescr descr : this.spiDescrs) {
                if (this.readProviders.containsKey(descr)) continue;
                className = PropertyFinder.findValue(descr.getName(), null);
                if (className != null) {
                    try {
                        this.instantiateServiceProvider(descr, className);
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        throw new CLParsingException("Service Provider class '" + className + "' not found");
                    }
                    catch (ClassCastException e) {
                        throw new CLParsingException("Invalid class for Service Provider '" + descr.getName() + "': '" + className + "' - not a Service provider");
                    }
                    catch (InstantiationException e) {
                        throw new CLParsingException("Can't instantiate Service Provider class '" + className + "'");
                    }
                    catch (Exception e) {
                        throw new CLParsingException("Error loading Service Provider '" + className + "': exception " + e.getClass() + " occured '" + e.getMessage() + "'", e);
                    }
                }
                if (descr.getDefaultSPI() == null) continue;
                this.addSPI(descr, descr.getDefaultSPI());
            }
        }
    }

    public boolean isValidOption(String name) {
        return this.getOptionByName(name) == null;
    }

    private void setOption(OptionDescr optDescr) {
        this.options.put(optDescr.name, null);
    }

    private void addValuedOption(String value, String option, OptionDescr optDescr) throws CLParsingException {
        if (value == null) {
            throw new CLParsingException("Option '" + option + "' is invalid: value expected.");
        }
        if (!optDescr.isAllowedValue(value)) {
            throw new CLParsingException("Invalid value for option '" + option + "' : '" + value + "'");
        }
        if (!optDescr.isMultiple) {
            ArrayList<String> list = new ArrayList<String>(1);
            list.add(value);
            this.options.put(optDescr.name, list);
        } else {
            List<String> list = this.options.get(optDescr.name);
            if (list == null) {
                list = new LinkedList<String>();
                this.options.put(optDescr.name, list);
            }
            list.add(value);
        }
    }

    public static String[] parseAgentString(String args) {
        if (args == null || args.trim().length() == 0) {
            return new String[0];
        }
        String[] opts = args.split(AGENT_OPT_DELIM);
        LinkedList<String> res = new LinkedList<String>();
        for (String s : opts) {
            int ind = s.indexOf(OPT_VAL_DELIM);
            if (ind == -1) {
                if (s.contains(PROP_FILE_SPECIFIER)) {
                    res.add(s);
                    continue;
                }
                res.add(OPTION_SPECIFIER + s);
                continue;
            }
            res.add(OPTION_SPECIFIER + s.substring(0, ind));
            res.add(s.substring(ind + 1));
        }
        return res.toArray(new String[res.size()]);
    }

    public void set(String option_name) {
        this.set(option_name, (String)null);
    }

    public void set(String option_name, String option_value) {
        List<String> opt_values = this.options.get(option_name);
        if (opt_values == null) {
            opt_values = new LinkedList<String>();
            this.options.put(option_name, opt_values);
        }
        if (option_value == null) {
            return;
        }
        opt_values.add(option_value);
    }

    public void set(String option_name, String[] option_values) {
        if (option_values == null) {
            this.options.put(option_name, null);
        } else {
            ArrayList<String> opt_values = new ArrayList<String>(Arrays.asList(option_values));
            this.options.put(option_name, opt_values);
        }
    }

    public void set(String option_name, List<String> option_values) {
        this.options.put(option_name, option_values);
    }

    public String getCleanValue(OptionDescr option) {
        if (!this.validOptions.contains(option)) {
            return null;
        }
        if (!option.hasValue && this.isSet(option)) {
            return "on";
        }
        String[] values = this.getCleanValues(option);
        if (values == null) {
            return option.defVal;
        }
        return values[0];
    }

    public String getValue(OptionDescr option) {
        if (!this.validOptions.contains(option)) {
            return option.defVal;
        }
        if (!option.hasValue && this.isSet(option)) {
            return "on";
        }
        String[] values = this.getValues(option);
        if (values == null) {
            return PropertyFinder.processMacroString(option.defVal, null, null);
        }
        return values[0];
    }

    private String[] getValues(String option_name) {
        List<String> opt_values = this.options.get(option_name);
        if (opt_values == null) {
            if (this.CLProperties.containsKey("jcov." + option_name)) {
                return ((String)this.CLProperties.get("jcov." + option_name)).split(PROP_OPT_DELIM);
            }
            String res = PropertyFinder.findValue(option_name, null);
            if (res != null) {
                return res.split(PROP_OPT_DELIM);
            }
            return null;
        }
        if (opt_values.isEmpty()) {
            return null;
        }
        return opt_values.toArray(new String[opt_values.size()]);
    }

    public String[] getCleanValues(OptionDescr option) {
        if (!this.validOptions.contains(option)) {
            return null;
        }
        if (!option.hasValue && this.isSet(option)) {
            return new String[]{"on"};
        }
        String[] values = this.getValues(option.name);
        if (values == null || values.length == 0) {
            String[] stringArray;
            if (option.defVal == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = option.defVal;
            }
            return stringArray;
        }
        return values;
    }

    public String[] getValues(OptionDescr option) {
        String[] values = this.getCleanValues(option);
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                values[i] = PropertyFinder.processMacroString(values[i], null, null);
            }
        }
        return values;
    }

    public String[] getTail() {
        return this.tail;
    }

    public boolean isSet(OptionDescr option) {
        if (!this.validOptions.contains(option)) {
            return false;
        }
        return this.options.containsKey(option.name) || this.CLProperties.containsKey("jcov." + option.name) || PropertyFinder.findValue(option.name, null) != null;
    }

    public String unParse() {
        StringBuilder builder = new StringBuilder();
        Iterator<String> it = this.options.keySet().iterator();
        while (it.hasNext()) {
            String opt_name = it.next();
            String[] opt_values = this.getValues(opt_name);
            if (opt_values != null) {
                for (int j = 0; j < opt_values.length; ++j) {
                    builder.append(OPTION_SPECIFIER).append(opt_name).append(OPT_VAL_DELIM).append(opt_values[j]);
                    if (j >= opt_values.length - 1) continue;
                    builder.append(" ");
                }
            } else {
                builder.append(OPTION_SPECIFIER).append(opt_name);
            }
            if (!it.hasNext()) continue;
            builder.append(" ");
        }
        return builder.toString();
    }

    public void printEnv() {
        for (OptionDescr descr : this.validOptions) {
            String source = null;
            source = this.options.containsKey(descr.name) ? "cmd" : PropertyFinder.findSource(descr.name);
            if (descr.equals(PRINT_ENV) && "defaults".equals(source)) continue;
            if (descr.isMultiple) {
                System.out.println("Property '" + descr.name + "' has values '" + Arrays.toString(this.getValues(descr)) + "' from " + source);
                continue;
            }
            if (descr.hasValue) {
                System.out.println("Property '" + descr.name + "' has value '" + this.getValue(descr) + "' from " + source);
                continue;
            }
            if (!this.isSet(descr)) continue;
            System.out.println("Property '" + descr.name + "' is set from " + source);
        }
    }

    public Map<String, List<String>> getFullEnvironment() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>(this.options);
        for (OptionDescr opt : this.validOptions) {
            if (map.containsKey(opt.name)) continue;
            if (!opt.hasValue) {
                map.put(opt.name, null);
                continue;
            }
            String[] values = this.getValues(opt);
            map.put(opt.name, Arrays.asList(values));
        }
        return map;
    }

    public int size() {
        return this.options.size();
    }

    public void usage(boolean verbose) {
        if (this.tool == null) {
            return;
        }
        if (!verbose) {
            this.out.println("Try \"-help-verbose\" for more detailed help");
        }
        this.out.println("Usage:");
        this.out.println("> " + this.tool.usageString());
        if (this.validOptions != null) {
            this.out.println("    options:");
            for (OptionDescr od : this.validOptions) {
                if (SHARED_OPTIONS.contains(od)) continue;
                this.out.println(od.getUsage(OPTION_SPECIFIER, " ", "    ", verbose));
            }
            for (OptionDescr od : SHARED_OPTIONS) {
                this.out.println(od.getUsage(OPTION_SPECIFIER, " ", "    ", verbose));
            }
        }
        if (!this.spiDescrs.isEmpty()) {
            this.out.println("Service providers: ");
            for (SPIDescr spi : this.spiDescrs) {
                this.out.print("    -");
                this.out.print(spi.getName());
                this.out.print(" : ");
                Class<? extends ServiceProvider> clazz = spi.getSPIClass();
                this.out.println(clazz.getSimpleName());
            }
        }
        this.out.print("Example: ");
        this.out.println(this.tool.exampleString());
    }

    public void usage() {
        this.usage(this.isSet(HELP_VERBOSE));
    }

    public void setOut(PrintStream out) {
        this.out = out;
    }

    public PrintStream getOut() {
        return this.out;
    }

    public void registerSPI(SPIDescr spiDescr) {
        if (this.spiDescrs.contains(spiDescr)) {
            return;
        }
        this.spiDescrs.add(spiDescr);
        Collection<ServiceProvider> defs = spiDescr.getPresets();
        if (defs != null) {
            for (ServiceProvider def : defs) {
                if (!(def instanceof EnvServiceProvider)) continue;
                this.extendingSPI = (EnvServiceProvider)def;
                this.extendingSPI.extendEnvHandler(this);
                this.extendingSPI = null;
            }
        }
    }

    public boolean removeOption(OptionDescr descr) {
        return this.validOptions.remove(descr);
    }

    public boolean addOption(OptionDescr descr) {
        int pos = 1;
        int foundPos = -1;
        for (OptionDescr d : this.validOptions) {
            if (d.name.equals(descr.name)) {
                return false;
            }
            if (foundPos < 0 && d.title != null && !d.title.isEmpty() && d.title.equals(descr.title)) {
                descr.title = "";
                foundPos = pos;
            }
            ++pos;
        }
        if (this.extendingSPI != null) {
            descr.setRegisteringSPI(this.extendingSPI);
        }
        if (foundPos > 0) {
            this.validOptions.add(foundPos, descr);
        } else {
            this.validOptions.add(descr);
        }
        return true;
    }

    public void addOptions(OptionDescr[] optionDescr) {
        for (OptionDescr opt : optionDescr) {
            this.addOption(opt);
        }
    }

    public <SPIClass extends ServiceProvider> ArrayList<SPIClass> getSPIs(Class<SPIClass> spiClass) {
        return this.getSPIs(this.getSPIByClass(spiClass));
    }

    public ArrayList<ServiceProvider> getSPIs(SPIDescr descr) {
        if (descr == null) {
            return new ArrayList<ServiceProvider>(0);
        }
        ArrayList<ServiceProvider> get = this.readProviders.get(descr);
        if (get == null) {
            if (descr.getDefaultSPI() != null) {
                get = new ArrayList(1);
                get.add(descr.getDefaultSPI());
                return get;
            }
            return new ArrayList<ServiceProvider>(0);
        }
        return get;
    }

    public int initializeSPIs() throws JCovTool.EnvHandlingException {
        for (ArrayList<ServiceProvider> list : this.readProviders.values()) {
            for (ServiceProvider sp : list) {
                if (!(sp instanceof EnvServiceProvider)) continue;
                int n = ((EnvServiceProvider)sp).handleEnv(this);
            }
        }
        for (SPIDescr spi : this.spiDescrs) {
            Collection<ServiceProvider> aliaseSPIs;
            if (spi.getDefaultSPI() != null && spi.getDefaultSPI() instanceof EnvServiceProvider) {
                ((EnvServiceProvider)spi.getDefaultSPI()).handleEnv(this);
            }
            if ((aliaseSPIs = spi.getPresets()) == null || aliaseSPIs.isEmpty()) continue;
            for (ServiceProvider sp : aliaseSPIs) {
                if (!(sp instanceof EnvServiceProvider)) continue;
                ((EnvServiceProvider)sp).handleEnv(this);
            }
        }
        return 0;
    }

    void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public static class CLParsingException
    extends Exception {
        public CLParsingException(Throwable cause) {
            super(cause);
        }

        public CLParsingException(String message, Throwable cause) {
            super(message, cause);
        }

        public CLParsingException(String message) {
            super(message);
        }

        public CLParsingException() {
        }
    }
}

