/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.tools;

import com.sun.tdk.jcov.runtime.PropertyFinder;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LoggingFormatter
extends Formatter {
    public static boolean printStackTrace = Boolean.parseBoolean(PropertyFinder.findValue("stacktrace", "false"));

    @Override
    public String format(LogRecord record) {
        if (record.getThrown() != null) {
            StringBuilder ret = new StringBuilder(String.format("%-8s: %s", record.getLevel().getLocalizedName(), record.getMessage() != null ? this.formatMessage(record) + "\nException details: " : ""));
            if (printStackTrace) {
                StringWriter sw = new StringWriter();
                record.getThrown().printStackTrace(new PrintWriter(sw));
                ret.append(sw.toString()).append("\n");
            } else if (record.getThrown() instanceof NullPointerException) {
                StackTraceElement[] stackTrace = record.getThrown().getStackTrace();
                if (stackTrace.length > 0) {
                    ret.append("NPE in ").append(stackTrace[0]).append("\n");
                } else {
                    ret.append("NPE in unknown place");
                    StringWriter sw = new StringWriter();
                    record.getThrown().printStackTrace(new PrintWriter(sw));
                    ret.append(sw.toString()).append("\n");
                }
            } else {
                ret.append(record.getThrown().getMessage()).append("\n");
            }
            return ret.toString();
        }
        return String.format("%-8s: %s\n", record.getLevel().getLocalizedName(), this.formatMessage(record));
    }
}

