/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.CodeSource;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipException;

public class AddToProduct {
    private static Set inJars;
    private static Set jarEntryNames;
    private static final String THIS_CLASS;

    public static void main(String[] args) {
        CodeSource src = AddToProduct.class.getProtectionDomain().getCodeSource();
        if (src == null) {
            System.err.println("Can't find main file in specified source");
            return;
        }
        URL location = src.getLocation();
        JarFile currentJar = null;
        try {
            currentJar = new JarFile(location.getFile());
        }
        catch (ZipException ze) {
            System.err.println("Can't read jar file to add it in products jars");
            return;
        }
        catch (IOException ioe) {
            System.err.println("Can't use this functionality not from jar file");
            return;
        }
        if (args.length == 0) {
            System.err.println("Please specify products jars to add this jar in");
            return;
        }
        inJars = new HashSet();
        for (int i = 0; i < args.length; ++i) {
            try {
                inJars.add(new JarFile(args[i]));
                continue;
            }
            catch (SecurityException ze) {
                System.out.println("Access to the specified product jar: " + args[i] + " is denied");
                continue;
            }
            catch (IOException ioe) {
                System.out.println("Product jar " + args[i] + " doesn't exist");
            }
        }
        if (inJars.isEmpty()) {
            System.err.println("Please specify products jars to add this jar in");
            return;
        }
        for (JarFile product : inJars) {
            File archiveFile = new File(product.getName() + "_temp");
            try {
                FileOutputStream stream = new FileOutputStream(archiveFile);
                JarOutputStream fos = new JarOutputStream((OutputStream)stream, product.getManifest());
                jarEntryNames = new HashSet();
                AddToProduct.writeEntriesToJar(product.entries(), fos, product);
                AddToProduct.writeEntriesToJar(currentJar.entries(), fos, currentJar);
                fos.flush();
                fos.close();
                File origFile = new File(product.getName());
                if (!origFile.delete()) {
                    System.out.println("Can not delete product jar: " + product.getName() + " the result is in the " + product.getName() + "_temp");
                    continue;
                }
                archiveFile.renameTo(origFile);
            }
            catch (IOException ioe) {
                System.out.println("IOException while processing product jar file: " + product.getName() + " " + ioe);
            }
        }
    }

    private static void writeEntriesToJar(Enumeration<JarEntry> en, JarOutputStream fos, JarFile outJar) throws IOException {
        while (en.hasMoreElements()) {
            JarEntry element = en.nextElement();
            if (element.getName().equals("META-INF/") || element.getName().equals("META-INF/MANIFEST.MF") || element.getName().equals(THIS_CLASS)) continue;
            if (!jarEntryNames.add(element.getName())) {
                System.err.println("Duplicate jar entry [" + element.getName() + "]");
                continue;
            }
            fos.putNextEntry(element);
            InputStream filereader = outJar.getInputStream(element);
            int buffersize = 1024;
            byte[] buffer = new byte[1024];
            int readcount = 0;
            while ((readcount = filereader.read(buffer, 0, 1024)) >= 0) {
                if (readcount <= 0) continue;
                fos.write(buffer, 0, readcount);
            }
            fos.closeEntry();
            filereader.close();
        }
    }

    static {
        THIS_CLASS = AddToProduct.class.getName().replace('.', '/') + ".class";
    }
}

