/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.util;

import com.sun.tdk.jcov.tools.JCovTool;
import com.sun.tdk.jcov.tools.LoggingFormatter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.PatternSyntaxException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public final class Utils {
    public static final int ASM_API_VERSION = 458752;
    private static Handler loggerHandler = null;
    private static final int ASCII_CHARS_TOTAL = 128;
    private static char[] buf = new char[32];
    private static File[] fileSysRoots;
    private static boolean fileSysRootsGot;
    static final char[] chars;
    public static final int radix;
    static int[] map;
    private static final Logger logger;
    public static final int VER16 = 160;
    public static final int VER17 = 160;
    public static final int VER18 = 160;
    public static final int VER90 = 900;
    public static final int VER100 = 1000;
    private static int javaVersion;

    public static int getJavaVersion() {
        if (javaVersion == -1) {
            String ver = System.getProperty("java.version");
            for (int i = 1; i <= 15; ++i) {
                if (!ver.startsWith(String.format(i <= 8 ? "1.%d" : "%d", i))) continue;
                return i <= 8 ? 100 + i * 10 : i * 100;
            }
            javaVersion = 900;
        }
        return javaVersion;
    }

    public static byte[] ensureBufLength(byte[] buf, int length, boolean copy_old_buf) {
        if (buf.length >= length) {
            return buf;
        }
        byte[] tmp_buf = new byte[length + length / 2];
        if (copy_old_buf) {
            System.arraycopy(buf, 0, tmp_buf, 0, buf.length);
        }
        return tmp_buf;
    }

    public static String getRelativePath(String ref_path, String tst_path) {
        String[] ref_arr = Utils.split(ref_path, File.separatorChar);
        String[] tst_arr = Utils.split(tst_path, File.separatorChar);
        int last_match_ind = -1;
        String res = "";
        int i = 0;
        while (i < ref_arr.length && i < tst_arr.length && ref_arr[i].equals(tst_arr[i])) {
            last_match_ind = i++;
        }
        for (i = 0; i < ref_arr.length - last_match_ind - 1; ++i) {
            res = res + ".." + File.separator;
        }
        for (i = last_match_ind + 1; i < tst_arr.length; ++i) {
            res = res + tst_arr[i] + File.separator;
        }
        if (res.equals("")) {
            res = "." + File.separator;
        }
        return res.substring(0, res.length() - 1);
    }

    private static File[] getFileSystemRoots() {
        if (!fileSysRootsGot) {
            fileSysRoots = File.listRoots();
            fileSysRootsGot = true;
        }
        return fileSysRoots;
    }

    public static String getRelativePath(File ref_file, File tst_file) {
        File[] roots = Utils.getFileSystemRoots();
        String ref_path = null;
        String tst_path = null;
        try {
            ref_path = ref_file.getCanonicalPath();
            tst_path = tst_file.getCanonicalPath();
        }
        catch (IOException e) {
            ref_path = ref_file.getAbsolutePath();
            tst_path = tst_file.getAbsolutePath();
        }
        if (roots != null) {
            for (int i = 0; i < roots.length; ++i) {
                String root = roots[i].getAbsolutePath();
                if (ref_path.startsWith(root) == tst_path.startsWith(root)) continue;
                return null;
            }
        }
        return Utils.getRelativePath(ref_path, tst_path);
    }

    public static String basename(String path) {
        int i2;
        int i;
        int i1 = path.lastIndexOf(File.separatorChar);
        int n = i = i1 > (i2 = path.lastIndexOf("/")) ? i1 : i2;
        if (i == -1) {
            return path;
        }
        return path.substring(i + 1);
    }

    public static String substitute(String s, String from, String to) {
        if (s == null || from == null || s.equals("") || from.equals("")) {
            return s;
        }
        String res = "";
        int ind = s.indexOf(from);
        while (ind >= 0) {
            res = res + s.substring(0, ind);
            res = res + to;
            s = s.substring(ind + 1);
            ind = s.indexOf(from);
        }
        res = res + s;
        return res;
    }

    public static String[] split(String s, char delim) {
        String str = s;
        if (str == null) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        int ind = str.indexOf(delim);
        while (ind >= 0) {
            if (ind > 0) {
                v.addElement(str.substring(0, ind));
            }
            str = str.substring(ind + 1);
            ind = str.indexOf(delim);
        }
        if (str.length() > 0) {
            v.addElement(str);
        }
        Object[] res = new String[v.size()];
        v.copyInto(res);
        return res;
    }

    public static String[] getSourcePaths(String s) {
        String[] source_paths = Utils.split(s, File.pathSeparatorChar);
        for (int i = 0; i < source_paths.length; ++i) {
            String path = source_paths[i];
            if (path.equals("") || path.endsWith("/") && !path.endsWith(File.separator)) continue;
            source_paths[i] = path = path + File.separator;
        }
        return source_paths;
    }

    public static int convert2BigRadix(int val, StringBuffer sbuf, int ind) {
        int i = 0;
        while (val > 0) {
            Utils.buf[i++] = chars[val % radix];
            val /= radix;
        }
        for (int j = 1; j <= i; ++j) {
            sbuf.setCharAt(ind + j - 1, buf[i - j]);
        }
        return ind + i;
    }

    public static int convert2Int(char digit) {
        return map[digit];
    }

    public static byte hexChar2Int(char ch) {
        boolean f3;
        boolean f1 = ch >= '0' && ch <= '9';
        boolean f2 = ch >= 'A' && ch <= 'F';
        boolean bl = f3 = ch >= 'a' && ch <= 'f';
        if (!(f1 || f2 || f3)) {
            return -1;
        }
        if (f1) {
            return (byte)(ch - 48);
        }
        if (f2) {
            return (byte)(10 + ch - 65);
        }
        return (byte)(10 + ch - 97);
    }

    public static char int2HexChar(int val) {
        if (val >= 0 && val < 10) {
            return (char)(val + 48);
        }
        if (val >= 10 && val < 16) {
            return (char)(val + 97 - 10);
        }
        return '\uffff';
    }

    public static int pow(int base, int power) {
        int res = 1;
        for (int i = 0; i < power; ++i) {
            res *= base;
        }
        return res;
    }

    public static void writeHalfByteAt(byte half_byte, int ind, byte[] dst) {
        int i = ind / 2;
        if (ind % 2 == 0) {
            byte val = (byte)(dst[i] & 0xF0);
            dst[i] = (byte)(val | half_byte);
        } else {
            byte val = (byte)(dst[i] & 0xF);
            dst[i] = (byte)(val | half_byte << 4);
        }
    }

    public static byte getHalfByteAt(int ind, byte[] src) {
        return (byte)(ind % 2 == 0 ? src[ind / 2] & 0xF : src[ind / 2] >>> 4 & 0xF);
    }

    public static byte getHalfByteAt(int ind, byte src) {
        return (byte)(ind % 2 == 0 ? src & 0xF : src >>> 4 & 0xF);
    }

    public static int halfBytesRequiredFor(int bits_total) {
        return (bits_total + 3) / 4;
    }

    public static int compareStringArrays(String[] arr1, String[] arr2) {
        boolean b2;
        boolean b1 = arr1 == null || arr1.length == 0;
        boolean bl = b2 = arr2 == null || arr2.length == 0;
        if (b1 && b2) {
            return 0;
        }
        if (b1 && !b2) {
            return -1;
        }
        if (!b1 && b2) {
            return 1;
        }
        int min_len = arr1.length > arr2.length ? arr2.length : arr1.length;
        for (int i = 0; i < min_len; ++i) {
            int res = arr1[i].compareTo(arr2[i]);
            if (res == 0) continue;
            return res;
        }
        return arr1.length > arr2.length ? 1 : -1;
    }

    public static <T> T[] copyOf(T[] original, int newLength) {
        return Utils.copyOf(original, newLength, original.getClass());
    }

    public static <T, U> T[] copyOf(U[] original, int newLength, Class<? extends T[]> newType) {
        Object[] copy = newType == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static int[] copyOf(int[] original, int newLength) {
        int[] copy = new int[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static String[] readLines(String fileName) throws IOException {
        return Utils.readLines(fileName, -1, -1);
    }

    public static String[] readLines(String fileName, int start, int end) throws IOException {
        String line;
        ArrayList<String> lst = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), Charset.defaultCharset()));
        int i = 0;
        while ((line = reader.readLine()) != null) {
            if (!(start != -1 && i < start || end != -1 && i > end || (line = line.trim()).length() <= 0)) {
                lst.add(line);
            }
            ++i;
        }
        reader.close();
        return lst.toArray(new String[0]);
    }

    public static void writeLines(String fileName, String[] lines) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), Charset.defaultCharset()));
        for (int i = 0; i < lines.length; ++i) {
            writer.write(lines[i]);
            writer.newLine();
        }
        writer.flush();
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File from, File to) throws FileNotFoundException, IOException {
        FileChannel infc = null;
        AbstractInterruptibleChannel outfc = null;
        try {
            infc = new FileInputStream(from).getChannel();
            outfc = new FileOutputStream(to).getChannel();
            long transfered = infc.transferTo(0L, from.length(), (WritableByteChannel)((Object)outfc));
            while (transfered < from.length()) {
                transfered = infc.transferTo(transfered, from.length(), (WritableByteChannel)((Object)outfc));
            }
        }
        finally {
            try {
                if (infc != null) {
                    infc.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (outfc != null) {
                    outfc.close();
                }
            }
            catch (Exception exception) {}
        }
        to.setExecutable(from.canExecute());
        to.setReadable(from.canRead());
        to.setWritable(from.canWrite());
    }

    public static void addToClasspath(String[] path) {
        if (ClassLoader.getSystemClassLoader() instanceof URLClassLoader) {
            URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
            Class<URLClassLoader> sysclass = URLClassLoader.class;
            try {
                Method method = sysclass.getDeclaredMethod("addURL", URL.class);
                method.setAccessible(true);
                URL[] urls = new URL[path.length];
                for (int i = 0; i < path.length; ++i) {
                    urls[i] = new File(path[i]).toURI().toURL();
                    method.invoke((Object)sysloader, urls[i]);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public static void addToClasspath(File directory) {
        if (directory.exists() && directory.isDirectory()) {
            ArrayList<String> classes = new ArrayList<String>();
            Utils.getClassesAndJars(directory, classes);
            Utils.addToClasspath(classes.toArray(new String[0]));
        }
    }

    private static void getClassesAndJars(File dir, List<String> classes) {
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                Utils.getClassesAndJars(f, classes);
                continue;
            }
            if (!f.getAbsolutePath().endsWith(".jar") && !f.getAbsolutePath().endsWith(".class")) continue;
            classes.add(f.getAbsolutePath());
        }
    }

    public static void setLoggerHandler(Handler loggerHandler) {
        loggerHandler.setFormatter(LoggerHandlerDelegator.formatter);
        if (Utils.loggerHandler != null) {
            loggerHandler.setLevel(Utils.loggerHandler.getLevel());
        }
        Utils.loggerHandler = loggerHandler;
    }

    public static void setLoggingLevel(Level level) {
        logger.setLevel(level);
        loggerHandler.setLevel(level);
    }

    public static void setLoggingLevel(String levelStr) {
        Level level = "VERBOSE".equals(levelStr = levelStr.toUpperCase()) || "V".equals(levelStr) ? Level.INFO : ("QUIET".equals(levelStr) || "Q".equals(levelStr) ? Level.OFF : Level.parse(levelStr));
        Utils.setLoggingLevel(level);
    }

    public static void initLogger() {
        if (loggerHandler == null) {
            Utils.setLoggerHandler(new ConsoleHandler());
        }
        if (System.getProperty("java.util.logging.config.file") == null) {
            InputStream in = null;
            try {
                in = Utils.class.getResourceAsStream("/com/sun/tdk/jcov/logging.properties");
                if (ClassLoader.getSystemClassLoader().equals(Utils.class.getClassLoader())) {
                    LogManager.getLogManager().readConfiguration(in);
                } else {
                    LogManager.getLogManager().reset();
                }
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void initLogger(String propfile) {
        if (System.getProperty("java.util.logging.config.file") == null) {
            InputStream in = null;
            try {
                System.setProperty("java.util.logging.config.file", propfile);
                in = Utils.class.getResourceAsStream(propfile);
                LogManager.getLogManager().readConfiguration(in);
            }
            catch (Exception ex) {
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public static String convertVMType(String s) {
        return Utils.getTypeName(s.replace('/', '.'));
    }

    public static String getTypeName(String typeName) {
        StringBuilder sb = new StringBuilder();
        int dims = 0;
        while (typeName.charAt(dims) == '[') {
            ++dims;
        }
        String type = typeName.charAt(dims) == 'L' ? typeName.substring(dims + 1, typeName.length() - 1) : PrimitiveTypes.getPrimitiveType(typeName.charAt(dims));
        sb.append(type);
        for (int i = 0; i < dims; ++i) {
            sb.append("[]");
        }
        return sb.toString();
    }

    public static String convertVMtoJLS(String methName, String VMsig) {
        Matcher m = java.util.regex.Pattern.compile("\\(([^\\)]*)\\)(.*)").matcher(VMsig);
        if (m.matches()) {
            return String.format("%s %s(%s)", Utils.convertVMType(m.group(2)), methName, Utils.getArgs(m.group(1)));
        }
        return methName + " " + VMsig;
    }

    private static String getArgs(String descr) throws IllegalArgumentException {
        if (descr.equals("")) {
            return descr;
        }
        int pos = 0;
        int lastPos = descr.length();
        StringBuilder args = new StringBuilder();
        int dims = 0;
        while (pos < lastPos) {
            String type;
            char ch = descr.charAt(pos);
            if (ch == 'L') {
                int delimPos = descr.indexOf(59, pos);
                if (delimPos == -1) {
                    delimPos = lastPos;
                }
                type = Utils.convertVMType(descr.substring(pos, delimPos + 1));
                pos = delimPos + 1;
            } else {
                if (ch == '[') {
                    ++dims;
                    ++pos;
                    continue;
                }
                type = PrimitiveTypes.getPrimitiveType(ch);
                ++pos;
            }
            args.append(type);
            for (int i = 0; i < dims; ++i) {
                args.append("[]");
            }
            dims = 0;
            if (pos >= lastPos) continue;
            args.append(',');
        }
        return args.toString();
    }

    public static Pattern[] concatFilters(String[] includes, String[] excludes) {
        return Utils.concatFilters(includes, excludes, false);
    }

    public static Pattern[] concatModuleFilters(String[] includes, String[] excludes) {
        return Utils.concatFilters(includes, excludes, true);
    }

    private static Pattern[] concatFilters(String[] includes, String[] excludes, boolean modulePattern) {
        int j;
        String[] split;
        int i;
        if (includes == null || includes.length == 1 && includes[0].equals("")) {
            includes = new String[]{};
        }
        if (excludes == null || excludes.length == 1 && excludes[0].equals("")) {
            excludes = new String[]{};
        }
        ArrayList<Pattern> list = new ArrayList<Pattern>(includes.length + excludes.length);
        for (i = 0; i < includes.length; ++i) {
            if (includes[i].contains("|")) {
                split = includes[i].split("\\|");
                for (j = 0; j < split.length; ++j) {
                    list.add(new Pattern(split[j], true, modulePattern));
                }
                continue;
            }
            list.add(new Pattern(includes[i], true, modulePattern));
        }
        for (i = 0; i < excludes.length; ++i) {
            if (excludes[i].contains("|")) {
                split = excludes[i].split("\\|");
                for (j = 0; j < split.length; ++j) {
                    list.add(new Pattern(split[j], false, modulePattern));
                }
                continue;
            }
            list.add(new Pattern(excludes[i], false, modulePattern));
        }
        Object[] alls = list.toArray(new Pattern[list.size()]);
        Arrays.sort(alls);
        return alls;
    }

    public static boolean accept(Pattern[] alls, String[] allowedModifs, String className, String sig) {
        if (alls.length == 0) {
            if (allowedModifs != null && sig != null && allowedModifs.length != 0) {
                for (int j = 0; j < allowedModifs.length; ++j) {
                    if (!sig.contains(allowedModifs[j])) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
        Boolean parentIncluded = null;
        boolean included = false;
        for (int i = 0; i < alls.length; ++i) {
            if (alls[i].included) {
                included = true;
            }
            if (!alls[i].patt.matcher(className).matches()) continue;
            parentIncluded = alls[i].included;
        }
        if (sig == null || allowedModifs == null || allowedModifs.length == 0) {
            return parentIncluded != null ? parentIncluded : !included;
        }
        for (int j = 0; j < allowedModifs.length; ++j) {
            if (!sig.contains(allowedModifs[j])) continue;
            return true;
        }
        return false;
    }

    public static void checkHostCanBeNull(String hostname, String description) throws JCovTool.EnvHandlingException {
        if (hostname != null) {
            try {
                InetAddress.getByName(hostname);
            }
            catch (UnknownHostException ex) {
                throw new JCovTool.EnvHandlingException("Incorrect " + description + " (" + hostname + ") - unknown host, can't resolve");
            }
        }
    }

    public static File checkFileNotNull(String filename, String description, CheckOptions ... opts) throws JCovTool.EnvHandlingException {
        if (filename == null) {
            throw new IllegalArgumentException("Argument " + description + " should not be null");
        }
        File f = new File(filename);
        Utils.checkFile(f, description, opts);
        return f;
    }

    public static File checkFileCanBeNull(String filename, String description, CheckOptions ... opts) throws JCovTool.EnvHandlingException {
        if (filename == null) {
            return null;
        }
        File f = new File(filename);
        Utils.checkFile(f, description, opts);
        return f;
    }

    public static void checkFile(File file, String description, CheckOptions ... opts) throws JCovTool.EnvHandlingException {
        block10: for (CheckOptions opt : opts) {
            switch (opt) {
                case FILE_EXISTS: {
                    if (file.exists()) continue block10;
                    throw new JCovTool.EnvHandlingException("Incorrect " + description + " (" + file.getPath() + ") - doesn't exist");
                }
                case FILE_NOTEXISTS: {
                    if (!file.exists()) continue block10;
                    throw new JCovTool.EnvHandlingException("Incorrect " + description + " (" + file.getPath() + ") - shouldn't exist");
                }
                case FILE_CANREAD: {
                    if (file.canRead()) continue block10;
                    throw new JCovTool.EnvHandlingException("Incorrect " + description + " (" + file.getPath() + ") - can't read");
                }
                case FILE_ISFILE: {
                    if (file.isFile()) continue block10;
                    throw new JCovTool.EnvHandlingException("Incorrect " + description + " (" + file.getPath() + ") - is not a file");
                }
                case FILE_NOTISFILE: {
                    if (!file.isFile()) continue block10;
                    throw new JCovTool.EnvHandlingException("Incorrect " + description + " (" + file.getPath() + ") - should not be a file");
                }
                case FILE_ISDIR: {
                    if (file.isDirectory()) continue block10;
                    throw new JCovTool.EnvHandlingException("Incorrect " + description + " (" + file.getPath() + ") - is not a directory");
                }
                case FILE_NOTISDIR: {
                    if (!file.isDirectory()) continue block10;
                    throw new JCovTool.EnvHandlingException("Incorrect " + description + " (" + file.getPath() + ") - should not be a directory");
                }
                case FILE_PARENTEXISTS: {
                    File p = file.getParentFile();
                    if (p == null || p.exists()) continue block10;
                    throw new JCovTool.EnvHandlingException("Incorrect " + description + " (" + file.getPath() + ") - parent directory doesn't exist");
                }
            }
        }
    }

    public static int checkedToInt(String value, String description, CheckOptions ... opts) throws JCovTool.EnvHandlingException {
        try {
            int port = Integer.parseInt(value);
            block7: for (CheckOptions opt : opts) {
                switch (opt) {
                    case INT_POSITIVE: {
                        if (port > 0) continue block7;
                        throw new JCovTool.EnvHandlingException("Incorrect " + description + " (" + port + ") - should be positive");
                    }
                    case INT_NONNEGATIVE: {
                        if (port >= 0) continue block7;
                        throw new JCovTool.EnvHandlingException("Incorrect " + description + " (" + port + ") - should not be negative");
                    }
                    case INT_NOT_NULL: {
                        if (port != 0) continue block7;
                        throw new JCovTool.EnvHandlingException("Incorrect " + description + " (0) - should not be null");
                    }
                }
            }
            return port;
        }
        catch (NumberFormatException ex) {
            throw new JCovTool.EnvHandlingException("Incorrect " + description + " (" + value + ") - not a number");
        }
    }

    public static void unzipFolder(File srcFolder, String destZipFile) throws Exception {
        ZipFile zip = new ZipFile(srcFolder);
        Enumeration<? extends ZipEntry> zipFileEntries = zip.entries();
        while (zipFileEntries.hasMoreElements()) {
            int currentByte;
            ZipEntry entry = zipFileEntries.nextElement();
            File destFile = new File(destZipFile, entry.getName());
            destFile.getParentFile().mkdirs();
            if (entry.isDirectory()) continue;
            BufferedInputStream is = new BufferedInputStream(zip.getInputStream(entry));
            FileOutputStream fos = new FileOutputStream(destFile);
            BufferedOutputStream dest = new BufferedOutputStream(fos, 2048);
            byte[] data = new byte[2048];
            while ((currentByte = is.read(data, 0, 2048)) != -1) {
                dest.write(data, 0, currentByte);
            }
            dest.flush();
            dest.close();
            is.close();
        }
    }

    public static void zipFolder(String srcFolder, String destZipFile) throws Exception {
        ZipOutputStream zip = null;
        FileOutputStream fileWriter = null;
        fileWriter = new FileOutputStream(destZipFile);
        zip = new ZipOutputStream(fileWriter);
        Utils.addFolderToZip("", srcFolder, zip);
        zip.flush();
        zip.close();
    }

    private static void addFileToZip(String path, String srcFile, ZipOutputStream zip) throws Exception {
        File folder = new File(srcFile);
        if (folder.isDirectory()) {
            Utils.addFolderToZip(path, srcFile, zip);
        } else {
            int len;
            byte[] buf = new byte[1024];
            FileInputStream in = new FileInputStream(srcFile);
            zip.putNextEntry(new ZipEntry(path + File.separator + folder.getName()));
            while ((len = in.read(buf)) > 0) {
                zip.write(buf, 0, len);
            }
            in.close();
        }
    }

    private static void addFolderToZip(String path, String srcFolder, ZipOutputStream zip) throws Exception {
        File folder = new File(srcFolder);
        for (String fileName : folder.list()) {
            if (path.equals("")) {
                Utils.addFileToZip(folder.getName(), srcFolder + File.separator + fileName, zip);
                continue;
            }
            Utils.addFileToZip(path + File.separator + folder.getName(), srcFolder + File.separator + fileName, zip);
        }
    }

    public static void copyDirectory(File source, File destination) throws IOException {
        File[] files;
        if (!source.exists()) {
            throw new IllegalArgumentException("Source directory (" + source.getPath() + ") doesn't exist.");
        }
        if (!source.isDirectory()) {
            throw new IllegalArgumentException("Source (" + source.getPath() + ") must be a directory.");
        }
        destination.mkdirs();
        for (File file : files = source.listFiles()) {
            if (file.isDirectory()) {
                Utils.copyDirectory(file, new File(destination, file.getName()));
                continue;
            }
            Utils.copyFile(file, new File(destination, file.getName()));
        }
    }

    public static boolean deleteDirectory(File directory) {
        File[] files;
        if (directory.exists() && null != (files = directory.listFiles())) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    Utils.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return directory.delete();
    }

    private static String checkName(String name) {
        if (name != null && !name.isEmpty()) {
            return name;
        }
        return "";
    }

    public static boolean isAdvanceStaticInstrAllowed(String classname, String methodname) {
        if (!(classname.equals("java/lang/System") || classname.equals("java/lang/String") || classname.equals("java/lang/StringLatin1") || classname.equals("java/lang/String$CaseInsensitiveComparator") || classname.equals("java/lang/Thread") || classname.equals("java/lang/ThreadGroup") || classname.equals("java/lang/RuntimePermission") || classname.equals("java/security/Permission") || classname.equals("java/security/BasicPermission") || classname.equals("java/lang/Class"))) {
            return true;
        }
        return !methodname.equals("<clinit>") && !methodname.equals("<init>") && !methodname.equals("init") && !methodname.equals("length") && !methodname.equals("coder") && !methodname.equals("isLatin1") && !methodname.equals("charAt") && !methodname.equals("equals") && !methodname.equals("add") && !methodname.equals("checkAccess") && !methodname.equals("checkParentAccess") && !methodname.equals("getSecurityManager") && !methodname.equals("registerNatives") && !methodname.equals("currentTimeMillis") && !methodname.equals("identityHashCode") && !methodname.equals("nanoTime") && !methodname.equals("getId");
    }

    static {
        fileSysRootsGot = false;
        chars = new char[]{'q', 'w', 'r', 't', 'y', 'u', 'i', 'o', 'p', 's', 'g', 'h', 'j', 'k', 'l', 'z', 'x', 'v', 'n', 'm', 'Q', 'W', 'R', 'T', 'Y', 'U', 'I', 'O', 'P', 'S', 'G', 'H', 'J', 'K', 'L', 'Z', 'X', 'V', 'N', 'M', '!', '@', '#', '$', '%', '^', '&', '*', '(', ')', '_', '+', '|', '~', '-', '=', '\\', '[', ']', '{', '}', ';', '\'', ':', '\"', ',', '.', '/', '<', '>', '?'};
        radix = chars.length;
        map = new int[128];
        logger = Logger.getLogger("com.sun.tdk.jcov");
        for (int i = 0; i < radix; ++i) {
            Utils.map[Utils.chars[i]] = i;
        }
        javaVersion = -1;
    }

    public static class LoggerHandlerDelegator
    extends Handler {
        private static LoggingFormatter formatter = new LoggingFormatter();

        @Override
        public Formatter getFormatter() {
            return formatter;
        }

        @Override
        public synchronized void setLevel(Level newLevel) throws SecurityException {
            loggerHandler.setLevel(newLevel);
        }

        @Override
        public void publish(LogRecord record) {
            loggerHandler.publish(record);
        }

        @Override
        public void flush() {
            loggerHandler.flush();
        }

        @Override
        public void close() throws SecurityException {
            loggerHandler.close();
        }
    }

    static enum PrimitiveTypes {
        BOOLEAN('Z', "boolean"),
        VOID('V', "void"),
        INT('I', "int"),
        LONG('J', "long"),
        CHAR('C', "char"),
        BYTE('B', "byte"),
        DOUBLE('D', "double"),
        SHORT('S', "short"),
        FLOAT('F', "float");

        private char VMSig;
        private String JLS;

        private PrimitiveTypes(char VMSig, String JLS) {
            this.VMSig = VMSig;
            this.JLS = JLS;
        }

        public static String getPrimitiveType(char c) {
            for (PrimitiveTypes type : PrimitiveTypes.values()) {
                if (type.VMSig != c) continue;
                return type.JLS;
            }
            return null;
        }

        public static Character getPrimitiveType(String str) {
            for (PrimitiveTypes type : PrimitiveTypes.values()) {
                if (!type.JLS.equals(str)) continue;
                return Character.valueOf(type.VMSig);
            }
            return null;
        }
    }

    public static class Pattern
    implements Comparable<Pattern> {
        public String element;
        public java.util.regex.Pattern patt;
        public boolean included;

        public String getElement() {
            return this.element;
        }

        public void setElement(String element) {
            this.element = element;
        }

        public boolean isIncluded() {
            return this.included;
        }

        public void setIncluded(boolean included) {
            this.included = included;
        }

        public Pattern(String element, boolean include, boolean modulePattern) {
            try {
                if ("/".equals(element)) {
                    this.element = element;
                    this.included = include;
                    this.patt = java.util.regex.Pattern.compile("/[a-zA-Z0-9_\\$]+");
                } else {
                    this.element = modulePattern ? element.replaceAll("([^\\\\])\\$", "$1\\\\\\$") : element.replaceAll("\\.", "/").replaceAll("([^\\\\])\\$", "$1\\\\\\$");
                    if (this.element.endsWith("/")) {
                        this.element = this.element.substring(0, this.element.length() - 1);
                    }
                    if (!(modulePattern || this.element.length() != 0 && this.element.startsWith("/"))) {
                        this.element = "/" + this.element;
                    }
                    this.patt = java.util.regex.Pattern.compile(this.element.replace('*', '#').replaceAll("##", "[a-zA-Z0-9_\\$/]*").replaceAll("#", "[a-zA-Z0-9_\\$]*") + "(/.*|\\$.*)*");
                    this.included = include;
                }
            }
            catch (PatternSyntaxException e) {
                int p = element.indexOf(92);
                if (p > -1) {
                    throw new IllegalArgumentException("Illegal character '\\' in the pattern '" + element + "' near index " + p);
                }
                p = element.indexOf(40);
                if (p > -1) {
                    throw new IllegalArgumentException("Illegal character '(' in the pattern '" + element + "' near index " + p);
                }
                p = element.indexOf(41);
                if (p > -1) {
                    throw new IllegalArgumentException("Illegal character ')' in the pattern '" + element + "' near index " + p);
                }
                p = element.indexOf(91);
                if (p > -1) {
                    throw new IllegalArgumentException("Illegal character '[' in the pattern '" + element + "' near index " + p);
                }
                p = element.indexOf(93);
                if (p > -1) {
                    throw new IllegalArgumentException("Illegal character ']' in the pattern '" + element + "' near index " + p);
                }
                throw new IllegalArgumentException("Illegal characters in the pattern '" + element + "'");
            }
        }

        public String toString() {
            return (this.included ? "+" : "-") + this.element;
        }

        @Override
        public int compareTo(Pattern o) {
            int i = 0;
            int j = 0;
            if (this.element.contains("$")) {
                if (!o.element.contains("$")) {
                    return 1;
                }
            } else if (o.element.contains("$")) {
                return -1;
            }
            char[] my = this.element.toCharArray();
            char[] his = o.element.toCharArray();
            while (i < my.length && j < his.length) {
                char him;
                char me = my[i];
                if (me == '/' ^ (him = his[i]) == '/') {
                    if (me == '/') {
                        return -1;
                    }
                    return 1;
                }
                int res = me - him;
                if (res != 0) {
                    if (me == '*') {
                        if (i < my.length - 1 && my[i + 1] == '*') {
                            return -2;
                        }
                        return -1;
                    }
                    if (him == '*') {
                        if (i < his.length - 1 && his[i + 1] == '*') {
                            return 2;
                        }
                        return 1;
                    }
                    return res;
                }
                if (me == '*' && i < my.length - 1 && my[i + 1] == '*') {
                    return 2;
                }
                if (him == '*' && i < his.length - 1 && his[i + 1] == '*') {
                    return -2;
                }
                ++i;
                ++j;
            }
            if (i == my.length && j == his.length) {
                if (this.included == o.included) {
                    return 0;
                }
                if (this.included) {
                    return 1;
                }
                if (o.included) {
                    return -1;
                }
                return 0;
            }
            if (i == my.length) {
                return -1000;
            }
            if (j == his.length) {
                return 1000;
            }
            return 0;
        }
    }

    public static enum CheckOptions {
        FILE_EXISTS,
        FILE_NOTEXISTS,
        FILE_ISFILE,
        FILE_ISDIR,
        FILE_NOTISDIR,
        FILE_PARENTEXISTS,
        FILE_CANREAD,
        FILE_CANWRITE,
        INT_NONNEGATIVE,
        INT_POSITIVE,
        INT_NOT_NULL,
        FILE_NOTISFILE;

    }

    public static class Pair {
        public int a;
        public int b;

        public Pair(int a, int b) {
            this.a = a;
            this.b = b;
        }
    }
}

