/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.alignment;

import java.awt.Point;

public enum AlignmentStrategy {
    MOUSE_BOTH{

        @Override
        public Point align(Point compPoint, Point mousePoint) {
            return mousePoint;
        }
    }
    ,
    MOUSE_X_COMPONENT_Y{

        @Override
        public Point align(Point compPoint, Point mousePoint) {
            return new Point(mousePoint.x, compPoint.y);
        }
    }
    ,
    COMPONENT_X_MOUSE_Y{

        @Override
        public Point align(Point compPoint, Point mousePoint) {
            return new Point(compPoint.x, mousePoint.y);
        }
    }
    ,
    COMPONENT_BOTH{

        @Override
        public Point align(Point compPoint, Point mousePoint) {
            return compPoint;
        }
    };


    public abstract Point align(Point var1, Point var2);
}

