/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.tabframe;

import com.github.weisj.darklaf.components.tabframe.PopupContainer;
import com.github.weisj.darklaf.components.tabframe.TabFrameContent;
import com.github.weisj.darklaf.components.tabframe.ToggleSplitPane;
import com.github.weisj.darklaf.util.Alignment;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.function.BiConsumer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class TabFrameContentPane
extends JPanel
implements TabFrameContent {
    protected static final double TOP_SPLIT_DEFAULT_POSITION = 0.2;
    protected static final double BOTTOM_SPLIT_DEFAULT_POSITION = TabFrameContentPane.calculateRelativeComplement(0.2);
    protected static final double LEFT_SPLIT_DEFAULT_POSITION = 0.2;
    protected static final double RIGHT_SPLIT_DEFAULT_POSITION = TabFrameContentPane.calculateRelativeComplement(0.2);
    protected static final double SPLITTER_DEFAULT_POSITION = 0.5;
    protected final ToggleSplitPane topSplit;
    protected final ToggleSplitPane bottomSplit;
    protected final ToggleSplitPane leftSplit;
    protected final ToggleSplitPane rightSplit;
    protected final ToggleSplitPane leftSplitter;
    protected final ToggleSplitPane rightSplitter;
    protected final ToggleSplitPane topSplitter;
    protected final ToggleSplitPane bottomSplitter;
    protected final boolean[] enabled = new boolean[8];
    protected Component cont = new JPanel();

    private static double calculateRelativeComplement(double x) {
        return 1.0 - x / (1.0 - x);
    }

    public TabFrameContentPane() {
        super(new BorderLayout());
        this.cont.setBackground(Color.YELLOW);
        PopupContainer leftBottomPanel = new PopupContainer();
        PopupContainer rightTopPanel = new PopupContainer();
        PopupContainer rightBottomPanel = new PopupContainer();
        PopupContainer topLeftPanel = new PopupContainer();
        PopupContainer topRightPanel = new PopupContainer();
        PopupContainer bottomLeftPanel = new PopupContainer();
        PopupContainer bottomRightPanel = new PopupContainer();
        PopupContainer leftTopPanel = new PopupContainer();
        this.rightSplitter = this.createSplitPane("rightSplitter");
        this.rightSplitter.setOrientation(0);
        this.rightSplitter.setTopComponent(rightTopPanel);
        this.rightSplitter.setBottomComponent(rightBottomPanel);
        this.leftSplitter = this.createSplitPane("leftSplitter");
        this.leftSplitter.setOrientation(0);
        this.leftSplitter.setTopComponent(leftTopPanel);
        this.leftSplitter.setBottomComponent(leftBottomPanel);
        this.topSplitter = this.createSplitPane("topSplitter");
        this.topSplitter.setOrientation(1);
        this.topSplitter.setLeftComponent(topLeftPanel);
        this.topSplitter.setRightComponent(topRightPanel);
        this.bottomSplitter = this.createSplitPane("bottomSplitter");
        this.bottomSplitter.setOrientation(1);
        this.bottomSplitter.setLeftComponent(bottomLeftPanel);
        this.bottomSplitter.setRightComponent(bottomRightPanel);
        this.topSplit = this.createSplitPane("topSplit");
        this.bottomSplit = this.createSplitPane("bottomSplit");
        this.topSplit.setOrientation(0);
        this.bottomSplit.setOrientation(0);
        this.topSplit.setTopComponent(this.topSplitter);
        this.topSplit.setBottomComponent(this.bottomSplit);
        this.bottomSplit.setBottomComponent(this.bottomSplitter);
        this.leftSplit = this.createSplitPane("leftSplit");
        this.rightSplit = this.createSplitPane("rightSplit");
        this.leftSplit.setOrientation(1);
        this.rightSplit.setOrientation(1);
        this.bottomSplit.setTopComponent(this.leftSplit);
        this.leftSplit.setLeftComponent(this.leftSplitter);
        this.leftSplit.setRightComponent(this.rightSplit);
        this.rightSplit.setRightComponent(this.rightSplitter);
        this.rightSplit.setLeftComponent(this.cont);
        this.topSplit.setResizeWeight(0.0);
        this.leftSplit.setResizeWeight(0.0);
        this.bottomSplit.setResizeWeight(1.0);
        this.rightSplit.setResizeWeight(1.0);
        this.setupSplitterPanes(JSplitPane::setResizeWeight, 0.5);
        this.setupSplitPanes(JComponent::setEnabled, false);
        this.setupSplitPanes(ToggleSplitPane::setResizable, false);
        this.setupSplitterPanes(JComponent::setEnabled, false);
        this.setupSplitterPanes(ToggleSplitPane::setResizable, false);
        this.add((Component)this.topSplit, "Center");
        this.init();
    }

    protected ToggleSplitPane createSplitPane(String name) {
        return new TabFrameSplitPane(name);
    }

    protected <T> void setupSplitterPanes(BiConsumer<? super ToggleSplitPane, T> consumer, T flag) {
        consumer.accept((ToggleSplitPane)((ToggleSplitPane)this.bottomSplitter), (ToggleSplitPane)flag);
        consumer.accept((ToggleSplitPane)((ToggleSplitPane)this.leftSplitter), (ToggleSplitPane)flag);
        consumer.accept((ToggleSplitPane)((ToggleSplitPane)this.rightSplitter), (ToggleSplitPane)flag);
        consumer.accept((ToggleSplitPane)((ToggleSplitPane)this.topSplitter), (ToggleSplitPane)flag);
    }

    protected <T> void setupSplitPanes(BiConsumer<? super ToggleSplitPane, T> consumer, T flag) {
        consumer.accept((ToggleSplitPane)((ToggleSplitPane)this.topSplit), (ToggleSplitPane)flag);
        consumer.accept((ToggleSplitPane)((ToggleSplitPane)this.leftSplit), (ToggleSplitPane)flag);
        consumer.accept((ToggleSplitPane)((ToggleSplitPane)this.bottomSplit), (ToggleSplitPane)flag);
        consumer.accept((ToggleSplitPane)((ToggleSplitPane)this.rightSplit), (ToggleSplitPane)flag);
    }

    protected void init() {
        this.disableAll(true);
        this.setupSplitterPanes(ToggleSplitPane::savePosition, 0.5);
        this.topSplit.savePosition(0.2);
        this.bottomSplit.savePosition(BOTTOM_SPLIT_DEFAULT_POSITION);
        this.leftSplit.savePosition(0.2);
        this.rightSplit.savePosition(RIGHT_SPLIT_DEFAULT_POSITION);
        this.doLayout();
    }

    public void disableAll(boolean force) {
        for (Alignment a : Alignment.values()) {
            this.setEnabled(a, false, force);
        }
    }

    @Override
    public void setEnabled(Alignment a, boolean enabled) {
        this.setEnabled(a, enabled, false);
    }

    public void setEnabled(Alignment a, boolean enabled, boolean force) {
        if (enabled == this.isEnabled(a) && !force) {
            return;
        }
        switch (a) {
            case NORTH: {
                this.changeStatus(enabled, Alignment.NORTH_EAST, this.topSplit, this.topSplitter, new LayoutProportions(0.2, 1.0, 0.0, 0.0), new LayoutWeights(0.0, 0.0, 0.0, 1.0));
                break;
            }
            case NORTH_EAST: {
                this.changeStatus(enabled, Alignment.NORTH, this.topSplit, this.topSplitter, new LayoutProportions(0.2, 0.0, 0.0, 1.0), new LayoutWeights(0.0, 0.0, 1.0, 0.0));
                break;
            }
            case EAST: {
                this.changeStatus(enabled, Alignment.SOUTH_EAST, this.rightSplit, this.rightSplitter, new LayoutProportions(RIGHT_SPLIT_DEFAULT_POSITION, 1.0, 1.0, 0.0), new LayoutWeights(1.0, 1.0, 0.0, 1.0));
                break;
            }
            case SOUTH_EAST: {
                this.changeStatus(enabled, Alignment.EAST, this.rightSplit, this.rightSplitter, new LayoutProportions(RIGHT_SPLIT_DEFAULT_POSITION, 0.0, 1.0, 1.0), new LayoutWeights(1.0, 1.0, 1.0, 0.0));
                break;
            }
            case NORTH_WEST: {
                this.changeStatus(enabled, Alignment.WEST, this.leftSplit, this.leftSplitter, new LayoutProportions(0.2, 1.0, 0.0, 0.0), new LayoutWeights(0.0, 0.0, 0.0, 1.0));
                break;
            }
            case WEST: {
                this.changeStatus(enabled, Alignment.NORTH_WEST, this.leftSplit, this.leftSplitter, new LayoutProportions(0.2, 0.0, 0.0, 1.0), new LayoutWeights(0.0, 0.0, 1.0, 0.0));
                break;
            }
            case SOUTH_WEST: {
                this.changeStatus(enabled, Alignment.SOUTH, this.bottomSplit, this.bottomSplitter, new LayoutProportions(BOTTOM_SPLIT_DEFAULT_POSITION, 1.0, 1.0, 0.0), new LayoutWeights(1.0, 1.0, 0.0, 1.0));
                break;
            }
            case SOUTH: {
                this.changeStatus(enabled, Alignment.SOUTH_WEST, this.bottomSplit, this.bottomSplitter, new LayoutProportions(BOTTOM_SPLIT_DEFAULT_POSITION, 0.0, 1.0, 1.0), new LayoutWeights(1.0, 1.0, 1.0, 0.0));
                break;
            }
        }
        this.setEnabledFlag(a, enabled);
    }

    private void changeStatus(boolean enabled, Alignment peer, ToggleSplitPane split, ToggleSplitPane splitter, LayoutProportions proportions, LayoutWeights weights) {
        if (enabled) {
            this.enable(split, weights.splitEnable);
            if (!this.isEnabled(peer)) {
                this.disable(splitter, weights.splitterPeerDisable, proportions.splitterPeerDisable);
            } else {
                this.enable(splitter, 0.5);
            }
        } else {
            if (!this.isEnabled(peer)) {
                this.disable(split, weights.splitDisable, proportions.splitDisable);
            }
            this.disable(splitter, weights.splitterDisable, proportions.splitterDisable);
        }
    }

    private void setEnabledFlag(Alignment a, boolean e) {
        if (a != Alignment.CENTER) {
            this.enabled[a.getIndex()] = e;
        }
    }

    private void enable(ToggleSplitPane splitPane, double weight) {
        boolean restore = !splitPane.isResizable();
        splitPane.setEnabled(true);
        splitPane.setResizable(true);
        splitPane.setResizeWeight(weight);
        if (restore) {
            splitPane.restorePosition();
        }
    }

    @Override
    public Component getContent() {
        return this.cont;
    }

    @Override
    public void setContent(Component pane) {
        this.cont = pane;
        this.rightSplit.setLeftComponent(pane);
    }

    private void disable(ToggleSplitPane splitPane, double weight, double location) {
        if (splitPane.isResizable() && splitPane.isShowing()) {
            splitPane.savePosition();
        }
        splitPane.setResizeWeight(weight);
        splitPane.forceSetDividerLocation(location);
        splitPane.setResizable(false, location);
        splitPane.setEnabled(false);
    }

    @Override
    public boolean isEnabled(Alignment a) {
        if (a == Alignment.CENTER) {
            return false;
        }
        return this.enabled[a.getIndex()];
    }

    @Override
    public void setComponentAt(Alignment a, Component c) {
        switch (a) {
            case NORTH: {
                ((PopupContainer)this.topSplitter.getLeftComponent()).setPopup(c);
                break;
            }
            case NORTH_EAST: {
                ((PopupContainer)this.topSplitter.getRightComponent()).setPopup(c);
                break;
            }
            case EAST: {
                ((PopupContainer)this.rightSplitter.getTopComponent()).setPopup(c);
                break;
            }
            case SOUTH_EAST: {
                ((PopupContainer)this.rightSplitter.getBottomComponent()).setPopup(c);
                break;
            }
            case SOUTH: {
                ((PopupContainer)this.bottomSplitter.getRightComponent()).setPopup(c);
                break;
            }
            case SOUTH_WEST: {
                ((PopupContainer)this.bottomSplitter.getLeftComponent()).setPopup(c);
                break;
            }
            case WEST: {
                ((PopupContainer)this.leftSplitter.getBottomComponent()).setPopup(c);
                break;
            }
            case NORTH_WEST: {
                ((PopupContainer)this.leftSplitter.getTopComponent()).setPopup(c);
                break;
            }
        }
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public boolean[] getStatus() {
        return this.enabled;
    }

    @Override
    public PopupContainer getContainer(Alignment alignment) {
        PopupContainer popupComponent;
        switch (alignment) {
            case NORTH: {
                popupComponent = (PopupContainer)this.topSplitter.getLeftComponent();
                break;
            }
            case NORTH_EAST: {
                popupComponent = (PopupContainer)this.topSplitter.getRightComponent();
                break;
            }
            case EAST: {
                popupComponent = (PopupContainer)this.rightSplitter.getTopComponent();
                break;
            }
            case SOUTH_EAST: {
                popupComponent = (PopupContainer)this.rightSplitter.getBottomComponent();
                break;
            }
            case SOUTH: {
                popupComponent = (PopupContainer)this.bottomSplitter.getRightComponent();
                break;
            }
            case SOUTH_WEST: {
                popupComponent = (PopupContainer)this.bottomSplitter.getLeftComponent();
                break;
            }
            case WEST: {
                popupComponent = (PopupContainer)this.leftSplitter.getBottomComponent();
                break;
            }
            case NORTH_WEST: {
                popupComponent = (PopupContainer)this.leftSplitter.getTopComponent();
                break;
            }
            default: {
                throw new IllegalArgumentException("CENTER is not supported");
            }
        }
        return popupComponent;
    }

    public Component getPopupComponent(Alignment a) {
        return this.getContainer(a).getPopup();
    }

    protected static class TabFrameSplitPane
    extends ToggleSplitPane {
        protected TabFrameSplitPane(String name) {
            super(name);
        }
    }

    protected static class LayoutWeights {
        protected final double splitEnable;
        protected final double splitterDisable;
        protected final double splitDisable;
        protected final double splitterPeerDisable;

        public LayoutWeights(double splitEnable, double splitterDisable, double splitDisable, double splitterPeerDisable) {
            this.splitEnable = splitEnable;
            this.splitterDisable = splitterDisable;
            this.splitDisable = splitDisable;
            this.splitterPeerDisable = splitterPeerDisable;
        }
    }

    protected static class LayoutProportions {
        protected final double splitRestore;
        protected final double splitterPeerDisable;
        protected final double splitDisable;
        protected final double splitterDisable;

        public LayoutProportions(double splitRestore, double splitterPeerDisable, double splitDisable, double splitterDisable) {
            this.splitRestore = splitRestore;
            this.splitterPeerDisable = splitterPeerDisable;
            this.splitDisable = splitDisable;
            this.splitterDisable = splitterDisable;
        }
    }
}

