/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.tabframe;

import com.github.weisj.darklaf.components.tabframe.JTabFrame;
import com.github.weisj.darklaf.components.tabframe.TabFrameTab;
import com.github.weisj.darklaf.util.Actions;
import com.github.weisj.darklaf.util.Alignment;
import com.github.weisj.darklaf.util.DarkUIUtil;
import java.awt.Component;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public class TabFrameUtil {
    private static final String ACCELERATOR_PREFIX = "accelerator_";

    private TabFrameUtil() {
    }

    public static void installAccelerator(JTabFrame tabFrame, TabFrameTab tab) {
        if (tabFrame == null) {
            return;
        }
        int acc = tab.getAccelerator();
        if (acc < 0) {
            return;
        }
        tabFrame.getInputMap(1).put(KeyStroke.getKeyStroke(UIManager.getString("TabFrame.acceleratorKeyCode") + " " + acc), ACCELERATOR_PREFIX + acc);
        tabFrame.getActionMap().put(ACCELERATOR_PREFIX + acc, TabFrameUtil.createAcceleratorAction(tabFrame, tab));
    }

    public static Action createAcceleratorAction(JTabFrame tabFrame, TabFrameTab tab) {
        return Actions.create(e -> {
            Alignment a = tab.getOrientation();
            int index = tab.getIndex();
            if (!tab.isSelected()) {
                tabFrame.toggleTab(a, index, true);
            } else {
                Component popup = tabFrame.getPopupComponentAt(a, index);
                if (!DarkUIUtil.hasFocus(popup)) {
                    popup.requestFocusInWindow();
                } else {
                    tabFrame.toggleTab(a, index, false);
                }
            }
        });
    }

    public static void uninstallAccelerator(JTabFrame tabFrame, TabFrameTab tab) {
        if (tabFrame == null) {
            return;
        }
        int acc = tab.getAccelerator();
        String accAction = ACCELERATOR_PREFIX + acc;
        tabFrame.getActionMap().remove(accAction);
    }
}

