/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.toolbar;

import com.github.weisj.darklaf.listener.MouseResponder;
import com.github.weisj.darklaf.ui.toolbar.DropPreviewPanel;
import com.github.weisj.darklaf.ui.toolbar.JDragWindow;
import com.github.weisj.darklaf.util.DarkUIUtil;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeListener;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicToolBarUI;

public class DarkToolBarUI
extends BasicToolBarUI {
    protected static final String KEY_PREFIX = "JToolBar.";
    public static final String KEY_USE_TOOL_BAR_BACKGROUND = "JToolBar.drag.useToolbarBackground";
    private static final Robot robot = DarkToolBarUI.createRobot();
    private final DropPreviewPanel previewPanel = new DropPreviewPanel();
    protected Color background;
    private Dimension verticalDim = new Dimension(0, 0);
    private Dimension horizontalDim = new Dimension(0, 0);
    private final Timer timer = new Timer(5, e -> this.dragTo());
    protected Container dockingSource;
    protected RootPaneContainer floatingToolBar;
    protected DarkDragWindow dragWindow;
    protected boolean floating;
    protected Point floatingPos = new Point();

    public static ComponentUI createUI(JComponent c) {
        return new DarkToolBarUI();
    }

    private static Robot createRobot() {
        try {
            return new Robot();
        }
        catch (AWTException e) {
            return null;
        }
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.previewPanel.setToolBar(this.toolBar);
    }

    protected DarkDragWindow getDragWindow() {
        if (this.dragWindow == null) {
            this.dragWindow = this.createDarkDragWindow(this.toolBar);
        }
        return this.dragWindow;
    }

    @Override
    protected void setBorderToRollover(Component c) {
    }

    @Override
    protected void setBorderToNormal(Component c) {
    }

    @Override
    protected void setBorderToNonRollover(Component c) {
    }

    @Override
    public void setFloating(boolean b, Point p) {
        if (this.toolBar.isFloatable()) {
            this.toolBar.doLayout();
            boolean visible = false;
            final Window ancestor = SwingUtilities.getWindowAncestor(this.toolBar);
            if (ancestor != null) {
                visible = ancestor.isVisible();
            }
            if (this.dragWindow != null) {
                this.stopDrag();
            }
            this.floating = b;
            final RootPaneContainer floatingTB = this.getFloatingToolBar();
            if (this.floating) {
                this.constraintBeforeFloating = this.calculateConstraint();
                floatingTB.getContentPane().add((Component)this.toolBar, "Center");
                if (floatingTB instanceof Window) {
                    ((Window)((Object)floatingTB)).pack();
                    ((Window)((Object)floatingTB)).setLocation(this.floatingPos.x, this.floatingPos.y);
                    if (visible) {
                        ((Window)((Object)floatingTB)).setVisible(true);
                    } else if (ancestor != null) {
                        ancestor.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowOpened(WindowEvent e) {
                                ((Window)((Object)floatingTB)).setVisible(true);
                                ancestor.removeWindowListener(this);
                            }
                        });
                    }
                }
            } else {
                if (floatingTB instanceof Window) {
                    ((Window)((Object)floatingTB)).setVisible(false);
                }
                floatingTB.getContentPane().remove(this.toolBar);
                String constraint = this.getDockingConstraint(this.dockingSource, p);
                if (constraint == null) {
                    constraint = "North";
                }
                this.setOrientation(this.mapConstraintToOrientation(constraint));
                this.dockingSource.add((Component)this.toolBar, constraint);
                this.updateDockingSource(this.dockingSource);
            }
        }
    }

    protected String calculateConstraint() {
        String constraint = null;
        LayoutManager lm = this.dockingSource.getLayout();
        if (lm instanceof BorderLayout) {
            constraint = (String)((BorderLayout)lm).getConstraints(this.toolBar);
        }
        return constraint != null ? constraint : this.constraintBeforeFloating;
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.background = UIManager.getColor("ToolBar.background");
        AtomicReference margin = new AtomicReference();
        PropertyChangeListener changeListener = e -> margin.set((Insets)e.getOldValue());
        this.toolBar.addPropertyChangeListener("margin", changeListener);
        this.toolBar.setMargin(null);
        this.toolBar.removePropertyChangeListener("margin", changeListener);
        this.toolBar.setMargin((Insets)margin.get());
        if (margin.get() == null || margin.get() instanceof UIResource) {
            this.toolBar.setMargin(UIManager.getInsets("ToolBar.margins"));
        }
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        if (this.toolBar.getMargin() instanceof UIResource) {
            this.toolBar.setMargin(null);
        }
    }

    @Override
    protected BasicToolBarUI.DragWindow createDragWindow(JToolBar toolbar) {
        throw new IllegalStateException("Created incorrect drag window");
    }

    protected DarkDragWindow createDarkDragWindow(JToolBar toolbar) {
        Window frame = DarkUIUtil.getWindow(toolbar);
        if (this.floatingToolBar instanceof Window) {
            frame = (Window)((Object)this.floatingToolBar);
        }
        return new DarkDragWindow(frame, this.toolBar);
    }

    protected boolean isDockable(Component comp, Object constraint) {
        Container cont;
        LayoutManager lm;
        if (comp instanceof Container && (lm = (cont = (Container)comp).getLayout()) instanceof BorderLayout) {
            BorderLayout blm = (BorderLayout)lm;
            Component c = blm.getLayoutComponent(cont, constraint);
            return c == null || c == this.toolBar || c == this.previewPanel;
        }
        return true;
    }

    protected String getDockingConstraint(Component c, Point p) {
        if (p == null) {
            return this.constraintBeforeFloating;
        }
        if (c.contains(p)) {
            if (p.y < this.horizontalDim.height && this.isDockable(c, "North")) {
                return "North";
            }
            if (p.y >= c.getHeight() - this.horizontalDim.height && this.isDockable(c, "South")) {
                return "South";
            }
            if (p.x >= c.getWidth() - this.verticalDim.width && this.isDockable(c, "East")) {
                return "East";
            }
            if (p.x < this.verticalDim.width && this.isDockable(c, "West")) {
                return "West";
            }
        }
        return null;
    }

    @Override
    public boolean canDock(Component c, Point p) {
        String constraints = this.getDockingConstraint(c, p);
        return p != null && constraints != null;
    }

    @Override
    protected void dragTo(Point position, Point origin) {
        this.dragTo();
    }

    protected void dragTo() {
        if (this.toolBar.isFloatable()) {
            DarkDragWindow dw = this.getDragWindow();
            Point offset = dw.getOffset();
            PointerInfo pointerInfo = MouseInfo.getPointerInfo();
            if (pointerInfo == null) {
                return;
            }
            Point global = pointerInfo.getLocation();
            Point dragPoint = new Point(global.x - offset.x, global.y - offset.y);
            this.ensureDockingSource();
            Point dockingPosition = this.dockingSource.getLocationOnScreen();
            Point comparisonPoint = new Point(global.x - dockingPosition.x, global.y - dockingPosition.y);
            if (this.canDock(this.dockingSource, comparisonPoint)) {
                String constraint = this.getDockingConstraint(this.dockingSource, comparisonPoint);
                this.setOrientation(this.mapConstraintToOrientation(constraint));
                this.dockingSource.add((Component)this.previewPanel, constraint);
            } else {
                this.setOrientation(this.mapConstraintToOrientation(this.constraintBeforeFloating));
                this.dockingSource.remove(this.previewPanel);
            }
            this.updateDockingSource(this.dockingSource);
            dw.setLocation(dragPoint.x, dragPoint.y);
            if (!dw.isVisible()) {
                this.showDragWindow();
            }
        }
    }

    @Override
    public void setOrientation(int orientation) {
        this.toolBar.setOrientation(orientation);
        if (this.dragWindow != null) {
            this.dragWindow.setOrientation(orientation);
        }
    }

    protected int mapConstraintToOrientation(String constraint) {
        int orientation = this.toolBar.getOrientation();
        if (constraint != null) {
            if (constraint.equals("East") || constraint.equals("West")) {
                orientation = 1;
            } else if (constraint.equals("North") || constraint.equals("South")) {
                orientation = 0;
            }
        }
        return orientation;
    }

    private void ensureDockingSource() {
        if (this.dockingSource == null) {
            this.dockingSource = this.toolBar.getParent();
        }
    }

    protected void updateDockingSource(Component c) {
        c.invalidate();
        Container dockingSourceParent = c.getParent();
        if (dockingSourceParent != null) {
            dockingSourceParent.validate();
        }
        c.repaint();
    }

    protected void showDragWindow() {
        DarkUIUtil.getWindow(this.getFloatingToolBar().getRootPane()).setVisible(false);
        DarkDragWindow dw = this.getDragWindow();
        dw.getContentPane().add(this.toolBar);
        dw.doLayout();
        this.updateDockingSource(this.dockingSource);
        dw.setVisible(true);
        SwingUtilities.invokeLater(() -> robot.mouseRelease(1024));
        int oldOrientation = this.toolBar.getOrientation();
        this.toolBar.setOrientation(1);
        this.verticalDim = this.toolBar.getPreferredSize();
        this.toolBar.setOrientation(0);
        this.horizontalDim = this.toolBar.getPreferredSize();
        this.toolBar.setOrientation(oldOrientation);
        this.timer.start();
    }

    public RootPaneContainer getFloatingToolBar() {
        if (this.floatingToolBar == null) {
            this.floatingToolBar = this.createFloatingWindow(this.toolBar);
        }
        return this.floatingToolBar;
    }

    @Override
    protected void floatAt(Point position, Point origin) {
    }

    @Override
    public void setFloatingLocation(int x, int y) {
        this.floatingPos.setLocation(x, y);
    }

    protected void floatAt() {
        if (this.toolBar.isFloatable()) {
            try {
                DarkDragWindow dw = this.getDragWindow();
                Point offset = dw.getOffset();
                Point global = MouseInfo.getPointerInfo().getLocation();
                this.setFloatingLocation(global.x - offset.x, global.y - offset.y);
                if (this.dockingSource != null) {
                    Point dockingPosition = this.dockingSource.getLocationOnScreen();
                    Point comparisonPoint = new Point(global.x - dockingPosition.x, global.y - dockingPosition.y);
                    if (this.canDock(this.dockingSource, comparisonPoint)) {
                        this.setFloating(false, comparisonPoint);
                    } else {
                        this.setFloating(true, null);
                    }
                } else {
                    this.setFloating(true, null);
                }
                this.dockingSource.remove(this.previewPanel);
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
    }

    protected void stopDrag() {
        this.getDragWindow().setVisible(false);
        this.timer.stop();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        g.setColor(this.background);
        g.fillRect(0, 0, c.getWidth(), c.getHeight());
    }

    @Override
    protected WindowListener createFrameListener() {
        return new DarkFrameListener();
    }

    protected static class DarkFrameListener
    extends WindowAdapter {
        protected DarkFrameListener() {
        }
    }

    protected class DarkDragWindow
    extends JDragWindow {
        protected DarkDragWindow(Window w, JToolBar toolBar) {
            super(w, toolBar);
            this.setBorderColor(UIManager.getColor("ToolBar.borderColor"));
            this.setLayout(new BorderLayout());
            this.setBackground(toolBar.getBackground());
            JPanel glassPane = new JPanel();
            glassPane.setOpaque(false);
            glassPane.addMouseListener(new MouseResponder(e -> {
                e.consume();
                if (e.getID() == 502) {
                    DarkToolBarUI.this.floatAt();
                }
            }));
            this.setGlassPane(glassPane);
            glassPane.setVisible(true);
        }

        @Override
        public void setOrientation(int o) {
            Dimension size = this.toolBar.getPreferredSize();
            Insets insets = this.getInsets();
            size.width += insets.left + insets.right;
            size.height += insets.top + insets.bottom;
            this.setSize(size);
            this.doLayout();
        }

        @Override
        public Point getOffset() {
            return new Point(this.getWidth() / 2, this.getHeight() / 2);
        }
    }
}

