/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jms.sampler;

import java.io.Serializable;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.StringProperty;

public class JMSProperty
extends AbstractTestElement
implements Serializable {
    private static final long serialVersionUID = 6371090992800805753L;
    public static final String PROP_NAME = "JMSProperty.name";
    public static final String PROP_VALUE = "JMSProperty.value";
    public static final String PROP_TYPE = "JMSProperty.type";
    private static final String DFLT_TYPE = String.class.getName();

    public JMSProperty() {
    }

    public JMSProperty(String name, String value) {
        this(name, value, DFLT_TYPE);
    }

    public JMSProperty(String name, String value, String type) {
        this.setProperty((JMeterProperty)new StringProperty(PROP_NAME, name));
        this.setProperty((JMeterProperty)new StringProperty(PROP_VALUE, value));
        this.setProperty((JMeterProperty)new StringProperty(PROP_TYPE, type));
    }

    public void setName(String newName) {
        this.setProperty((JMeterProperty)new StringProperty(PROP_NAME, newName));
    }

    public String getName() {
        return this.getPropertyAsString(PROP_NAME);
    }

    public void setValue(String newValue) {
        this.setProperty((JMeterProperty)new StringProperty(PROP_VALUE, newValue));
    }

    public String getValue() {
        return this.getPropertyAsString(PROP_VALUE);
    }

    public void setType(String type) {
        this.setProperty((JMeterProperty)new StringProperty(PROP_TYPE, type));
    }

    public String getType() {
        return this.getPropertyAsString(PROP_TYPE);
    }

    public String toString() {
        return this.getName() + "," + this.getValue() + "," + this.getType();
    }

    public Object getValueAsObject() {
        String type = this.getType();
        String value = this.getValue();
        if (type.equals(Boolean.class.getName())) {
            return Boolean.valueOf(value);
        }
        if (type.equals(Byte.class.getName())) {
            return Byte.valueOf(value);
        }
        if (type.equals(Short.class.getName())) {
            return Short.valueOf(value);
        }
        if (type.equals(Integer.class.getName())) {
            return Integer.valueOf(value);
        }
        if (type.equals(Long.class.getName())) {
            return Long.valueOf(value);
        }
        if (type.equals(Float.class.getName())) {
            return Float.valueOf(value);
        }
        if (type.equals(Double.class.getName())) {
            return Double.valueOf(value);
        }
        if (type.equals(String.class.getName())) {
            return value;
        }
        return null;
    }
}

