/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.driver.net.ServerAddress;

public class BoltServerAddress
implements ServerAddress {
    public static final int DEFAULT_PORT = 7687;
    public static final BoltServerAddress LOCAL_DEFAULT = new BoltServerAddress("localhost", 7687);
    private final String host;
    private final int port;
    private final String stringValue;
    private InetAddress resolved;

    public BoltServerAddress(String address) {
        this(BoltServerAddress.uriFrom(address));
    }

    public BoltServerAddress(URI uri) {
        this(BoltServerAddress.hostFrom(uri), BoltServerAddress.portFrom(uri));
    }

    public BoltServerAddress(String host, int port) {
        this(host, null, port);
    }

    private BoltServerAddress(String host, InetAddress resolved, int port) {
        this.host = Objects.requireNonNull(host, "host");
        this.resolved = resolved;
        this.port = BoltServerAddress.requireValidPort(port);
        this.stringValue = resolved != null ? String.format("%s(%s):%d", host, resolved.getHostAddress(), port) : String.format("%s:%d", host, port);
    }

    public static BoltServerAddress from(ServerAddress address) {
        return address instanceof BoltServerAddress ? (BoltServerAddress)address : new BoltServerAddress(address.host(), address.port());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoltServerAddress that = (BoltServerAddress)o;
        return this.port == that.port && this.host.equals(that.host);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port);
    }

    public String toString() {
        return this.stringValue;
    }

    public SocketAddress toSocketAddress() {
        return this.resolved == null ? new InetSocketAddress(this.host, this.port) : new InetSocketAddress(this.resolved, this.port);
    }

    public BoltServerAddress resolve() throws UnknownHostException {
        return new BoltServerAddress(this.host, InetAddress.getByName(this.host), this.port);
    }

    public List<BoltServerAddress> resolveAll() throws UnknownHostException {
        return Stream.of(InetAddress.getAllByName(this.host)).map(address -> new BoltServerAddress(this.host, (InetAddress)address, this.port)).collect(Collectors.toList());
    }

    @Override
    public String host() {
        return this.host;
    }

    @Override
    public int port() {
        return this.port;
    }

    private static String hostFrom(URI uri) {
        String host = uri.getHost();
        if (host == null) {
            throw BoltServerAddress.invalidAddressFormat(uri);
        }
        return host;
    }

    private static int portFrom(URI uri) {
        int port = uri.getPort();
        return port == -1 ? 7687 : port;
    }

    private static URI uriFrom(String address) {
        String hostPort;
        String scheme;
        String[] schemeSplit = address.split("://");
        if (schemeSplit.length == 1) {
            scheme = "bolt://";
            hostPort = BoltServerAddress.hostPortFrom(schemeSplit[0]);
        } else if (schemeSplit.length == 2) {
            scheme = schemeSplit[0] + "://";
            hostPort = BoltServerAddress.hostPortFrom(schemeSplit[1]);
        } else {
            throw BoltServerAddress.invalidAddressFormat(address);
        }
        return URI.create(scheme + hostPort);
    }

    private static String hostPortFrom(String address) {
        boolean containsSingleColon;
        if (address.startsWith("[")) {
            return address;
        }
        boolean bl = containsSingleColon = address.indexOf(":") == address.lastIndexOf(":");
        if (containsSingleColon) {
            return address;
        }
        return "[" + address + "]";
    }

    private static RuntimeException invalidAddressFormat(URI uri) {
        return BoltServerAddress.invalidAddressFormat(uri.toString());
    }

    private static RuntimeException invalidAddressFormat(String address) {
        return new IllegalArgumentException("Invalid address format `" + address + "`");
    }

    private static int requireValidPort(int port) {
        if (port >= 0 && port <= 65535) {
            return port;
        }
        throw new IllegalArgumentException("Illegal port: " + port);
    }
}

