/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileToString
extends AbstractFunction {
    private static final Logger log = LoggerFactory.getLogger(FileToString.class);
    private static final List<String> desc = new ArrayList<String>();
    private static final String KEY = "__FileToString";
    static final String ERR_IND = "**ERR**";
    private static final int MIN_PARAM_COUNT = 1;
    private static final int MAX_PARAM_COUNT = 3;
    private static final int ENCODING = 2;
    private static final int PARAM_NAME = 3;
    private Object[] values;

    public String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        JMeterVariables vars;
        String fileName = ((CompoundVariable)this.values[0]).execute();
        String encoding = null;
        if (this.values.length >= 2 && (encoding = ((CompoundVariable)this.values[1]).execute().trim()).length() <= 0) {
            encoding = null;
        }
        String myName = "";
        if (this.values.length >= 3) {
            myName = ((CompoundVariable)this.values[2]).execute().trim();
        }
        String myValue = ERR_IND;
        try {
            File file = new File(fileName);
            if (file.exists() && file.canRead()) {
                myValue = FileUtils.readFileToString((File)new File(fileName), (String)encoding);
            } else {
                log.warn("Could not read open: {} ", (Object)fileName);
            }
        }
        catch (IOException e) {
            log.warn("Could not read file: {} {}", new Object[]{fileName, e.getMessage(), e});
        }
        if (myName.length() > 0 && (vars = this.getVariables()) != null) {
            vars.put(myName, myValue);
        }
        if (log.isDebugEnabled()) {
            log.debug("{} name: {} value: {}", new Object[]{Thread.currentThread().getName(), myName, myValue});
        }
        return myValue;
    }

    public void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        this.checkParameterCount(parameters, 1, 3);
        this.values = parameters.toArray();
    }

    public String getReferenceKey() {
        return KEY;
    }

    public List<String> getArgumentDesc() {
        return desc;
    }

    static {
        desc.add(JMeterUtils.getResString((String)"string_from_file_file_name"));
        desc.add(JMeterUtils.getResString((String)"string_from_file_encoding"));
        desc.add(JMeterUtils.getResString((String)"function_name_paropt"));
    }
}

