/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.jCharts.Chart;
import org.jCharts.chartData.interfaces.IAxisDataSeries;
import org.jCharts.chartData.interfaces.IAxisPlotDataSet;
import org.jCharts.chartData.interfaces.IData;
import org.jCharts.chartData.interfaces.IPieChartDataSet;
import org.jCharts.chartData.processors.TextProcessor;
import org.jCharts.properties.LegendProperties;
import org.jCharts.properties.PointChartProperties;
import org.jCharts.test.HTMLGenerator;
import org.jCharts.test.HTMLTestable;
import org.jCharts.types.ChartType;

public final class Legend
implements HTMLTestable,
Serializable {
    private Chart chart;
    private LegendProperties legendProperties;
    private float iconSide;
    private float widestLabelAndColumnPadding;
    private int numColumns;
    private int numRows;
    private TextProcessor textProcessor;
    private float x;
    private float y;
    private float width = 0.0f;
    private float height = 0.0f;
    private ArrayList labels;
    private ArrayList paints;
    private ArrayList shapes = new ArrayList();
    private ArrayList fillPointsFlags = new ArrayList();
    private ArrayList pointOutlinePaints = new ArrayList();

    public Legend(Chart chart) {
        this.chart = chart;
    }

    public Legend(Chart chart, LegendProperties legendProperties) {
        this.chart = chart;
        this.legendProperties = legendProperties;
    }

    public void setX(float f) {
        this.x = f;
    }

    public void setY(float f) {
        this.y = f;
    }

    public void computeLegendXY(IAxisDataSeries iAxisDataSeries, float f) {
        this.calculateDrawingValues(iAxisDataSeries);
        if (this.getLegendProperties().getPlacement() == 1 || this.getLegendProperties().getPlacement() == 2) {
            if ((float)this.getHeight() > (float)this.chart.getImageHeight() - this.chart.getChartProperties().getEdgePadding() * 2.0f) {
                this.setY(this.chart.getChartProperties().getEdgePadding());
            } else {
                this.setY(this.chart.getImageHeight() / 2 - this.getHeight() / 2);
            }
            if (this.getLegendProperties().getPlacement() == 1) {
                this.setX((float)this.chart.getImageWidth() - this.getWidth() - this.chart.getChartProperties().getEdgePadding());
            } else {
                this.setX(this.chart.getChartProperties().getEdgePadding());
            }
        } else {
            if (this.getWidth() + this.chart.getChartProperties().getEdgePadding() * 2.0f > (float)this.chart.getImageWidth()) {
                this.setX(this.chart.getChartProperties().getEdgePadding());
            } else {
                this.setX((float)(this.chart.getImageWidth() / 2) - this.getWidth() / 2.0f);
            }
            if (this.getLegendProperties().getPlacement() == 0) {
                this.setY((float)(this.chart.getImageHeight() - this.getHeight()) - this.chart.getChartProperties().getEdgePadding());
            } else {
                this.setY(this.chart.getChartProperties().getEdgePadding() + f);
            }
        }
    }

    private void processData(IAxisDataSeries iAxisDataSeries) {
        this.textProcessor = new TextProcessor();
        Iterator iterator = iAxisDataSeries.getIAxisPlotDataSetIterator();
        while (iterator.hasNext()) {
            this.processLegendLabels((IAxisPlotDataSet)iterator.next());
        }
    }

    private void processData(IPieChartDataSet iPieChartDataSet) {
        this.textProcessor = new TextProcessor();
        this.processLegendLabels(iPieChartDataSet);
    }

    private void processLegendLabels(IAxisPlotDataSet iAxisPlotDataSet) {
        int n = 0;
        while (n < iAxisPlotDataSet.getNumberOfLegendLabels()) {
            if (iAxisPlotDataSet.getLegendLabel(n) != null) {
                this.textProcessor.addLabel(iAxisPlotDataSet.getLegendLabel(n), this.legendProperties.getFont(), this.chart.getGraphics2D().getFontRenderContext());
                this.labels.add(iAxisPlotDataSet.getLegendLabel(n));
                this.paints.add(iAxisPlotDataSet.getPaint(n));
                if (iAxisPlotDataSet.getChartType().equals(ChartType.POINT)) {
                    PointChartProperties pointChartProperties = (PointChartProperties)iAxisPlotDataSet.getChartTypeProperties();
                    this.shapes.add(pointChartProperties.getShape(n));
                    this.fillPointsFlags.add(new Boolean(pointChartProperties.getFillPointsFlag(n)));
                    this.pointOutlinePaints.add(pointChartProperties.getPointOutlinePaints(n));
                }
            }
            ++n;
        }
    }

    private void processLegendLabels(IPieChartDataSet iPieChartDataSet) {
        int n = 0;
        while (n < iPieChartDataSet.getNumberOfLegendLabels()) {
            if (iPieChartDataSet.getLegendLabel(n) != null) {
                this.textProcessor.addLabel(iPieChartDataSet.getLegendLabel(n), this.legendProperties.getFont(), this.chart.getGraphics2D().getFontRenderContext());
                this.labels.add(iPieChartDataSet.getLegendLabel(n));
                this.paints.add(iPieChartDataSet.getPaint(n));
            }
            ++n;
        }
    }

    public LegendProperties getLegendProperties() {
        return this.legendProperties;
    }

    public void calculateDrawingValues(IData iData) {
        int n;
        this.labels = new ArrayList();
        this.paints = new ArrayList();
        if (iData instanceof IAxisDataSeries) {
            IAxisDataSeries iAxisDataSeries = (IAxisDataSeries)iData;
            this.processData(iAxisDataSeries);
            n = iAxisDataSeries.getTotalNumberOfDataSets();
        } else {
            IPieChartDataSet iPieChartDataSet = (IPieChartDataSet)iData;
            this.processData(iPieChartDataSet);
            n = iPieChartDataSet.getNumberOfLegendLabels();
        }
        this.iconSide = 0.5f * this.textProcessor.getTallestLabel();
        this.determineWidthAndHeight(n);
    }

    public float getWidth() {
        return this.width;
    }

    public int getHeight() {
        return (int)Math.ceil(this.height);
    }

    private void determineWidthAndHeight(int n) {
        this.height = this.width = this.legendProperties.getEdgePadding() * 2.0f;
        if (this.legendProperties.getNumColumns() == 0 || this.legendProperties.getNumColumns() >= n) {
            this.numColumns = n;
            this.width += this.textProcessor.getTotalLabelWidths();
            this.numRows = 1;
        } else {
            this.widestLabelAndColumnPadding = this.textProcessor.getWidestLabel() + (float)this.legendProperties.getColumnPadding();
            if (this.legendProperties.getNumColumns() == -1) {
                float f = this.legendProperties.getSize().width;
                float f2 = this.widestLabelAndColumnPadding + this.iconSide + (float)this.legendProperties.getIconPadding() + (float)this.legendProperties.getColumnPadding();
                this.numColumns = (int)(f / f2);
                this.numColumns = Math.min(this.numColumns, n);
            } else {
                this.numColumns = this.legendProperties.getNumColumns();
            }
            this.width += this.textProcessor.getWidestLabel() * (float)this.numColumns;
            this.numRows = (int)Math.ceil((double)n / (double)this.numColumns);
        }
        this.width += (this.iconSide + (float)this.legendProperties.getIconPadding()) * (float)this.numColumns;
        this.width += (float)(this.legendProperties.getColumnPadding() * (this.numColumns - 1));
        this.height += this.textProcessor.getTallestLabel() * (float)this.numRows;
        this.height += (float)(this.legendProperties.getRowPadding() * (this.numRows - 1));
    }

    public void render() {
        Graphics2D graphics2D = this.chart.getGraphics2D();
        Rectangle2D.Float float_ = new Rectangle2D.Float(this.x, this.y, this.width - 1.0f, this.height - 1.0f);
        if (this.legendProperties.getBackgroundPaint() != null) {
            graphics2D.setPaint(this.legendProperties.getBackgroundPaint());
            graphics2D.fill(float_);
        }
        if (this.legendProperties.getBorderStroke() != null) {
            this.legendProperties.getBorderStroke().draw(graphics2D, float_);
        }
        graphics2D.setFont(this.legendProperties.getFont());
        float_.y += this.legendProperties.getEdgePadding() + this.textProcessor.getTallestLabel() / 2.0f - this.iconSide / 2.0f;
        float_.width = this.iconSide;
        float_.height = this.iconSide;
        float f = this.x + this.legendProperties.getEdgePadding();
        float f2 = float_.y + float_.height;
        float f3 = this.textProcessor.getTallestLabel() + (float)this.legendProperties.getRowPadding();
        float f4 = this.iconSide + (float)this.legendProperties.getIconPadding();
        int n = 0;
        int n2 = 0;
        while (n2 < this.numRows) {
            int n3 = 0;
            while (n3 < this.numColumns) {
                float_.x = f;
                graphics2D.setPaint((Paint)this.paints.get(n));
                AffineTransform affineTransform = graphics2D.getTransform();
                if (this.shapes.size() > 0) {
                    graphics2D.translate(float_.x, float_.y);
                    if (((Boolean)this.fillPointsFlags.get(n)).booleanValue()) {
                        graphics2D.fill((Shape)this.shapes.get(n));
                        if (this.pointOutlinePaints.get(n) != null) {
                            graphics2D.setPaint((Paint)this.pointOutlinePaints.get(n));
                            graphics2D.draw((Shape)this.shapes.get(n));
                        }
                    } else {
                        graphics2D.draw((Shape)this.shapes.get(n));
                    }
                    graphics2D.setTransform(affineTransform);
                } else {
                    graphics2D.fill(float_);
                    if (this.legendProperties.getIconBorderStroke() != null) {
                        graphics2D.setStroke(this.legendProperties.getIconBorderStroke());
                        graphics2D.setPaint(this.legendProperties.getIconBorderPaint());
                        graphics2D.draw(float_);
                    }
                }
                graphics2D.setPaint(this.legendProperties.getFontPaint());
                graphics2D.drawString((String)this.labels.get(n), f += f4, f2);
                f = this.legendProperties.getNumColumns() == 0 || this.legendProperties.getNumColumns() >= this.labels.size() ? (f += this.textProcessor.getTextTag(n).getWidth() + (float)this.legendProperties.getColumnPadding()) : (f += this.widestLabelAndColumnPadding);
                if (++n == this.labels.size()) break;
                ++n3;
            }
            f = this.x + this.legendProperties.getEdgePadding();
            f2 += f3;
            float_.y += f3;
            ++n2;
        }
    }

    public void toHTML(HTMLGenerator hTMLGenerator) {
        hTMLGenerator.legendTableStart();
        hTMLGenerator.addTableRow("Width", Float.toString(this.width));
        hTMLGenerator.addTableRow("Height", Float.toString(this.height));
        hTMLGenerator.addTableRow("Icon Side", Float.toString(this.iconSide));
        hTMLGenerator.innerTableRowStart();
        this.legendProperties.toHTML(hTMLGenerator);
        hTMLGenerator.innerTableRowEnd();
        hTMLGenerator.legendTableEnd();
    }
}

