/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.config;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.protocol.http.util.HTTPArgument;
import org.apache.jmeter.protocol.http.util.HTTPFileArgs;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Matcher;

public class MultipartUrlConfig
implements Serializable {
    private static final long serialVersionUID = 240L;
    private static final String CRLF = "\r\n";
    private static final String CRLFCRLF = "\r\n\r\n";
    private static final String LF = "\n";
    private static final String LFLF = "\n\n";
    private final String boundary;
    private final Arguments args = new Arguments();
    private final HTTPFileArgs files = new HTTPFileArgs();

    @Deprecated
    public MultipartUrlConfig() {
        this(null);
    }

    public MultipartUrlConfig(String boundary) {
        this.boundary = boundary;
    }

    public String getBoundary() {
        return this.boundary;
    }

    public Arguments getArguments() {
        return this.args;
    }

    public void addArgument(String name, String value) {
        Arguments myArgs = this.getArguments();
        myArgs.addArgument((Argument)new HTTPArgument(name, value));
    }

    public void addArgument(String name, String value, String metadata) {
        Arguments myArgs = this.getArguments();
        myArgs.addArgument((Argument)new HTTPArgument(name, value, metadata));
    }

    public HTTPFileArgs getHTTPFileArgs() {
        return this.files;
    }

    private void addNonEncodedArgument(String name, String value, String contentType) {
        Arguments myArgs = this.getArguments();
        HTTPArgument arg = new HTTPArgument(name, value, false);
        if (!StringUtils.isEmpty((CharSequence)contentType)) {
            int indexOfSemiColon = contentType.indexOf(59);
            if (indexOfSemiColon > 0) {
                arg.setContentType(contentType.substring(0, indexOfSemiColon));
            } else {
                arg.setContentType(contentType);
            }
        }
        arg.setAlwaysEncoded(false);
        myArgs.addArgument((Argument)arg);
    }

    public void parseArguments(String queryString) {
        String[] parts;
        for (String part : parts = JOrphanUtils.split((String)queryString, (String)("--" + this.getBoundary()))) {
            String contentDisposition = MultipartUrlConfig.getHeaderValue("Content-disposition", part);
            String contentType = MultipartUrlConfig.getHeaderValue("Content-type", part);
            if (contentDisposition == null || !contentDisposition.contains("form-data")) continue;
            String namePrefix = "name=\"";
            int index = contentDisposition.indexOf("name=\"") + "name=\"".length();
            String name = contentDisposition.substring(index, contentDisposition.indexOf(34, index));
            String filenamePrefix = "filename=\"";
            if (contentDisposition.contains("filename=\"")) {
                index = contentDisposition.indexOf("filename=\"") + "filename=\"".length();
                String path = contentDisposition.substring(index, contentDisposition.indexOf(34, index));
                if (path == null || path.length() <= 0) continue;
                this.files.addHTTPFileArg(path, name, contentType);
                continue;
            }
            int indexEmptyCrLfCrLfLinePos = part.indexOf(CRLFCRLF);
            int indexEmptyLfLfLinePos = part.indexOf(LFLF);
            String value = null;
            if (indexEmptyCrLfCrLfLinePos > -1) {
                value = part.substring(indexEmptyCrLfCrLfLinePos + CRLFCRLF.length(), part.lastIndexOf(CRLF));
            } else if (indexEmptyLfLfLinePos > -1) {
                value = part.substring(indexEmptyLfLfLinePos + LFLF.length(), part.lastIndexOf(LF));
            }
            this.addNonEncodedArgument(name, value, contentType);
        }
    }

    private static String getHeaderValue(String headerName, String multiPart) {
        Pattern pattern;
        String regularExpression = headerName + "\\s*:\\s*(.*)$";
        Perl5Matcher localMatcher = JMeterUtils.getMatcher();
        if (localMatcher.contains(multiPart, pattern = JMeterUtils.getPattern((String)regularExpression, (int)32777))) {
            return localMatcher.getMatch().group(1).trim();
        }
        return null;
    }
}

