/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.control.gui;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.apache.jmeter.control.gui.LogicControllerGui;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.gui.tree.JMeterTreeModel;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.protocol.http.control.RecordingController;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TestElementMetadata(labelResource="record_controller_title")
public class RecordController
extends LogicControllerGui
implements ActionListener {
    private static final long serialVersionUID = 241L;
    private static final Logger log = LoggerFactory.getLogger(RecordController.class);
    private JButton clearButton;

    public RecordController() {
        this.init();
    }

    public String getLabelResource() {
        return "record_controller_title";
    }

    public TestElement createTestElement() {
        RecordingController con = new RecordingController();
        super.configureTestElement((TestElement)con);
        return con;
    }

    private void init() {
        JPanel panel = new JPanel();
        this.clearButton = new JButton(JMeterUtils.getResString((String)"record_controller_clear_samples"));
        this.clearButton.addActionListener(this);
        panel.add(this.clearButton);
        panel.setLayout(new BoxLayout(panel, 1));
        this.add(panel);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.clearButton) {
            GuiPackage guiPackage = GuiPackage.getInstance();
            JMeterTreeNode currentNode = guiPackage.getTreeListener().getCurrentNode();
            if (!(currentNode.getUserObject() instanceof RecordingController)) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            try {
                guiPackage.updateCurrentNode();
                JMeterTreeModel treeModel = guiPackage.getTreeModel();
                int childCount = currentNode.getChildCount();
                for (int i = 0; i < childCount; ++i) {
                    JMeterTreeNode node = (JMeterTreeNode)currentNode.getChildAt(0);
                    treeModel.removeNodeFromParent(node);
                }
            }
            catch (Exception err) {
                Toolkit.getDefaultToolkit().beep();
                log.error("Error while removing recorded samples", (Throwable)err);
            }
        }
    }
}

