/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.sampler;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import org.apache.jmeter.protocol.http.sampler.HTTPAbstractImpl;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.protocol.http.util.HTTPArgument;
import org.apache.jmeter.protocol.http.util.HTTPFileArg;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.property.JMeterProperty;

public class PostWriter {
    private static final String DASH_DASH = "--";
    private static final byte[] DASH_DASH_BYTES = new byte[]{45, 45};
    protected static final String BOUNDARY = "---------------------------7d159c1302d0y0";
    private static final byte[] CRLF = new byte[]{13, 10};
    public static final String ENCODING = StandardCharsets.ISO_8859_1.name();
    protected byte[] formDataUrlEncoded;
    protected byte[] formDataPostBody;
    private final String boundary;

    public PostWriter() {
        this(BOUNDARY);
    }

    public PostWriter(String boundary) {
        this.boundary = boundary;
    }

    public String sendPostData(URLConnection connection, HTTPSamplerBase sampler) throws IOException {
        StringBuilder postedBody = new StringBuilder(1000);
        HTTPFileArg[] files = sampler.getHTTPFiles();
        String contentEncoding = sampler.getContentEncoding();
        if (contentEncoding == null || contentEncoding.length() == 0) {
            contentEncoding = ENCODING;
        }
        if (sampler.getUseMultipart()) {
            OutputStream out = connection.getOutputStream();
            out.write(this.formDataPostBody);
            postedBody.append(new String(this.formDataPostBody, contentEncoding));
            for (int i = 0; i < files.length; ++i) {
                HTTPFileArg file = files[i];
                String headerValue = file.getHeader();
                byte[] header = headerValue.getBytes(ENCODING);
                out.write(header);
                postedBody.append(headerValue);
                PostWriter.writeFileToStream(file.getPath(), out);
                postedBody.append("<actual file content, not shown here>");
                byte[] fileMultipartEndDivider = this.getFileMultipartEndDivider();
                out.write(fileMultipartEndDivider);
                postedBody.append(new String(fileMultipartEndDivider, ENCODING));
                if (i + 1 >= files.length) continue;
                out.write(CRLF);
                postedBody.append(new String(CRLF, SampleResult.DEFAULT_HTTP_ENCODING));
            }
            byte[] multipartEndDivider = this.getMultipartEndDivider();
            out.write(multipartEndDivider);
            postedBody.append(new String(multipartEndDivider, ENCODING));
            out.flush();
            out.close();
        } else if (sampler.getArguments() != null && !sampler.hasArguments() && sampler.getSendFileAsPostBody()) {
            OutputStream out = connection.getOutputStream();
            HTTPFileArg file = files[0];
            PostWriter.writeFileToStream(file.getPath(), out);
            out.flush();
            out.close();
            postedBody.append("<actual file content, not shown here>");
        } else if (this.formDataUrlEncoded != null) {
            OutputStream out = connection.getOutputStream();
            out.write(this.formDataUrlEncoded);
            out.flush();
            out.close();
            postedBody.append(new String(this.formDataUrlEncoded, contentEncoding));
        }
        return postedBody.toString();
    }

    public void setHeaders(URLConnection connection, HTTPSamplerBase sampler) throws IOException {
        String contentEncoding = sampler.getContentEncoding();
        if (contentEncoding == null || contentEncoding.length() == 0) {
            contentEncoding = ENCODING;
        }
        long contentLength = 0L;
        HTTPFileArg[] files = sampler.getHTTPFiles();
        if (sampler.getUseMultipart()) {
            connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.getBoundary());
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            bos.write(this.getMultipartDivider());
            for (JMeterProperty jMeterProperty : sampler.getArguments()) {
                String parameterName;
                HTTPArgument arg = (HTTPArgument)jMeterProperty.getObjectValue();
                if (arg.isSkippable(parameterName = arg.getName())) continue;
                bos.write(CRLF);
                this.writeFormMultipart(bos, parameterName, arg.getValue(), contentEncoding, sampler.getDoBrowserCompatibleMultipart());
            }
            if (files.length > 0) {
                bos.write(CRLF);
            }
            bos.flush();
            this.formDataPostBody = bos.toByteArray();
            bos.close();
            contentLength = this.formDataPostBody.length;
            for (int i = 0; i < files.length; ++i) {
                HTTPFileArg file = files[i];
                bos = new ByteArrayOutputStream();
                this.writeStartFileMultipart(bos, file.getPath(), file.getParamName(), file.getMimeType());
                bos.flush();
                String header = bos.toString(contentEncoding);
                file.setHeader(header);
                bos.close();
                contentLength += (long)header.length();
                File uploadFile = new File(file.getPath());
                contentLength += uploadFile.length();
                contentLength += (long)this.getFileMultipartEndDivider().length;
                if (i + 1 >= files.length) continue;
                contentLength += (long)CRLF.length;
            }
            connection.setRequestProperty("Content-Length", Long.toString(contentLength += (long)this.getMultipartEndDivider().length));
            connection.setDoOutput(true);
            connection.setDoInput(true);
        } else {
            boolean hasContentTypeHeader;
            String contentTypeHeader = connection.getRequestProperty("Content-Type");
            boolean bl = hasContentTypeHeader = contentTypeHeader != null && contentTypeHeader.length() > 0;
            if (sampler.getArguments() != null && sampler.getArguments().getArgumentCount() == 0 && sampler.getSendFileAsPostBody()) {
                HTTPFileArg file = files[0];
                if (!hasContentTypeHeader) {
                    if (file.getMimeType() != null && file.getMimeType().length() > 0) {
                        connection.setRequestProperty("Content-Type", file.getMimeType());
                    } else if (HTTPAbstractImpl.ADD_CONTENT_TYPE_TO_POST_IF_MISSING) {
                        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                    }
                }
                File inputFile = new File(file.getPath());
                contentLength = inputFile.length();
            } else {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                String postBody = null;
                if (!sampler.getSendParameterValuesAsPostBody()) {
                    if (!hasContentTypeHeader && HTTPAbstractImpl.ADD_CONTENT_TYPE_TO_POST_IF_MISSING) {
                        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                    }
                    postBody = sampler.getQueryString(contentEncoding);
                } else {
                    if (!hasContentTypeHeader) {
                        HTTPFileArg file;
                        HTTPFileArg hTTPFileArg = file = files.length > 0 ? files[0] : null;
                        if (file != null && file.getMimeType() != null && file.getMimeType().length() > 0) {
                            connection.setRequestProperty("Content-Type", file.getMimeType());
                        } else if (HTTPAbstractImpl.ADD_CONTENT_TYPE_TO_POST_IF_MISSING) {
                            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                        }
                    }
                    StringBuilder postBodyBuffer = new StringBuilder();
                    for (JMeterProperty jMeterProperty : sampler.getArguments()) {
                        HTTPArgument arg = (HTTPArgument)jMeterProperty.getObjectValue();
                        postBodyBuffer.append(arg.getEncodedValue(contentEncoding));
                    }
                    postBody = postBodyBuffer.toString();
                }
                bos.write(postBody.getBytes(contentEncoding));
                bos.flush();
                bos.close();
                this.formDataUrlEncoded = bos.toByteArray();
                contentLength = bos.toByteArray().length;
            }
            connection.setRequestProperty("Content-Length", Long.toString(contentLength));
            connection.setDoOutput(true);
        }
    }

    protected String getBoundary() {
        return this.boundary;
    }

    private byte[] getMultipartDivider() throws IOException {
        return (DASH_DASH + this.getBoundary()).getBytes(ENCODING);
    }

    private byte[] getFileMultipartEndDivider() throws IOException {
        byte[] ending = this.getMultipartDivider();
        byte[] completeEnding = new byte[ending.length + CRLF.length];
        System.arraycopy(CRLF, 0, completeEnding, 0, CRLF.length);
        System.arraycopy(ending, 0, completeEnding, CRLF.length, ending.length);
        return completeEnding;
    }

    private byte[] getMultipartEndDivider() {
        byte[] ending = DASH_DASH_BYTES;
        byte[] completeEnding = new byte[ending.length + CRLF.length];
        System.arraycopy(ending, 0, completeEnding, 0, ending.length);
        System.arraycopy(CRLF, 0, completeEnding, ending.length, CRLF.length);
        return completeEnding;
    }

    private void writeStartFileMultipart(OutputStream out, String filename, String nameField, String mimetype) throws IOException {
        this.write(out, "Content-Disposition: form-data; name=\"");
        this.write(out, nameField);
        this.write(out, "\"; filename=\"");
        this.write(out, new File(filename).getName());
        this.writeln(out, "\"");
        this.writeln(out, "Content-Type: " + mimetype);
        this.writeln(out, "Content-Transfer-Encoding: binary");
        out.write(CRLF);
    }

    private static void writeFileToStream(String filename, OutputStream out) throws IOException {
        byte[] buf = new byte[1024];
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(filename));){
            int read;
            while ((read = ((InputStream)in).read(buf)) > 0) {
                out.write(buf, 0, read);
            }
        }
    }

    private void writeFormMultipart(OutputStream out, String name, String value, String charSet, boolean browserCompatibleMultipart) throws IOException {
        this.writeln(out, "Content-Disposition: form-data; name=\"" + name + "\"");
        if (!browserCompatibleMultipart) {
            this.writeln(out, "Content-Type: text/plain; charset=" + charSet);
            this.writeln(out, "Content-Transfer-Encoding: 8bit");
        }
        out.write(CRLF);
        out.write(value.getBytes(charSet));
        out.write(CRLF);
        out.write(this.getMultipartDivider());
    }

    private void write(OutputStream out, String value) throws UnsupportedEncodingException, IOException {
        out.write(value.getBytes(ENCODING));
    }

    private void writeln(OutputStream out, String value) throws UnsupportedEncodingException, IOException {
        out.write(value.getBytes(ENCODING));
        out.write(CRLF);
    }
}

