/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.file;

import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.file.PathHelper;
import com.helger.commons.io.stream.NonBlockingBufferedReader;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.state.ESuccess;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class SimpleFileIO {
    private static final SimpleFileIO s_aInstance = new SimpleFileIO();

    private SimpleFileIO() {
    }

    @Nullable
    public static byte[] getAllFileBytes(@Nullable File file) {
        return file == null ? null : StreamHelper.getAllBytes(FileHelper.getInputStream(file));
    }

    @Nullable
    public static byte[] getAllFileBytes(@Nullable Path path) {
        try {
            return path == null ? null : Files.readAllBytes(path);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static List<String> readAllLines(@Nonnull Path path, @Nonnull Charset charset) throws IOException {
        try (NonBlockingBufferedReader nonBlockingBufferedReader = PathHelper.getBufferedReader(path, charset);){
            Object object;
            ArrayList<String> arrayList = new ArrayList<String>();
            while ((object = nonBlockingBufferedReader.readLine()) != null) {
                arrayList.add((String)object);
            }
            object = arrayList;
            return object;
        }
    }

    @Nullable
    public static String getFileAsString(@Nullable File file, @Nonnull Charset charset) {
        return file == null ? null : StreamHelper.getAllBytesAsString(FileHelper.getInputStream(file), charset);
    }

    @Nullable
    public static ICommonsList<String> getAllFileLines(@Nullable File file, @Nonnull Charset charset) {
        return file == null ? null : StreamHelper.readStreamLines(FileHelper.getInputStream(file), charset);
    }

    public static void readFileLines(@Nullable File file, @Nonnull Charset charset, @Nonnull List<String> list) {
        if (file != null) {
            StreamHelper.readStreamLines((InputStream)FileHelper.getInputStream(file), charset, list);
        }
    }

    public static void readFileLines(@Nullable File file, @Nonnull Charset charset, @Nonnull Consumer<? super String> consumer) {
        if (file != null) {
            StreamHelper.readStreamLines((InputStream)FileHelper.getInputStream(file), charset, consumer);
        }
    }

    @Nonnull
    public static ESuccess writeFile(@Nonnull File file, @Nonnull byte[] byArray) {
        FileOutputStream fileOutputStream = FileHelper.getOutputStream(file);
        return fileOutputStream == null ? ESuccess.FAILURE : StreamHelper.writeStream(fileOutputStream, byArray);
    }

    @Nonnull
    public static ESuccess writeFile(@Nonnull File file, @Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        FileOutputStream fileOutputStream = FileHelper.getOutputStream(file);
        return fileOutputStream == null ? ESuccess.FAILURE : StreamHelper.writeStream(fileOutputStream, byArray, n, n2);
    }

    @Nonnull
    public static ESuccess writeFile(@Nonnull File file, @Nonnull String string, @Nonnull Charset charset) {
        FileOutputStream fileOutputStream = FileHelper.getOutputStream(file);
        return fileOutputStream == null ? ESuccess.FAILURE : StreamHelper.writeStream(fileOutputStream, string, charset);
    }
}

