/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.lafwidget.tabbed;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.jvnet.lafwidget.utils.FadeTracker;
import org.jvnet.lafwidget.utils.LafConstants;

public class TabPreviewControl
extends JPanel {
    protected JLabel iconLabel;
    protected JLabel titleLabel;
    protected JPanel previewImagePanel;
    protected BufferedImage previewImage;
    protected JTabbedPane tabPane;

    public TabPreviewControl(JTabbedPane tabPane, int tabIndex) {
        boolean isSelected;
        this.tabPane = tabPane;
        this.setLayout(new TabPreviewControlLayout());
        this.iconLabel = new JLabel(tabPane.getIconAt(tabIndex));
        this.titleLabel = new JLabel(tabPane.getTitleAt(tabIndex));
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(1));
        this.previewImagePanel = new JPanel(){

            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (TabPreviewControl.this.previewImage != null) {
                    int pw = TabPreviewControl.this.previewImage.getWidth();
                    int ph = TabPreviewControl.this.previewImage.getHeight();
                    int w = this.getWidth();
                    int h = this.getHeight();
                    Graphics2D g2 = (Graphics2D)g.create();
                    FadeTracker fadeTracker = FadeTracker.getInstance();
                    if (fadeTracker.isTracked(this, FadeTracker.FadeKind.ENABLE)) {
                        float fadeFactor10 = fadeTracker.getFade10(this, FadeTracker.FadeKind.ENABLE);
                        g2.setComposite(AlphaComposite.getInstance(3, fadeFactor10 / 10.0f));
                    }
                    g2.drawImage((Image)TabPreviewControl.this.previewImage, (w - pw) / 2, (h - ph) / 2, null);
                    g2.dispose();
                }
            }
        };
        this.add(this.iconLabel);
        this.add(this.titleLabel);
        this.add(this.previewImagePanel);
        boolean bl = isSelected = tabPane.getSelectedIndex() == tabIndex;
        if (isSelected) {
            this.setBorder(new LineBorder(Color.black, 2));
        } else {
            this.setBorder(new CompoundBorder(new EmptyBorder(1, 1, 1, 1), new LineBorder(Color.black, 1)));
        }
    }

    public void setTabIndex(int tabIndex) {
        boolean isSelected;
        this.iconLabel.setIcon(this.tabPane.getIconAt(tabIndex));
        this.titleLabel.setText(this.tabPane.getTitleAt(tabIndex));
        boolean bl = isSelected = this.tabPane.getSelectedIndex() == tabIndex;
        if (isSelected) {
            this.setBorder(new LineBorder(Color.black, 2));
        } else {
            this.setBorder(new CompoundBorder(new EmptyBorder(1, 1, 1, 1), new LineBorder(Color.black, 1)));
        }
    }

    public void setPreviewImage(BufferedImage previewImage) {
        this.previewImage = previewImage;
        this.previewImagePanel.putClientProperty("lafwidgets.animationKind", LafConstants.AnimationKind.SLOW);
        FadeTracker.getInstance().trackFadeIn(FadeTracker.FadeKind.ENABLE, this.previewImagePanel, false, null);
    }

    protected class TabPreviewControlLayout
    implements LayoutManager {
        protected TabPreviewControlLayout() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public void layoutContainer(Container parent) {
            int width = parent.getWidth();
            int height = parent.getHeight();
            Insets insets = TabPreviewControl.this.getInsets();
            TabPreviewControl.this.iconLabel.setBounds(insets.left + 1, insets.top + 1, 16, 16);
            TabPreviewControl.this.titleLabel.setBounds(insets.left + 18, insets.top + 1, width - 18 - insets.left - insets.right, 16);
            TabPreviewControl.this.previewImagePanel.setBounds(insets.left + 1, insets.top + 17, width - insets.left - insets.right - 2, height - 17 - insets.top - insets.bottom);
        }

        public Dimension minimumLayoutSize(Container parent) {
            return parent.getSize();
        }

        public Dimension preferredLayoutSize(Container parent) {
            return this.minimumLayoutSize(parent);
        }
    }
}

