/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.lafwidget.utils.FadeStateListener;
import org.jvnet.lafwidget.utils.FadeTracker;
import org.jvnet.substance.SubstanceButtonBorder;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.button.BaseButtonShaper;
import org.jvnet.substance.button.SubstanceButtonShaper;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.combo.SubstanceComboBoxButton;
import org.jvnet.substance.utils.ButtonBackgroundDelegate;
import org.jvnet.substance.utils.ButtonColorDelegate;
import org.jvnet.substance.utils.PulseTracker;
import org.jvnet.substance.utils.RolloverButtonListener;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceConstants;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class SubstanceButtonUI
extends BasicButtonUI {
    protected Set lafWidgets;
    public static final String BORDER_COMPUTED = "substancelaf.buttonbordercomputed";
    public static final String BORDER_COMPUTING = "substancelaf.buttonbordercomputing";
    public static final String BORDER_ORIGINAL = "substancelaf.buttonborderoriginal";
    public static final String OPACITY_ORIGINAL = "substancelaf.buttonopacityoriginal";
    public static final int DEFAULT_WIDTH = 70;
    public static final int DEFAULT_HEIGHT = 20;
    private ButtonBackgroundDelegate delegate = new ButtonBackgroundDelegate();
    private RolloverButtonListener substanceButtonListener;
    protected PropertyChangeListener substancePropertyListener;
    protected FadeStateListener substanceFadeStateListener;

    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        Object object = jComponent.getClientProperty("lafwidgets.layout.alpha");
        if (object instanceof Float) {
            graphics2D.setComposite(AlphaComposite.getInstance(3, ((Float)object).floatValue()));
        }
        this.__org__jvnet__substance__SubstanceButtonUI__update(graphics2D, jComponent);
        graphics2D.setComposite(composite);
    }

    public void __org__jvnet__substance__SubstanceButtonUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__jvnet__substance__SubstanceButtonUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    public void __org__jvnet__substance__SubstanceButtonUI__uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        this.__org__jvnet__substance__SubstanceButtonUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    public void installListeners(AbstractButton abstractButton) {
        this.__org__jvnet__substance__SubstanceButtonUI__installListeners(abstractButton);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    public void installDefaults(AbstractButton abstractButton) {
        this.__org__jvnet__substance__SubstanceButtonUI__installDefaults(abstractButton);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    public void uninstallListeners(AbstractButton abstractButton) {
        this.__org__jvnet__substance__SubstanceButtonUI__uninstallListeners(abstractButton);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    public void uninstallDefaults(AbstractButton abstractButton) {
        this.__org__jvnet__substance__SubstanceButtonUI__uninstallDefaults(abstractButton);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    public static ComponentUI createUI(JComponent b) {
        AbstractButton button = (AbstractButton)b;
        button.setRolloverEnabled(true);
        button.setOpaque(false);
        return new SubstanceButtonUI();
    }

    public void __org__jvnet__substance__SubstanceButtonUI__installDefaults(AbstractButton b) {
        Color fg;
        Color bg;
        super.installDefaults(b);
        if (b.getClientProperty(BORDER_ORIGINAL) == null) {
            b.putClientProperty(BORDER_ORIGINAL, b.getBorder());
        }
        SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(b);
        if (b.getClientProperty(BORDER_COMPUTED) == null) {
            b.setBorder(shaper.getButtonBorder(b));
        } else {
            Border currBorder = b.getBorder();
            if (!(currBorder instanceof SubstanceButtonBorder)) {
                b.setBorder(shaper.getButtonBorder(b));
            } else {
                SubstanceButtonBorder sbCurrBorder = (SubstanceButtonBorder)currBorder;
                if (shaper.getClass() != sbCurrBorder.getButtonShaperClass()) {
                    b.setBorder(shaper.getButtonBorder(b));
                }
            }
        }
        b.putClientProperty(OPACITY_ORIGINAL, b.isOpaque());
        if (b instanceof SubstanceComboBoxButton) {
            b.setBorder(new BorderUIResource.CompoundBorderUIResource(new EmptyBorder(1, 1, 1, 1), b.getBorder()));
        }
        if ((bg = b.getBackground()) instanceof UIResource) {
            b.setBackground(new ButtonColorDelegate(b, false));
        }
        if ((fg = b.getForeground()) instanceof UIResource) {
            b.setForeground(new ButtonColorDelegate(b, true));
        }
    }

    public void __org__jvnet__substance__SubstanceButtonUI__uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        b.setBorder((Border)b.getClientProperty(BORDER_ORIGINAL));
        b.setOpaque((Boolean)b.getClientProperty(OPACITY_ORIGINAL));
        b.putClientProperty(OPACITY_ORIGINAL, null);
    }

    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return null;
    }

    protected void __org__jvnet__substance__SubstanceButtonUI__installListeners(final AbstractButton b) {
        super.installListeners(b);
        this.substanceButtonListener = new RolloverButtonListener(b);
        b.addMouseListener(this.substanceButtonListener);
        b.addMouseMotionListener(this.substanceButtonListener);
        b.addFocusListener(this.substanceButtonListener);
        b.addPropertyChangeListener(this.substanceButtonListener);
        b.addChangeListener(this.substanceButtonListener);
        this.substancePropertyListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("substancelaf.buttonShaper".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            SwingUtilities.updateComponentTreeUI(b);
                        }
                    });
                }
                if ("model".equals(evt.getPropertyName())) {
                    if (SubstanceButtonUI.this.substanceFadeStateListener != null) {
                        SubstanceButtonUI.this.substanceFadeStateListener.unregisterListeners();
                    }
                    SubstanceButtonUI.this.substanceFadeStateListener = new FadeStateListener(b, b.getModel(), null);
                    SubstanceButtonUI.this.substanceFadeStateListener.registerListeners();
                }
            }
        };
        b.addPropertyChangeListener(this.substancePropertyListener);
        this.substanceFadeStateListener = new FadeStateListener(b, b.getModel(), null);
        this.substanceFadeStateListener.registerListeners();
    }

    protected void __org__jvnet__substance__SubstanceButtonUI__uninstallListeners(AbstractButton b) {
        b.removeMouseListener(this.substanceButtonListener);
        b.removeMouseMotionListener(this.substanceButtonListener);
        b.removeFocusListener(this.substanceButtonListener);
        b.removePropertyChangeListener(this.substanceButtonListener);
        b.removeChangeListener(this.substanceButtonListener);
        this.substanceButtonListener = null;
        b.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        this.substanceFadeStateListener.unregisterListeners();
        this.substanceFadeStateListener = null;
        super.uninstallListeners(b);
    }

    public void __org__jvnet__substance__SubstanceButtonUI__update(Graphics g, JComponent c) {
        JButton jb;
        AbstractButton button = (AbstractButton)c;
        if (button instanceof JButton && PulseTracker.isPulsating(jb = (JButton)button)) {
            PulseTracker.update(jb);
        }
        this.delegate.updateBackground(g, button);
        this.paint(g, c);
        AbstractButton b = (AbstractButton)c;
        FontMetrics fm = c.getFontMetrics(c.getFont());
        Insets i = c.getInsets();
        Rectangle viewRect = new Rectangle();
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        viewRect.x = i.left;
        viewRect.y = i.top;
        viewRect.width = b.getWidth() - (i.right + viewRect.x);
        viewRect.height = b.getHeight() - (i.bottom + viewRect.y);
        textRect.height = 0;
        textRect.width = 0;
        textRect.y = 0;
        textRect.x = 0;
        iconRect.height = 0;
        iconRect.width = 0;
        iconRect.y = 0;
        iconRect.x = 0;
        Font f = c.getFont();
        g.setFont(f);
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : b.getIconTextGap());
        if (!(b.hasFocus() && b.isFocusPainted() || !FadeTracker.getInstance().isTracked(c, FadeTracker.FadeKind.FOCUS))) {
            this.paintFocus(g, b, viewRect, textRect, iconRect);
        }
    }

    public Dimension getPreferredSize(JComponent c) {
        AbstractButton button = (AbstractButton)c;
        SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(button);
        return shaper.getPreferredSize(button, super.getPreferredSize(button));
    }

    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        FadeTracker fadeTracker = FadeTracker.getInstance();
        SubstanceConstants.FocusKind focusKind = SubstanceCoreUtilities.getFocusKind(b);
        if (focusKind == SubstanceConstants.FocusKind.NONE && !fadeTracker.isTracked(b, FadeTracker.FadeKind.FOCUS)) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float alpha = 1.0f;
        if (fadeTracker.isTracked(b, FadeTracker.FadeKind.FOCUS)) {
            alpha = fadeTracker.getFade10(b, FadeTracker.FadeKind.FOCUS) / 10.0f;
        }
        graphics.setComposite(TransitionLayout.getAlphaComposite(b, alpha));
        ColorScheme currScheme = SubstanceCoreUtilities.getActiveScheme(b);
        if (currScheme == null) {
            return;
        }
        GeneralPath contour = null;
        if (focusKind == SubstanceConstants.FocusKind.TEXT) {
            graphics.setStroke(new BasicStroke(1.3f, 0, 1, 0.0f, new float[]{2.0f, 1.0f}, 0.0f));
            contour = BaseButtonShaper.getBaseOutline(textRect.width + 2, textRect.height, 2.0f, null);
            Color color = SubstanceCoreUtilities.isThemeDark(SubstanceCoreUtilities.getActiveTheme(b, true)) ? SubstanceColorUtilities.getInterpolatedColor(currScheme.getUltraLightColor(), currScheme.getForegroundColor(), 0.4) : currScheme.getDarkColor();
            graphics.setColor(color);
            graphics.translate(textRect.x - 1, textRect.y);
            graphics.draw(contour);
            graphics.dispose();
            return;
        }
        if (focusKind == SubstanceConstants.FocusKind.UNDERLINE) {
            graphics.setStroke(new BasicStroke(1.3f, 0, 1, 0.0f, new float[]{2.0f, 1.0f}, 0.0f));
            Color color = SubstanceCoreUtilities.isThemeDark(SubstanceCoreUtilities.getActiveTheme(b, true)) ? SubstanceColorUtilities.getInterpolatedColor(currScheme.getUltraLightColor(), currScheme.getForegroundColor(), 0.4) : currScheme.getDarkColor();
            graphics.setColor(color);
            graphics.translate(textRect.x - 1, textRect.y);
            graphics.drawLine(0, textRect.height - 1, textRect.width, textRect.height - 1);
            graphics.dispose();
            return;
        }
        if (focusKind == SubstanceConstants.FocusKind.STRONG_UNDERLINE) {
            Color color = SubstanceCoreUtilities.isThemeDark(SubstanceCoreUtilities.getActiveTheme(b, true)) ? SubstanceColorUtilities.getInterpolatedColor(currScheme.getUltraLightColor(), currScheme.getForegroundColor(), 0.4) : currScheme.getDarkColor();
            graphics.setColor(color);
            graphics.translate(textRect.x - 1, textRect.y);
            graphics.drawLine(0, textRect.height - 1, textRect.width, textRect.height - 1);
            graphics.dispose();
            return;
        }
        SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(b);
        if (shaper == null) {
            return;
        }
        Shape currClip = graphics.getClip();
        if (focusKind == SubstanceConstants.FocusKind.ALL || !shaper.isProportionate()) {
            Color neg;
            graphics.setStroke(new BasicStroke(1.1f, 0, 1, 0.0f, new float[]{2.0f, 1.0f}, 0.0f));
            contour = shaper.getButtonOutline(b, null);
            int height = b.getHeight();
            int width = b.getWidth();
            Color topBorderColor = neg = SubstanceCoreUtilities.isThemeDark(SubstanceLookAndFeel.getTheme()) ? Color.white : Color.black;
            Color topBorderColor2 = currScheme.getUltraLightColor();
            Color midBorderColor = currScheme.getDarkColor();
            Color bottomBorderColor = currScheme.getUltraDarkColor();
            GradientPaint gradientBorderTop = new GradientPaint(0.0f, 0.0f, topBorderColor, 0.0f, height / 2, midBorderColor);
            graphics.setPaint(gradientBorderTop);
            graphics.clipRect(0, 0, width, height / 2);
            graphics.draw(contour);
            graphics.setStroke(new BasicStroke(1.2f, 0, 1, 0.0f, new float[]{1.0f, 2.0f}, 1.0f));
            GradientPaint gradientBorderTop2 = new GradientPaint(0.0f, 0.0f, topBorderColor2, 0.0f, height / 2, midBorderColor);
            graphics.setPaint(gradientBorderTop2);
            graphics.draw(contour);
            graphics.setClip(currClip);
            GradientPaint gradientBorderBottom = new GradientPaint(0.0f, height / 2, midBorderColor, 0.0f, height - 2, bottomBorderColor);
            graphics.setPaint(gradientBorderBottom);
            graphics.clipRect(0, height / 2, width, height - height / 2);
            graphics.draw(contour);
            graphics.dispose();
            return;
        }
        if (focusKind == SubstanceConstants.FocusKind.ALL_INNER) {
            graphics.setStroke(new BasicStroke(1.1f, 0, 1, 0.0f, new float[]{2.0f, 1.0f}, 0.0f));
            Insets insets = focusKind == SubstanceConstants.FocusKind.ALL ? null : new Insets(2, 2, 2, 2);
            contour = shaper.getButtonOutline(b, insets);
            int height = b.getHeight();
            int width = b.getWidth();
            Color topBorderColor = SubstanceCoreUtilities.isThemeDark(SubstanceLookAndFeel.getTheme()) ? Color.white : Color.black;
            Color midBorderColor = currScheme.getDarkColor();
            Color bottomBorderColor = currScheme.getUltraDarkColor();
            GradientPaint gradientBorderTop = new GradientPaint(0.0f, 0.0f, topBorderColor, 0.0f, height / 2, midBorderColor);
            graphics.setPaint(gradientBorderTop);
            graphics.clipRect(0, 0, width, height / 2);
            graphics.draw(contour);
            graphics.setClip(currClip);
            GradientPaint gradientBorderBottom = new GradientPaint(0.0f, height / 2, midBorderColor, 0.0f, height - 2, bottomBorderColor);
            graphics.setPaint(gradientBorderBottom);
            graphics.clipRect(0, height / 2, width, height - height / 2);
            graphics.draw(contour);
            graphics.dispose();
            return;
        }
    }

    protected void paintButtonPressed(Graphics g, AbstractButton b) {
    }

    public boolean contains(JComponent c, int x, int y) {
        return ButtonBackgroundDelegate.contains((JButton)c, x, y);
    }
}

