/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollPaneUI;
import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.layout.TransitionBorder;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.substance.SubstanceFillBackgroundDelegate;
import org.jvnet.substance.SubstanceScrollBarUI;
import org.jvnet.substance.SubstanceScrollPaneBorder;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class SubstanceScrollPaneUI
extends BasicScrollPaneUI {
    protected Set lafWidgets;
    protected PropertyChangeListener substancePropertyChangeListener;
    protected static SubstanceFillBackgroundDelegate bgDelegate = new SubstanceFillBackgroundDelegate();

    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        Object object = jComponent.getClientProperty("lafwidgets.layout.alpha");
        if (object instanceof Float) {
            graphics2D.setComposite(AlphaComposite.getInstance(3, ((Float)object).floatValue()));
        }
        this.__org__jvnet__substance__SubstanceScrollPaneUI__update(graphics2D, jComponent);
        graphics2D.setComposite(composite);
    }

    public void __org__jvnet__substance__SubstanceScrollPaneUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__jvnet__substance__SubstanceScrollPaneUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    public void __org__jvnet__substance__SubstanceScrollPaneUI__uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        this.__org__jvnet__substance__SubstanceScrollPaneUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    public void installListeners(JScrollPane jScrollPane) {
        this.__org__jvnet__substance__SubstanceScrollPaneUI__installListeners(jScrollPane);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    public void installDefaults(JScrollPane jScrollPane) {
        this.__org__jvnet__substance__SubstanceScrollPaneUI__installDefaults(jScrollPane);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    public void uninstallListeners(JComponent jComponent) {
        this.__org__jvnet__substance__SubstanceScrollPaneUI__uninstallListeners(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    public void __org__jvnet__substance__SubstanceScrollPaneUI__uninstallDefaults(JScrollPane jScrollPane) {
        super.uninstallDefaults(jScrollPane);
    }

    public void uninstallDefaults(JScrollPane jScrollPane) {
        this.__org__jvnet__substance__SubstanceScrollPaneUI__uninstallDefaults(jScrollPane);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    public static ComponentUI createUI(JComponent c) {
        return new SubstanceScrollPaneUI();
    }

    protected void __org__jvnet__substance__SubstanceScrollPaneUI__installDefaults(JScrollPane scrollpane) {
        super.installDefaults(scrollpane);
        if (SubstanceCoreUtilities.toBleedWatermark(this.scrollpane)) {
            this.scrollpane.setOpaque(false);
            this.scrollpane.getViewport().setOpaque(false);
        }
        scrollpane.setLayout(new AdjustedLayout());
    }

    protected void __org__jvnet__substance__SubstanceScrollPaneUI__installListeners(final JScrollPane c) {
        super.installListeners(c);
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("substancelaf.scrollPaneButtonsPolicy".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            c.getHorizontalScrollBar().doLayout();
                            c.getVerticalScrollBar().doLayout();
                        }
                    });
                }
                if ("substancelaf.watermark.tobleed".equals(evt.getPropertyName())) {
                    boolean toBleed = SubstanceCoreUtilities.toBleedWatermark(c);
                    c.setOpaque(!toBleed);
                    c.getViewport().setOpaque(!toBleed);
                    Component view = c.getViewport().getView();
                    if (view instanceof JComponent) {
                        ((JComponent)view).setOpaque(!toBleed);
                    }
                }
            }
        };
        c.addPropertyChangeListener(this.substancePropertyChangeListener);
    }

    protected void __org__jvnet__substance__SubstanceScrollPaneUI__uninstallListeners(JComponent c) {
        c.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        super.uninstallListeners(c);
    }

    protected MouseWheelListener createMouseWheelListener() {
        return new MouseWheelHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void __org__jvnet__substance__SubstanceScrollPaneUI__update(Graphics g, JComponent c) {
        JComponent jComponent = c;
        synchronized (jComponent) {
            if (TransitionLayout.isOpaque(c)) {
                bgDelegate.update(g, c);
                super.paint(g, c);
            } else {
                super.paint(g, c);
            }
        }
    }

    protected static class AdjustedLayout
    extends ScrollPaneLayout.UIResource {
        protected AdjustedLayout() {
        }

        public void layoutContainer(Container parent) {
            super.layoutContainer(parent);
            JScrollPane scrollPane = (JScrollPane)parent;
            Border border = scrollPane.getBorder();
            boolean toAdjust = border instanceof SubstanceScrollPaneBorder;
            if (border instanceof TransitionBorder) {
                toAdjust = ((TransitionBorder)border).getDelegate() instanceof SubstanceScrollPaneBorder;
            }
            if (toAdjust) {
                Rectangle hBounds;
                Rectangle vBounds;
                JScrollBar vertical = scrollPane.getVerticalScrollBar();
                JScrollBar horizontal = scrollPane.getHorizontalScrollBar();
                int dx = 0;
                int dy = 0;
                int dw = 0;
                int dh = 0;
                if (scrollPane.getComponentOrientation().isLeftToRight()) {
                    if (vertical.isVisible()) {
                        vBounds = vertical.getBounds();
                        ++dw;
                        vertical.setBounds(vBounds.x + 1, vBounds.y - 1, vBounds.width, vBounds.height + 2);
                    }
                    if (horizontal.isVisible()) {
                        ++dh;
                        hBounds = horizontal.getBounds();
                        horizontal.setBounds(hBounds.x - 1, hBounds.y + 1, hBounds.width + 2, hBounds.height);
                    }
                } else {
                    if (vertical.isVisible()) {
                        --dx;
                        ++dw;
                        vBounds = vertical.getBounds();
                        vertical.setBounds(vBounds.x - 1, vBounds.y - 1, vBounds.width, vBounds.height + 2);
                    }
                    if (horizontal.isVisible()) {
                        ++dh;
                        hBounds = horizontal.getBounds();
                        horizontal.setBounds(hBounds.x - 1, hBounds.y + 1, hBounds.width + 2, hBounds.height);
                    }
                }
                Rectangle vpBounds = this.viewport.getBounds();
                this.viewport.setBounds(new Rectangle(vpBounds.x + dx, vpBounds.y + dy, vpBounds.width + dw, vpBounds.height + dh));
            }
        }
    }

    protected class MouseWheelHandler
    implements MouseWheelListener {
        protected MouseWheelHandler() {
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
            if (SubstanceScrollPaneUI.this.scrollpane.isWheelScrollingEnabled() && e.getScrollAmount() != 0) {
                JScrollBar toScroll = SubstanceScrollPaneUI.this.scrollpane.getVerticalScrollBar();
                int direction = 0;
                if (!(toScroll != null && toScroll.isVisible() && e.getModifiers() != 8 || (toScroll = SubstanceScrollPaneUI.this.scrollpane.getHorizontalScrollBar()) != null && toScroll.isVisible())) {
                    return;
                }
                direction = e.getWheelRotation() < 0 ? -1 : 1;
                SubstanceScrollBarUI ui = (SubstanceScrollBarUI)toScroll.getUI();
                if (e.getScrollType() == 0) {
                    ui.scrollByUnits(direction, 2 * e.getScrollAmount());
                } else if (e.getScrollType() == 1) {
                    ui.scrollByBlock(direction);
                }
            }
        }
    }
}

