/*
 * Decompiled with CFR 0.152.
 */
package avr8_burn_o_mat;

import avr8_burn_o_mat.AVR;
import avr8_burn_o_mat.AvrdudeConfigFile;
import avr8_burn_o_mat.AvrdudeProgrammer;
import avr8_burn_o_mat.Fuse;
import avr8_burn_o_mat.InterfaceTextOutput;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvrdudeControl {
    private String m_avrdude;
    private String m_avrdudeConfig;
    private String m_port = "/dev/parport0";
    private Boolean m_disableAutoErase = false;
    private Boolean m_exitSpecActivated = false;
    private Boolean m_leftResetActivated = false;
    private Boolean m_leftVccActivated = false;
    private Boolean m_disableFuseCheck = false;
    private InterfaceTextOutput m_intfTextOutput;
    private AvrdudeProgrammer m_programmer = new AvrdudeProgrammer("stk200", "par", "STK200");
    private AvrdudeConfigFile m_avrdudeConfigFile = new AvrdudeConfigFile();
    private String m_additionalOptions = "";
    private Map<String, File> m_tempFile;

    public AvrdudeControl(InterfaceTextOutput intfTextOutput) throws IOException {
        this.m_intfTextOutput = intfTextOutput;
        this.m_tempFile = new HashMap<String, File>();
        for (String fuse : Fuse.FUSE_BYTES) {
            File file = File.createTempFile(fuse, ".hex");
            file.deleteOnExit();
            this.m_tempFile.put(fuse, file);
        }
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("windows")) {
            this.m_avrdude = "C:\\WinAVR\\bin\\avrdude.exe";
            this.m_avrdudeConfig = "C:\\WinAVR\\bin\\avrdude.conf";
        } else {
            this.m_avrdude = "/usr/local/bin/avrdude";
            this.m_avrdudeConfig = "/usr/local/etc/avrdude.conf";
        }
        this.loadPreferences();
    }

    private String getTempFileFuse(String fuse) throws Exception {
        File file = this.m_tempFile.get(fuse);
        if (file != null) {
            return file.getPath();
        }
        throw new Exception("internal error: no temp file for fuse " + fuse);
    }

    public Vector<AvrdudeProgrammer> getProgrammerList() {
        return this.m_avrdudeConfigFile.getProgrammerList();
    }

    public void savePreferences() {
        try {
            Preferences prefs = Preferences.userNodeForPackage(this.getClass());
            prefs.put("Avrdude", this.m_avrdude);
            prefs.put("AvrdudeConfig", this.m_avrdudeConfig);
            prefs.put("Programmer", this.m_programmer.getId());
            prefs.put("Port", this.m_port);
            prefs.put("AdditionalOptions", this.m_additionalOptions);
            prefs.putBoolean("DisableAutoErase", this.m_disableAutoErase);
            prefs.putBoolean("ExitSpecActivated", this.m_exitSpecActivated);
            prefs.putBoolean("LeftResetActivated", this.m_leftResetActivated);
            prefs.putBoolean("LeftVccActivated", this.m_leftVccActivated);
            prefs.putBoolean("DisableFuseCheck", this.m_disableFuseCheck);
            prefs.flush();
        }
        catch (Exception e) {
            System.err.println("Error while saving preferences: " + e.getMessage());
        }
    }

    public void loadPreferences() {
        try {
            Preferences prefs = Preferences.userNodeForPackage(this.getClass());
            this.m_avrdude = prefs.get("Avrdude", this.m_avrdude);
            this.m_avrdudeConfig = prefs.get("AvrdudeConfig", this.m_avrdudeConfig);
            this.m_port = prefs.get("Port", "/dev/parport0");
            this.m_additionalOptions = prefs.get("AdditionalOptions", "");
            this.m_disableAutoErase = prefs.getBoolean("DisableAutoErase", false);
            this.m_exitSpecActivated = prefs.getBoolean("ExitSpecActivated", false);
            this.m_leftResetActivated = prefs.getBoolean("LeftResetActivated", false);
            this.m_leftVccActivated = prefs.getBoolean("LeftVccActivated", false);
            this.m_disableFuseCheck = prefs.getBoolean("DisableFuseCheck", false);
            String programmer = prefs.get("Programmer", "");
            this.m_avrdudeConfigFile.readAvrdudeConfigFile(this.m_avrdudeConfig);
            Vector<AvrdudeProgrammer> progList = this.m_avrdudeConfigFile.getProgrammerList();
            for (AvrdudeProgrammer p : progList) {
                if (!p.equals(programmer)) continue;
                this.m_programmer = p;
            }
        }
        catch (Exception e) {
            System.err.println("Error while loading preferences: " + e.getMessage());
        }
    }

    public String getAvrdude() {
        return this.m_avrdude;
    }

    public void setAvrdude(String avrdude) {
        this.m_avrdude = avrdude;
    }

    public AvrdudeProgrammer getProgrammer() {
        return this.m_programmer;
    }

    public void setProgrammer(AvrdudeProgrammer programmer) {
        this.m_programmer = programmer;
    }

    public String getPort() {
        return this.m_port;
    }

    public void setPort(String port) {
        this.m_port = port;
    }

    public String getAdditionalOptions() {
        return this.m_additionalOptions;
    }

    public void setAdditionalOptions(String additionalOptions) {
        this.m_additionalOptions = additionalOptions;
    }

    public String getAvrdudeConfig() {
        return this.m_avrdudeConfig;
    }

    public void setAvrdudeConfig(String avrdudeConfig) {
        this.m_avrdudeConfig = avrdudeConfig;
    }

    private void addAdditionalOptions(Vector<String> cmd) {
        String[] options;
        for (String o : options = this.m_additionalOptions.split(" ")) {
            cmd.add(o);
        }
    }

    private Vector<String> getCmd(AVR avr) {
        Vector<String> cmd = new Vector<String>();
        cmd.add(this.m_avrdude);
        if (this.m_disableFuseCheck.booleanValue()) {
            cmd.add("-u");
        }
        if (this.m_avrdudeConfig.length() > 0) {
            cmd.add("-C");
            cmd.add(this.m_avrdudeConfig);
        }
        cmd.add("-p");
        cmd.add(avr.getName());
        cmd.add("-P");
        cmd.add(this.m_port);
        cmd.add("-c");
        cmd.add(this.m_programmer.getId());
        if (this.m_disableAutoErase.booleanValue()) {
            cmd.add("-D");
        }
        if (this.m_exitSpecActivated.booleanValue()) {
            String exitSpec = this.m_leftResetActivated != false ? "reset" : "noreset";
            exitSpec = this.m_leftVccActivated != false ? exitSpec + ",vcc" : exitSpec + ",novcc";
            cmd.add("-E");
            cmd.add(exitSpec);
        }
        this.addAdditionalOptions(cmd);
        return cmd;
    }

    public void readFuses(AVR avr) throws Exception {
        Vector<String> cmd = this.getCmd(avr);
        Vector<String> fuseBytes = avr.getUsedFuseBytes();
        for (String fuseByte : fuseBytes) {
            String fuseTempFile = this.getTempFileFuse(fuseByte);
            cmd.add("-U");
            cmd.add(String.format("%s:r:%s:r", fuseByte, fuseTempFile));
        }
        int exitValue = this.startAvrdudeFusesReadWrite(cmd);
        if (exitValue != 0) {
            throw new Exception("Error reading fuses!");
        }
        for (String fuseByte : fuseBytes) {
            FileInputStream fs = new FileInputStream(this.getTempFileFuse(fuseByte));
            int data = fs.read();
            avr.setFuseByteData(fuseByte, data);
            fs.close();
        }
    }

    public void writeFuses(AVR avr) throws Exception {
        Vector<String> fuseBytes = avr.getUsedFuseBytes();
        Vector<String> cmd = this.getCmd(avr);
        if (!this.m_disableFuseCheck.booleanValue()) {
            cmd.add("-u");
        }
        for (String fuseByte : fuseBytes) {
            int data = avr.getFuseByteData(fuseByte);
            cmd.add("-U");
            cmd.add(String.format("%s:w:0x%02X:m", fuseByte, data));
        }
        int exitValue = this.startAvrdudeFusesReadWrite(cmd);
        if (exitValue != 0) {
            throw new Exception("Error writing fuses!");
        }
    }

    public void verifyFuses(AVR avr) throws Exception {
        Vector<String> fuseBytes = avr.getUsedFuseBytes();
        Vector<String> cmd = this.getCmd(avr);
        for (String fuseByte : fuseBytes) {
            int data = avr.getFuseByteData(fuseByte);
            cmd.add("-U");
            cmd.add(String.format("%s:v:0x%02X:m", fuseByte, data));
        }
        int exitValue = this.startAvrdudeFusesReadWrite(cmd);
        if (exitValue != 0) {
            throw new Exception("Error verifying fuses!");
        }
    }

    public void readFlash(AVR avr, String filename, FileFormat fileFormat) throws Exception {
        Vector<String> cmd = this.getCmd(avr);
        cmd.add("-U");
        cmd.add(String.format("flash:r:%s:%s", filename, this.FileFormat2AvrdudeOption(fileFormat)));
        int exitValue = this.startAvrdudeFlashReadWrite(cmd);
        if (exitValue != 0) {
            throw new Exception("Error reading flash!");
        }
    }

    public void writeFlash(AVR avr, String filename, FileFormat fileFormat) throws Exception {
        Vector<String> cmd = this.getCmd(avr);
        cmd.add("-U");
        cmd.add(String.format("flash:w:%s:%s", filename, this.FileFormat2AvrdudeOption(fileFormat)));
        int exitValue = this.startAvrdudeFlashReadWrite(cmd);
        if (exitValue != 0) {
            throw new Exception("Error writing flash!");
        }
    }

    public void verifyFlash(AVR avr, String filename, FileFormat fileFormat) throws Exception {
        Vector<String> cmd = this.getCmd(avr);
        cmd.add("-U");
        cmd.add(String.format("flash:v:%s:%s", filename, this.FileFormat2AvrdudeOption(fileFormat)));
        int exitValue = this.startAvrdudeFlashReadWrite(cmd);
        if (exitValue != 0) {
            throw new Exception("Error verifying flash!");
        }
    }

    public void readEEPROM(AVR avr, String filename, FileFormat fileFormat) throws Exception {
        Vector<String> cmd = this.getCmd(avr);
        cmd.add("-U");
        cmd.add(String.format("eeprom:r:%s:%s", filename, this.FileFormat2AvrdudeOption(fileFormat)));
        int exitValue = this.startAvrdudeFlashReadWrite(cmd);
        if (exitValue != 0) {
            throw new Exception("Error reading EEPROM!");
        }
    }

    public void writeEEPROM(AVR avr, String filename, FileFormat fileFormat) throws Exception {
        Vector<String> cmd = this.getCmd(avr);
        cmd.add("-U");
        cmd.add(String.format("eeprom:w:%s:%s", filename, this.FileFormat2AvrdudeOption(fileFormat)));
        int exitValue = this.startAvrdudeFlashReadWrite(cmd);
        if (exitValue != 0) {
            throw new Exception("Error writing EEPROM!");
        }
    }

    public void verifyEEPROM(AVR avr, String filename, FileFormat fileFormat) throws Exception {
        Vector<String> cmd = this.getCmd(avr);
        cmd.add("-U");
        cmd.add(String.format("eeprom:v:%s:%s", filename, this.FileFormat2AvrdudeOption(fileFormat)));
        int exitValue = this.startAvrdudeFlashReadWrite(cmd);
        if (exitValue != 0) {
            throw new Exception("Error verifying EEPROM!");
        }
    }

    private int startAvrdudeFusesReadWrite(Vector<String> cmd) throws Exception {
        String line;
        this.m_intfTextOutput.clearText();
        for (String s : cmd) {
            this.m_intfTextOutput.print(s + " ");
        }
        this.m_intfTextOutput.println("");
        String[] cmdArray = new String[cmd.size()];
        cmd.toArray(cmdArray);
        Process p = Runtime.getRuntime().exec(cmdArray);
        BufferedReader input = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        while ((line = input.readLine()) != null) {
            this.m_intfTextOutput.println(line);
        }
        input.close();
        p.waitFor();
        return p.exitValue();
    }

    private int startAvrdudeFlashReadWrite(Vector<String> cmd) throws Exception {
        String line;
        this.m_intfTextOutput.clearText();
        for (String s : cmd) {
            this.m_intfTextOutput.print(s + " ");
        }
        this.m_intfTextOutput.println("");
        String[] cmdArray = new String[cmd.size()];
        cmd.toArray(cmdArray);
        Process p = Runtime.getRuntime().exec(cmdArray);
        BufferedReader input = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        while ((line = input.readLine()) != null) {
            this.m_intfTextOutput.println(line);
        }
        input.close();
        p.waitFor();
        return p.exitValue();
    }

    private String FileFormat2AvrdudeOption(FileFormat fileFormat) {
        switch (fileFormat) {
            case RAW: {
                return "r";
            }
            case INTEL_HEX: {
                return "i";
            }
            case MOTOROLA_S_RECORD: {
                return "s";
            }
            case AUTO_DETECT: {
                return "a";
            }
        }
        assert (false);
        return "";
    }

    public static FileFormat String2FileFormat(String fileFormat) {
        if (fileFormat.equals("Intel Hex")) {
            return FileFormat.INTEL_HEX;
        }
        if (fileFormat.equals("Motorola S-record")) {
            return FileFormat.MOTOROLA_S_RECORD;
        }
        if (fileFormat.equals("raw")) {
            return FileFormat.RAW;
        }
        return FileFormat.AUTO_DETECT;
    }

    public Boolean getDisableAutoErase() {
        return this.m_disableAutoErase;
    }

    public void setDisableAutoErase(Boolean disableAutoErase) {
        this.m_disableAutoErase = disableAutoErase;
    }

    public Boolean getExitSpecActivated() {
        return this.m_exitSpecActivated;
    }

    public void setExitSpecActivated(Boolean exitSpecActivated) {
        this.m_exitSpecActivated = exitSpecActivated;
    }

    public Boolean getLeftResetActivated() {
        return this.m_leftResetActivated;
    }

    public void setLeftResetActivated(Boolean leftResetActivated) {
        this.m_leftResetActivated = leftResetActivated;
    }

    public Boolean getLeftVccActivated() {
        return this.m_leftVccActivated;
    }

    public void setLeftVccActivated(Boolean leftVccActivated) {
        this.m_leftVccActivated = leftVccActivated;
    }

    public Boolean getDisableFuseCheck() {
        return this.m_disableFuseCheck;
    }

    public void setDisableFuseCheck(Boolean disableFuseCheck) {
        this.m_disableFuseCheck = disableFuseCheck;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FileFormat {
        RAW,
        INTEL_HEX,
        MOTOROLA_S_RECORD,
        AUTO_DETECT;

    }
}

