/*
 * Decompiled with CFR 0.152.
 */
package avr8_burn_o_mat;

import avr8_burn_o_mat.AVR;
import avr8_burn_o_mat.ActionThread;
import avr8_burn_o_mat.AvrdudeControl;
import avr8_burn_o_mat.FileFilterHex;
import avr8_burn_o_mat.FormAbout;
import avr8_burn_o_mat.FormAvrdudeSettings;
import avr8_burn_o_mat.FormFuses;
import avr8_burn_o_mat.InterfaceTextOutput;
import avr8_burn_o_mat.XmlReaderAvrConfig;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Collections;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class FormMain
extends JFrame
implements InterfaceTextOutput,
ActionThread.Observer {
    private final int MAX_ITEMS_IN_HISTORY = 8;
    private Vector<AVR> m_avrList;
    private AVR m_avr;
    private AvrdudeControl m_avrdudeCtrl;
    private JFileChooser m_fileChooserFlash;
    private JFileChooser m_fileChooserEEPROM;
    private ActionThread m_actionThread;
    private FormAbout m_formAbout;
    private FormFuses m_formFuses;
    private FormAvrdudeSettings m_formAvrdudeSettings;
    private String m_currentLookAndFeel = "";
    private JButton jButtonFileEEPROM;
    private JButton jButtonFileFlash;
    private JButton jButtonFuses;
    private JButton jButtonReadEEPROM;
    private JButton jButtonReadFlash;
    private JButton jButtonVerifyEEPROM;
    private JButton jButtonVerifyFlash;
    private JButton jButtonWriteEEPROM;
    private JButton jButtonWriteFlash;
    private JComboBox jComboBoxAvr;
    private JComboBox jComboBoxEEPROMFileType;
    private JComboBox jComboBoxFileEEPROM;
    private JComboBox jComboBoxFileFlash;
    private JComboBox jComboBoxFlashFileType;
    private JLabel jLabel1;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenu jMenu3;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItem3;
    private JMenuItem jMenuItemAllToClipboard;
    private JMenuItem jMenuItemClearOutput;
    private JMenuItem jMenuItemCopySelectedToClipboard;
    private JMenu jMenuLookAndFeel;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPopupMenu jPopupMenuCopyToClipboard;
    private JScrollPane jScrollPane1;
    private JSplitPane jSplitPane1;
    private JTextArea jTextAreaOutput;

    public FormMain() {
        this.initComponents();
        try {
            UIManager.LookAndFeelInfo[] lafList;
            this.m_avrdudeCtrl = new AvrdudeControl(this);
            this.m_actionThread = new ActionThread(this.m_avrdudeCtrl);
            this.m_actionThread.m_observable.addObserver(this);
            this.m_formFuses = new FormFuses(this.m_actionThread);
            this.m_formAbout = new FormAbout();
            this.m_formAvrdudeSettings = new FormAvrdudeSettings(this.m_avrdudeCtrl);
            this.readAVRConfig("./AVR8_Burn_O_Mat_Config.xml");
            this.setIconImage(Toolkit.getDefaultToolkit().getImage("AVR8_Burn-O-Mat_Icon_16.png"));
            this.loadPreferences();
            this.setState(ActionThread.Action.IDLE);
            for (UIManager.LookAndFeelInfo laf : lafList = UIManager.getInstalledLookAndFeels()) {
                JMenuItem item = new JMenuItem(laf.getName());
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        FormMain.this.jMenuItemLookAndFeelActionPerformed(evt);
                    }
                });
                this.jMenuLookAndFeel.add(item);
            }
            this.m_fileChooserFlash = new JFileChooser();
            this.m_fileChooserEEPROM = new JFileChooser();
            this.m_fileChooserFlash.setFileFilter(new FileFilterHex());
            this.m_fileChooserEEPROM.setFileFilter(new FileFilterHex());
        }
        catch (Exception e) {
            this.showError("Error while loading program: " + e.getMessage());
            System.exit(1);
        }
    }

    public static boolean setLookAndFeel(String lookAndFeelName) {
        try {
            UIManager.LookAndFeelInfo[] lafList = UIManager.getInstalledLookAndFeels();
            String lafClass = null;
            for (UIManager.LookAndFeelInfo lookAndFeelInfo : lafList) {
                if (!lookAndFeelName.equals(lookAndFeelInfo.getName())) continue;
                lafClass = lookAndFeelInfo.getClassName();
                break;
            }
            if (lafClass == null) {
                throw new Exception("Look And Feel " + lookAndFeelName + " not available");
            }
            for (Frame frame : Frame.getFrames()) {
                frame.setPreferredSize(frame.getSize());
            }
            UIManager.setLookAndFeel(lafClass);
            for (Frame frame : Frame.getFrames()) {
                SwingUtilities.updateComponentTreeUI(frame);
                frame.pack();
                for (Window w : frame.getOwnedWindows()) {
                    SwingUtilities.updateComponentTreeUI(w);
                    w.pack();
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private void jMenuItemLookAndFeelActionPerformed(ActionEvent evt) {
        FormMain.setLookAndFeel(evt.getActionCommand());
        this.m_currentLookAndFeel = evt.getActionCommand();
    }

    private void addToHistory(JComboBox comboBox, String item) {
        boolean removed;
        block0: do {
            removed = false;
            for (int idx = 0; idx < comboBox.getItemCount(); ++idx) {
                String s = (String)comboBox.getItemAt(idx);
                assert (s != null);
                if (!s.equals(item)) continue;
                comboBox.removeItemAt(idx);
                removed = true;
                continue block0;
            }
        } while (removed);
        comboBox.insertItemAt(item, 0);
        while (comboBox.getItemCount() > 8) {
            comboBox.removeItemAt(comboBox.getItemCount() - 1);
        }
        comboBox.setSelectedItem(item);
    }

    public void actionThreadStateChanged(ActionThread.Action newState) {
        final ActionThread.Action newStateTmp = newState;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FormMain.this.setState(newStateTmp);
            }
        });
        String msg = null;
        boolean error = false;
        switch (newState) {
            case READ_FLASH_DONE: {
                msg = "Flash successfully read.";
                break;
            }
            case WRITE_FLASH_DONE: {
                msg = "Flash successfully written.";
                break;
            }
            case VERIFY_FLASH_DONE: {
                msg = "Flash successfully verified.";
                break;
            }
            case READ_EEPROM_DONE: {
                msg = "EEPROM successfully read.";
                break;
            }
            case WRITE_EEPROM_DONE: {
                msg = "EEPROM successfully written.";
                break;
            }
            case VERIFY_EEPROM_DONE: {
                msg = "EEPROM successfully verified.";
                break;
            }
            case READ_FUSES_DONE: {
                msg = "Fuses successfully read.";
                break;
            }
            case WRITE_FUSES_DONE: {
                msg = "Fuses successfully written.";
                break;
            }
            case VERIFY_FUSES_DONE: {
                msg = "Fuses successfully verified.";
                break;
            }
            case READ_FLASH_ERROR: 
            case WRITE_FLASH_ERROR: 
            case VERIFY_FLASH_ERROR: 
            case READ_EEPROM_ERROR: 
            case WRITE_EEPROM_ERROR: 
            case VERIFY_EEPROM_ERROR: 
            case READ_FUSES_ERROR: 
            case WRITE_FUSES_ERROR: 
            case VERIFY_FUSES_ERROR: {
                msg = this.m_actionThread.getLastErrorMsg();
                error = true;
            }
        }
        if (msg != null) {
            final String s = msg;
            final boolean err = error;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (err) {
                        FormMain.this.showError(s);
                    } else {
                        JOptionPane.showMessageDialog(null, s);
                    }
                }
            });
        }
    }

    private void setState(ActionThread.Action state) {
        switch (state) {
            case IDLE: {
                this.jComboBoxAvr.setEnabled(true);
                this.jButtonFuses.setEnabled(true);
                this.jComboBoxFileFlash.setEnabled(true);
                this.jComboBoxFileEEPROM.setEnabled(true);
                this.jButtonFileFlash.setEnabled(true);
                this.jButtonFileEEPROM.setEnabled(true);
                this.jComboBoxFlashFileType.setEnabled(true);
                this.jComboBoxEEPROMFileType.setEnabled(true);
                this.jButtonReadFlash.setEnabled(true);
                this.jButtonWriteFlash.setEnabled(true);
                this.jButtonVerifyFlash.setEnabled(true);
                this.jButtonReadEEPROM.setEnabled(true);
                this.jButtonWriteEEPROM.setEnabled(true);
                this.jButtonVerifyEEPROM.setEnabled(true);
                break;
            }
            default: {
                this.jComboBoxAvr.setEnabled(false);
                this.jButtonFuses.setEnabled(false);
                this.jComboBoxFileFlash.setEnabled(false);
                this.jComboBoxFileEEPROM.setEnabled(false);
                this.jButtonFileFlash.setEnabled(false);
                this.jButtonFileEEPROM.setEnabled(false);
                this.jComboBoxFlashFileType.setEnabled(false);
                this.jComboBoxEEPROMFileType.setEnabled(false);
                this.jButtonReadFlash.setEnabled(false);
                this.jButtonWriteFlash.setEnabled(false);
                this.jButtonVerifyFlash.setEnabled(false);
                this.jButtonReadEEPROM.setEnabled(false);
                this.jButtonWriteEEPROM.setEnabled(false);
                this.jButtonVerifyEEPROM.setEnabled(false);
            }
        }
    }

    public void savePreferences() {
        try {
            int idx;
            Preferences prefs = Preferences.userNodeForPackage(this.getClass());
            System.out.println("preferences saved to: " + prefs.absolutePath());
            prefs.putInt("FormMain_Width", this.getWidth());
            prefs.putInt("FormMain_Height", this.getHeight());
            prefs.putInt("FormMain_PosX", this.getX());
            prefs.putInt("FormMain_PosY", this.getY());
            prefs.putInt("FormMain_DividerPos", this.jSplitPane1.getDividerLocation());
            String file = (String)this.jComboBoxFileFlash.getSelectedItem();
            if (file != null) {
                prefs.put("FileFlash", file);
            }
            if ((file = (String)this.jComboBoxFileEEPROM.getSelectedItem()) != null) {
                prefs.put("FileEEPROM", file);
            }
            prefs.put("ComboBoxAvr", (String)this.jComboBoxAvr.getSelectedItem());
            prefs.put("ComboBoxFlashFileType", (String)this.jComboBoxFlashFileType.getSelectedItem());
            prefs.put("ComboBoxEEPROMFileType", (String)this.jComboBoxEEPROMFileType.getSelectedItem());
            prefs.put("FileDialogLastDirFlash", this.m_fileChooserFlash.getCurrentDirectory().getPath());
            prefs.put("FileDialogLastDirEEPROM", this.m_fileChooserEEPROM.getCurrentDirectory().getPath());
            prefs.put("LookAndFeel", this.m_currentLookAndFeel);
            for (idx = 0; idx < this.jComboBoxFileFlash.getItemCount(); ++idx) {
                file = (String)this.jComboBoxFileFlash.getItemAt(idx);
                assert (file != null);
                prefs.put("FileFlashHistory" + idx, file);
            }
            for (idx = 0; idx < this.jComboBoxFileEEPROM.getItemCount(); ++idx) {
                file = (String)this.jComboBoxFileEEPROM.getItemAt(idx);
                assert (file != null);
                prefs.put("FileEEPROMHistory" + idx, file);
            }
            prefs.flush();
        }
        catch (Exception e) {
            System.err.println("Error while saving preferences: " + e.getMessage());
        }
    }

    public void loadPreferences() {
        try {
            int idx;
            Preferences prefs = Preferences.userNodeForPackage(this.getClass());
            String s = prefs.get("LookAndFeel", "Substance");
            if (s.length() > 0) {
                FormMain.setLookAndFeel(s);
                this.m_currentLookAndFeel = s;
            }
            int w = prefs.getInt("FormMain_Width", 600);
            int h = prefs.getInt("FormMain_Height", 500);
            this.setSize(w, h);
            this.setPreferredSize(new Dimension(w, h));
            this.setLocation(prefs.getInt("FormMain_PosX", 100), prefs.getInt("FormMain_PosY", 100));
            this.jSplitPane1.setDividerLocation(prefs.getInt("FormMain_DividerPos", this.jSplitPane1.getDividerLocation()));
            this.jComboBoxFileFlash.removeAllItems();
            for (idx = 0; idx < 8; ++idx) {
                s = prefs.get("FileFlashHistory" + idx, "");
                if (s.length() <= 0) continue;
                this.jComboBoxFileFlash.addItem(s);
            }
            this.jComboBoxFileEEPROM.removeAllItems();
            for (idx = 0; idx < 8; ++idx) {
                s = prefs.get("FileEEPROMHistory" + idx, "");
                if (s.length() <= 0) continue;
                this.jComboBoxFileEEPROM.addItem(s);
            }
            this.jComboBoxFileFlash.setSelectedItem(prefs.get("FileFlash", ""));
            this.jComboBoxFileEEPROM.setSelectedItem(prefs.get("FileEEPROM", ""));
            s = prefs.get("ComboBoxAvr", "");
            if (s.length() > 0) {
                this.jComboBoxAvr.setSelectedItem(s);
            }
            if ((s = prefs.get("ComboBoxFlashFileType", "")).length() > 0) {
                this.jComboBoxFlashFileType.setSelectedItem(s);
            }
            if ((s = prefs.get("ComboBoxEEPROMFileType", "")).length() > 0) {
                this.jComboBoxEEPROMFileType.setSelectedItem(s);
            }
            if ((s = prefs.get("FileDialogLastDirFlash", "")).length() > 0) {
                this.m_fileChooserFlash.setCurrentDirectory(new File(s));
            }
            if ((s = prefs.get("FileDialogLastDirEEPROM", "")).length() > 0) {
                this.m_fileChooserEEPROM.setCurrentDirectory(new File(s));
            }
        }
        catch (Exception e) {
            System.err.println("Error while loading preferences: " + e.getMessage());
        }
    }

    public void print(final String line) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FormMain.this.jTextAreaOutput.append(line);
            }
        });
    }

    public void println(final String line) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FormMain.this.jTextAreaOutput.append(line);
                FormMain.this.jTextAreaOutput.append("\n");
            }
        });
    }

    public void clearText() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FormMain.this.jTextAreaOutput.setText("");
            }
        });
    }

    public void readAVRConfig(String uri) {
        this.m_avr = null;
        try {
            XmlReaderAvrConfig cfg = new XmlReaderAvrConfig();
            cfg.readXmlFile(uri);
            this.m_avrList = cfg.getAVRList();
        }
        catch (Exception e) {
            this.showError("Error while reading config: " + e.getMessage());
        }
        this.UpdateComboBoxAvr();
    }

    private void UpdateComboBoxAvr() {
        Vector<String> items = new Vector<String>();
        for (AVR avr : this.m_avrList) {
            items.add(avr.getCaption());
        }
        Collections.sort(items);
        this.jComboBoxAvr.removeAllItems();
        for (String item : items) {
            this.jComboBoxAvr.addItem(item);
        }
    }

    private void initComponents() {
        this.jPopupMenuCopyToClipboard = new JPopupMenu();
        this.jMenuItemCopySelectedToClipboard = new JMenuItem();
        this.jMenuItemAllToClipboard = new JMenuItem();
        this.jMenuItemClearOutput = new JMenuItem();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jComboBoxAvr = new JComboBox();
        this.jButtonFuses = new JButton();
        this.jPanel2 = new JPanel();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaOutput = new JTextArea();
        this.jPanel3 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jButtonFileFlash = new JButton();
        this.jComboBoxFlashFileType = new JComboBox();
        this.jPanel6 = new JPanel();
        this.jButtonWriteFlash = new JButton();
        this.jButtonReadFlash = new JButton();
        this.jButtonVerifyFlash = new JButton();
        this.jComboBoxFileFlash = new JComboBox();
        this.jPanel5 = new JPanel();
        this.jComboBoxEEPROMFileType = new JComboBox();
        this.jButtonFileEEPROM = new JButton();
        this.jComboBoxFileEEPROM = new JComboBox();
        this.jPanel7 = new JPanel();
        this.jButtonWriteEEPROM = new JButton();
        this.jButtonReadEEPROM = new JButton();
        this.jButtonVerifyEEPROM = new JButton();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.jMenuItem3 = new JMenuItem();
        this.jMenuLookAndFeel = new JMenu();
        this.jMenu3 = new JMenu();
        this.jMenuItem2 = new JMenuItem();
        this.jMenuItemCopySelectedToClipboard.setText("Copy selected  to clipboard");
        this.jMenuItemCopySelectedToClipboard.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormMain.this.jMenuItemCopySelectedToClipboardActionPerformed(evt);
            }
        });
        this.jPopupMenuCopyToClipboard.add(this.jMenuItemCopySelectedToClipboard);
        this.jMenuItemAllToClipboard.setText("Copy all to clipboard");
        this.jMenuItemAllToClipboard.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormMain.this.jMenuItemAllToClipboardActionPerformed(evt);
            }
        });
        this.jPopupMenuCopyToClipboard.add(this.jMenuItemAllToClipboard);
        this.jMenuItemClearOutput.setText("Clear output");
        this.jMenuItemClearOutput.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormMain.this.jMenuItemClearOutputActionPerformed(evt);
            }
        });
        this.jPopupMenuCopyToClipboard.add(this.jMenuItemClearOutput);
        this.setTitle("AVR8 Burn-O-Mat v2");
        this.setMinimumSize(new Dimension(600, 500));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                FormMain.this.formWindowClosing(evt);
            }
        });
        this.getContentPane().setLayout(new BorderLayout(10, 10));
        this.jPanel1.setLayout(new FlowLayout(0, 10, 10));
        this.jLabel1.setText("AVR type");
        this.jPanel1.add(this.jLabel1);
        this.jComboBoxAvr.setMaximumRowCount(10);
        this.jComboBoxAvr.setMinimumSize(new Dimension(150, 24));
        this.jComboBoxAvr.setPreferredSize(new Dimension(150, 24));
        this.jComboBoxAvr.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                FormMain.this.jComboBoxAvrItemStateChanged(evt);
            }
        });
        this.jPanel1.add(this.jComboBoxAvr);
        this.jButtonFuses.setText("Fuses");
        this.jButtonFuses.setPreferredSize(new Dimension(80, 25));
        this.jButtonFuses.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormMain.this.jButtonFusesActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonFuses);
        this.getContentPane().add((Component)this.jPanel1, "North");
        this.jPanel2.setPreferredSize(new Dimension(400, 300));
        this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 2));
        this.jSplitPane1.setDividerLocation(200);
        this.jSplitPane1.setOrientation(0);
        this.jTextAreaOutput.setColumns(20);
        this.jTextAreaOutput.setEditable(false);
        this.jTextAreaOutput.setRows(5);
        this.jTextAreaOutput.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                FormMain.this.jTextAreaOutputMouseReleased(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTextAreaOutput);
        this.jSplitPane1.setRightComponent(this.jScrollPane1);
        this.jPanel3.setLayout(new BoxLayout(this.jPanel3, 1));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("Flash"));
        this.jPanel4.setLayout(new GridBagLayout());
        this.jButtonFileFlash.setText("File");
        this.jButtonFileFlash.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormMain.this.jButtonFileFlashActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.jButtonFileFlash, gridBagConstraints);
        this.jComboBoxFlashFileType.setModel(new DefaultComboBoxModel<String>(new String[]{"auto", "Intel Hex", "Motorola S-record", "raw"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.jComboBoxFlashFileType, gridBagConstraints);
        this.jPanel6.setLayout(new FlowLayout(0));
        this.jButtonWriteFlash.setText("Write");
        this.jButtonWriteFlash.setPreferredSize(new Dimension(80, 25));
        this.jButtonWriteFlash.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormMain.this.jButtonWriteFlashActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.jButtonWriteFlash);
        this.jButtonReadFlash.setText("Read");
        this.jButtonReadFlash.setPreferredSize(new Dimension(80, 25));
        this.jButtonReadFlash.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormMain.this.jButtonReadFlashActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.jButtonReadFlash);
        this.jButtonVerifyFlash.setText("Verify");
        this.jButtonVerifyFlash.setPreferredSize(new Dimension(80, 25));
        this.jButtonVerifyFlash.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormMain.this.jButtonVerifyFlashActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.jButtonVerifyFlash);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.jPanel4.add((Component)this.jPanel6, gridBagConstraints);
        this.jComboBoxFileFlash.setEditable(true);
        this.jComboBoxFileFlash.setMinimumSize(new Dimension(100, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.jComboBoxFileFlash, gridBagConstraints);
        this.jPanel3.add(this.jPanel4);
        this.jPanel5.setBorder(BorderFactory.createTitledBorder("EEPROM"));
        this.jPanel5.setLayout(new GridBagLayout());
        this.jComboBoxEEPROMFileType.setModel(new DefaultComboBoxModel<String>(new String[]{"auto", "Intel Hex", "Motorola S-record", "raw"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel5.add((Component)this.jComboBoxEEPROMFileType, gridBagConstraints);
        this.jButtonFileEEPROM.setText("File");
        this.jButtonFileEEPROM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormMain.this.jButtonFileEEPROMActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel5.add((Component)this.jButtonFileEEPROM, gridBagConstraints);
        this.jComboBoxFileEEPROM.setEditable(true);
        this.jComboBoxFileEEPROM.setMinimumSize(new Dimension(100, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel5.add((Component)this.jComboBoxFileEEPROM, gridBagConstraints);
        this.jPanel7.setLayout(new FlowLayout(0));
        this.jButtonWriteEEPROM.setText("Write");
        this.jButtonWriteEEPROM.setPreferredSize(new Dimension(80, 25));
        this.jButtonWriteEEPROM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormMain.this.jButtonWriteEEPROMActionPerformed(evt);
            }
        });
        this.jPanel7.add(this.jButtonWriteEEPROM);
        this.jButtonReadEEPROM.setText("Read");
        this.jButtonReadEEPROM.setPreferredSize(new Dimension(80, 25));
        this.jButtonReadEEPROM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormMain.this.jButtonReadEEPROMActionPerformed(evt);
            }
        });
        this.jPanel7.add(this.jButtonReadEEPROM);
        this.jButtonVerifyEEPROM.setText("Verify");
        this.jButtonVerifyEEPROM.setPreferredSize(new Dimension(80, 25));
        this.jButtonVerifyEEPROM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormMain.this.jButtonVerifyEEPROMActionPerformed(evt);
            }
        });
        this.jPanel7.add(this.jButtonVerifyEEPROM);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.jPanel5.add((Component)this.jPanel7, gridBagConstraints);
        this.jPanel3.add(this.jPanel5);
        this.jSplitPane1.setTopComponent(this.jPanel3);
        this.jPanel2.add(this.jSplitPane1);
        this.getContentPane().add((Component)this.jPanel2, "Center");
        this.jMenu1.setText("File");
        this.jMenuItem1.setText("Exit");
        this.jMenuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormMain.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem1);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu2.setText("Settings");
        this.jMenuItem3.setText("AVRDUDE");
        this.jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormMain.this.jMenuItem3ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem3);
        this.jMenuLookAndFeel.setText("Look and feel");
        this.jMenu2.add(this.jMenuLookAndFeel);
        this.jMenuBar1.add(this.jMenu2);
        this.jMenu3.setText("Help");
        this.jMenuItem2.setText("About");
        this.jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormMain.this.jMenuItem2ActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItem2);
        this.jMenuBar1.add(this.jMenu3);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void jMenuItemAllToClipboardActionPerformed(ActionEvent evt) {
        this.jTextAreaOutput.selectAll();
        this.jTextAreaOutput.copy();
    }

    private void jMenuItemClearOutputActionPerformed(ActionEvent evt) {
        this.jTextAreaOutput.setText("");
    }

    private void jMenuItemCopySelectedToClipboardActionPerformed(ActionEvent evt) {
        this.jTextAreaOutput.copy();
    }

    private void jTextAreaOutputMouseReleased(MouseEvent evt) {
        if (evt.getButton() == 3) {
            this.jMenuItemCopySelectedToClipboard.setEnabled(this.jTextAreaOutput.getSelectedText() != null);
            this.jPopupMenuCopyToClipboard.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void jButtonVerifyEEPROMActionPerformed(ActionEvent evt) {
        try {
            String fileType = (String)this.jComboBoxEEPROMFileType.getSelectedItem();
            String file = (String)this.jComboBoxFileEEPROM.getSelectedItem();
            if (file == null || file.length() == 0) {
                return;
            }
            this.addToHistory(this.jComboBoxFileEEPROM, file);
            this.m_actionThread.verifyEEPROM(this.m_avr, file, AvrdudeControl.String2FileFormat(fileType));
        }
        catch (Exception e) {
            this.showError("Error verifying EEPROM: " + e.getMessage());
        }
    }

    private void jButtonVerifyFlashActionPerformed(ActionEvent evt) {
        try {
            String fileType = (String)this.jComboBoxFlashFileType.getSelectedItem();
            String file = (String)this.jComboBoxFileFlash.getSelectedItem();
            if (file == null || file.length() == 0) {
                return;
            }
            this.addToHistory(this.jComboBoxFileFlash, file);
            this.m_actionThread.verifyFlash(this.m_avr, file, AvrdudeControl.String2FileFormat(fileType));
        }
        catch (Exception e) {
            this.showError("Error verifying Flash: " + e.getMessage());
        }
    }

    private void jMenuItem3ActionPerformed(ActionEvent evt) {
        this.m_formAvrdudeSettings.setVisible(true);
    }

    private void jMenuItem2ActionPerformed(ActionEvent evt) {
        this.m_formAbout.setVisible(true);
    }

    private void jButtonWriteEEPROMActionPerformed(ActionEvent evt) {
        try {
            String fileType = (String)this.jComboBoxEEPROMFileType.getSelectedItem();
            String file = (String)this.jComboBoxFileEEPROM.getSelectedItem();
            if (file == null || file.length() == 0) {
                return;
            }
            this.addToHistory(this.jComboBoxFileEEPROM, file);
            this.m_actionThread.writeEEPROM(this.m_avr, file, AvrdudeControl.String2FileFormat(fileType));
        }
        catch (Exception e) {
            this.showError("Error writing EEPROM: " + e.getMessage());
        }
    }

    private void jButtonReadEEPROMActionPerformed(ActionEvent evt) {
        try {
            int r;
            String fileType = (String)this.jComboBoxEEPROMFileType.getSelectedItem();
            String file = (String)this.jComboBoxFileEEPROM.getSelectedItem();
            if (file == null || file.length() == 0) {
                return;
            }
            this.addToHistory(this.jComboBoxFileEEPROM, file);
            if (new File(file).exists() && (r = JOptionPane.showConfirmDialog(this, "File already exists! Do you want to overwrite the existing file?")) != 0) {
                return;
            }
            this.m_actionThread.readEEPROM(this.m_avr, file, AvrdudeControl.String2FileFormat(fileType));
        }
        catch (Exception e) {
            this.showError("Error reading EEPROM: " + e.getMessage());
        }
    }

    private void jButtonWriteFlashActionPerformed(ActionEvent evt) {
        try {
            String fileType = (String)this.jComboBoxFlashFileType.getSelectedItem();
            String file = (String)this.jComboBoxFileFlash.getSelectedItem();
            if (file == null || file.length() == 0) {
                return;
            }
            this.addToHistory(this.jComboBoxFileFlash, file);
            this.m_actionThread.writeFlash(this.m_avr, file, AvrdudeControl.String2FileFormat(fileType));
        }
        catch (Exception e) {
            this.showError("Error writing Flash: " + e.getMessage());
        }
    }

    private void jButtonReadFlashActionPerformed(ActionEvent evt) {
        try {
            int r;
            String fileType = (String)this.jComboBoxFlashFileType.getSelectedItem();
            String file = (String)this.jComboBoxFileFlash.getSelectedItem();
            if (file == null || file.length() == 0) {
                return;
            }
            this.addToHistory(this.jComboBoxFileFlash, file);
            if (new File(file).exists() && (r = JOptionPane.showConfirmDialog(this, "File already exists! Do you want to overwrite the existing file?")) != 0) {
                return;
            }
            this.m_actionThread.readFlash(this.m_avr, file, AvrdudeControl.String2FileFormat(fileType));
        }
        catch (Exception e) {
            this.showError("Error reading Flash: " + e.getMessage());
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.ExitProgram();
    }

    private void jButtonFileEEPROMActionPerformed(ActionEvent evt) {
        int state = this.m_fileChooserEEPROM.showOpenDialog(null);
        if (state == 0) {
            File file = this.m_fileChooserEEPROM.getSelectedFile();
            this.jComboBoxFileEEPROM.setSelectedItem(file.getPath());
            this.addToHistory(this.jComboBoxFileEEPROM, file.getPath());
        }
    }

    private void jButtonFileFlashActionPerformed(ActionEvent evt) {
        int state = this.m_fileChooserFlash.showOpenDialog(null);
        if (state == 0) {
            File file = this.m_fileChooserFlash.getSelectedFile();
            this.jComboBoxFileFlash.setSelectedItem(file.getPath());
            this.addToHistory(this.jComboBoxFileFlash, file.getPath());
        }
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        this.ExitProgram();
    }

    private void jComboBoxAvrItemStateChanged(ItemEvent evt) {
        String s = (String)this.jComboBoxAvr.getSelectedItem();
        for (AVR avr : this.m_avrList) {
            if (!avr.getCaption().equals(s)) continue;
            this.m_avr = avr;
            this.m_formFuses.setAVR(avr);
            break;
        }
    }

    private void jButtonFusesActionPerformed(ActionEvent evt) {
        if (this.m_avr == null) {
            this.showError("Please select an AVR type first!");
        } else {
            this.m_formFuses.setVisible(true);
        }
    }

    public void ExitProgram() {
        this.savePreferences();
        this.m_formFuses.savePreferences();
        this.m_formAvrdudeSettings.savePreferences();
        this.m_avrdudeCtrl.savePreferences();
        System.exit(0);
    }

    private void showError(String s) {
        JOptionPane.showMessageDialog(this, s, this.getTitle(), 0);
    }

    public static void main(String[] args) {
        UIManager.installLookAndFeel("Substance", "org.jvnet.substance.SubstanceLookAndFeel");
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                FormMain formMain = new FormMain();
                formMain.setVisible(true);
            }
        });
    }
}

