/*
 * Decompiled with CFR 0.152.
 */
package avr8_burn_o_mat;

import avr8_burn_o_mat.XmlUtil;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Fuse {
    public static final String[] FUSE_BYTES = new String[]{"fuse", "lfuse", "hfuse", "efuse"};
    private String m_name;
    private String m_description;
    private Integer m_bitNumber;
    private String m_fuseByte;
    private FuseState m_fuseState;
    private FuseState m_defaultFuseState;
    private FuseMode m_fuseMode;

    public Fuse() {
        this.m_name = "";
        this.m_description = "";
        this.m_bitNumber = 0;
        this.m_fuseByte = "fuse";
        this.m_fuseState = FuseState.UNPROGRAMMED;
        this.m_defaultFuseState = FuseState.UNPROGRAMMED;
        this.m_fuseMode = FuseMode.EXPERT;
        assert (this.m_fuseState != null);
    }

    public Fuse(String name, String desc, Integer bitNumber, String fuseByte, FuseState defaultFuseState, FuseMode fuseMode) throws Exception {
        if (!Fuse.isValidFuseName(fuseByte)) {
            throw new Exception("'" + fuseByte + "' is not a valid fuse name!");
        }
        this.m_name = name;
        this.m_description = desc;
        this.m_bitNumber = bitNumber;
        this.m_fuseByte = fuseByte;
        this.m_fuseState = defaultFuseState;
        this.m_defaultFuseState = defaultFuseState;
        this.m_fuseMode = fuseMode;
        assert (this.m_fuseState != null);
    }

    public static boolean isValidFuseName(String fuse) {
        for (String f : FUSE_BYTES) {
            if (!f.equals(fuse)) continue;
            return true;
        }
        return false;
    }

    public static Integer FuseState2Integer(FuseState fuseState) throws Exception {
        if (fuseState == FuseState.PROGRAMMED) {
            return 0;
        }
        if (fuseState == FuseState.UNPROGRAMMED) {
            return 1;
        }
        assert (false);
        throw new Exception("internal error function: FuseState2Integer");
    }

    public static FuseState Integer2FuseState(Integer fuseState) throws Exception {
        if (fuseState == 0) {
            return FuseState.PROGRAMMED;
        }
        if (fuseState == 1) {
            return FuseState.UNPROGRAMMED;
        }
        throw new Exception("invalid fuse state, 0 or 1 expected");
    }

    public String getName() {
        return this.m_name;
    }

    public String getDescription() {
        return this.m_description;
    }

    public Integer getBitNumber() {
        return this.m_bitNumber;
    }

    public String getFuseByte() {
        return this.m_fuseByte;
    }

    public FuseState getDefaultFuseState() {
        return this.m_defaultFuseState;
    }

    public Boolean isProgrammed() {
        return this.m_fuseState == FuseState.PROGRAMMED;
    }

    public void setFuseState(FuseState fuseState) {
        assert (fuseState != null);
        this.m_fuseState = fuseState;
    }

    public FuseState getFuseState() {
        assert (this.m_fuseState != null);
        return this.m_fuseState;
    }

    public FuseMode getFuseMode() {
        return this.m_fuseMode;
    }

    public void loadFromXml(Node nodeFuse) throws Exception {
        this.m_name = XmlUtil.getAttr(nodeFuse, "name");
        this.m_description = XmlUtil.getAttr(nodeFuse, "desc");
        String s = XmlUtil.getAttr(nodeFuse, "bit");
        try {
            this.m_bitNumber = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new DOMException(17, "Attribute \"bit\" in fuse tag is not a number!");
        }
        if (this.m_bitNumber < 0 || this.m_bitNumber > 7) {
            throw new DOMException(17, "Attribute \"bit\" in fuse tag must be a number between 0 and 7!");
        }
        s = XmlUtil.getAttr(nodeFuse, "fuseByte").toLowerCase();
        if (!Fuse.isValidFuseName(s)) {
            String msg = "Attribute \"fuseByte\" in fuse tag is not valid, valid values:";
            for (String f : FUSE_BYTES) {
                msg = msg + " " + f;
            }
            throw new DOMException(17, msg);
        }
        this.m_fuseByte = s;
        String defaultFuseState = XmlUtil.getAttr(nodeFuse, "default");
        try {
            this.m_fuseState = this.m_defaultFuseState = Fuse.Integer2FuseState(Integer.parseInt(defaultFuseState));
        }
        catch (NumberFormatException e) {
            throw new DOMException(17, "Attribute \"default\" in fuse tag is not a number!");
        }
        this.m_fuseMode = FuseMode.NORMAL;
        try {
            s = XmlUtil.getAttr(nodeFuse, "mode").toLowerCase();
            if (s.equals("expert")) {
                this.m_fuseMode = FuseMode.EXPERT;
            }
        }
        catch (DOMException e) {
            // empty catch block
        }
        assert (this.m_fuseState != null);
    }

    public void loadStateFromXml(Node nodeFuse) throws Exception {
        String name = XmlUtil.getAttr(nodeFuse, "name");
        assert (name.equals(this.m_name));
        String fuseState = XmlUtil.getAttr(nodeFuse, "state");
        try {
            this.m_fuseState = Fuse.Integer2FuseState(Integer.parseInt(fuseState));
        }
        catch (NumberFormatException e) {
            throw new Exception("Attribute \"state\" in fuse tag is not a number!");
        }
        assert (this.m_fuseState != null);
    }

    public void saveStateToXml(Document doc, Node nodeAvr) throws Exception {
        Integer fuseState = Fuse.FuseState2Integer(this.m_fuseState);
        Element elem = doc.createElement("Fuse");
        elem.setAttribute("name", this.m_name);
        elem.setAttribute("state", fuseState.toString());
        nodeAvr.appendChild(elem);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FuseMode {
        NORMAL,
        EXPERT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FuseState {
        PROGRAMMED,
        UNPROGRAMMED;

    }
}

