/*
 * Decompiled with CFR 0.152.
 */
package avr8_burn_o_mat;

import avr8_burn_o_mat.AVR;
import avr8_burn_o_mat.FusesObserver;
import avr8_burn_o_mat.JPanelFuses;
import avr8_burn_o_mat.XmlReaderAvrConfig;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class JPanelApplet
extends JPanel
implements FusesObserver {
    JPanelFuses m_panelFuses;
    private Vector<AVR> m_avrList;
    private AVR m_avr;
    private JComboBox jComboBoxAvr;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel6;
    private JLabel jLabelStatus;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JTextField jTextFieldCommandLine;
    private JTextField jTextFieldFuses;

    public JPanelApplet(String appletPath) {
        this.initComponents();
        this.m_panelFuses = new JPanelFuses(null);
        this.add((Component)this.m_panelFuses, "Center");
        try {
            this.readAVRConfig(appletPath + "/AVR8_Burn_O_Mat_Config.xml");
        }
        catch (Exception e) {
            this.jLabelStatus.setText("Error while loading program: " + e.getMessage());
        }
        this.m_panelFuses.getFusesObservable().addObserver(this);
    }

    public void readAVRConfig(String uri) {
        try {
            if (uri.endsWith("/build/AVR8_Burn_O_Mat_Config.xml")) {
                uri = uri.substring(0, uri.lastIndexOf("/build/AVR8_Burn_O_Mat_Config.xml")) + "/AVR8_Burn_O_Mat_Config.xml";
            }
            XmlReaderAvrConfig cfg = new XmlReaderAvrConfig();
            cfg.readXmlFile(uri);
            this.m_avrList = cfg.getAVRList();
        }
        catch (Exception e) {
            this.jLabelStatus.setText("Error while reading config: " + e.getMessage());
        }
        this.UpdateComboBoxAvr();
    }

    private void UpdateComboBoxAvr() {
        Vector<String> items = new Vector<String>();
        for (AVR avr : this.m_avrList) {
            items.add(avr.getCaption());
        }
        Collections.sort(items);
        this.jComboBoxAvr.removeAllItems();
        for (String item : items) {
            this.jComboBoxAvr.addItem(item);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jComboBoxAvr = new JComboBox();
        this.jLabel6 = new JLabel();
        this.jLabelStatus = new JLabel();
        this.jPanel2 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jTextFieldFuses = new JTextField();
        this.jTextFieldCommandLine = new JTextField();
        this.setLayout(new BorderLayout());
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel1.setPreferredSize(new Dimension(626, 70));
        this.jLabel1.setFont(new Font("DejaVu Sans", 3, 18));
        this.jLabel1.setText("AVR Burn-O-Mat Fuse Configurator Applet");
        this.jComboBoxAvr.setMaximumRowCount(10);
        this.jComboBoxAvr.setMinimumSize(new Dimension(150, 24));
        this.jComboBoxAvr.setPreferredSize(new Dimension(150, 24));
        this.jComboBoxAvr.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                JPanelApplet.this.jComboBoxAvrItemStateChanged(evt);
            }
        });
        this.jLabel6.setText("AVR type");
        this.jLabelStatus.setForeground(new Color(255, 0, 0));
        this.jLabelStatus.setBorder(BorderFactory.createEtchedBorder());
        this.jLabelStatus.setMaximumSize(new Dimension(1000, 24));
        this.jLabelStatus.setMinimumSize(new Dimension(100, 24));
        this.jLabelStatus.setPreferredSize(new Dimension(432, 24));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxAvr, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelStatus, -1, 428, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.jComboBoxAvr, -2, -1, -2)).addComponent(this.jLabelStatus, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.add((Component)this.jPanel1, "North");
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel2.setPreferredSize(new Dimension(626, 70));
        this.jLabel2.setText("avrdude command line parameters");
        this.jLabel3.setText("fuses");
        this.jTextFieldFuses.setEditable(false);
        this.jTextFieldCommandLine.setEditable(false);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldFuses, -2, 243, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldCommandLine, -1, 405, Short.MAX_VALUE).addComponent(this.jLabel2)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldFuses, -2, -1, -2).addComponent(this.jTextFieldCommandLine, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.add((Component)this.jPanel2, "South");
    }

    private void jComboBoxAvrItemStateChanged(ItemEvent evt) {
        String s = (String)this.jComboBoxAvr.getSelectedItem();
        for (AVR avr : this.m_avrList) {
            if (!avr.getCaption().equals(s)) continue;
            this.m_panelFuses.setAVR(avr);
            this.fusesChanged();
            break;
        }
    }

    public void fusesChanged() {
        AVR avr = this.m_panelFuses.getAVR();
        if (avr == null) {
            return;
        }
        String s1 = "";
        String s2 = "";
        for (String fuseByte : avr.getUsedFuseBytes()) {
            int data = avr.getFuseByteData(fuseByte);
            s1 = s1 + String.format("%s=%02X ", fuseByte, data);
            s2 = s2 + String.format("-U %s:w:0x%02X:m ", fuseByte, data);
        }
        this.jTextFieldFuses.setText(s1);
        this.jTextFieldCommandLine.setText(s2);
    }
}

