/*
 * Decompiled with CFR 0.152.
 */
package avr8_burn_o_mat;

import avr8_burn_o_mat.Fuse;
import avr8_burn_o_mat.FusesEditor;
import avr8_burn_o_mat.JPanelOscillatorOptions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JPanelOscillatorOptionsATmega48
extends JPanelOscillatorOptions {
    private Fuse.FuseState CKDIV8;
    private Fuse.FuseState CKOUT;
    private Fuse.FuseState[] CKSEL = new Fuse.FuseState[4];
    private Fuse.FuseState[] SUT = new Fuse.FuseState[2];
    private boolean m_fusesAreValid = false;
    private boolean m_preventUpdateFuses = false;
    private ButtonGroup buttonGroupExtClock;
    private ButtonGroup buttonGroupFullSwingStart;
    private ButtonGroup buttonGroupFullSwingType;
    private ButtonGroup buttonGroupIntRc128Osci;
    private ButtonGroup buttonGroupIntRcOsci;
    private ButtonGroup buttonGroupLowFreq;
    private ButtonGroup buttonGroupLowPwrFreq;
    private ButtonGroup buttonGroupLowPwrStart;
    private ButtonGroup buttonGroupLowPwrType;
    private JCheckBox jCheckBoxDivClockBy8;
    private JCheckBox jCheckBoxOutputClock;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel11;
    private JPanel jPanel12;
    private JPanel jPanel13;
    private JPanel jPanel3;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JPanel jPanelExtClock;
    private JPanel jPanelFullSwingXtal;
    private JPanel jPanelIntRcOsci;
    private JPanel jPanelIntRcOsci128kHz;
    private JPanel jPanelLowFreqXtal;
    private JPanel jPanelLowPwrXtal;
    private JRadioButton jRadioButtonExtClockStartBod;
    private JRadioButton jRadioButtonExtClockStartFast;
    private JRadioButton jRadioButtonExtClockStartSlowly;
    private JRadioButton jRadioButtonFullSwingStartBod;
    private JRadioButton jRadioButtonFullSwingStartFast;
    private JRadioButton jRadioButtonFullSwingStartSlowly;
    private JRadioButton jRadioButtonFullSwingTypeCeramic;
    private JRadioButton jRadioButtonFullSwingTypeCrystal;
    private JRadioButton jRadioButtonIntRc128OsciStartBod;
    private JRadioButton jRadioButtonIntRc128OsciStartFast;
    private JRadioButton jRadioButtonIntRc128OsciStartSlowly;
    private JRadioButton jRadioButtonIntRcOsciStartBod;
    private JRadioButton jRadioButtonIntRcOsciStartFast;
    private JRadioButton jRadioButtonIntRcOsciStartSlowly;
    private JRadioButton jRadioButtonLowFreqStartBod;
    private JRadioButton jRadioButtonLowFreqStartFast;
    private JRadioButton jRadioButtonLowFreqStartSlowly;
    private JRadioButton jRadioButtonLowPwrFreq04;
    private JRadioButton jRadioButtonLowPwrFreq09;
    private JRadioButton jRadioButtonLowPwrFreq30;
    private JRadioButton jRadioButtonLowPwrFreq80;
    private JRadioButton jRadioButtonLowPwrStartBod;
    private JRadioButton jRadioButtonLowPwrStartFast;
    private JRadioButton jRadioButtonLowPwrStartSlowly;
    private JRadioButton jRadioButtonLowPwrTypeCeramic;
    private JRadioButton jRadioButtonLowPwrTypeCrystal;
    private JScrollPane jScrollPaneFullSwingXtal;
    private JScrollPane jScrollPaneLowPwrXtal;
    private JTabbedPane jTabbedPaneClockSource;

    public JPanelOscillatorOptionsATmega48(FusesEditor fusesEditor) {
        super(fusesEditor);
        this.initComponents();
        this.addSettingsChangedListener(this.jCheckBoxDivClockBy8);
        this.addSettingsChangedListener(this.jCheckBoxOutputClock);
        this.addSettingsChangedListener(this.jRadioButtonExtClockStartBod);
        this.addSettingsChangedListener(this.jRadioButtonExtClockStartFast);
        this.addSettingsChangedListener(this.jRadioButtonExtClockStartSlowly);
        this.addSettingsChangedListener(this.jRadioButtonFullSwingStartBod);
        this.addSettingsChangedListener(this.jRadioButtonFullSwingStartFast);
        this.addSettingsChangedListener(this.jRadioButtonFullSwingStartSlowly);
        this.addSettingsChangedListener(this.jRadioButtonFullSwingTypeCeramic);
        this.addSettingsChangedListener(this.jRadioButtonFullSwingTypeCrystal);
        this.addSettingsChangedListener(this.jRadioButtonIntRc128OsciStartBod);
        this.addSettingsChangedListener(this.jRadioButtonIntRc128OsciStartFast);
        this.addSettingsChangedListener(this.jRadioButtonIntRc128OsciStartSlowly);
        this.addSettingsChangedListener(this.jRadioButtonIntRcOsciStartBod);
        this.addSettingsChangedListener(this.jRadioButtonIntRcOsciStartFast);
        this.addSettingsChangedListener(this.jRadioButtonIntRcOsciStartSlowly);
        this.addSettingsChangedListener(this.jRadioButtonLowFreqStartBod);
        this.addSettingsChangedListener(this.jRadioButtonLowFreqStartFast);
        this.addSettingsChangedListener(this.jRadioButtonLowFreqStartSlowly);
        this.addSettingsChangedListener(this.jRadioButtonLowPwrFreq04);
        this.addSettingsChangedListener(this.jRadioButtonLowPwrFreq09);
        this.addSettingsChangedListener(this.jRadioButtonLowPwrFreq30);
        this.addSettingsChangedListener(this.jRadioButtonLowPwrFreq80);
        this.addSettingsChangedListener(this.jRadioButtonLowPwrStartBod);
        this.addSettingsChangedListener(this.jRadioButtonLowPwrStartFast);
        this.addSettingsChangedListener(this.jRadioButtonLowPwrStartSlowly);
        this.addSettingsChangedListener(this.jRadioButtonLowPwrTypeCeramic);
        this.addSettingsChangedListener(this.jRadioButtonLowPwrTypeCrystal);
        this.fusesChanged();
    }

    public void fusesChanged() {
        try {
            this.updateGuiFromFuses();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Error fuses changed: " + ex.getMessage());
        }
        this.ensureValidSettings();
    }

    private void ensureValidSettings() {
        if (this.jRadioButtonLowPwrTypeCrystal.isSelected()) {
            if (this.jRadioButtonLowPwrFreq04.isSelected()) {
                this.jRadioButtonLowPwrFreq09.setSelected(true);
            }
            this.jRadioButtonLowPwrFreq04.setEnabled(false);
        } else {
            this.jRadioButtonLowPwrFreq04.setEnabled(true);
        }
    }

    private void loadFuses() throws Exception {
        this.CKDIV8 = this.m_fusesEditor.getFuse("CKDIV8");
        this.CKOUT = this.m_fusesEditor.getFuse("CKOUT");
        this.CKSEL[0] = this.m_fusesEditor.getFuse("CKSEL0");
        this.CKSEL[1] = this.m_fusesEditor.getFuse("CKSEL1");
        this.CKSEL[2] = this.m_fusesEditor.getFuse("CKSEL2");
        this.CKSEL[3] = this.m_fusesEditor.getFuse("CKSEL3");
        this.SUT[0] = this.m_fusesEditor.getFuse("SUT0");
        this.SUT[1] = this.m_fusesEditor.getFuse("SUT1");
        this.m_fusesAreValid = true;
    }

    private void storeFuses() throws Exception {
        if (!this.m_fusesAreValid) {
            return;
        }
        this.m_fusesEditor.setFuse("CKDIV8", this.CKDIV8);
        this.m_fusesEditor.setFuse("CKOUT", this.CKOUT);
        this.m_fusesEditor.setFuse("CKSEL0", this.CKSEL[0]);
        this.m_fusesEditor.setFuse("CKSEL1", this.CKSEL[1]);
        this.m_fusesEditor.setFuse("CKSEL2", this.CKSEL[2]);
        this.m_fusesEditor.setFuse("CKSEL3", this.CKSEL[3]);
        this.m_fusesEditor.setFuse("SUT0", this.SUT[0]);
        this.m_fusesEditor.setFuse("SUT1", this.SUT[1]);
        this.m_fusesEditor.getFusesObservable().fusesChanged(this);
    }

    private void updateFusesFromGui() throws Exception {
        if (!this.m_fusesAreValid || this.m_preventUpdateFuses) {
            return;
        }
        this.ensureValidSettings();
        Component c = this.jTabbedPaneClockSource.getSelectedComponent();
        if (c == this.jPanelIntRcOsci128kHz) {
            this.updateFusesFromGuiIntRcOsci128kHz();
        } else if (c == this.jPanelIntRcOsci) {
            this.updateFusesFromGuiIntRcOsci();
        } else if (c == this.jPanelExtClock) {
            this.updateFusesFromGuiExtClock();
        } else if (c == this.jPanelLowFreqXtal) {
            this.updateFusesFromGuiLowFreqXtal();
        } else if (c == this.jScrollPaneFullSwingXtal) {
            this.updateFusesFromGuiFullSwingXtal();
        } else if (c == this.jScrollPaneLowPwrXtal) {
            this.updateFusesFromGuiLowPwrXtal();
        } else {
            throw new Exception("Internal error: updateFusesFromGui()");
        }
        this.CKDIV8 = this.jCheckBoxDivClockBy8.isSelected() ? this.PROG : this.UNPROG;
        this.CKOUT = this.jCheckBoxOutputClock.isSelected() ? this.PROG : this.UNPROG;
        this.storeFuses();
    }

    private void updateFusesFromGuiIntRcOsci128kHz() throws Exception {
        this.CKSEL[3] = this.PROG;
        this.CKSEL[2] = this.PROG;
        this.CKSEL[1] = this.UNPROG;
        this.CKSEL[0] = this.UNPROG;
        if (this.jRadioButtonIntRc128OsciStartBod.isSelected()) {
            this.SUT[1] = this.PROG;
            this.SUT[0] = this.PROG;
        } else if (this.jRadioButtonIntRc128OsciStartFast.isSelected()) {
            this.SUT[1] = this.PROG;
            this.SUT[0] = this.UNPROG;
        } else if (this.jRadioButtonIntRc128OsciStartSlowly.isSelected()) {
            this.SUT[1] = this.UNPROG;
            this.SUT[0] = this.PROG;
        } else {
            throw new Exception("Internal error: updateFusesFromGuiIntRcOsci128kHz()");
        }
    }

    private void updateFusesFromGuiIntRcOsci() throws Exception {
        this.CKSEL[3] = this.PROG;
        this.CKSEL[2] = this.PROG;
        this.CKSEL[1] = this.UNPROG;
        this.CKSEL[0] = this.PROG;
        if (this.jRadioButtonIntRcOsciStartBod.isSelected()) {
            this.SUT[1] = this.PROG;
            this.SUT[0] = this.PROG;
        } else if (this.jRadioButtonIntRcOsciStartFast.isSelected()) {
            this.SUT[1] = this.PROG;
            this.SUT[0] = this.UNPROG;
        } else if (this.jRadioButtonIntRcOsciStartSlowly.isSelected()) {
            this.SUT[1] = this.UNPROG;
            this.SUT[0] = this.PROG;
        } else {
            throw new Exception("Internal error: updateFusesFromGuiIntRcOsci()");
        }
    }

    private void updateFusesFromGuiExtClock() throws Exception {
        this.CKSEL[3] = this.PROG;
        this.CKSEL[2] = this.PROG;
        this.CKSEL[1] = this.PROG;
        this.CKSEL[0] = this.PROG;
        if (this.jRadioButtonIntRcOsciStartBod.isSelected()) {
            this.SUT[1] = this.PROG;
            this.SUT[0] = this.PROG;
        } else if (this.jRadioButtonIntRcOsciStartFast.isSelected()) {
            this.SUT[1] = this.PROG;
            this.SUT[0] = this.UNPROG;
        } else if (this.jRadioButtonIntRcOsciStartSlowly.isSelected()) {
            this.SUT[1] = this.UNPROG;
            this.SUT[0] = this.PROG;
        } else {
            throw new Exception("Internal error: updateFusesFromGuiExtClock()");
        }
    }

    private void updateFusesFromGuiLowFreqXtal() throws Exception {
        this.CKSEL[3] = this.PROG;
        this.CKSEL[2] = this.UNPROG;
        this.CKSEL[1] = this.PROG;
        this.CKSEL[0] = this.UNPROG;
        if (this.jRadioButtonIntRcOsciStartBod.isSelected()) {
            this.SUT[1] = this.PROG;
            this.SUT[0] = this.PROG;
        } else if (this.jRadioButtonIntRcOsciStartFast.isSelected()) {
            this.SUT[1] = this.PROG;
            this.SUT[0] = this.UNPROG;
        } else if (this.jRadioButtonIntRcOsciStartSlowly.isSelected()) {
            this.SUT[1] = this.UNPROG;
            this.SUT[0] = this.PROG;
        } else {
            throw new Exception("Internal error: updateFusesFromGuiLowFreqXtal()");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateFusesFromGuiFullSwingXtal() throws Exception {
        this.CKSEL[3] = this.PROG;
        this.CKSEL[2] = this.UNPROG;
        this.CKSEL[1] = this.UNPROG;
        if (this.jRadioButtonFullSwingTypeCrystal.isSelected()) {
            this.CKSEL[0] = this.UNPROG;
            if (this.jRadioButtonFullSwingStartBod.isSelected()) {
                this.SUT[1] = this.PROG;
                this.SUT[0] = this.UNPROG;
                return;
            } else if (this.jRadioButtonFullSwingStartFast.isSelected()) {
                this.SUT[1] = this.UNPROG;
                this.SUT[0] = this.PROG;
                return;
            } else {
                if (!this.jRadioButtonFullSwingStartSlowly.isSelected()) throw new Exception("Internal error: updateFusesFromGuiFullSwingXtal()");
                this.SUT[1] = this.UNPROG;
                this.SUT[0] = this.UNPROG;
            }
            return;
        } else {
            if (!this.jRadioButtonFullSwingTypeCeramic.isSelected()) throw new Exception("Internal error: updateFusesFromGuiFullSwingXtal()");
            if (this.jRadioButtonFullSwingStartBod.isSelected()) {
                this.CKSEL[0] = this.PROG;
                this.SUT[1] = this.UNPROG;
                this.SUT[0] = this.PROG;
                return;
            } else if (this.jRadioButtonFullSwingStartFast.isSelected()) {
                this.CKSEL[0] = this.PROG;
                this.SUT[1] = this.UNPROG;
                this.SUT[0] = this.UNPROG;
                return;
            } else {
                if (!this.jRadioButtonFullSwingStartSlowly.isSelected()) throw new Exception("Internal error: updateFusesFromGuiFullSwingXtal()");
                this.CKSEL[0] = this.UNPROG;
                this.SUT[1] = this.PROG;
                this.SUT[0] = this.PROG;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateFusesFromGuiLowPwrXtal() throws Exception {
        if (this.jRadioButtonLowPwrFreq04.isSelected()) {
            this.CKSEL[3] = this.UNPROG;
            this.CKSEL[2] = this.PROG;
            this.CKSEL[1] = this.PROG;
        } else if (this.jRadioButtonLowPwrFreq09.isSelected()) {
            this.CKSEL[3] = this.UNPROG;
            this.CKSEL[2] = this.PROG;
            this.CKSEL[1] = this.UNPROG;
        } else if (this.jRadioButtonLowPwrFreq30.isSelected()) {
            this.CKSEL[3] = this.UNPROG;
            this.CKSEL[2] = this.UNPROG;
            this.CKSEL[1] = this.PROG;
        } else {
            if (!this.jRadioButtonLowPwrFreq80.isSelected()) throw new Exception("Internal error: updateFusesFromGuiLowPwrXtal()");
            this.CKSEL[3] = this.UNPROG;
            this.CKSEL[2] = this.UNPROG;
            this.CKSEL[1] = this.UNPROG;
        }
        if (this.jRadioButtonLowPwrTypeCrystal.isSelected()) {
            this.CKSEL[0] = this.UNPROG;
            if (this.jRadioButtonLowPwrStartBod.isSelected()) {
                this.SUT[1] = this.PROG;
                this.SUT[0] = this.UNPROG;
                return;
            } else if (this.jRadioButtonLowPwrStartFast.isSelected()) {
                this.SUT[1] = this.UNPROG;
                this.SUT[0] = this.PROG;
                return;
            } else {
                if (!this.jRadioButtonLowPwrStartSlowly.isSelected()) throw new Exception("Internal error: updateFusesFromGuiLowPwrXtal()");
                this.SUT[1] = this.UNPROG;
                this.SUT[0] = this.UNPROG;
            }
            return;
        } else {
            if (!this.jRadioButtonLowPwrTypeCeramic.isSelected()) throw new Exception("Internal error: updateFusesFromGuiLowPwrXtal()");
            if (this.jRadioButtonLowPwrStartBod.isSelected()) {
                this.CKSEL[0] = this.PROG;
                this.SUT[1] = this.UNPROG;
                this.SUT[0] = this.PROG;
                return;
            } else if (this.jRadioButtonLowPwrStartFast.isSelected()) {
                this.CKSEL[0] = this.PROG;
                this.SUT[1] = this.UNPROG;
                this.SUT[0] = this.UNPROG;
                return;
            } else {
                if (!this.jRadioButtonLowPwrStartSlowly.isSelected()) throw new Exception("Internal error: updateFusesFromGuiLowPwrXtal()");
                this.CKSEL[0] = this.UNPROG;
                this.SUT[1] = this.PROG;
                this.SUT[0] = this.PROG;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void updateGuiFromFuses() throws Exception {
        this.m_preventUpdateFuses = true;
        try {
            this.loadFuses();
            switch (this.getFusesInt(this.CKSEL)) {
                case 0: {
                    this.updateGuiFromFusesExtClock();
                    ** break;
lbl8:
                    // 1 sources

                    break;
                }
                case 1: 
                case 2: {
                    this.updateGuiFromFusesIntRcOsci();
                    ** break;
lbl12:
                    // 1 sources

                    break;
                }
                case 3: {
                    this.updateGuiFromFusesIntRcOsci128kHz();
                    ** break;
lbl16:
                    // 1 sources

                    break;
                }
                case 4: 
                case 5: {
                    this.updateGuiFromFusesLowFreqXtal();
                    ** break;
lbl20:
                    // 1 sources

                    break;
                }
                case 6: 
                case 7: {
                    this.updateGuiFromFusesFullSwingXtal();
                    ** break;
lbl24:
                    // 1 sources

                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    this.updateGuiFromFusesLowPwrXtal();
                    ** break;
lbl28:
                    // 1 sources

                    break;
                }
                default: {
                    throw new Exception("Internal error: updateGuiFromFuses()");
                }
            }
        }
        finally {
            this.m_preventUpdateFuses = false;
        }
        this.jCheckBoxDivClockBy8.setSelected(this.CKDIV8 == this.PROG);
        this.jCheckBoxOutputClock.setSelected(this.CKOUT == this.PROG);
        this.ensureValidSettings();
    }

    private void updateGuiFromFusesIntRcOsci128kHz() throws Exception {
        this.jTabbedPaneClockSource.setSelectedComponent(this.jPanelIntRcOsci128kHz);
        switch (this.getFusesInt(this.SUT)) {
            case 0: {
                this.jRadioButtonIntRc128OsciStartBod.setSelected(true);
                break;
            }
            case 1: {
                this.jRadioButtonIntRc128OsciStartFast.setSelected(true);
                break;
            }
            default: {
                this.jRadioButtonIntRc128OsciStartSlowly.setSelected(true);
            }
        }
    }

    private void updateGuiFromFusesIntRcOsci() throws Exception {
        this.jTabbedPaneClockSource.setSelectedComponent(this.jPanelIntRcOsci);
        switch (this.getFusesInt(this.SUT)) {
            case 0: {
                this.jRadioButtonIntRcOsciStartBod.setSelected(true);
                break;
            }
            case 1: {
                this.jRadioButtonIntRcOsciStartFast.setSelected(true);
                break;
            }
            default: {
                this.jRadioButtonIntRcOsciStartSlowly.setSelected(true);
            }
        }
    }

    private void updateGuiFromFusesExtClock() throws Exception {
        this.jTabbedPaneClockSource.setSelectedComponent(this.jPanelExtClock);
        switch (this.getFusesInt(this.SUT)) {
            case 0: {
                this.jRadioButtonExtClockStartBod.setSelected(true);
                break;
            }
            case 1: {
                this.jRadioButtonExtClockStartFast.setSelected(true);
                break;
            }
            default: {
                this.jRadioButtonExtClockStartSlowly.setSelected(true);
            }
        }
    }

    private void updateGuiFromFusesLowFreqXtal() throws Exception {
        this.jTabbedPaneClockSource.setSelectedComponent(this.jPanelLowFreqXtal);
        switch (this.getFusesInt(this.SUT)) {
            case 0: {
                this.jRadioButtonLowFreqStartBod.setSelected(true);
                break;
            }
            case 1: {
                this.jRadioButtonLowFreqStartFast.setSelected(true);
                break;
            }
            default: {
                this.jRadioButtonLowFreqStartSlowly.setSelected(true);
            }
        }
    }

    private void updateGuiFromFusesFullSwingXtal() throws Exception {
        this.jTabbedPaneClockSource.setSelectedComponent(this.jScrollPaneFullSwingXtal);
        int i = this.getFusesInt(this.SUT) | (this.getFusesInt(this.CKSEL) & 1) << 2;
        if (i >= 0 && i <= 4) {
            this.jRadioButtonFullSwingTypeCeramic.setSelected(true);
        } else if (i >= 5 && i <= 7) {
            this.jRadioButtonFullSwingTypeCrystal.setSelected(true);
        } else {
            throw new Exception("Internal error: updateGuiFromFusesFullSwingXtal()");
        }
        switch (i) {
            case 2: 
            case 5: {
                this.jRadioButtonFullSwingStartBod.setSelected(true);
                break;
            }
            case 0: 
            case 3: 
            case 6: {
                this.jRadioButtonFullSwingStartFast.setSelected(true);
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                this.jRadioButtonFullSwingStartSlowly.setSelected(true);
                break;
            }
            default: {
                throw new Exception("Internal error: updateGuiFromFusesFullSwingXtal()");
            }
        }
    }

    private void updateGuiFromFusesLowPwrXtal() throws Exception {
        this.jTabbedPaneClockSource.setSelectedComponent(this.jScrollPaneLowPwrXtal);
        int i = this.getFusesInt(this.SUT) | (this.getFusesInt(this.CKSEL) & 1) << 2;
        if (i >= 0 && i <= 4) {
            this.jRadioButtonLowPwrTypeCeramic.setSelected(true);
        } else if (i >= 5 && i <= 7) {
            this.jRadioButtonLowPwrTypeCrystal.setSelected(true);
        } else {
            throw new Exception("Internal error: updateGuiFromFusesLowPwrXtal()");
        }
        switch (i) {
            case 2: 
            case 5: {
                this.jRadioButtonLowPwrStartBod.setSelected(true);
                break;
            }
            case 0: 
            case 3: 
            case 6: {
                this.jRadioButtonLowPwrStartFast.setSelected(true);
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                this.jRadioButtonLowPwrStartSlowly.setSelected(true);
                break;
            }
            default: {
                throw new Exception("Internal error: updateGuiFromFusesLowPwrXtal()");
            }
        }
        i = this.getFusesInt(this.CKSEL) >> 1;
        switch (i) {
            case 4: {
                this.jRadioButtonLowPwrFreq04.setSelected(true);
                break;
            }
            case 5: {
                this.jRadioButtonLowPwrFreq09.setSelected(true);
                break;
            }
            case 6: {
                this.jRadioButtonLowPwrFreq30.setSelected(true);
                break;
            }
            case 7: {
                this.jRadioButtonLowPwrFreq80.setSelected(true);
                break;
            }
            default: {
                throw new Exception("Internal error: updateGuiFromFusesLowPwrXtal()");
            }
        }
    }

    private void settingsChanged() {
        try {
            this.updateFusesFromGui();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Error update fuses: " + ex.getMessage());
        }
    }

    private void addSettingsChangedListener(AbstractButton bttn) {
        bttn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPanelOscillatorOptionsATmega48.this.settingsChanged();
            }
        });
    }

    private void initComponents() {
        this.buttonGroupIntRc128Osci = new ButtonGroup();
        this.buttonGroupIntRcOsci = new ButtonGroup();
        this.buttonGroupExtClock = new ButtonGroup();
        this.buttonGroupLowFreq = new ButtonGroup();
        this.buttonGroupFullSwingType = new ButtonGroup();
        this.buttonGroupFullSwingStart = new ButtonGroup();
        this.buttonGroupLowPwrType = new ButtonGroup();
        this.buttonGroupLowPwrFreq = new ButtonGroup();
        this.buttonGroupLowPwrStart = new ButtonGroup();
        this.jTabbedPaneClockSource = new JTabbedPane();
        this.jPanelIntRcOsci128kHz = new JPanel();
        this.jPanel3 = new JPanel();
        this.jRadioButtonIntRc128OsciStartFast = new JRadioButton();
        this.jRadioButtonIntRc128OsciStartSlowly = new JRadioButton();
        this.jRadioButtonIntRc128OsciStartBod = new JRadioButton();
        this.jLabel3 = new JLabel();
        this.jPanelIntRcOsci = new JPanel();
        this.jPanel5 = new JPanel();
        this.jRadioButtonIntRcOsciStartFast = new JRadioButton();
        this.jRadioButtonIntRcOsciStartSlowly = new JRadioButton();
        this.jRadioButtonIntRcOsciStartBod = new JRadioButton();
        this.jLabel2 = new JLabel();
        this.jPanelExtClock = new JPanel();
        this.jPanel6 = new JPanel();
        this.jRadioButtonExtClockStartFast = new JRadioButton();
        this.jRadioButtonExtClockStartSlowly = new JRadioButton();
        this.jRadioButtonExtClockStartBod = new JRadioButton();
        this.jLabel6 = new JLabel();
        this.jPanelLowFreqXtal = new JPanel();
        this.jPanel13 = new JPanel();
        this.jRadioButtonLowFreqStartFast = new JRadioButton();
        this.jRadioButtonLowFreqStartSlowly = new JRadioButton();
        this.jRadioButtonLowFreqStartBod = new JRadioButton();
        this.jLabel1 = new JLabel();
        this.jScrollPaneFullSwingXtal = new JScrollPane();
        this.jPanelFullSwingXtal = new JPanel();
        this.jPanel11 = new JPanel();
        this.jRadioButtonFullSwingTypeCrystal = new JRadioButton();
        this.jRadioButtonFullSwingTypeCeramic = new JRadioButton();
        this.jPanel12 = new JPanel();
        this.jRadioButtonFullSwingStartFast = new JRadioButton();
        this.jRadioButtonFullSwingStartSlowly = new JRadioButton();
        this.jRadioButtonFullSwingStartBod = new JRadioButton();
        this.jLabel4 = new JLabel();
        this.jScrollPaneLowPwrXtal = new JScrollPane();
        this.jPanelLowPwrXtal = new JPanel();
        this.jPanel9 = new JPanel();
        this.jRadioButtonLowPwrFreq04 = new JRadioButton();
        this.jRadioButtonLowPwrFreq09 = new JRadioButton();
        this.jRadioButtonLowPwrFreq30 = new JRadioButton();
        this.jRadioButtonLowPwrFreq80 = new JRadioButton();
        this.jPanel8 = new JPanel();
        this.jRadioButtonLowPwrTypeCrystal = new JRadioButton();
        this.jRadioButtonLowPwrTypeCeramic = new JRadioButton();
        this.jPanel10 = new JPanel();
        this.jRadioButtonLowPwrStartFast = new JRadioButton();
        this.jRadioButtonLowPwrStartSlowly = new JRadioButton();
        this.jRadioButtonLowPwrStartBod = new JRadioButton();
        this.jLabel5 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jCheckBoxDivClockBy8 = new JCheckBox();
        this.jCheckBoxOutputClock = new JCheckBox();
        this.setLayout(new BorderLayout());
        this.jTabbedPaneClockSource.setPreferredSize(new Dimension(220, 160));
        this.jTabbedPaneClockSource.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                JPanelOscillatorOptionsATmega48.this.jTabbedPaneClockSourceStateChanged(evt);
            }
        });
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Start-up time"));
        this.buttonGroupIntRc128Osci.add(this.jRadioButtonIntRc128OsciStartFast);
        this.jRadioButtonIntRc128OsciStartFast.setText("fast rising power");
        this.buttonGroupIntRc128Osci.add(this.jRadioButtonIntRc128OsciStartSlowly);
        this.jRadioButtonIntRc128OsciStartSlowly.setSelected(true);
        this.jRadioButtonIntRc128OsciStartSlowly.setText("slowly rising power");
        this.buttonGroupIntRc128Osci.add(this.jRadioButtonIntRc128OsciStartBod);
        this.jRadioButtonIntRc128OsciStartBod.setText("brown out detection enabled");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonIntRc128OsciStartFast).addComponent(this.jRadioButtonIntRc128OsciStartSlowly).addComponent(this.jRadioButtonIntRc128OsciStartBod)).addContainerGap(407, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jRadioButtonIntRc128OsciStartFast).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonIntRc128OsciStartSlowly).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonIntRc128OsciStartBod)));
        this.jLabel3.setFont(new Font("DejaVu Sans", 0, 14));
        this.jLabel3.setText("128kHz internal low power oscillator");
        GroupLayout jPanelIntRcOsci128kHzLayout = new GroupLayout(this.jPanelIntRcOsci128kHz);
        this.jPanelIntRcOsci128kHz.setLayout(jPanelIntRcOsci128kHzLayout);
        jPanelIntRcOsci128kHzLayout.setHorizontalGroup(jPanelIntRcOsci128kHzLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelIntRcOsci128kHzLayout.createSequentialGroup().addContainerGap().addGroup(jPanelIntRcOsci128kHzLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jPanel3, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanelIntRcOsci128kHzLayout.setVerticalGroup(jPanelIntRcOsci128kHzLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelIntRcOsci128kHzLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3).addGap(18, 18, 18).addComponent(this.jPanel3, -2, -1, -2).addContainerGap(301, Short.MAX_VALUE)));
        this.jTabbedPaneClockSource.addTab("Internal 128kHz RC oscillator", this.jPanelIntRcOsci128kHz);
        this.jPanel5.setBorder(BorderFactory.createTitledBorder("Start-up time"));
        this.buttonGroupIntRcOsci.add(this.jRadioButtonIntRcOsciStartFast);
        this.jRadioButtonIntRcOsciStartFast.setText("fast rising power");
        this.buttonGroupIntRcOsci.add(this.jRadioButtonIntRcOsciStartSlowly);
        this.jRadioButtonIntRcOsciStartSlowly.setSelected(true);
        this.jRadioButtonIntRcOsciStartSlowly.setText("slowly rising power");
        this.buttonGroupIntRcOsci.add(this.jRadioButtonIntRcOsciStartBod);
        this.jRadioButtonIntRcOsciStartBod.setText("brown out detection enabled");
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonIntRcOsciStartFast).addComponent(this.jRadioButtonIntRcOsciStartSlowly).addComponent(this.jRadioButtonIntRcOsciStartBod)).addContainerGap(407, Short.MAX_VALUE)));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.jRadioButtonIntRcOsciStartFast).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonIntRcOsciStartSlowly).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonIntRcOsciStartBod)));
        this.jLabel2.setFont(new Font("DejaVu Sans", 0, 14));
        this.jLabel2.setText("8.0MHz calibrated internal RC oscillator");
        GroupLayout jPanelIntRcOsciLayout = new GroupLayout(this.jPanelIntRcOsci);
        this.jPanelIntRcOsci.setLayout(jPanelIntRcOsciLayout);
        jPanelIntRcOsciLayout.setHorizontalGroup(jPanelIntRcOsciLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelIntRcOsciLayout.createSequentialGroup().addContainerGap().addGroup(jPanelIntRcOsciLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jPanel5, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanelIntRcOsciLayout.setVerticalGroup(jPanelIntRcOsciLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelIntRcOsciLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addGap(18, 18, 18).addComponent(this.jPanel5, -2, -1, -2).addContainerGap(301, Short.MAX_VALUE)));
        this.jTabbedPaneClockSource.addTab("Calibrated internal RC oscillator", this.jPanelIntRcOsci);
        this.jPanel6.setBorder(BorderFactory.createTitledBorder("Start-up time"));
        this.buttonGroupExtClock.add(this.jRadioButtonExtClockStartFast);
        this.jRadioButtonExtClockStartFast.setText("fast rising power");
        this.buttonGroupExtClock.add(this.jRadioButtonExtClockStartSlowly);
        this.jRadioButtonExtClockStartSlowly.setSelected(true);
        this.jRadioButtonExtClockStartSlowly.setText("slowly rising power");
        this.buttonGroupExtClock.add(this.jRadioButtonExtClockStartBod);
        this.jRadioButtonExtClockStartBod.setText("brown out detection enabled");
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonExtClockStartFast).addComponent(this.jRadioButtonExtClockStartSlowly).addComponent(this.jRadioButtonExtClockStartBod)).addContainerGap(407, Short.MAX_VALUE)));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.jRadioButtonExtClockStartFast).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonExtClockStartSlowly).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonExtClockStartBod)));
        this.jLabel6.setFont(new Font("DejaVu Sans", 0, 14));
        this.jLabel6.setText("0MHz - 20MHz external clock");
        GroupLayout jPanelExtClockLayout = new GroupLayout(this.jPanelExtClock);
        this.jPanelExtClock.setLayout(jPanelExtClockLayout);
        jPanelExtClockLayout.setHorizontalGroup(jPanelExtClockLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelExtClockLayout.createSequentialGroup().addContainerGap().addGroup(jPanelExtClockLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addComponent(this.jPanel6, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanelExtClockLayout.setVerticalGroup(jPanelExtClockLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelExtClockLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel6).addGap(18, 18, 18).addComponent(this.jPanel6, -2, -1, -2).addContainerGap(301, Short.MAX_VALUE)));
        this.jTabbedPaneClockSource.addTab("External clock", this.jPanelExtClock);
        this.jPanel13.setBorder(BorderFactory.createTitledBorder("Start-up time"));
        this.buttonGroupLowFreq.add(this.jRadioButtonLowFreqStartFast);
        this.jRadioButtonLowFreqStartFast.setText("fast rising power");
        this.buttonGroupLowFreq.add(this.jRadioButtonLowFreqStartSlowly);
        this.jRadioButtonLowFreqStartSlowly.setSelected(true);
        this.jRadioButtonLowFreqStartSlowly.setText("slowly rising power");
        this.buttonGroupLowFreq.add(this.jRadioButtonLowFreqStartBod);
        this.jRadioButtonLowFreqStartBod.setText("brown out detection enabled");
        GroupLayout jPanel13Layout = new GroupLayout(this.jPanel13);
        this.jPanel13.setLayout(jPanel13Layout);
        jPanel13Layout.setHorizontalGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel13Layout.createSequentialGroup().addContainerGap().addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonLowFreqStartFast).addComponent(this.jRadioButtonLowFreqStartSlowly).addComponent(this.jRadioButtonLowFreqStartBod)).addContainerGap(407, Short.MAX_VALUE)));
        jPanel13Layout.setVerticalGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel13Layout.createSequentialGroup().addComponent(this.jRadioButtonLowFreqStartFast).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonLowFreqStartSlowly).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonLowFreqStartBod).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel1.setFont(new Font("DejaVu Sans", 0, 14));
        this.jLabel1.setText("32.768kHz watch crystal");
        GroupLayout jPanelLowFreqXtalLayout = new GroupLayout(this.jPanelLowFreqXtal);
        this.jPanelLowFreqXtal.setLayout(jPanelLowFreqXtalLayout);
        jPanelLowFreqXtalLayout.setHorizontalGroup(jPanelLowFreqXtalLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelLowFreqXtalLayout.createSequentialGroup().addContainerGap().addGroup(jPanelLowFreqXtalLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel13, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1)).addContainerGap()));
        jPanelLowFreqXtalLayout.setVerticalGroup(jPanelLowFreqXtalLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelLowFreqXtalLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addGap(18, 18, 18).addComponent(this.jPanel13, -2, -1, -2).addContainerGap(289, Short.MAX_VALUE)));
        this.jTabbedPaneClockSource.addTab("Low frequency crystal oscillator", this.jPanelLowFreqXtal);
        this.jPanel11.setBorder(BorderFactory.createTitledBorder("Type"));
        this.buttonGroupFullSwingType.add(this.jRadioButtonFullSwingTypeCrystal);
        this.jRadioButtonFullSwingTypeCrystal.setSelected(true);
        this.jRadioButtonFullSwingTypeCrystal.setText("crystal");
        this.buttonGroupFullSwingType.add(this.jRadioButtonFullSwingTypeCeramic);
        this.jRadioButtonFullSwingTypeCeramic.setText("ceramic resonator");
        GroupLayout jPanel11Layout = new GroupLayout(this.jPanel11);
        this.jPanel11.setLayout(jPanel11Layout);
        jPanel11Layout.setHorizontalGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel11Layout.createSequentialGroup().addContainerGap().addGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonFullSwingTypeCrystal).addComponent(this.jRadioButtonFullSwingTypeCeramic)).addContainerGap(472, Short.MAX_VALUE)));
        jPanel11Layout.setVerticalGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel11Layout.createSequentialGroup().addComponent(this.jRadioButtonFullSwingTypeCrystal).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonFullSwingTypeCeramic)));
        this.jPanel12.setBorder(BorderFactory.createTitledBorder("Start-up time"));
        this.buttonGroupFullSwingStart.add(this.jRadioButtonFullSwingStartFast);
        this.jRadioButtonFullSwingStartFast.setText("fast rising power");
        this.buttonGroupFullSwingStart.add(this.jRadioButtonFullSwingStartSlowly);
        this.jRadioButtonFullSwingStartSlowly.setSelected(true);
        this.jRadioButtonFullSwingStartSlowly.setText("slowly rising power");
        this.buttonGroupFullSwingStart.add(this.jRadioButtonFullSwingStartBod);
        this.jRadioButtonFullSwingStartBod.setText("brown out detection enabled");
        GroupLayout jPanel12Layout = new GroupLayout(this.jPanel12);
        this.jPanel12.setLayout(jPanel12Layout);
        jPanel12Layout.setHorizontalGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel12Layout.createSequentialGroup().addContainerGap().addGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonFullSwingStartFast).addComponent(this.jRadioButtonFullSwingStartSlowly).addComponent(this.jRadioButtonFullSwingStartBod)).addContainerGap(407, Short.MAX_VALUE)));
        jPanel12Layout.setVerticalGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel12Layout.createSequentialGroup().addComponent(this.jRadioButtonFullSwingStartFast).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonFullSwingStartSlowly).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonFullSwingStartBod).addContainerGap()));
        this.jLabel4.setFont(new Font("DejaVu Sans", 0, 14));
        this.jLabel4.setText("0.4MHz - 20MHz full swing crystal/ceramic resonator oscillator");
        GroupLayout jPanelFullSwingXtalLayout = new GroupLayout(this.jPanelFullSwingXtal);
        this.jPanelFullSwingXtal.setLayout(jPanelFullSwingXtalLayout);
        jPanelFullSwingXtalLayout.setHorizontalGroup(jPanelFullSwingXtalLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelFullSwingXtalLayout.createSequentialGroup().addContainerGap().addGroup(jPanelFullSwingXtalLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel12, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel4).addComponent(this.jPanel11, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanelFullSwingXtalLayout.setVerticalGroup(jPanelFullSwingXtalLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelFullSwingXtalLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel4).addGap(18, 18, 18).addComponent(this.jPanel11, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jPanel12, -2, -1, -2).addContainerGap(192, Short.MAX_VALUE)));
        this.jScrollPaneFullSwingXtal.setViewportView(this.jPanelFullSwingXtal);
        this.jTabbedPaneClockSource.addTab("Full swing crystal oscillator", this.jScrollPaneFullSwingXtal);
        this.jPanel9.setBorder(BorderFactory.createTitledBorder("Frequency range"));
        this.buttonGroupLowPwrFreq.add(this.jRadioButtonLowPwrFreq04);
        this.jRadioButtonLowPwrFreq04.setText("0.4MHz - 0.9MHz (for ceramic resonators only!)");
        this.buttonGroupLowPwrFreq.add(this.jRadioButtonLowPwrFreq09);
        this.jRadioButtonLowPwrFreq09.setText("0.9MHz - 3.0MHz");
        this.buttonGroupLowPwrFreq.add(this.jRadioButtonLowPwrFreq30);
        this.jRadioButtonLowPwrFreq30.setSelected(true);
        this.jRadioButtonLowPwrFreq30.setText("3.0MHz - 8.0MHz");
        this.buttonGroupLowPwrFreq.add(this.jRadioButtonLowPwrFreq80);
        this.jRadioButtonLowPwrFreq80.setText("8.0MHz - 16.0MHz");
        GroupLayout jPanel9Layout = new GroupLayout(this.jPanel9);
        this.jPanel9.setLayout(jPanel9Layout);
        jPanel9Layout.setHorizontalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel9Layout.createSequentialGroup().addContainerGap().addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonLowPwrFreq04).addComponent(this.jRadioButtonLowPwrFreq09).addComponent(this.jRadioButtonLowPwrFreq30).addComponent(this.jRadioButtonLowPwrFreq80)).addContainerGap(286, Short.MAX_VALUE)));
        jPanel9Layout.setVerticalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel9Layout.createSequentialGroup().addComponent(this.jRadioButtonLowPwrFreq04).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonLowPwrFreq09).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonLowPwrFreq30).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonLowPwrFreq80)));
        this.jPanel8.setBorder(BorderFactory.createTitledBorder("Type"));
        this.buttonGroupLowPwrType.add(this.jRadioButtonLowPwrTypeCrystal);
        this.jRadioButtonLowPwrTypeCrystal.setSelected(true);
        this.jRadioButtonLowPwrTypeCrystal.setText("crystal");
        this.buttonGroupLowPwrType.add(this.jRadioButtonLowPwrTypeCeramic);
        this.jRadioButtonLowPwrTypeCeramic.setText("ceramic resonator");
        GroupLayout jPanel8Layout = new GroupLayout(this.jPanel8);
        this.jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addContainerGap().addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonLowPwrTypeCrystal).addComponent(this.jRadioButtonLowPwrTypeCeramic)).addContainerGap(472, Short.MAX_VALUE)));
        jPanel8Layout.setVerticalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addComponent(this.jRadioButtonLowPwrTypeCrystal).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonLowPwrTypeCeramic)));
        this.jPanel10.setBorder(BorderFactory.createTitledBorder("Start-up time"));
        this.buttonGroupLowPwrStart.add(this.jRadioButtonLowPwrStartFast);
        this.jRadioButtonLowPwrStartFast.setText("fast rising power");
        this.buttonGroupLowPwrStart.add(this.jRadioButtonLowPwrStartSlowly);
        this.jRadioButtonLowPwrStartSlowly.setSelected(true);
        this.jRadioButtonLowPwrStartSlowly.setText("slowly rising power");
        this.buttonGroupLowPwrStart.add(this.jRadioButtonLowPwrStartBod);
        this.jRadioButtonLowPwrStartBod.setText("brown out detection enabled");
        GroupLayout jPanel10Layout = new GroupLayout(this.jPanel10);
        this.jPanel10.setLayout(jPanel10Layout);
        jPanel10Layout.setHorizontalGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel10Layout.createSequentialGroup().addContainerGap().addGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonLowPwrStartFast).addComponent(this.jRadioButtonLowPwrStartSlowly).addComponent(this.jRadioButtonLowPwrStartBod)).addContainerGap(407, Short.MAX_VALUE)));
        jPanel10Layout.setVerticalGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel10Layout.createSequentialGroup().addComponent(this.jRadioButtonLowPwrStartFast).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonLowPwrStartSlowly).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonLowPwrStartBod).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel5.setFont(new Font("DejaVu Sans", 0, 14));
        this.jLabel5.setText("0.4MHz - 20MHz low power crystal/ceramic resonator oscillator");
        GroupLayout jPanelLowPwrXtalLayout = new GroupLayout(this.jPanelLowPwrXtal);
        this.jPanelLowPwrXtal.setLayout(jPanelLowPwrXtalLayout);
        jPanelLowPwrXtalLayout.setHorizontalGroup(jPanelLowPwrXtalLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelLowPwrXtalLayout.createSequentialGroup().addContainerGap().addGroup(jPanelLowPwrXtalLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel10, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel5).addComponent(this.jPanel8, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel9, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanelLowPwrXtalLayout.setVerticalGroup(jPanelLowPwrXtalLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelLowPwrXtalLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel5).addGap(18, 18, 18).addComponent(this.jPanel8, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jPanel9, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jPanel10, -2, -1, -2).addContainerGap(43, Short.MAX_VALUE)));
        this.jScrollPaneLowPwrXtal.setViewportView(this.jPanelLowPwrXtal);
        this.jTabbedPaneClockSource.addTab("Low power crystal oscillator", this.jScrollPaneLowPwrXtal);
        this.add((Component)this.jTabbedPaneClockSource, "Center");
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel1.setPreferredSize(new Dimension(100, 80));
        this.jCheckBoxDivClockBy8.setText("divide system clock by 8");
        this.jCheckBoxOutputClock.setText("output system clock on pin CLKO (pin PB0)");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxDivClockBy8).addComponent(this.jCheckBoxOutputClock)).addContainerGap(357, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxDivClockBy8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxOutputClock).addContainerGap(14, Short.MAX_VALUE)));
        this.add((Component)this.jPanel1, "North");
    }

    private void jTabbedPaneClockSourceStateChanged(ChangeEvent evt) {
        this.settingsChanged();
    }
}

