/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.lafwidget.tabbed;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JTabbedPane;
import javax.swing.JWindow;
import org.jvnet.lafwidget.LafWidgetUtilities;
import org.jvnet.lafwidget.tabbed.TabPreviewControl;
import org.jvnet.lafwidget.tabbed.TabPreviewPainter;
import org.jvnet.lafwidget.tabbed.TabPreviewThread;

public class TabPagerManager {
    protected static TabPagerManager instance;
    protected JTabbedPane currTabbedPane;
    protected int currTabIndex;
    protected JWindow prevTabWindow;
    protected JWindow currTabWindow;
    protected JWindow nextTabWindow;
    protected boolean isVisible;

    public static synchronized TabPagerManager getPager() {
        if (instance == null) {
            instance = new TabPagerManager();
        }
        return instance;
    }

    private TabPagerManager() {
        Rectangle virtualBounds = new Rectangle();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gds = ge.getScreenDevices();
        for (int i = 0; i < gds.length; ++i) {
            GraphicsDevice gd = gds[i];
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            virtualBounds = virtualBounds.union(gc.getBounds());
        }
        int screenWidth = virtualBounds.width;
        int screenHeight = virtualBounds.height;
        this.currTabWindow = new JWindow();
        this.currTabWindow.getContentPane().setLayout(new BorderLayout());
        int currWidth = screenWidth / 3;
        int currHeight = screenHeight / 3;
        this.currTabWindow.setSize(currWidth, currHeight);
        this.currTabWindow.setLocation(currWidth, currHeight);
        int smallWidth = 2 * screenWidth / 9;
        int smallHeight = 2 * screenHeight / 9;
        this.prevTabWindow = new JWindow();
        this.prevTabWindow.getContentPane().setLayout(new BorderLayout());
        this.prevTabWindow.setSize(smallWidth, smallHeight);
        this.prevTabWindow.setLocation(screenWidth / 18, 7 * screenHeight / 18);
        this.nextTabWindow = new JWindow();
        this.nextTabWindow.getContentPane().setLayout(new BorderLayout());
        this.nextTabWindow.setSize(smallWidth, smallHeight);
        this.nextTabWindow.setLocation(13 * screenWidth / 18, 7 * screenHeight / 18);
        this.isVisible = false;
    }

    private void setTabbedPane(JTabbedPane jtp) {
        if (this.currTabbedPane == jtp) {
            return;
        }
        this.currTabbedPane = jtp;
    }

    public synchronized void page(JTabbedPane tabbedPane, boolean isForward) {
        this.setTabbedPane(tabbedPane);
        if (!this.isVisible) {
            this.currTabWindow.setVisible(true);
            this.prevTabWindow.setVisible(true);
            this.nextTabWindow.setVisible(true);
            this.isVisible = true;
            this.currTabIndex = this.currTabbedPane.getSelectedIndex();
        }
        int delta = isForward ? 1 : -1;
        this.currTabIndex += delta;
        if (this.currTabIndex == this.currTabbedPane.getTabCount()) {
            this.currTabIndex = 0;
        }
        if (this.currTabIndex == -1) {
            this.currTabIndex = this.currTabbedPane.getTabCount() - 1;
        }
        int nextTabIndex = this.currTabIndex + 1;
        int prevTabIndex = this.currTabIndex - 1;
        if (nextTabIndex == this.currTabbedPane.getTabCount()) {
            nextTabIndex = 0;
        }
        if (prevTabIndex == -1) {
            prevTabIndex = this.currTabbedPane.getTabCount() - 1;
        }
        TabPreviewThread.TabPreviewInfo currTabPreviewInfo = new TabPreviewThread.TabPreviewInfo();
        currTabPreviewInfo.tabPane = this.currTabbedPane;
        currTabPreviewInfo.tabIndexToPreview = this.currTabIndex;
        currTabPreviewInfo.previewWidth = this.currTabWindow.getWidth() - 4;
        currTabPreviewInfo.previewHeight = this.currTabWindow.getHeight() - 20;
        currTabPreviewInfo.previewCallback = new TabPagerPreviewCallback(this.currTabWindow, this.currTabbedPane, this.currTabIndex);
        currTabPreviewInfo.initiator = this;
        TabPreviewPainter previewPainter = LafWidgetUtilities.getTabPreviewPainter(currTabPreviewInfo.tabPane);
        if (previewPainter != null && previewPainter.hasPreviewWindow(this.currTabbedPane, this.currTabIndex)) {
            TabPreviewThread.getInstance().queueTabPreviewRequest(currTabPreviewInfo);
        }
        TabPreviewThread.TabPreviewInfo prevTabPreviewInfo = new TabPreviewThread.TabPreviewInfo();
        prevTabPreviewInfo.tabPane = this.currTabbedPane;
        prevTabPreviewInfo.tabIndexToPreview = prevTabIndex;
        prevTabPreviewInfo.previewWidth = this.prevTabWindow.getWidth() - 4;
        prevTabPreviewInfo.previewHeight = this.prevTabWindow.getHeight() - 20;
        prevTabPreviewInfo.previewCallback = new TabPagerPreviewCallback(this.prevTabWindow, this.currTabbedPane, prevTabIndex);
        prevTabPreviewInfo.initiator = this;
        if (previewPainter != null && previewPainter.hasPreviewWindow(this.currTabbedPane, prevTabIndex)) {
            TabPreviewThread.getInstance().queueTabPreviewRequest(prevTabPreviewInfo);
        }
        TabPreviewThread.TabPreviewInfo nextTabPreviewInfo = new TabPreviewThread.TabPreviewInfo();
        nextTabPreviewInfo.tabPane = this.currTabbedPane;
        nextTabPreviewInfo.tabIndexToPreview = nextTabIndex;
        nextTabPreviewInfo.previewWidth = this.nextTabWindow.getWidth() - 4;
        nextTabPreviewInfo.previewHeight = this.nextTabWindow.getHeight() - 20;
        nextTabPreviewInfo.previewCallback = new TabPagerPreviewCallback(this.nextTabWindow, this.currTabbedPane, nextTabIndex);
        nextTabPreviewInfo.initiator = this;
        if (previewPainter != null && previewPainter.hasPreviewWindow(this.currTabbedPane, nextTabIndex)) {
            TabPreviewThread.getInstance().queueTabPreviewRequest(nextTabPreviewInfo);
        }
    }

    public synchronized int hide() {
        int result = this.isVisible ? this.currTabIndex : -1;
        this.currTabWindow.setVisible(false);
        this.currTabWindow.dispose();
        this.prevTabWindow.setVisible(false);
        this.prevTabWindow.dispose();
        this.nextTabWindow.setVisible(false);
        this.nextTabWindow.dispose();
        this.isVisible = false;
        return result;
    }

    public static void reset() {
    }

    public class TabPagerPreviewCallback
    implements TabPreviewThread.TabPreviewCallback {
        private JWindow previewWindow;
        private TabPreviewControl previewControl;

        public TabPagerPreviewCallback(JWindow previewWindow, JTabbedPane tabPane, int tabIndex) {
            this.previewWindow = previewWindow;
            this.previewControl = new TabPreviewControl(tabPane, tabIndex);
            this.previewWindow.getContentPane().removeAll();
            this.previewWindow.getContentPane().add((Component)this.previewControl, "Center");
            this.previewWindow.getContentPane().doLayout();
            this.previewControl.doLayout();
        }

        public void start(JTabbedPane tabPane, int tabCount, TabPreviewThread.TabPreviewInfo tabPreviewInfo) {
        }

        public void offer(JTabbedPane tabPane, int tabIndex, BufferedImage componentSnap) {
            if (TabPagerManager.this.currTabbedPane != tabPane) {
                return;
            }
            if (!this.previewWindow.isVisible()) {
                return;
            }
            this.previewControl.setPreviewImage(componentSnap);
        }
    }
}

