/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.lafwidget.utils;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.utils.FadeTracker;

public class FadeStateListener {
    protected FadeTracker.FadeTrackerCallback callback;
    protected Component comp;
    protected ButtonModel buttonModel;
    protected Map prevStateMap;
    protected ChangeListener modelListener;
    protected FocusListener focusListener;

    public FadeStateListener(Component comp, ButtonModel buttonModel, FadeTracker.FadeTrackerCallback callback) {
        this.comp = comp;
        this.buttonModel = buttonModel;
        this.callback = callback;
        this.prevStateMap = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trackModelChange(FadeTracker.FadeKind fadeKind, boolean newValue) {
        if (LafWidgetRepository.getRepository().getFadeIgnoreManager().toIgnoreAnimations(this.comp)) {
            return;
        }
        try {
            if (this.prevStateMap.containsKey(fadeKind)) {
                boolean prevValue = (Boolean)this.prevStateMap.get(fadeKind);
                if (prevValue == newValue) {
                    return;
                }
            } else {
                if (!newValue) {
                    return;
                }
                if (fadeKind == FadeTracker.FadeKind.SELECTION) {
                    return;
                }
            }
            FadeTracker.getInstance().trackFade(this.comp, fadeKind, newValue, false, this.callback);
        }
        finally {
            this.prevStateMap.put(fadeKind, newValue);
        }
    }

    public void registerListeners() {
        this.modelListener = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                FadeStateListener.this.trackModelChange(FadeTracker.FadeKind.SELECTION, FadeStateListener.this.buttonModel.isSelected());
                FadeStateListener.this.trackModelChange(FadeTracker.FadeKind.ARM, FadeStateListener.this.buttonModel.isArmed());
                FadeStateListener.this.trackModelChange(FadeTracker.FadeKind.ROLLOVER, FadeStateListener.this.buttonModel.isRollover());
                FadeStateListener.this.trackModelChange(FadeTracker.FadeKind.ENABLE, FadeStateListener.this.buttonModel.isEnabled());
                FadeStateListener.this.trackModelChange(FadeTracker.FadeKind.PRESS, FadeStateListener.this.buttonModel.isPressed());
            }
        };
        this.buttonModel.addChangeListener(this.modelListener);
        this.focusListener = new FocusListener(){

            public void focusGained(FocusEvent e) {
                FadeStateListener.this.trackModelChange(FadeTracker.FadeKind.FOCUS, true);
            }

            public void focusLost(FocusEvent e) {
                FadeStateListener.this.trackModelChange(FadeTracker.FadeKind.FOCUS, false);
            }
        };
        this.comp.addFocusListener(this.focusListener);
    }

    public void unregisterListeners() {
        this.buttonModel.removeChangeListener(this.modelListener);
        this.comp.removeFocusListener(this.focusListener);
    }
}

