/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Color;
import java.awt.Component;
import java.text.DateFormat;
import java.text.NumberFormat;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class SubstanceDefaultTableCellRenderer
extends DefaultTableCellRenderer {
    private Color unselectedForeground;
    private Color unselectedBackground;

    public void setForeground(Color c) {
        super.setForeground(c);
        this.unselectedForeground = c;
    }

    public void setBackground(Color c) {
        super.setBackground(c);
        this.unselectedBackground = c;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color backgroundToSet;
        if (isSelected) {
            super.setForeground(table.getSelectionForeground());
        } else {
            super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
        }
        Color color = backgroundToSet = this.unselectedBackground != null ? this.unselectedBackground : table.getBackground();
        if (row % 2 != 0) {
            int r = backgroundToSet.getRed();
            int g = backgroundToSet.getGreen();
            int b = backgroundToSet.getBlue();
            double coef = SubstanceCoreUtilities.isThemeDark(SubstanceLookAndFeel.getTheme()) ? 0.8 : 0.96;
            backgroundToSet = new Color((int)(coef * (double)r), (int)(coef * (double)g), (int)(coef * (double)b));
        }
        super.setBackground(backgroundToSet);
        this.setFont(table.getFont());
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (!isSelected && table.isCellEditable(row, column)) {
                Color col = UIManager.getColor("Table.focusCellForeground");
                if (col != null) {
                    super.setForeground(col);
                }
                if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                    super.setBackground(col);
                }
            }
        } else {
            this.setBorder(DefaultTableCellRenderer.noFocusBorder);
        }
        this.setValue(value);
        this.setOpaque(!SubstanceCoreUtilities.toBleedWatermark(table));
        return this;
    }

    public static class DateRenderer
    extends SubstanceDefaultTableCellRenderer {
        DateFormat formatter;

        public void setValue(Object value) {
            if (this.formatter == null) {
                this.formatter = DateFormat.getDateInstance();
            }
            this.setText(value == null ? "" : this.formatter.format(value));
        }
    }

    public static class DoubleRenderer
    extends NumberRenderer {
        NumberFormat formatter;

        public void setValue(Object value) {
            if (this.formatter == null) {
                this.formatter = NumberFormat.getInstance();
            }
            this.setText(value == null ? "" : this.formatter.format(value));
        }
    }

    public static class NumberRenderer
    extends SubstanceDefaultTableCellRenderer {
        public NumberRenderer() {
            this.setHorizontalAlignment(4);
        }
    }

    public static class IconRenderer
    extends SubstanceDefaultTableCellRenderer {
        public IconRenderer() {
            this.setHorizontalAlignment(0);
        }

        public void setValue(Object value) {
            this.setIcon(value instanceof Icon ? (Icon)value : null);
            this.setText(null);
        }
    }

    public static class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public BooleanRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setForeground(table.getForeground());
            }
            Color backgroundToSet = table.getBackground();
            if (row % 2 != 0) {
                int r = backgroundToSet.getRed();
                int g = backgroundToSet.getGreen();
                int b = backgroundToSet.getBlue();
                double coef = SubstanceCoreUtilities.isThemeDark(SubstanceLookAndFeel.getTheme()) ? 0.8 : 0.96;
                backgroundToSet = new Color((int)(coef * (double)r), (int)(coef * (double)g), (int)(coef * (double)b));
            }
            super.setBackground(backgroundToSet);
            this.setSelected(value != null && (Boolean)value != false);
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(noFocusBorder);
            }
            this.setOpaque(!SubstanceCoreUtilities.toBleedWatermark(table));
            return this;
        }
    }
}

