/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.ButtonModel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.lafwidget.utils.FadeTracker;
import org.jvnet.substance.SubstanceFillBackgroundDelegate;
import org.jvnet.substance.SubstanceGradientBackgroundDelegate;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class SubstanceMenuBackgroundDelegate {
    private static SubstanceGradientBackgroundDelegate activeBackgroundDelegate = new SubstanceGradientBackgroundDelegate();
    private SubstanceFillBackgroundDelegate fillBackgroundDelegate;

    public SubstanceMenuBackgroundDelegate(float fillAlpha) {
        this.fillBackgroundDelegate = new SubstanceFillBackgroundDelegate(fillAlpha);
    }

    private void paintBackground(Graphics g, JMenuItem menuItem, int width, int height, SubstanceTheme theme, boolean hasDarkBorder) {
        activeBackgroundDelegate.update(g, menuItem, width, height, theme, hasDarkBorder);
    }

    public void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor, boolean hasDarkBorder, int textOffset) {
        if (!menuItem.isShowing()) {
            return;
        }
        ButtonModel model = menuItem.getModel();
        Color oldColor = g.getColor();
        int menuWidth = menuItem.getWidth();
        int menuHeight = menuItem.getHeight();
        MenuElement[] selectedMenuPath = MenuSelectionManager.defaultManager().getSelectedPath();
        boolean isRollover = selectedMenuPath.length == 0;
        for (MenuElement elem : selectedMenuPath) {
            if (elem != menuItem) continue;
            isRollover = true;
            break;
        }
        isRollover = isRollover && model.isRollover();
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setComposite(TransitionLayout.getAlphaComposite(menuItem));
        Composite oldComposite = graphics.getComposite();
        if (TransitionLayout.isOpaque(menuItem)) {
            graphics.setColor(menuItem.getBackground());
            graphics.fillRect(0, 0, menuWidth, menuHeight);
            this.fillBackgroundDelegate.setAlphaComposite(0.4f);
            for (Container comp = menuItem.getParent(); comp != null && !(comp instanceof JMenuItem); comp = comp.getParent()) {
                if (!(comp instanceof JMenuBar)) continue;
                this.fillBackgroundDelegate.setAlphaComposite(1.0f);
                break;
            }
            this.fillBackgroundDelegate.update(graphics, menuItem);
            if (menuItem.getParent() instanceof JPopupMenu) {
                GradientPaint gp;
                if (menuItem.getComponentOrientation().isLeftToRight()) {
                    gp = new GradientPaint(0.0f, 0.0f, SubstanceCoreUtilities.getActiveScheme(menuItem).getUltraLightColor(), textOffset, 0.0f, SubstanceCoreUtilities.getActiveScheme(menuItem).getLightColor());
                    graphics.setPaint(gp);
                    graphics.fillRect(0, 0, textOffset - 2, menuHeight);
                } else {
                    gp = new GradientPaint(menuWidth - textOffset, 0.0f, SubstanceCoreUtilities.getActiveScheme(menuItem).getUltraLightColor(), menuWidth, 0.0f, SubstanceCoreUtilities.getActiveScheme(menuItem).getLightColor());
                    graphics.setPaint(gp);
                    graphics.fillRect(menuWidth - textOffset - 2, 0, menuWidth, menuHeight);
                }
            }
        }
        FadeTracker fadeTracker = FadeTracker.getInstance();
        boolean isRolloverAnim = fadeTracker.isTracked(menuItem, FadeTracker.FadeKind.ROLLOVER);
        boolean isArmedAnim = fadeTracker.isTracked(menuItem, FadeTracker.FadeKind.ARM);
        boolean isSelectedAnim = fadeTracker.isTracked(menuItem, FadeTracker.FadeKind.SELECTION);
        if (model.isArmed() || isArmedAnim || isRollover || isRolloverAnim || menuItem instanceof JMenu && (model.isSelected() || isSelectedAnim)) {
            float cyclePos;
            if (fadeTracker.isTracked(menuItem, FadeTracker.FadeKind.ROLLOVER)) {
                cyclePos = fadeTracker.getFade10(menuItem, FadeTracker.FadeKind.ROLLOVER);
                graphics.setComposite(TransitionLayout.getAlphaComposite(menuItem, cyclePos / 10.0f));
            }
            if (fadeTracker.isTracked(menuItem, FadeTracker.FadeKind.ARM)) {
                cyclePos = fadeTracker.getFade10(menuItem, FadeTracker.FadeKind.ARM);
                graphics.setComposite(TransitionLayout.getAlphaComposite(menuItem, cyclePos / 10.0f));
            }
            if (fadeTracker.isTracked(menuItem, FadeTracker.FadeKind.SELECTION)) {
                cyclePos = fadeTracker.getFade10(menuItem, FadeTracker.FadeKind.SELECTION);
                graphics.setComposite(TransitionLayout.getAlphaComposite(menuItem, cyclePos / 10.0f));
            }
            this.paintBackground(graphics, menuItem, menuWidth, menuHeight, SubstanceCoreUtilities.getActiveTheme(menuItem, true), hasDarkBorder);
        }
        graphics.setColor(oldColor);
        graphics.setComposite(oldComposite);
        graphics.dispose();
    }
}

