/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;
import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.lafwidget.utils.FadeTracker;
import org.jvnet.lafwidget.utils.LafConstants;
import org.jvnet.substance.SubstanceFillBackgroundDelegate;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.SubstanceScrollButton;
import org.jvnet.substance.TabCloseListener;
import org.jvnet.substance.button.BaseButtonShaper;
import org.jvnet.substance.button.ClassicButtonShaper;
import org.jvnet.substance.button.SubstanceButtonShaper;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.color.SunfireRedColorScheme;
import org.jvnet.substance.color.SunsetColorScheme;
import org.jvnet.substance.painter.ControlBackgroundComposite;
import org.jvnet.substance.painter.SubstanceGradientPainter;
import org.jvnet.substance.tabbed.BaseTabCloseListener;
import org.jvnet.substance.tabbed.MultipleTabCloseListener;
import org.jvnet.substance.tabbed.TabCloseCallback;
import org.jvnet.substance.tabbed.VetoableMultipleTabCloseListener;
import org.jvnet.substance.tabbed.VetoableTabCloseListener;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.IconFadeStep;
import org.jvnet.substance.utils.ModifiedFadeStep;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceConstants;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.icon.IconWrapper;
import org.jvnet.substance.utils.icon.MixIcon;
import org.jvnet.substance.utils.icon.ProgressIcon;
import org.jvnet.substance.utils.icon.RotatableIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubstanceTabbedPaneUI
extends BasicTabbedPaneUI {
    protected Set lafWidgets;
    public static final int TAB_DEFAULT_BUTTON_DIMENSION = 11;
    protected Point substanceMouseLocation;
    private static Map<String, BufferedImage> backgroundMap = new HashMap<String, BufferedImage>();
    private static Map<String, BufferedImage> closeButtonMap = new HashMap<String, BufferedImage>();
    private Map<Component, Long> fadeModifiedIds;
    private Map<Component, Long> fadeIconIds;
    protected MouseRolloverHandler substanceRolloverHandler;
    protected TabbedContainerListener substanceContainerListener;
    protected ChangeListener substanceSelectionListener;
    private SubstanceFillBackgroundDelegate bgDelegate = new SubstanceFillBackgroundDelegate();

    public void __org__jvnet__substance__SubstanceTabbedPaneUI__update(Graphics graphics, JComponent jComponent) {
        super.update(graphics, jComponent);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        Object object = jComponent.getClientProperty("lafwidgets.layout.alpha");
        if (object instanceof Float) {
            graphics2D.setComposite(AlphaComposite.getInstance(3, ((Float)object).floatValue()));
        }
        this.__org__jvnet__substance__SubstanceTabbedPaneUI__update(graphics2D, jComponent);
        graphics2D.setComposite(composite);
    }

    public void __org__jvnet__substance__SubstanceTabbedPaneUI__installComponents() {
        super.installComponents();
    }

    @Override
    public void installComponents() {
        this.__org__jvnet__substance__SubstanceTabbedPaneUI__installComponents();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installComponents();
        }
    }

    public void __org__jvnet__substance__SubstanceTabbedPaneUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__jvnet__substance__SubstanceTabbedPaneUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.__org__jvnet__substance__SubstanceTabbedPaneUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    @Override
    public void installListeners() {
        this.__org__jvnet__substance__SubstanceTabbedPaneUI__installListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    public void installDefaults() {
        this.__org__jvnet__substance__SubstanceTabbedPaneUI__installDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    public void __org__jvnet__substance__SubstanceTabbedPaneUI__uninstallComponents() {
        super.uninstallComponents();
    }

    @Override
    public void uninstallComponents() {
        this.__org__jvnet__substance__SubstanceTabbedPaneUI__uninstallComponents();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallComponents();
        }
    }

    @Override
    public void uninstallListeners() {
        this.__org__jvnet__substance__SubstanceTabbedPaneUI__uninstallListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    @Override
    public void uninstallDefaults() {
        this.__org__jvnet__substance__SubstanceTabbedPaneUI__uninstallDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    public static synchronized void reset() {
        backgroundMap.clear();
    }

    public static ComponentUI createUI(JComponent tabPane) {
        SubstanceTabbedPaneUI result = new SubstanceTabbedPaneUI();
        return result;
    }

    protected void __org__jvnet__substance__SubstanceTabbedPaneUI__installListeners() {
        super.installListeners();
        this.substanceRolloverHandler = new MouseRolloverHandler();
        this.tabPane.addMouseMotionListener(this.substanceRolloverHandler);
        this.tabPane.addMouseListener(this.substanceRolloverHandler);
        this.substanceContainerListener = new TabbedContainerListener();
        this.substanceContainerListener.trackExistingTabs();
        for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
            SubstanceConstants.TabAnimationKind animKind;
            Component tabComp = this.tabPane.getComponentAt(i);
            if (SubstanceCoreUtilities.isTabModified(tabComp)) {
                long fadeInstanceId = FadeTracker.getInstance().trackFadeLooping(ModifiedFadeStep.MARKED_MODIFIED_FADE_KIND, new LafConstants.AnimationKind(new ModifiedFadeStep(), "modified"), this.tabPane, Integer.valueOf(i), false, this.getCallback(i), true);
                this.fadeModifiedIds.put(tabComp, fadeInstanceId);
            }
            if ((animKind = SubstanceCoreUtilities.getTabAnimationKind(tabComp)) == null) continue;
            TabIconAnimationCallback callback = new TabIconAnimationCallback(this.tabPane, i);
            callback.startIconAnimation(animKind);
        }
        this.tabPane.addContainerListener(this.substanceContainerListener);
        this.substanceSelectionListener = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (SubstanceTabbedPaneUI.this.tabPane == null) {
                            return;
                        }
                        int selected = SubstanceTabbedPaneUI.this.tabPane.getSelectedIndex();
                        FadeTracker fadeTracker = FadeTracker.getInstance();
                        if (selected >= 0 && selected < SubstanceTabbedPaneUI.this.tabPane.getTabCount() && SubstanceTabbedPaneUI.this.tabPane.isEnabledAt(selected)) {
                            fadeTracker.trackFadeIn(FadeTracker.FadeKind.ROLLOVER, (Component)SubstanceTabbedPaneUI.this.tabPane, selected, true, (FadeTracker.FadeTrackerCallback)new TabRepaintCallback(SubstanceTabbedPaneUI.this.tabPane, selected));
                        }
                    }
                });
            }
        };
        this.tabPane.getModel().addChangeListener(this.substanceSelectionListener);
    }

    protected void __org__jvnet__substance__SubstanceTabbedPaneUI__uninstallListeners() {
        super.uninstallListeners();
        if (this.substanceRolloverHandler != null) {
            this.tabPane.removeMouseMotionListener(this.substanceRolloverHandler);
            this.tabPane.removeMouseListener(this.substanceRolloverHandler);
            this.substanceRolloverHandler = null;
        }
        if (this.substanceContainerListener != null) {
            for (Map.Entry entry : this.substanceContainerListener.listeners.entrySet()) {
                Component comp = (Component)entry.getKey();
                for (PropertyChangeListener pcl : (List)entry.getValue()) {
                    comp.removePropertyChangeListener(pcl);
                }
            }
            this.substanceContainerListener.listeners.clear();
            this.tabPane.removeContainerListener(this.substanceContainerListener);
            this.substanceContainerListener = null;
        }
        this.tabPane.getModel().removeChangeListener(this.substanceSelectionListener);
        this.substanceSelectionListener = null;
    }

    protected void __org__jvnet__substance__SubstanceTabbedPaneUI__installDefaults() {
        super.installDefaults();
        this.fadeModifiedIds = new HashMap<Component, Long>();
        this.fadeIconIds = new HashMap<Component, Long>();
    }

    protected void __org__jvnet__substance__SubstanceTabbedPaneUI__uninstallDefaults() {
        this.fadeModifiedIds.clear();
        this.fadeIconIds.clear();
        super.uninstallDefaults();
    }

    public void __org__jvnet__substance__SubstanceTabbedPaneUI__uninstallUI(JComponent c) {
        for (Map.Entry<Component, Long> fadeIconInstanceEntry : this.fadeIconIds.entrySet()) {
            int tabIndex = this.tabPane.indexOfComponent(fadeIconInstanceEntry.getKey());
            Icon icon = this.tabPane.getIconAt(tabIndex);
            if (icon instanceof IconWrapper) {
                this.tabPane.setIconAt(tabIndex, ((IconWrapper)((Object)icon)).getOriginalIcon());
            }
            FadeTracker.getInstance().cancelFadeInstance(fadeIconInstanceEntry.getValue());
        }
        super.uninstallUI(c);
    }

    private static synchronized BufferedImage getTabBackground(int width, int height, boolean isSelected, float cyclePos, int tabPlacement, SubstanceConstants.Side side, ColorScheme colorScheme, ColorScheme colorScheme2) {
        SubstanceGradientPainter gradientPainter = SubstanceLookAndFeel.getCurrentGradientPainter();
        if (gradientPainter == null) {
            return null;
        }
        int dx = 0;
        int ox = 0;
        int oy = 0;
        int dy = 0;
        switch (side) {
            case BOTTOM: {
                dy = 2;
                break;
            }
            case TOP: {
                dy = 2;
                oy = 2;
                break;
            }
            case RIGHT: {
                dx = 2;
                break;
            }
            case LEFT: {
                dx = 2;
                ox = -2;
            }
        }
        SubstanceButtonShaper shaper = SubstanceLookAndFeel.getCurrentButtonShaper();
        String key = width + dx + ":" + (height + dy) + ":" + isSelected + ":" + cyclePos + ":" + side.toString() + ":" + gradientPainter.getDisplayName() + ":" + shaper.getDisplayName() + ":" + SubstanceCoreUtilities.getSchemeId(colorScheme) + ":" + SubstanceCoreUtilities.getSchemeId(colorScheme2);
        BufferedImage result = backgroundMap.get(key);
        if (result == null) {
            HashSet<SubstanceConstants.Side> straightSides = new HashSet<SubstanceConstants.Side>();
            straightSides.add(side);
            int cornerRadius = height / 3;
            if (shaper instanceof ClassicButtonShaper) {
                cornerRadius = 2;
                if (tabPlacement == 1 || tabPlacement == 3) {
                    --width;
                } else {
                    --height;
                }
            }
            GeneralPath contour = BaseButtonShaper.getBaseOutline(width + dx, height + dy, cornerRadius, straightSides);
            result = gradientPainter.getContourBackground(width + dx, height + dy, contour, false, colorScheme, colorScheme2, cyclePos, true, colorScheme != colorScheme2);
            BufferedImage finalImage = SubstanceCoreUtilities.getBlankImage(width, height);
            Graphics2D finalGraphics = (Graphics2D)finalImage.getGraphics();
            finalGraphics.drawImage((Image)result, ox, oy, null);
            backgroundMap.put(key, finalImage);
            result = finalImage;
        }
        return result;
    }

    private static synchronized BufferedImage getCloseButtonImage(int width, int height, float cyclePos10, boolean toPaintBackground, ColorScheme colorScheme, ColorScheme colorScheme2) {
        SubstanceGradientPainter gradientPainter = SubstanceLookAndFeel.getCurrentGradientPainter();
        if (gradientPainter == null) {
            return null;
        }
        String key = width + ":" + height + ":" + toPaintBackground + ":" + cyclePos10 + ":" + gradientPainter.getDisplayName() + ":" + SubstanceCoreUtilities.getSchemeId(colorScheme) + ":" + SubstanceCoreUtilities.getSchemeId(colorScheme2);
        BufferedImage result = closeButtonMap.get(key);
        if (result == null) {
            result = SubstanceCoreUtilities.getBlankImage(width, height);
            Graphics2D finalGraphics = (Graphics2D)result.getGraphics();
            finalGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (toPaintBackground) {
                GeneralPath contour = BaseButtonShaper.getBaseOutline(width, height, 1.0f, null);
                BufferedImage background = gradientPainter.getContourBackground(width, height, contour, false, colorScheme, colorScheme2, cyclePos10, true, colorScheme != colorScheme2);
                finalGraphics.drawImage((Image)background, 0, 0, null);
            }
            finalGraphics.setColor(colorScheme.getForegroundColor());
            finalGraphics.setStroke(new BasicStroke(1.2f));
            finalGraphics.drawLine(2, 2, width - 3, height - 3);
            finalGraphics.drawLine(2, height - 3, width - 3, 2);
            closeButtonMap.put(key, result);
        }
        return result;
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        boolean hasActivePresence;
        BufferedImage backgroundImage = null;
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setComposite(TransitionLayout.getAlphaComposite(this.tabPane));
        graphics.clip(new Rectangle(x, y, w, h));
        boolean isRollover = this.getRolloverTab() == tabIndex;
        boolean isEnabled = this.tabPane.isEnabledAt(tabIndex);
        Component tabComponent = this.tabPane.getComponentAt(tabIndex);
        ColorScheme colorScheme = SubstanceCoreUtilities.getActiveScheme(tabComponent, this.tabPane);
        boolean bl = hasActivePresence = isSelected || isRollover && isEnabled;
        if (!isSelected && !isRollover) {
            colorScheme = SubstanceCoreUtilities.getDefaultScheme(tabComponent, this.tabPane);
        }
        if (!isEnabled) {
            colorScheme = SubstanceCoreUtilities.getDisabledScheme(tabComponent, this.tabPane);
        }
        float cyclePos = isRollover && isEnabled ? 5.0f : 0.0f;
        ColorScheme colorScheme2 = colorScheme;
        Component comp = this.tabPane.getComponentAt(tabIndex);
        boolean isWindowModified = SubstanceCoreUtilities.isTabModified(comp);
        boolean toMarkModifiedCloseButton = SubstanceCoreUtilities.toAnimateCloseIconOfModifiedTab(this.tabPane, tabIndex);
        if (isWindowModified && isEnabled && !toMarkModifiedCloseButton) {
            colorScheme2 = SubstanceTheme.YELLOW;
            colorScheme = SubstanceTheme.ORANGE;
            cyclePos = FadeTracker.getInstance().getFade10((Component)this.tabPane, tabIndex, ModifiedFadeStep.MARKED_MODIFIED_FADE_KIND);
            hasActivePresence = true;
        }
        FadeTracker fadeTracker = FadeTracker.getInstance();
        if (!isWindowModified && fadeTracker.isTracked((Component)this.tabPane, tabIndex, FadeTracker.FadeKind.ROLLOVER)) {
            hasActivePresence = true;
            ColorScheme defaultScheme = SubstanceCoreUtilities.getDefaultScheme(tabComponent, this.tabPane);
            if (!isRollover) {
                colorScheme2 = SubstanceCoreUtilities.getActiveScheme(this.tabPane.getComponentAt(tabIndex), this.tabPane);
                colorScheme = isSelected ? colorScheme : defaultScheme;
                cyclePos = fadeTracker.getFade10((Component)this.tabPane, tabIndex, null);
            } else {
                colorScheme2 = colorScheme;
                colorScheme = isSelected ? colorScheme : defaultScheme;
                cyclePos = fadeTracker.getFade10((Component)this.tabPane, tabIndex, null);
            }
        }
        boolean toSwap = SubstanceCoreUtilities.toLayoutVertically(this.tabPane);
        switch (tabPlacement) {
            case 2: {
                backgroundImage = SubstanceTabbedPaneUI.getTabBackground(w, h, isSelected, cyclePos, toSwap ? 1 : tabPlacement, toSwap ? SubstanceConstants.Side.BOTTOM : SubstanceConstants.Side.RIGHT, colorScheme, colorScheme2);
                if (!isSelected) break;
                int fw = backgroundImage.getWidth();
                int fh = backgroundImage.getHeight();
                SubstanceTheme tabTheme = SubstanceCoreUtilities.getTheme(tabComponent, this.tabPane, true);
                BufferedImage fade = SubstanceCoreUtilities.getBlankImage(fw, fh);
                Graphics2D fadeGraphics = fade.createGraphics();
                fadeGraphics.setColor(tabComponent != null ? tabComponent.getBackground() : this.tabPane.getBackground());
                fadeGraphics.fillRect(0, 0, fw, fh);
                SubstanceLookAndFeel.getCurrentWatermark().drawWatermarkImage(fadeGraphics, this.tabPane, 0, 0, fw, fh);
                fadeGraphics.setColor(this.darkShadow);
                if (toSwap) {
                    fadeGraphics.drawLine(0, 0, 0, fh - 1);
                    fadeGraphics.drawLine(fw - 1, 0, fw - 1, fh - 1);
                    backgroundImage = SubstanceCoreUtilities.blendImagesVertical(backgroundImage, fade, tabTheme.getSelectedTabFadeStart(), tabTheme.getSelectedTabFadeEnd());
                    break;
                }
                fadeGraphics.drawLine(0, 0, fw - 1, 0);
                fadeGraphics.drawLine(0, fh - 1, fw - 1, fh - 1);
                backgroundImage = SubstanceCoreUtilities.blendImagesHorizontal(backgroundImage, fade, tabTheme.getSelectedTabFadeStart(), tabTheme.getSelectedTabFadeEnd());
                break;
            }
            case 4: {
                backgroundImage = SubstanceTabbedPaneUI.getTabBackground(w, h, isSelected, cyclePos, toSwap ? 3 : tabPlacement, toSwap ? SubstanceConstants.Side.BOTTOM : SubstanceConstants.Side.LEFT, colorScheme, colorScheme2);
                if (!isSelected) break;
                int fw = backgroundImage.getWidth();
                int fh = backgroundImage.getHeight();
                SubstanceTheme tabTheme = SubstanceCoreUtilities.getTheme(tabComponent, this.tabPane, true);
                BufferedImage fade = SubstanceCoreUtilities.getBlankImage(fw, fh);
                Graphics2D fadeGraphics = fade.createGraphics();
                fadeGraphics.setColor(tabComponent != null ? tabComponent.getBackground() : this.tabPane.getBackground());
                fadeGraphics.fillRect(0, 0, fw, fh);
                SubstanceLookAndFeel.getCurrentWatermark().drawWatermarkImage(fadeGraphics, this.tabPane, 0, 0, fw, fh);
                fadeGraphics.setColor(this.darkShadow);
                if (toSwap) {
                    fadeGraphics.drawLine(0, 0, 0, fh - 1);
                    fadeGraphics.drawLine(fw - 1, 0, fw - 1, fh - 1);
                    backgroundImage = SubstanceCoreUtilities.blendImagesVertical(backgroundImage, fade, tabTheme.getSelectedTabFadeStart(), tabTheme.getSelectedTabFadeEnd());
                    break;
                }
                fadeGraphics.drawLine(0, 0, fw - 1, 0);
                fadeGraphics.drawLine(0, fh - 1, fw - 1, fh - 1);
                backgroundImage = SubstanceCoreUtilities.blendImagesHorizontal(fade, backgroundImage, 1.0 - tabTheme.getSelectedTabFadeEnd(), 1.0 - tabTheme.getSelectedTabFadeStart());
                break;
            }
            case 3: {
                backgroundImage = SubstanceTabbedPaneUI.getTabBackground(w, h, isSelected, cyclePos, tabPlacement, SubstanceConstants.Side.BOTTOM, colorScheme, colorScheme2);
                backgroundImage = SubstanceImageCreator.getRotated(backgroundImage, 2);
                if (!isSelected) break;
                int fw = backgroundImage.getWidth();
                int fh = backgroundImage.getHeight();
                SubstanceTheme tabTheme = SubstanceCoreUtilities.getTheme(tabComponent, this.tabPane, true);
                BufferedImage fade = SubstanceCoreUtilities.getBlankImage(fw, fh);
                Graphics2D fadeGraphics = fade.createGraphics();
                fadeGraphics.setColor(tabComponent != null ? tabComponent.getBackground() : this.tabPane.getBackground());
                fadeGraphics.fillRect(0, 0, fw, fh);
                SubstanceLookAndFeel.getCurrentWatermark().drawWatermarkImage(fadeGraphics, this.tabPane, 0, 0, fw, fh);
                fadeGraphics.setColor(this.darkShadow);
                fadeGraphics.drawLine(0, 0, 0, fh - 1);
                fadeGraphics.drawLine(fw - 1, 0, fw - 1, fh - 1);
                backgroundImage = SubstanceCoreUtilities.blendImagesVertical(fade, backgroundImage, 1.0 - tabTheme.getSelectedTabFadeEnd(), 1.0 - tabTheme.getSelectedTabFadeStart());
                break;
            }
            default: {
                backgroundImage = SubstanceTabbedPaneUI.getTabBackground(w, h, isSelected, cyclePos, tabPlacement, SubstanceConstants.Side.BOTTOM, colorScheme, colorScheme2);
                if (!isSelected) break;
                int fw = backgroundImage.getWidth();
                int fh = backgroundImage.getHeight();
                SubstanceTheme tabTheme = SubstanceCoreUtilities.getTheme(tabComponent, this.tabPane, true);
                BufferedImage fade = SubstanceCoreUtilities.getBlankImage(fw, fh);
                Graphics2D fadeGraphics = fade.createGraphics();
                fadeGraphics.setColor(tabComponent != null ? tabComponent.getBackground() : this.tabPane.getBackground());
                fadeGraphics.fillRect(0, 0, fw, fh);
                SubstanceLookAndFeel.getCurrentWatermark().drawWatermarkImage(fadeGraphics, this.tabPane, 0, 0, fw, fh);
                fadeGraphics.setColor(this.darkShadow);
                fadeGraphics.drawLine(0, 0, 0, fh - 1);
                fadeGraphics.drawLine(fw - 1, 0, fw - 1, fh - 1);
                backgroundImage = SubstanceCoreUtilities.blendImagesVertical(backgroundImage, fade, tabTheme.getSelectedTabFadeStart(), tabTheme.getSelectedTabFadeEnd());
            }
        }
        BufferedImage result = SubstanceCoreUtilities.getBlankImage(backgroundImage.getWidth(), backgroundImage.getHeight());
        Graphics2D resultGr = result.createGraphics();
        if (backgroundImage != null) {
            ControlBackgroundComposite composite = SubstanceCoreUtilities.getControlBackgroundComposite(this.tabPane);
            resultGr.setComposite(composite.getBackgroundComposite(tabComponent, this.tabPane, tabIndex, hasActivePresence));
            resultGr.drawImage((Image)backgroundImage, 0, 0, null);
        }
        if (SubstanceCoreUtilities.hasCloseButton(this.tabPane, tabIndex) && isEnabled) {
            float alpha;
            float f = alpha = isSelected || isRollover ? 1.0f : 0.0f;
            if (!isSelected && fadeTracker.isTracked((Component)this.tabPane, tabIndex, FadeTracker.FadeKind.ROLLOVER)) {
                alpha = fadeTracker.getFade10((Component)this.tabPane, tabIndex, FadeTracker.FadeKind.ROLLOVER) / 10.0f;
            }
            if ((double)alpha > 0.0) {
                resultGr.setComposite(AlphaComposite.getInstance(3, alpha));
                Rectangle orig = this.getCloseButtonRectangleForDraw(tabIndex, x, y, w, h);
                boolean toPaintCloseBorder = false;
                if (isRollover && this.substanceMouseLocation != null) {
                    Rectangle rect;
                    Rectangle bounds = new Rectangle();
                    bounds = this.getTabBounds(tabIndex, bounds);
                    if (toSwap) {
                        bounds = new Rectangle(bounds.x, bounds.y, bounds.height, bounds.width);
                    }
                    if ((rect = this.getCloseButtonRectangleForEvents(tabIndex, bounds.x, bounds.y, bounds.width, bounds.height)).contains(this.substanceMouseLocation)) {
                        toPaintCloseBorder = true;
                    }
                }
                if (isWindowModified && isEnabled && toMarkModifiedCloseButton) {
                    colorScheme2 = SubstanceTheme.YELLOW;
                    colorScheme = SubstanceTheme.ORANGE;
                    cyclePos = FadeTracker.getInstance().getFade10((Component)this.tabPane, tabIndex, ModifiedFadeStep.MARKED_MODIFIED_FADE_KIND);
                }
                BufferedImage closeButtonImage = SubstanceTabbedPaneUI.getCloseButtonImage(orig.width, orig.height, cyclePos, toPaintCloseBorder, colorScheme, colorScheme2);
                resultGr.drawImage((Image)closeButtonImage, orig.x - x, orig.y - y, null);
            }
        }
        graphics.drawImage((Image)result, x, y, null);
        resultGr.dispose();
        graphics.dispose();
    }

    @Override
    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
    }

    @Override
    protected JButton createScrollButton(int direction) {
        Icon icon = SubstanceImageCreator.getArrowIcon(9, 5, direction, SubstanceCoreUtilities.getActiveTheme(this.tabPane, true));
        SubstanceScrollButton ssb = new SubstanceScrollButton(icon, direction);
        return ssb;
    }

    @Override
    protected ChangeListener createChangeListener() {
        return new TabSelectionHandler();
    }

    @Override
    protected Insets getTabAreaInsets(int tabPlacement) {
        Insets result = super.getTabAreaInsets(tabPlacement);
        return result;
    }

    @Override
    protected Insets getTabInsets(int tabPlacement, int tabIndex) {
        Insets result = super.getTabInsets(tabPlacement, tabIndex);
        return result;
    }

    @Override
    protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        boolean toSwap = SubstanceCoreUtilities.toLayoutVertically(this.tabPane);
        if (toSwap) {
            return this.getTabExtraWidth(tabPlacement, tabIndex) + super.calculateTabWidth(tabPlacement, tabIndex, this.getFontMetrics());
        }
        return super.calculateTabHeight(tabPlacement, tabIndex, fontHeight);
    }

    @Override
    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        boolean toSwap = SubstanceCoreUtilities.toLayoutVertically(this.tabPane);
        if (toSwap) {
            return super.calculateTabHeight(tabPlacement, tabIndex, metrics.getHeight());
        }
        int result = this.getTabExtraWidth(tabPlacement, tabIndex) + super.calculateTabWidth(tabPlacement, tabIndex, metrics);
        return result;
    }

    @Override
    protected int calculateMaxTabHeight(int tabPlacement) {
        if (tabPlacement == 1 || tabPlacement == 3) {
            return super.calculateMaxTabHeight(tabPlacement);
        }
        int result = 0;
        for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
            result = Math.max(result, this.calculateTabHeight(tabPlacement, i, this.getFontMetrics().getHeight()));
        }
        return result;
    }

    @Override
    protected int getTabRunOverlay(int tabPlacement) {
        boolean toSwap = SubstanceCoreUtilities.toLayoutVertically(this.tabPane);
        if (!toSwap) {
            return super.getTabRunOverlay(tabPlacement);
        }
        return 0;
    }

    @Override
    protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
        boolean toSwap = SubstanceCoreUtilities.toLayoutVertically(this.tabPane);
        if (toSwap) {
            Graphics2D tempG = (Graphics2D)g.create();
            Rectangle tabRect = rects[tabIndex];
            Rectangle correctRect = new Rectangle(tabRect.x, tabRect.y, tabRect.height, tabRect.width);
            if (tabPlacement == 2) {
                tempG.rotate(-1.5707963267948966, tabRect.x, tabRect.y);
                tempG.translate(-tabRect.height, 0);
            } else {
                tempG.rotate(1.5707963267948966, tabRect.x, tabRect.y);
                tempG.translate(0.0, -tabRect.getWidth());
            }
            tempG.setColor(Color.red);
            rects[tabIndex] = correctRect;
            super.paintTab(tempG, tabPlacement, rects, tabIndex, iconRect, textRect);
            rects[tabIndex] = tabRect;
            tempG.dispose();
        } else {
            super.paintTab(g, tabPlacement, rects, tabIndex, iconRect, textRect);
        }
    }

    @Override
    protected void paintTabArea(Graphics g, int tabPlacement, int selectedIndex) {
        this.bgDelegate.update(g, this.tabPane);
        super.paintTabArea(g, tabPlacement, selectedIndex);
    }

    @Override
    protected Icon getIconForTab(int tabIndex) {
        Icon superResult = super.getIconForTab(tabIndex);
        if (!SubstanceCoreUtilities.toLayoutVertically(this.tabPane)) {
            return superResult;
        }
        if (!SubstanceCoreUtilities.toShowIconUnrotated(this.tabPane, tabIndex)) {
            return superResult;
        }
        boolean rotateClockwise = this.tabPane.getTabPlacement() == 2;
        return new RotatableIcon(superResult, rotateClockwise);
    }

    protected Rectangle getCloseButtonRectangleForDraw(int tabIndex, int x, int y, int width, int height) {
        int dimension = SubstanceCoreUtilities.getCloseButtonSize(this.tabPane, tabIndex);
        int xs = this.tabPane.getComponentOrientation().isLeftToRight() ? x + width - dimension - 4 : x + 4;
        int ys = y + (height - dimension) / 2;
        return new Rectangle(xs, ys, dimension, dimension);
    }

    protected Rectangle getCloseButtonRectangleForEvents(int tabIndex, int x, int y, int w, int h) {
        int tabPlacement = this.tabPane.getTabPlacement();
        boolean toSwap = SubstanceCoreUtilities.toLayoutVertically(this.tabPane);
        if (!toSwap) {
            return this.getCloseButtonRectangleForDraw(tabIndex, x, y, w, h);
        }
        int dimension = SubstanceCoreUtilities.getCloseButtonSize(this.tabPane, tabIndex);
        Point2D transCorner = null;
        Rectangle rectForDraw = this.getCloseButtonRectangleForDraw(tabIndex, x, y, h, w);
        if (tabPlacement == 2) {
            AffineTransform trans = new AffineTransform();
            trans.rotate(-1.5707963267948966, x, y);
            trans.translate(-h, 0.0);
            Point2D.Double origCorner = new Point2D.Double(rectForDraw.getMaxX(), rectForDraw.getMinY());
            transCorner = trans.transform(origCorner, null);
        } else {
            AffineTransform trans = new AffineTransform();
            trans.rotate(1.5707963267948966, x, y);
            trans.translate(0.0, -w);
            Point2D.Double origCorner = new Point2D.Double(rectForDraw.getMinX(), rectForDraw.getMaxY());
            transCorner = trans.transform(origCorner, null);
        }
        return new Rectangle((int)transCorner.getX(), (int)transCorner.getY(), dimension, dimension);
    }

    protected void ensureCurrentLayout() {
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (!this.tabPane.isValid()) {
            LayoutManager lm = this.tabPane.getLayout();
            if (lm instanceof TabbedPaneLayout) {
                TabbedPaneLayout layout = (TabbedPaneLayout)lm;
                layout.calculateLayoutInfo();
            } else if (lm instanceof TransitionLayout && (lm = ((TransitionLayout)lm).getDelegate()) instanceof TabbedPaneLayout) {
                TabbedPaneLayout layout = (TabbedPaneLayout)lm;
                layout.calculateLayoutInfo();
            }
        }
    }

    public FadeTracker.FadeTrackerCallback getCallback(int tabIndex) {
        return new TabRepaintCallback(this.tabPane, tabIndex);
    }

    protected void tryCloseTabs(int tabIndex, SubstanceConstants.TabCloseKind tabCloseKind) {
        if (tabCloseKind == null) {
            return;
        }
        if (tabCloseKind == SubstanceConstants.TabCloseKind.NONE) {
            return;
        }
        if (tabCloseKind == SubstanceConstants.TabCloseKind.ALL_BUT_THIS) {
            HashSet<Integer> indexes = new HashSet<Integer>();
            for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
                if (i == tabIndex) continue;
                indexes.add(i);
            }
            this.tryCloseTabs(indexes);
            return;
        }
        if (tabCloseKind == SubstanceConstants.TabCloseKind.ALL) {
            HashSet<Integer> indexes = new HashSet<Integer>();
            for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
                indexes.add(i);
            }
            this.tryCloseTabs(indexes);
            return;
        }
        this.tryCloseTab(tabIndex);
    }

    protected void tryCloseTab(int tabIndex) {
        Component component = this.tabPane.getComponentAt(tabIndex);
        HashSet<Component> componentSet = new HashSet<Component>();
        componentSet.add(component);
        boolean isVetoed = false;
        for (BaseTabCloseListener listener : SubstanceLookAndFeel.getAllTabCloseListeners(this.tabPane)) {
            BaseTabCloseListener vetoableListener;
            if (listener instanceof VetoableTabCloseListener) {
                vetoableListener = (VetoableTabCloseListener)listener;
                boolean bl = isVetoed = isVetoed || vetoableListener.vetoTabClosing(this.tabPane, component);
            }
            if (!(listener instanceof VetoableMultipleTabCloseListener)) continue;
            vetoableListener = (VetoableMultipleTabCloseListener)listener;
            isVetoed = isVetoed || vetoableListener.vetoTabsClosing(this.tabPane, componentSet);
        }
        if (isVetoed) {
            return;
        }
        for (BaseTabCloseListener listener : SubstanceLookAndFeel.getAllTabCloseListeners(this.tabPane)) {
            if (listener instanceof TabCloseListener) {
                ((TabCloseListener)listener).tabClosing(this.tabPane, component);
            }
            if (!(listener instanceof MultipleTabCloseListener)) continue;
            ((MultipleTabCloseListener)listener).tabsClosing(this.tabPane, componentSet);
        }
        this.tabPane.remove(tabIndex);
        if (this.tabPane.getTabCount() > 0) {
            this.selectPreviousTab(0);
            this.selectNextTab(this.tabPane.getSelectedIndex());
        }
        this.tabPane.repaint();
        for (BaseTabCloseListener listener : SubstanceLookAndFeel.getAllTabCloseListeners(this.tabPane)) {
            if (listener instanceof TabCloseListener) {
                ((TabCloseListener)listener).tabClosed(this.tabPane, component);
            }
            if (!(listener instanceof MultipleTabCloseListener)) continue;
            ((MultipleTabCloseListener)listener).tabsClosed(this.tabPane, componentSet);
        }
    }

    protected void tryCloseTabs(Set<Integer> tabIndexes) {
        HashSet<Component> componentSet = new HashSet<Component>();
        for (int tabIndex : tabIndexes) {
            componentSet.add(this.tabPane.getComponentAt(tabIndex));
        }
        boolean isVetoed = false;
        for (BaseTabCloseListener listener : SubstanceLookAndFeel.getAllTabCloseListeners(this.tabPane)) {
            if (!(listener instanceof VetoableMultipleTabCloseListener)) continue;
            VetoableMultipleTabCloseListener vetoableListener = (VetoableMultipleTabCloseListener)listener;
            isVetoed = isVetoed || vetoableListener.vetoTabsClosing(this.tabPane, componentSet);
        }
        if (isVetoed) {
            return;
        }
        for (BaseTabCloseListener listener : SubstanceLookAndFeel.getAllTabCloseListeners(this.tabPane)) {
            if (!(listener instanceof MultipleTabCloseListener)) continue;
            ((MultipleTabCloseListener)listener).tabsClosing(this.tabPane, componentSet);
        }
        for (Component toRemove : componentSet) {
            this.tabPane.remove(toRemove);
        }
        if (this.tabPane.getTabCount() > 0) {
            this.selectPreviousTab(0);
            this.selectNextTab(this.tabPane.getSelectedIndex());
        }
        this.tabPane.repaint();
        for (BaseTabCloseListener listener : SubstanceLookAndFeel.getAllTabCloseListeners(this.tabPane)) {
            if (!(listener instanceof MultipleTabCloseListener)) continue;
            ((MultipleTabCloseListener)listener).tabsClosed(this.tabPane, componentSet);
        }
    }

    @Override
    protected void layoutLabel(int tabPlacement, FontMetrics metrics, int tabIndex, String title, Icon icon, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        iconRect.y = 0;
        iconRect.x = 0;
        textRect.y = 0;
        textRect.x = 0;
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            this.tabPane.putClientProperty("html", v);
        }
        SwingUtilities.layoutCompoundLabel(this.tabPane, metrics, title, icon, 0, this.getTextAlignment(tabPlacement), 0, 11, tabRect, iconRect, textRect, this.textIconGap);
        this.tabPane.putClientProperty("html", null);
        int xNudge = this.getTabLabelShiftX(tabPlacement, tabIndex, isSelected);
        int yNudge = this.getTabLabelShiftY(tabPlacement, tabIndex, isSelected);
        iconRect.x += xNudge;
        iconRect.y += yNudge;
        textRect.x += xNudge;
        textRect.y += yNudge;
    }

    protected int getTextAlignment(int tabPlacement) {
        SubstanceConstants.TabTextAlignmentKind textAlignmentKind = SubstanceCoreUtilities.getTabTextAlignmentKind(this.tabPane);
        if (SubstanceCoreUtilities.toLayoutVertically(this.tabPane)) {
            return 0;
        }
        if (tabPlacement == 2) {
            switch (textAlignmentKind) {
                case ALWAYS_LEFT: 
                case FOLLOW_PLACEMENT: {
                    return 2;
                }
                case FOLLOW_ORIENTATION: {
                    if (this.tabPane.getComponentOrientation().isLeftToRight()) {
                        return 2;
                    }
                    return 4;
                }
                case ALWAYS_RIGHT: {
                    return 4;
                }
            }
        }
        if (tabPlacement == 4) {
            switch (textAlignmentKind) {
                case FOLLOW_PLACEMENT: 
                case ALWAYS_RIGHT: {
                    return 4;
                }
                case FOLLOW_ORIENTATION: {
                    if (this.tabPane.getComponentOrientation().isLeftToRight()) {
                        return 2;
                    }
                    return 4;
                }
                case ALWAYS_LEFT: {
                    return 2;
                }
            }
        }
        return 0;
    }

    @Override
    protected int getTabLabelShiftX(int tabPlacement, int tabIndex, boolean isSelected) {
        int textAlignment = this.getTextAlignment(tabPlacement);
        int delta = 0;
        if (textAlignment == 2) {
            delta = 10;
        }
        if (textAlignment == 4) {
            delta = -10 - SubstanceCoreUtilities.getCloseButtonSize(this.tabPane, tabIndex);
        }
        if (textAlignment == 0 && SubstanceCoreUtilities.hasCloseButton(this.tabPane, tabIndex)) {
            delta = this.tabPane.getComponentOrientation().isLeftToRight() ? 5 - SubstanceCoreUtilities.getCloseButtonSize(this.tabPane, tabIndex) : SubstanceCoreUtilities.getCloseButtonSize(this.tabPane, tabIndex) - 5;
        }
        return delta + super.getTabLabelShiftX(tabPlacement, tabIndex, isSelected);
    }

    @Override
    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        int result = 0;
        result = tabPlacement == 3 ? -1 : 1;
        return result;
    }

    protected int getTabExtraWidth(int tabPlacement, int tabIndex) {
        int extraWidth = 0;
        SubstanceButtonShaper shaper = SubstanceLookAndFeel.getCurrentButtonShaper();
        extraWidth = shaper instanceof ClassicButtonShaper ? 2 : super.calculateTabHeight(tabPlacement, tabIndex, this.getFontMetrics().getHeight()) / 3;
        if (SubstanceCoreUtilities.hasCloseButton(this.tabPane, tabIndex) && this.tabPane.isEnabledAt(tabIndex)) {
            extraWidth += 4 + SubstanceCoreUtilities.getCloseButtonSize(this.tabPane, tabIndex);
        }
        return extraWidth;
    }

    public int getRolloverTabIndex() {
        return this.getRolloverTab();
    }

    public void setTabAreaInsets(Insets insets) {
        this.tabAreaInsets = insets;
    }

    public Insets getTabAreaInsets() {
        return this.tabAreaInsets;
    }

    public Rectangle getTabRectangle(int tabIndex) {
        return this.rects[tabIndex];
    }

    public static String getMemoryUsage() {
        StringBuffer sb = new StringBuffer();
        sb.append("SubstanceTabbedPaneUI: \n");
        sb.append("\t" + backgroundMap.size() + " backgrounds");
        return sb.toString();
    }

    @Override
    protected boolean shouldPadTabRun(int tabPlacement, int run) {
        return this.runCount > 1 && run < this.runCount - 1;
    }

    @Override
    protected LayoutManager createLayoutManager() {
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            return super.createLayoutManager();
        }
        return new TabbedPaneLayout();
    }

    @Override
    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect;
        Rectangle rectangle = selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        if (tabPlacement != 3 || selectedIndex < 0 || selRect.y - 1 > h || selRect.x < x || selRect.x > x + w) {
            g.setColor(this.highlight);
            g.drawLine(x + 1, y + h - 2, x + w - 2, y + h - 2);
            g.setColor(this.darkShadow);
            g.drawLine(x + 1, y + h - 1, x + w - 2, y + h - 1);
        } else {
            SubstanceButtonShaper shaper = SubstanceLookAndFeel.getCurrentButtonShaper();
            int delta = shaper instanceof ClassicButtonShaper ? 0 : 1;
            g.setColor(this.highlight);
            g.drawLine(x + 1, y + h - 2, selRect.x + 1, y + h - 2);
            g.setColor(this.darkShadow);
            g.drawLine(x + 1, y + h - 1, selRect.x, y + h - 1);
            if (selRect.x + selRect.width < x + w - 2) {
                g.setColor(this.highlight);
                g.drawLine(selRect.x + selRect.width + delta - 2, y + h - 2, x + w - 2, y + h - 2);
                g.setColor(this.darkShadow);
                g.drawLine(selRect.x + selRect.width + delta - 2, y + h - 1, x + w - 2, y + h - 1);
            }
        }
        g.setColor(SubstanceColorUtilities.getInterpolatedColor(this.darkShadow, this.highlight, 0.5));
        g.drawLine(x, y + h - 1, x, y + h - 1);
        g.drawLine(x + w - 1, y + h - 1, x + w - 1, y + h - 1);
    }

    @Override
    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect;
        Rectangle rectangle = selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        if (tabPlacement != 2 || selectedIndex < 0 || selRect.x + selRect.width + 1 < x || selRect.y < y || selRect.y > y + h) {
            g.setColor(this.darkShadow);
            g.drawLine(x, y + 1, x, y + h - 2);
            g.setColor(this.highlight);
            g.drawLine(x + 1, y + 1, x + 1, y + h - 2);
        } else {
            SubstanceButtonShaper shaper = SubstanceLookAndFeel.getCurrentButtonShaper();
            int delta = shaper instanceof ClassicButtonShaper ? 1 : 0;
            g.setColor(this.darkShadow);
            g.drawLine(x, y + 1, x, selRect.y + 1);
            g.setColor(this.highlight);
            g.drawLine(x + 1, y + 1, x + 1, selRect.y);
            if (selRect.y + selRect.height < y + h - 2) {
                g.setColor(this.darkShadow);
                g.drawLine(x, selRect.y + selRect.height - delta - 1, x, y + h - 2);
                g.setColor(this.highlight);
                g.drawLine(x + 1, selRect.y + selRect.height - delta, x + 1, y + h - 2);
            }
        }
    }

    @Override
    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect;
        Rectangle rectangle = selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        if (tabPlacement != 4 || selectedIndex < 0 || selRect.x - 1 > w || selRect.y < y || selRect.y > y + h) {
            g.setColor(this.highlight);
            g.drawLine(x + w - 2, y + 1, x + w - 2, y + h - 2);
            g.setColor(this.darkShadow);
            g.drawLine(x + w - 1, y + 1, x + w - 1, y + h - 2);
        } else {
            int delta;
            g.setColor(this.highlight);
            g.drawLine(x + w - 2, y + 1, x + w - 2, selRect.y);
            g.setColor(this.darkShadow);
            g.drawLine(x + w - 1, y + 1, x + w - 1, selRect.y);
            SubstanceButtonShaper shaper = SubstanceLookAndFeel.getCurrentButtonShaper();
            int n = delta = shaper instanceof ClassicButtonShaper ? 1 : 0;
            if (selRect.y + selRect.height < y + h - 2) {
                g.setColor(this.highlight);
                g.drawLine(x + w - 2, selRect.y + selRect.height - delta - 2, x + w - 2, y + h - 2);
                g.setColor(this.darkShadow);
                g.drawLine(x + w - 1, selRect.y + selRect.height - delta - 1, x + w - 1, y + h - 2);
            }
        }
    }

    @Override
    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect;
        Rectangle rectangle = selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        if (tabPlacement != 1 || selectedIndex < 0 || selRect.y + selRect.height + 1 < y || selRect.x < x || selRect.x > x + w) {
            g.setColor(this.darkShadow);
            g.drawLine(x + 1, y, x + w - 2, y);
            g.setColor(this.highlight);
            g.drawLine(x + 1, y + 1, x + w - 2, y + 1);
        } else {
            SubstanceButtonShaper shaper = SubstanceLookAndFeel.getCurrentButtonShaper();
            int delta = shaper instanceof ClassicButtonShaper ? 0 : 1;
            g.setColor(this.darkShadow);
            g.drawLine(x + 1, y, selRect.x, y);
            g.setColor(this.highlight);
            g.drawLine(x + 1, y + 1, selRect.x - 1, y + 1);
            if (selRect.x + selRect.width < x + w - 2) {
                g.setColor(this.darkShadow);
                g.drawLine(selRect.x + selRect.width + delta - 2, y, x + w - 2, y);
                g.setColor(this.highlight);
                g.drawLine(selRect.x + selRect.width + delta - 1, y + 1, x + w - 2, y + 1);
            }
        }
        g.setColor(SubstanceColorUtilities.getInterpolatedColor(this.darkShadow, this.highlight, 0.5));
        g.drawLine(x, y, x, y);
        g.drawLine(x + w - 1, y, x + w - 1, y);
    }

    @Override
    public Rectangle getTabBounds(JTabbedPane pane, int i) {
        this.ensureCurrentLayout();
        Rectangle tabRect = new Rectangle();
        return this.getTabBounds(i, tabRect);
    }

    public class TabbedPaneLayout
    extends BasicTabbedPaneUI.TabbedPaneLayout {
        public TabbedPaneLayout() {
            super(SubstanceTabbedPaneUI.this);
        }

        protected void normalizeTabRuns(int tabPlacement, int tabCount, int start, int max) {
            if (tabPlacement == 1 || tabPlacement == 3) {
                super.normalizeTabRuns(tabPlacement, tabCount, start, max);
            }
        }

        protected void rotateTabRuns(int tabPlacement, int selectedRun) {
        }

        protected void padSelectedTab(int tabPlacement, int selectedIndex) {
        }
    }

    protected class TabIconAnimationCallback
    implements FadeTracker.FadeTrackerCallback {
        protected JTabbedPane tabbedPane;
        protected int tabIndex;

        public TabIconAnimationCallback(JTabbedPane tabPane, int tabIndex) {
            this.tabbedPane = tabPane;
            this.tabIndex = tabIndex;
        }

        public void fadePerformed(FadeTracker.FadeKind fadeKind, float fade10) {
            Component comp = this.tabbedPane.getComponent(this.tabIndex);
            if (comp == null) {
                return;
            }
            Icon icon = this.tabbedPane.getIconAt(this.tabIndex);
            if (icon instanceof IconWrapper) {
                ((IconWrapper)((Object)icon)).setCyclePos((double)fade10 / 10.0);
            }
            if (UIManager.getLookAndFeel() instanceof SubstanceLookAndFeel) {
                FadeTracker.FadeTrackerCallback callback = SubstanceTabbedPaneUI.this.getCallback(this.tabIndex);
                callback.fadePerformed(IconFadeStep.ICON_ANIMATION_FADE_KIND, 0.0f);
            } else if (icon instanceof IconWrapper) {
                this.tabbedPane.setIconAt(this.tabIndex, ((IconWrapper)((Object)icon)).getOriginalIcon());
            }
        }

        public void fadeEnded(FadeTracker.FadeKind fadeKind) {
            Icon currentIcon = this.tabbedPane.getIconAt(this.tabIndex);
            Icon originalIcon = null;
            if (currentIcon instanceof IconWrapper) {
                originalIcon = ((IconWrapper)((Object)currentIcon)).getOriginalIcon();
            }
            Component tabComponent = this.tabbedPane.getComponent(this.tabIndex);
            SubstanceConstants.TabAnimationKind nextKind = SubstanceCoreUtilities.getTabAnimationKind(tabComponent);
            SubstanceTabbedPaneUI.this.fadeIconIds.remove(tabComponent);
            this.tabbedPane.setIconAt(this.tabIndex, originalIcon);
            if (nextKind != null) {
                this.startIconAnimation(nextKind);
            }
        }

        public void startIconAnimation(SubstanceConstants.TabAnimationKind nextKind) {
            Icon origIcon = this.tabbedPane.getIconAt(this.tabIndex);
            switch (nextKind) {
                case ERROR: {
                    MixIcon mErrorIcon = new MixIcon(origIcon, SubstanceImageCreator.getErrorMarkerIcon(origIcon.getIconWidth(), new SunfireRedColorScheme()));
                    this.tabbedPane.setIconAt(this.tabIndex, mErrorIcon);
                    break;
                }
                case WARNING: {
                    MixIcon mWarningIcon = new MixIcon(origIcon, SubstanceImageCreator.getWarningMarkerIcon(origIcon.getIconWidth(), new SunsetColorScheme()));
                    this.tabbedPane.setIconAt(this.tabIndex, mWarningIcon);
                    break;
                }
                case LOADING: {
                    ProgressIcon pIcon = new ProgressIcon(origIcon);
                    this.tabbedPane.setIconAt(this.tabIndex, pIcon);
                }
            }
            long fadeInstanceId = FadeTracker.getInstance().trackFadeLooping(IconFadeStep.ICON_ANIMATION_FADE_KIND, new LafConstants.AnimationKind(new IconFadeStep(), "iconAnimation"), this.tabbedPane, Integer.valueOf(this.tabIndex), false, new TabIconAnimationCallback(this.tabbedPane, this.tabIndex), nextKind != SubstanceConstants.TabAnimationKind.LOADING);
            Component tabComponent = this.tabbedPane.getComponent(this.tabIndex);
            SubstanceTabbedPaneUI.this.fadeIconIds.put(tabComponent, fadeInstanceId);
        }
    }

    protected class TabRepaintCallback
    implements FadeTracker.FadeTrackerCallback {
        protected JTabbedPane tabbedPane;
        protected int tabIndex;

        public TabRepaintCallback(JTabbedPane tabPane, int tabIndex) {
            this.tabbedPane = tabPane;
            this.tabIndex = tabIndex;
        }

        public void fadePerformed(FadeTracker.FadeKind fadeKind, float fade10) {
            this.repaintTab();
        }

        public void fadeEnded(FadeTracker.FadeKind fadeKind) {
            this.repaintTab();
        }

        protected void repaintTab() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (SubstanceTabbedPaneUI.this.tabPane == null) {
                        return;
                    }
                    SubstanceTabbedPaneUI.this.ensureCurrentLayout();
                    int tabCount = SubstanceTabbedPaneUI.this.tabPane.getTabCount();
                    if (tabCount > 0 && TabRepaintCallback.this.tabIndex < tabCount && TabRepaintCallback.this.tabIndex < SubstanceTabbedPaneUI.this.rects.length) {
                        Rectangle rect = SubstanceTabbedPaneUI.this.getTabBounds(SubstanceTabbedPaneUI.this.tabPane, TabRepaintCallback.this.tabIndex);
                        SubstanceTabbedPaneUI.this.tabPane.repaint(rect);
                    }
                }
            });
        }
    }

    protected class TabSelectionHandler
    implements ChangeListener {
        protected TabSelectionHandler() {
        }

        public void stateChanged(ChangeEvent e) {
            JTabbedPane tabbedPane = (JTabbedPane)e.getSource();
            tabbedPane.revalidate();
            tabbedPane.repaint();
        }
    }

    protected class MouseRolloverHandler
    implements MouseListener,
    MouseMotionListener {
        int prevRolledOver = -1;
        boolean prevInCloseButton = false;

        protected MouseRolloverHandler() {
        }

        public void mouseClicked(MouseEvent e) {
            final int tabIndex = SubstanceTabbedPaneUI.this.tabForCoordinate(SubstanceTabbedPaneUI.this.tabPane, e.getX(), e.getY());
            TabCloseCallback closeCallback = SubstanceCoreUtilities.getTabCloseCallback(e, SubstanceTabbedPaneUI.this.tabPane, tabIndex);
            if (closeCallback == null) {
                return;
            }
            final SubstanceConstants.TabCloseKind tabCloseKind = closeCallback.onAreaClick(SubstanceTabbedPaneUI.this.tabPane, tabIndex, e);
            if (tabCloseKind == SubstanceConstants.TabCloseKind.NONE) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SubstanceTabbedPaneUI.this.tryCloseTabs(tabIndex, tabCloseKind);
                }
            });
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
            if (e.getSource() != SubstanceTabbedPaneUI.this.tabPane) {
                return;
            }
            if (SubstanceLookAndFeel.toIgnoreAnimation(SubstanceTabbedPaneUI.this.tabPane.getClass())) {
                return;
            }
            SubstanceTabbedPaneUI.this.substanceMouseLocation = e.getPoint();
            int currRolledOver = SubstanceTabbedPaneUI.this.getRolloverTab();
            TabCloseCallback tabCloseCallback = SubstanceCoreUtilities.getTabCloseCallback(e, SubstanceTabbedPaneUI.this.tabPane, currRolledOver);
            if (currRolledOver == this.prevRolledOver) {
                if (currRolledOver >= 0) {
                    Rectangle rect = new Rectangle();
                    rect = SubstanceTabbedPaneUI.this.getTabBounds(currRolledOver, rect);
                    Rectangle close = SubstanceTabbedPaneUI.this.getCloseButtonRectangleForEvents(currRolledOver, rect.x, rect.y, rect.width, rect.height);
                    boolean inCloseButton = close.contains(e.getPoint());
                    if (this.prevInCloseButton == inCloseButton) {
                        return;
                    }
                    this.prevInCloseButton = inCloseButton;
                    if (tabCloseCallback != null) {
                        if (inCloseButton) {
                            SubstanceTabbedPaneUI.this.tabPane.setToolTipTextAt(currRolledOver, tabCloseCallback.getCloseButtonTooltip(SubstanceTabbedPaneUI.this.tabPane, currRolledOver));
                        } else {
                            SubstanceTabbedPaneUI.this.tabPane.setToolTipTextAt(currRolledOver, tabCloseCallback.getAreaTooltip(SubstanceTabbedPaneUI.this.tabPane, currRolledOver));
                        }
                    }
                    if (currRolledOver >= 0 && currRolledOver < SubstanceTabbedPaneUI.this.tabPane.getTabCount()) {
                        FadeTracker.FadeTrackerCallback currCallback = SubstanceTabbedPaneUI.this.getCallback(currRolledOver);
                        currCallback.fadePerformed(FadeTracker.FadeKind.ROLLOVER, 0.0f);
                    }
                }
            } else {
                FadeTracker fadeTracker = FadeTracker.getInstance();
                if (this.prevRolledOver >= 0 && this.prevRolledOver < SubstanceTabbedPaneUI.this.tabPane.getTabCount() && SubstanceTabbedPaneUI.this.tabPane.isEnabledAt(this.prevRolledOver)) {
                    fadeTracker.trackFadeOut(FadeTracker.FadeKind.ROLLOVER, (Component)SubstanceTabbedPaneUI.this.tabPane, this.prevRolledOver, true, (FadeTracker.FadeTrackerCallback)new TabRepaintCallback(SubstanceTabbedPaneUI.this.tabPane, this.prevRolledOver));
                }
                if (currRolledOver >= 0 && currRolledOver < SubstanceTabbedPaneUI.this.tabPane.getTabCount() && SubstanceTabbedPaneUI.this.tabPane.isEnabledAt(currRolledOver)) {
                    fadeTracker.trackFadeIn(FadeTracker.FadeKind.ROLLOVER, (Component)SubstanceTabbedPaneUI.this.tabPane, currRolledOver, true, (FadeTracker.FadeTrackerCallback)new TabRepaintCallback(SubstanceTabbedPaneUI.this.tabPane, currRolledOver));
                }
            }
            this.prevRolledOver = currRolledOver;
        }

        public void mouseExited(MouseEvent e) {
            if (this.prevRolledOver >= 0 && this.prevRolledOver < SubstanceTabbedPaneUI.this.tabPane.getTabCount() && SubstanceTabbedPaneUI.this.tabPane.isEnabledAt(this.prevRolledOver)) {
                FadeTracker fadeTracker = FadeTracker.getInstance();
                fadeTracker.trackFadeOut(FadeTracker.FadeKind.ROLLOVER, (Component)SubstanceTabbedPaneUI.this.tabPane, this.prevRolledOver, true, (FadeTracker.FadeTrackerCallback)new TabRepaintCallback(SubstanceTabbedPaneUI.this.tabPane, this.prevRolledOver));
            }
            this.prevRolledOver = -1;
        }

        public void mousePressed(final MouseEvent e) {
            final int tabIndex = SubstanceTabbedPaneUI.this.tabForCoordinate(SubstanceTabbedPaneUI.this.tabPane, e.getX(), e.getY());
            if (SubstanceCoreUtilities.hasCloseButton(SubstanceTabbedPaneUI.this.tabPane, tabIndex)) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (tabIndex >= 0 && SubstanceTabbedPaneUI.this.tabPane.isEnabledAt(tabIndex)) {
                            Rectangle rect = new Rectangle();
                            rect = SubstanceTabbedPaneUI.this.getTabBounds(tabIndex, rect);
                            Rectangle close = SubstanceTabbedPaneUI.this.getCloseButtonRectangleForEvents(tabIndex, rect.x, rect.y, rect.width, rect.height);
                            if (close.contains(e.getPoint())) {
                                TabCloseCallback closeCallback = SubstanceCoreUtilities.getTabCloseCallback(e, SubstanceTabbedPaneUI.this.tabPane, tabIndex);
                                SubstanceConstants.TabCloseKind tabCloseKind = closeCallback == null ? SubstanceConstants.TabCloseKind.THIS : closeCallback.onCloseButtonClick(SubstanceTabbedPaneUI.this.tabPane, tabIndex, e);
                                SubstanceTabbedPaneUI.this.tryCloseTabs(tabIndex, tabCloseKind);
                            }
                        }
                    }
                });
            }
        }
    }

    protected final class TabbedContainerListener
    extends ContainerAdapter {
        private Map<Component, List<PropertyChangeListener>> listeners = new HashMap<Component, List<PropertyChangeListener>>();

        protected void trackExistingTabs() {
            for (int i = 0; i < SubstanceTabbedPaneUI.this.tabPane.getTabCount(); ++i) {
                this.trackTab(SubstanceTabbedPaneUI.this.tabPane.getComponentAt(i));
            }
        }

        protected void trackTab(final Component tabComponent) {
            int tabIndex;
            if (tabComponent == null) {
                return;
            }
            PropertyChangeListener tabModifiedListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    Object oldValue;
                    if ("windowModified".equals(evt.getPropertyName())) {
                        int tabIndex;
                        oldValue = evt.getOldValue();
                        Object newValue = evt.getNewValue();
                        boolean wasModified = Boolean.TRUE.equals(oldValue);
                        boolean isModified = Boolean.TRUE.equals(newValue);
                        if (wasModified) {
                            if (!isModified) {
                                long fadeInstanceId = (Long)SubstanceTabbedPaneUI.this.fadeModifiedIds.get(tabComponent);
                                FadeTracker.getInstance().cancelFadeInstance(fadeInstanceId);
                            }
                        } else if (isModified && (tabIndex = SubstanceTabbedPaneUI.this.tabPane.indexOfComponent(tabComponent)) >= 0) {
                            long fadeInstanceId = FadeTracker.getInstance().trackFadeLooping(ModifiedFadeStep.MARKED_MODIFIED_FADE_KIND, new LafConstants.AnimationKind(new ModifiedFadeStep(), "modified"), SubstanceTabbedPaneUI.this.tabPane, Integer.valueOf(tabIndex), false, SubstanceTabbedPaneUI.this.getCallback(tabIndex), true);
                            SubstanceTabbedPaneUI.this.fadeModifiedIds.put(tabComponent, fadeInstanceId);
                        }
                    }
                    if ("substancelaf.tabbedpanetabAnimationKind".equals(evt.getPropertyName())) {
                        oldValue = evt.getOldValue();
                        if (oldValue != null) {
                            long fadeInstanceId = (Long)SubstanceTabbedPaneUI.this.fadeIconIds.get(tabComponent);
                            FadeTracker.getInstance().requestStopOnCycleBreak(fadeInstanceId);
                        } else {
                            int tabIndex = SubstanceTabbedPaneUI.this.tabPane.indexOfComponent(tabComponent);
                            TabIconAnimationCallback callback = new TabIconAnimationCallback(SubstanceTabbedPaneUI.this.tabPane, tabIndex);
                            callback.startIconAnimation((SubstanceConstants.TabAnimationKind)((Object)evt.getNewValue()));
                        }
                    }
                }
            };
            tabComponent.addPropertyChangeListener(tabModifiedListener);
            List<PropertyChangeListener> currList = this.listeners.get(tabComponent);
            if (currList == null) {
                currList = new LinkedList<PropertyChangeListener>();
            }
            currList.add(tabModifiedListener);
            this.listeners.put(tabComponent, currList);
            if (tabComponent instanceof JComponent && Boolean.TRUE.equals(((JComponent)tabComponent).getClientProperty("windowModified")) && (tabIndex = SubstanceTabbedPaneUI.this.tabPane.indexOfComponent(tabComponent)) >= 0) {
                long fadeInstanceId = FadeTracker.getInstance().trackFadeLooping(ModifiedFadeStep.MARKED_MODIFIED_FADE_KIND, new LafConstants.AnimationKind(new ModifiedFadeStep(), "modified"), SubstanceTabbedPaneUI.this.tabPane, Integer.valueOf(tabIndex), false, SubstanceTabbedPaneUI.this.getCallback(tabIndex), true);
                SubstanceTabbedPaneUI.this.fadeModifiedIds.put(tabComponent, fadeInstanceId);
            }
        }

        protected void stopTrackTab(Component tabComponent) {
            if (tabComponent == null) {
                return;
            }
            List<PropertyChangeListener> pclList = this.listeners.get(tabComponent);
            if (pclList != null) {
                for (PropertyChangeListener pcl : pclList) {
                    tabComponent.removePropertyChangeListener(pcl);
                }
            }
            this.listeners.put(tabComponent, null);
        }

        protected void stopTrackExistingTabs() {
            for (int i = 0; i < SubstanceTabbedPaneUI.this.tabPane.getTabCount(); ++i) {
                this.stopTrackTab(SubstanceTabbedPaneUI.this.tabPane.getComponentAt(i));
            }
        }

        public void componentAdded(ContainerEvent e) {
            Component tabComponent = e.getChild();
            if (tabComponent instanceof UIResource) {
                return;
            }
            this.trackTab(tabComponent);
        }

        public void componentRemoved(ContainerEvent e) {
            Component tabComponent = e.getChild();
            if (tabComponent == null) {
                return;
            }
            if (tabComponent instanceof UIResource) {
                return;
            }
            for (PropertyChangeListener pcl : this.listeners.get(tabComponent)) {
                tabComponent.removePropertyChangeListener(pcl);
            }
            this.listeners.get(tabComponent).clear();
            this.listeners.remove(tabComponent);
            this.cleanListeners(tabComponent);
        }

        private void cleanListeners(Component comp) {
            if (comp instanceof Container) {
                Container cont = (Container)comp;
                for (int i = 0; i < cont.getComponentCount(); ++i) {
                    this.cleanListeners(cont.getComponent(i));
                }
            }
            if (comp instanceof JTabbedPane) {
                JTabbedPane jtp = (JTabbedPane)comp;
                SubstanceTabbedPaneUI substanceTabbedPaneUI = (SubstanceTabbedPaneUI)jtp.getUI();
            }
        }
    }
}

