/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.lafwidget.layout;

import java.awt.Container;
import java.awt.LayoutManager;
import org.jvnet.lafwidget.layout.TransitionLayout;

public class TransitionLayoutManager {
    private static TransitionLayoutManager instance;

    public static synchronized TransitionLayoutManager getInstance() {
        if (instance == null) {
            instance = new TransitionLayoutManager();
        }
        return instance;
    }

    public void track(Container container, boolean hasFades) {
        this.track(container, hasFades, false);
    }

    public void track(Container container, boolean hasFades, boolean doImmediateRepaint) {
        LayoutManager currLayout = container.getLayout();
        if (currLayout instanceof TransitionLayout) {
            return;
        }
        TransitionLayout layout = new TransitionLayout(container, container.getLayout(), hasFades);
        layout.setDoImmediateRepaint(doImmediateRepaint);
        container.setLayout(layout);
    }

    public void untrack(Container container) {
        LayoutManager layout = container.getLayout();
        if (layout instanceof TransitionLayout) {
            TransitionLayout tLayout = (TransitionLayout)layout;
            tLayout.uninstallBorders(container);
            container.setLayout(tLayout.getDelegate());
        }
    }
}

