/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.lafwidget.utils;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.jvnet.lafwidget.LafWidgetRepository;

public class FadeIgnoreManager {
    protected Set ignoreAnimationsOn = new HashSet();
    protected Set cache = new HashSet();

    public void populate() {
        try {
            Enumeration<URL> rs = LafWidgetRepository.class.getClassLoader().getResources("META-INF/lafwidget.animations.properties");
            while (rs.hasMoreElements()) {
                URL rUrl = rs.nextElement();
                this.populateFrom(rUrl);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateFrom(URL url) {
        InputStream is = null;
        BufferedReader br = null;
        try {
            String line;
            is = url.openStream();
            br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).length() == 0) continue;
                this.addToIgnoreAnimations(line);
            }
        }
        catch (IOException ioe) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {}
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    public void addToIgnoreAnimations(Class clazz) {
        this.ignoreAnimationsOn.add(clazz);
    }

    public void addToIgnoreAnimations(String className) {
        try {
            this.ignoreAnimationsOn.add(Class.forName(className));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized boolean toIgnoreAnimations(Component comp) {
        for (Component currComp = comp; currComp != null; currComp = currComp.getParent()) {
            Class<?> currClazz = currComp.getClass();
            if (this.cache.contains(currClazz)) {
                return true;
            }
            for (Class ignoreAnimationClazz : this.ignoreAnimationsOn) {
                if (!ignoreAnimationClazz.isAssignableFrom(currClazz)) continue;
                this.cache.add(currClazz);
                return true;
            }
        }
        return false;
    }
}

