/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JSpinner;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.utils.SubstanceConstants;

public class SubstanceSpinnerButton
extends JButton {
    private int orientation;

    public SubstanceSpinnerButton(JSpinner spinner, Icon spinnerIcon, int orientation) {
        this.setEnabled(spinner.isEnabled());
        this.setFocusable(false);
        this.setRequestFocusEnabled(false);
        this.setMargin(new Insets(0, 0, 0, 2));
        this.setBorder(null);
        this.orientation = orientation;
        this.setIcon(spinnerIcon);
        this.setDisabledIcon(SubstanceImageCreator.makeTransparent(spinner, spinnerIcon, 0.4));
    }

    public boolean isFocusable() {
        return false;
    }

    public SubstanceConstants.Side getSide() {
        switch (this.orientation) {
            case 1: {
                return SubstanceConstants.Side.BOTTOM;
            }
            case 7: {
                return SubstanceConstants.Side.RIGHT;
            }
            case 5: {
                return SubstanceConstants.Side.TOP;
            }
            case 3: {
                return SubstanceConstants.Side.LEFT;
            }
        }
        return null;
    }
}

