/*
 * Decompiled with CFR 0.152.
 */
package avr8_burn_o_mat;

import avr8_burn_o_mat.AvrdudeProgrammer;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvrdudeConfigFile {
    private Vector<AvrdudeProgrammer> m_avrdudeProgrammerList = new Vector();

    public Vector<AvrdudeProgrammer> getProgrammerList() {
        return this.m_avrdudeProgrammerList;
    }

    public void readAvrdudeConfigFile(String filename) throws IOException {
        this.m_avrdudeProgrammerList.clear();
        BufferedReader r = new BufferedReader(new FileReader(filename));
        ReadState readState = ReadState.NOTHING;
        Pattern patProgStart = Pattern.compile("\\s*programmer\\s*");
        Pattern patProgEnd = Pattern.compile("\\s*;\\s*");
        Pattern patProgVal1 = Pattern.compile("\\s*(\\w+)\\s*=\\s*\"([^\"]+)\"\\s*;\\s*");
        Pattern patProgVal2 = Pattern.compile("\\s*(\\w+)\\s*=\\s*([^\\s;]+)\\s*;\\s*");
        String progId = null;
        String progType = null;
        String progDesc = null;
        String line = r.readLine();
        while (line != null) {
            switch (readState) {
                case NOTHING: {
                    Matcher m = patProgStart.matcher(line);
                    if (!m.matches()) break;
                    readState = ReadState.PROGRAMMER;
                    progId = null;
                    progType = null;
                    progDesc = null;
                    break;
                }
                case PROGRAMMER: {
                    Matcher m = patProgEnd.matcher(line);
                    if (m.matches()) {
                        readState = ReadState.NOTHING;
                        if (progId == null || progType == null || progDesc == null) break;
                        this.m_avrdudeProgrammerList.add(new AvrdudeProgrammer(progId, progType, progDesc));
                        break;
                    }
                    String key = null;
                    String val = null;
                    m = patProgVal1.matcher(line);
                    if (m.matches()) {
                        key = m.group(1);
                        val = m.group(2);
                    } else {
                        m = patProgVal2.matcher(line);
                        if (m.matches()) {
                            key = m.group(1);
                            val = m.group(2);
                        }
                    }
                    if (key == null) break;
                    assert (val != null);
                    if ((key = key.toLowerCase()).equals("id")) {
                        progId = val;
                        break;
                    }
                    if (key.equals("desc")) {
                        progDesc = val;
                        break;
                    }
                    if (!key.equals("type")) break;
                    progType = val;
                }
            }
            line = r.readLine();
        }
        r.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ReadState {
        NOTHING,
        PROGRAMMER;

    }
}

