/*
 * Decompiled with CFR 0.152.
 */
package avr8_burn_o_mat;

import avr8_burn_o_mat.AVR;
import avr8_burn_o_mat.BrownOutDetection;
import avr8_burn_o_mat.FusesEditor;
import avr8_burn_o_mat.FusesObserver;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class JPanelBrownOutDetection
extends JPanel
implements FusesObserver,
ActionListener {
    private Vector<JRadioButton> m_radioButtonList;
    private ButtonGroup m_buttonGroup;
    private BrownOutDetection m_brownOutDetection = null;
    private JLabel m_labelNotSupported;
    private FusesEditor m_fusesEditor;

    public JPanelBrownOutDetection(FusesEditor fusesEditor) {
        this.initComponents();
        this.m_fusesEditor = fusesEditor;
        this.m_fusesEditor.getFusesObservable().addObserver(this);
        this.m_buttonGroup = new ButtonGroup();
        this.m_radioButtonList = new Vector();
        this.m_labelNotSupported = new JLabel("not supported for selected MCU");
        this.m_labelNotSupported.setBounds(20, 20, 400, 25);
    }

    public void fusesChanged() {
        this.fuseState2Selection();
    }

    public void fuseState2Selection() {
        if (this.m_brownOutDetection == null) {
            return;
        }
        int idx = this.m_brownOutDetection.getSettingIndexFromFusesState();
        if (idx == -1) {
            this.m_buttonGroup.clearSelection();
        } else {
            this.m_radioButtonList.elementAt(idx).setSelected(true);
        }
    }

    public void actionPerformed(ActionEvent e) {
        assert (this.m_brownOutDetection != null);
        int idx = -1;
        for (int i = 0; i < this.m_radioButtonList.size(); ++i) {
            if (this.m_radioButtonList.elementAt(i) != e.getSource()) continue;
            idx = i;
            break;
        }
        assert (idx != -1);
        this.m_brownOutDetection.applyFusesFromSetting(idx);
        this.m_fusesEditor.getFusesObservable().fusesChanged(this);
    }

    public void setAVR(AVR avr) {
        this.removeRadioButtons();
        this.m_brownOutDetection = avr.getBrownOutDetection();
        if (this.m_brownOutDetection == null) {
            this.add(this.m_labelNotSupported);
            this.setPreferredSize(new Dimension(500, 100));
            return;
        }
        this.remove(this.m_labelNotSupported);
        this.createRadioButtons();
        this.fuseState2Selection();
    }

    private void removeRadioButtons() {
        for (JRadioButton r : this.m_radioButtonList) {
            r.removeActionListener(this);
            this.m_buttonGroup.remove(r);
            this.remove(r);
        }
        this.m_radioButtonList.clear();
    }

    private void createRadioButtons() {
        int LINE_HEIGHT = 25;
        int LINE_SPACE = 10;
        assert (this.m_brownOutDetection != null);
        int idx = 0;
        for (BrownOutDetection.Setting s : this.m_brownOutDetection.m_settingList) {
            JRadioButton r = new JRadioButton(s.getName());
            this.add(r);
            r.setBounds(20, (idx + 1) * 10 + idx * 25, 400, 25);
            r.addActionListener(this);
            this.m_buttonGroup.add(r);
            this.m_radioButtonList.add(r);
            ++idx;
        }
        this.m_buttonGroup.clearSelection();
        this.setPreferredSize(new Dimension(500, (idx + 1) * 10 + idx * 25));
    }

    private void initComponents() {
        this.setPreferredSize(new Dimension(100, 100));
        this.setLayout(null);
    }
}

