/*
 * Decompiled with CFR 0.152.
 */
package avr8_burn_o_mat;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.Timer;

public class PixFX
extends JPanel
implements ActionListener,
MouseMotionListener,
MouseListener {
    private static final double ACCELERATION = 12.0;
    private static final double TIME_STEP = 0.5;
    private static final double FRICTION = 0.984;
    private static final int TIMER_INTERVALL = 50;
    private static final int WIN_WIDTH = 450;
    private static final int WIN_HEIGHT = 300;
    private static final int ADD_MOVER_SPEED = 20;
    private Borders m_borders;
    private Image m_image;
    private MoverList m_moverList;
    private Timer m_timer;
    private double[] m_targetBackupX;
    private double[] m_targetBackupY;

    public PixFX(String imageFileName) throws Exception {
        this.m_image = Toolkit.getDefaultToolkit().getImage(imageFileName);
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(this.m_image, 0);
        mediaTracker.waitForAll();
        if (mediaTracker.isErrorAny()) {
            throw new Exception("Can not load image " + imageFileName);
        }
        this.setDoubleBuffered(true);
        this.setPreferredSize(new Dimension(460, 310));
        this.setSize(460, 310);
        this.m_borders = new Borders();
        this.m_borders.m_borderLeft = -10.0;
        this.m_borders.m_borderRight = 460.0;
        this.m_borders.m_borderTop = -10.0;
        this.m_borders.m_borderBottom = 310.0;
        this.m_moverList = new MoverList();
        this.scanImage(this.m_image);
        this.m_timer = new Timer(50, this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    private void scanImage(Image image) throws InterruptedException {
        this.m_moverList.clear();
        PixelGrabber pg = new PixelGrabber(image, 0, 0, -1, -1, true);
        pg.grabPixels();
        int[] pixels = (int[])pg.getPixels();
        int imgWidth = pg.getWidth();
        int imgHeight = pg.getHeight();
        int offsetX = 225 - imgWidth / 2;
        int offsetY = 150 - imgHeight / 2;
        if (offsetX < 0) {
            offsetX = 0;
        }
        if (offsetY < 0) {
            offsetY = 0;
        }
        Vector<Integer> colorRGB = new Vector<Integer>();
        Vector<Color> color = new Vector<Color>();
        ColorModel cm = pg.getColorModel();
        int n = 0;
        for (int y = 0; y < imgHeight; ++y) {
            for (int x = 0; x < imgWidth; ++x) {
                int colRGB = pixels[n];
                if (cm.getAlpha(colRGB) > 100) {
                    Color col;
                    int idx = colorRGB.indexOf(colRGB);
                    if (idx == -1) {
                        col = new Color(colRGB);
                        colorRGB.add(colRGB);
                        color.add(col);
                    } else {
                        col = (Color)color.elementAt(idx);
                    }
                    Mover m = new Mover(this.m_borders, x + offsetX, y + offsetY, col);
                    this.m_moverList.addMover(m);
                }
                ++n;
            }
        }
        this.m_moverList.addMoverFinished();
        this.m_targetBackupX = this.m_moverList.storeTargetPosX();
        this.m_targetBackupY = this.m_moverList.storeTargetPosY();
        assert (colorRGB.size() == color.size());
    }

    protected void paintComponent(Graphics g) {
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.m_moverList.draw(g);
    }

    public void actionPerformed(ActionEvent evt) {
        this.m_moverList.calcTimeStep();
        this.repaint();
    }

    public void start() {
        this.m_moverList.setTargetPos(this.m_targetBackupX, this.m_targetBackupY);
        this.m_moverList.setMoverAppearance(MoverAppearanceMode.AROUND);
        this.m_timer.start();
    }

    public void stop() {
        this.m_timer.stop();
    }

    public void mouseMoved(MouseEvent event) {
        this.m_moverList.mouseMoved(event.getX(), event.getY());
    }

    public void mousePressed(MouseEvent event) {
        this.m_moverList.addRandMove(20.0);
    }

    public void mouseDragged(MouseEvent event) {
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseReleased(MouseEvent event) {
    }

    private class MoverList {
        private Vector<Mover> m_moverTempList = new Vector();
        private Mover[] m_moverList;
        private int m_numberOfActiveMover = 0;

        public void clear() {
            this.m_numberOfActiveMover = 0;
            this.m_moverTempList.clear();
            this.m_moverList = null;
        }

        public void addMover(Mover mover) {
            this.m_moverTempList.add(mover);
        }

        public void addMoverFinished() {
            Collections.sort(this.m_moverTempList, new Comparator<Mover>(){

                @Override
                public int compare(Mover m1, Mover m2) {
                    if (m1.getColorRGB() < m2.getColorRGB()) {
                        return -1;
                    }
                    if (m1.getColorRGB() > m2.getColorRGB()) {
                        return 1;
                    }
                    return 0;
                }
            });
            this.m_moverList = new Mover[this.m_moverTempList.size()];
            this.m_moverList = this.m_moverTempList.toArray(this.m_moverList);
        }

        public void calcTimeStep() {
            for (Mover m : this.m_moverList) {
                if (!m.m_active) continue;
                m.calcTimeStep();
            }
            for (int idx = 0; idx < 20 && this.m_numberOfActiveMover < this.m_moverList.length; ++idx) {
                this.m_moverList[this.m_numberOfActiveMover].m_active = true;
                ++this.m_numberOfActiveMover;
            }
        }

        public void draw(Graphics g) {
            int currColorRGB = g.getColor().getRGB();
            for (Mover m : this.m_moverList) {
                if (!m.m_active) continue;
                if (m.getColorRGB() != currColorRGB) {
                    g.setColor(m.getColor());
                }
                int x = (int)m.getPosX();
                int y = (int)m.getPosY();
                g.drawLine(x, y, x, y);
            }
        }

        public double[] storeTargetPosX() {
            double[] x = new double[this.m_moverList.length];
            for (int idx = 0; idx < this.m_moverList.length; ++idx) {
                x[idx] = this.m_moverList[idx].getTargetPosX();
            }
            return x;
        }

        public double[] storeTargetPosY() {
            double[] y = new double[this.m_moverList.length];
            for (int idx = 0; idx < this.m_moverList.length; ++idx) {
                y[idx] = this.m_moverList[idx].getTargetPosY();
            }
            return y;
        }

        public void setTargetPos(double[] tx, double[] ty) {
            for (int idx = 0; idx < this.m_moverList.length; ++idx) {
                this.m_moverList[idx].setTarget(tx[idx], ty[idx]);
            }
        }

        public void setMoverAppearance(MoverAppearanceMode mode) {
            int cnt = this.m_moverList.length;
            switch (mode) {
                case AROUND: 
                case BORDERS: {
                    int idx = 0;
                    while (idx < cnt) {
                        int x;
                        int y = 0;
                        for (x = 0; x < 450 && idx < cnt; ++idx, ++x) {
                            this.m_moverList[idx].setPos(x, y);
                            this.m_moverList[idx].setVelocity(0.0, 0.0);
                        }
                        x = 449;
                        for (y = 0; y < 300 && idx < cnt; ++idx, ++y) {
                            this.m_moverList[idx].setPos(x, y);
                            this.m_moverList[idx].setVelocity(0.0, 0.0);
                        }
                        y = 299;
                        for (x = 449; x >= 0 && idx < cnt; ++idx, --x) {
                            this.m_moverList[idx].setPos(x, y);
                            this.m_moverList[idx].setVelocity(0.0, 0.0);
                        }
                        x = 0;
                        for (y = 299; y >= 0 && idx < cnt; ++idx, --y) {
                            this.m_moverList[idx].setPos(x, y);
                            this.m_moverList[idx].setVelocity(0.0, 0.0);
                        }
                    }
                    for (Mover m : this.m_moverList) {
                        m.m_active = mode == MoverAppearanceMode.BORDERS;
                    }
                    if (mode == MoverAppearanceMode.BORDERS) {
                        this.m_numberOfActiveMover = cnt;
                        break;
                    }
                    this.m_numberOfActiveMover = 0;
                    break;
                }
                case BIG_BANG: 
                case SPUTTERING: {
                    for (Mover m : this.m_moverList) {
                        m.m_active = mode == MoverAppearanceMode.BIG_BANG;
                        double angle = Math.random() * Math.PI * 2.0;
                        double value = Math.random() * 10.0 + 1.0;
                        m.setPos(225.0, 150.0);
                        m.setVelocity(value * Math.cos(angle), value * Math.sin(angle));
                    }
                    if (mode == MoverAppearanceMode.BIG_BANG) {
                        this.m_numberOfActiveMover = cnt;
                        break;
                    }
                    this.m_numberOfActiveMover = 0;
                    break;
                }
                case FOUR_EDGES: 
                case FOUR_PIECES: {
                    block18: for (int idx = 0; idx < cnt; ++idx) {
                        Mover m = this.m_moverList[idx];
                        m.m_active = mode == MoverAppearanceMode.FOUR_PIECES;
                        switch (idx % 4) {
                            case 0: {
                                m.setPos(0.0, 0.0);
                                m.setVelocity(3.0, 0.0);
                                continue block18;
                            }
                            case 1: {
                                m.setPos(449.0, 0.0);
                                m.setVelocity(0.0, 3.0);
                                continue block18;
                            }
                            case 2: {
                                m.setPos(449.0, 299.0);
                                m.setVelocity(-3.0, 0.0);
                                continue block18;
                            }
                            case 3: {
                                m.setPos(0.0, 299.0);
                                m.setVelocity(0.0, -3.0);
                            }
                        }
                    }
                    if (mode == MoverAppearanceMode.FOUR_PIECES) {
                        this.m_numberOfActiveMover = cnt;
                        break;
                    }
                    this.m_numberOfActiveMover = 0;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        public void setMoverDisappearance(MoverDisappearanceMode mode) {
            switch (mode) {
                case EXPLODE_AND_FALL_DOWN: {
                    for (Mover m : this.m_moverList) {
                        double x = m.getPosX() - 225.0;
                        double y = m.getPosY() - 150.0;
                        double a = 30.0 / Math.sqrt(x * x + y * y);
                        m.setVelocity(x * a, y * a);
                        m.setTarget(x * a, 400.0);
                    }
                    break;
                }
                case SUCTION: {
                    for (Mover m : this.m_moverList) {
                        m.setTarget(500.0, 350.0);
                    }
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        public void addRandMove(double strong) {
            for (Mover m : this.m_moverList) {
                m.addRandMove(strong);
            }
        }

        public void mouseMoved(double x, double y) {
            for (Mover m : this.m_moverList) {
                m.mouseMoved(x, y);
            }
        }
    }

    private class Mover {
        private double m_px;
        private double m_py;
        private double m_vx;
        private double m_vy;
        private double m_tx;
        private double m_ty;
        private Borders m_borders;
        private Color m_color;
        private int m_colorRGB;
        public boolean m_active = false;

        public Mover(Borders borders, double tx, double ty, Color color) {
            this.m_borders = borders;
            this.m_px = 0.0;
            this.m_py = 0.0;
            this.m_vx = 0.0;
            this.m_vy = 0.0;
            this.m_tx = tx;
            this.m_ty = ty;
            this.m_color = color;
            this.m_colorRGB = this.m_color.getRGB();
        }

        public Color getColor() {
            return this.m_color;
        }

        public int getColorRGB() {
            return this.m_colorRGB;
        }

        public void setTarget(double tx, double ty) {
            this.m_tx = tx;
            this.m_ty = ty;
        }

        public void setPos(double px, double py) {
            this.m_px = px;
            this.m_py = py;
        }

        public void setVelocity(double vx, double vy) {
            this.m_vx = vx;
            this.m_vy = vy;
        }

        public double getPosX() {
            return this.m_px;
        }

        public double getPosY() {
            return this.m_py;
        }

        public void calcTimeStep() {
            if (!this.m_active) {
                return;
            }
            double dx = this.m_px - this.m_tx;
            double dy = this.m_py - this.m_ty;
            double dd = dx * dx + dy * dy;
            double f = -12.0 / (dd + 7.0);
            double v = this.m_vx * this.m_vx + this.m_vy * this.m_vy;
            if (v < 5.0 && dd < 5.0) {
                this.m_px = this.m_tx;
                this.m_py = this.m_ty;
                this.m_vx = 0.0;
                this.m_vy = 0.0;
            } else {
                this.m_vx += f * dx;
                this.m_vy += f * dy;
                this.m_vx *= 0.984;
                this.m_vy *= 0.984;
                this.m_px += this.m_vx * 0.5;
                this.m_py += this.m_vy * 0.5;
            }
            if (this.m_px > this.m_borders.m_borderRight) {
                this.m_px = this.m_borders.m_borderRight;
                this.m_vx = 0.0;
            } else if (this.m_px < this.m_borders.m_borderLeft) {
                this.m_px = this.m_borders.m_borderLeft;
                this.m_vx = 0.0;
            }
            if (this.m_py > this.m_borders.m_borderBottom) {
                this.m_py = this.m_borders.m_borderBottom;
                this.m_vy = 0.0;
            } else if (this.m_py < this.m_borders.m_borderTop) {
                this.m_py = this.m_borders.m_borderTop;
                this.m_vy = 0.0;
            }
        }

        public double getTargetPosX() {
            return this.m_tx;
        }

        public double getTargetPosY() {
            return this.m_ty;
        }

        public void addRandMove(double strong) {
            if (this.m_active) {
                this.m_vx += (0.5 - Math.random()) * strong;
                this.m_vy += (0.5 - Math.random()) * strong;
            }
        }

        public void mouseMoved(double x, double y) {
            if (this.m_active) {
                double dx = x - this.m_tx;
                double dy = y - this.m_ty;
                double dd = dx * dx + dy * dy;
                double f = -12.0 / (dd + 7.0);
                this.m_vx += f * dx * 3.0;
                this.m_vy += f * dy * 3.0;
            }
        }
    }

    private class Borders {
        double m_borderTop;
        double m_borderBottom;
        double m_borderLeft;
        double m_borderRight;

        private Borders() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MoverDisappearanceMode {
        EXPLODE_AND_FALL_DOWN,
        SUCTION;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MoverAppearanceMode {
        FOUR_EDGES,
        AROUND,
        FOUR_PIECES,
        BORDERS,
        BIG_BANG,
        SPUTTERING;

    }
}

